/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PartitionedScan;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class})
@ImpermanentDbmsExtension
class IncomparableValuesIndexRangeQueryTest {
    private static String INDEX_NAME = "TestIndex";
    private static String LABEL = "TestLabel";
    private static String PROPERTY = "testProp";
    @Inject
    private GraphDatabaseService db;
    @Inject
    RandomSupport random;

    IncomparableValuesIndexRangeQueryTest() {
    }

    @BeforeEach
    void setupRandomConfig() {
        this.random.reset();
        this.createIndex();
    }

    @MethodSource(value={"incomparableValueTypes"})
    @ParameterizedTest
    void testSeek(ValueType valueType) throws KernelException {
        Range range = this.prepareData(valueType);
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction kernelTx = ((TransactionImpl)tx).kernelTransaction();
            IndexDescriptor index = kernelTx.schemaRead().indexGetForName(INDEX_NAME);
            IndexReadSession indexSession = kernelTx.dataRead().indexReadSession(index);
            int prop = kernelTx.tokenRead().propertyKey(PROPERTY);
            try (NodeValueIndexCursor cursor = kernelTx.cursors().allocateNodeValueIndexCursor(kernelTx.cursorContext(), kernelTx.memoryTracker());){
                PropertyIndexQuery.RangePredicate query = PropertyIndexQuery.range((int)prop, (Value)range.from, (boolean)true, (Value)range.to, (boolean)true);
                kernelTx.dataRead().nodeIndexSeek(kernelTx.queryContext(), indexSession, cursor, IndexQueryConstraints.unordered((boolean)true), new PropertyIndexQuery[]{query});
                Assertions.assertFalse((boolean)cursor.next());
            }
            cursor = kernelTx.cursors().allocateNodeValueIndexCursor(kernelTx.cursorContext(), kernelTx.memoryTracker());
            try {
                kernelTx.dataRead().nodeIndexSeek(kernelTx.queryContext(), indexSession, cursor, IndexQueryConstraints.unordered((boolean)true), new PropertyIndexQuery[]{PropertyIndexQuery.exists((int)prop)});
                Assertions.assertTrue((boolean)cursor.next());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @MethodSource(value={"incomparableValueTypes"})
    @ParameterizedTest
    void testPartitionedScan(ValueType valueType) throws KernelException {
        Assumptions.assumeTrue((valueType != ValueType.GEOGRAPHIC_POINT && valueType != ValueType.GEOGRAPHIC_POINT_ARRAY ? 1 : 0) != 0);
        Range range = this.prepareData(valueType);
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction kernelTx = ((TransactionImpl)tx).kernelTransaction();
            IndexDescriptor index = kernelTx.schemaRead().indexGetForName(INDEX_NAME);
            IndexReadSession indexSession = kernelTx.dataRead().indexReadSession(index);
            int prop = kernelTx.tokenRead().propertyKey(PROPERTY);
            PropertyIndexQuery.RangePredicate query = PropertyIndexQuery.range((int)prop, (Value)range.from, (boolean)true, (Value)range.to, (boolean)true);
            PartitionedScan partitionedScan = kernelTx.dataRead().nodeIndexSeek(indexSession, 2, kernelTx.queryContext(), new PropertyIndexQuery[]{query});
            for (int i = 0; i < 2; ++i) {
                try (NodeValueIndexCursor cursor = kernelTx.cursors().allocateNodeValueIndexCursor(kernelTx.cursorContext(), kernelTx.memoryTracker());){
                    partitionedScan.reservePartition((Cursor)cursor, kernelTx.cursorContext(), kernelTx.securityContext().mode());
                    Assertions.assertFalse((boolean)cursor.next());
                    continue;
                }
            }
        }
    }

    private Range prepareData(ValueType valueType) throws KernelException {
        Value[] values = this.random.randomValues().nextValuesOfTypes(10, new ValueType[]{valueType});
        Arrays.sort(values, Values.COMPARATOR);
        try (Transaction tx = this.db.beginTx();){
            for (Value value : values) {
                KernelTransaction kernelTx = ((TransactionImpl)tx).kernelTransaction();
                long node = kernelTx.dataWrite().nodeCreate();
                int label = kernelTx.tokenRead().nodeLabel(LABEL);
                kernelTx.dataWrite().nodeAddLabel(node, label);
                int prop = kernelTx.tokenRead().propertyKey(PROPERTY);
                kernelTx.dataWrite().nodeSetProperty(node, prop, value);
            }
            tx.commit();
        }
        return new Range(values[0], values[values.length - 1]);
    }

    private void createIndex() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(Label.label((String)LABEL)).on(PROPERTY).withIndexType(IndexType.RANGE).withName(INDEX_NAME).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(5L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static Stream<ValueType> incomparableValueTypes() {
        return Stream.of(ValueType.DURATION, ValueType.DURATION_ARRAY, ValueType.GEOGRAPHIC_POINT, ValueType.GEOGRAPHIC_POINT_ARRAY);
    }

    record Range(Value from, Value to) {
    }
}

