/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.ToLongFunction;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.Primitive;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestSupport;
import org.neo4j.kernel.impl.newapi.TestUtils;
import org.neo4j.util.concurrent.Futures;

public abstract class ParallelNodeCursorTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static LongList NODE_IDS;
    private static final int NUMBER_OF_NODES = 128;
    private static final ToLongFunction<NodeCursor> NODE_GET;

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            LongArrayList list = new LongArrayList(128);
            for (int i = 0; i < 128; ++i) {
                list.add(tx.createNode().getId());
            }
            NODE_IDS = list;
            tx.commit();
        }
    }

    @Test
    void shouldScanASubsetOfNodes() {
        try (NodeCursor nodes = this.cursors.allocateNodeCursor(CursorContext.NULL_CONTEXT);){
            Scan scan = this.read.allNodesScan();
            Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)nodes, 3, CursorContext.NULL_CONTEXT, this.tx.securityContext().mode()));
            Assertions.assertTrue((boolean)nodes.next());
            Assertions.assertEquals((long)NODE_IDS.get(0), (long)nodes.nodeReference());
            Assertions.assertTrue((boolean)nodes.next());
            Assertions.assertEquals((long)NODE_IDS.get(1), (long)nodes.nodeReference());
            Assertions.assertTrue((boolean)nodes.next());
            Assertions.assertEquals((long)NODE_IDS.get(2), (long)nodes.nodeReference());
            Assertions.assertFalse((boolean)nodes.next());
        }
    }

    @Test
    void shouldHandleSizeHintLargerThanNumberOfNodes() {
        try (NodeCursor nodes = this.cursors.allocateNodeCursor(CursorContext.NULL_CONTEXT);){
            Scan scan = this.read.allNodesScan();
            Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)nodes, 256, CursorContext.NULL_CONTEXT, this.tx.securityContext().mode()));
            LongArrayList ids = new LongArrayList();
            while (nodes.next()) {
                ids.add(nodes.nodeReference());
            }
            Assertions.assertEquals((Object)NODE_IDS, (Object)ids);
        }
    }

    @Test
    void shouldHandleMaxSizeHint() {
        try (NodeCursor nodes = this.cursors.allocateNodeCursor(CursorContext.NULL_CONTEXT);){
            Scan scan = this.read.allNodesScan();
            LongArrayList ids = new LongArrayList();
            Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)nodes, Primitive.ceil((int)128, (int)4), CursorContext.NULL_CONTEXT, this.tx.securityContext().mode()));
            while (nodes.next()) {
                ids.add(nodes.nodeReference());
            }
            Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)nodes, Integer.MAX_VALUE, CursorContext.NULL_CONTEXT, this.tx.securityContext().mode()));
            while (nodes.next()) {
                ids.add(nodes.nodeReference());
            }
            Assertions.assertEquals((Object)NODE_IDS, (Object)ids);
        }
    }

    @Test
    void shouldFailForSizeHintZero() {
        try (NodeCursor nodes = this.cursors.allocateNodeCursor(CursorContext.NULL_CONTEXT);){
            Scan scan = this.read.allNodesScan();
            Assertions.assertThrows(IllegalArgumentException.class, () -> scan.reserveBatch((Cursor)nodes, 0, CursorContext.NULL_CONTEXT, this.tx.securityContext().mode()));
        }
    }

    @Test
    void shouldScanAllNodesInBatches() {
        LongArrayList ids = new LongArrayList();
        try (NodeCursor nodes = this.cursors.allocateNodeCursor(CursorContext.NULL_CONTEXT);){
            Scan scan = this.read.allNodesScan();
            while (scan.reserveBatch((Cursor)nodes, 3, CursorContext.NULL_CONTEXT, this.tx.securityContext().mode())) {
                while (nodes.next()) {
                    ids.add(nodes.nodeReference());
                }
            }
        }
        Assertions.assertEquals((Object)NODE_IDS, (Object)ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllNodesFromMultipleThreads() throws InterruptedException, ExecutionException {
        int numberOfWorkers = 4;
        ExecutorService service = Executors.newFixedThreadPool(numberOfWorkers);
        Scan scan = this.read.allNodesScan();
        CursorFactory cursors = testSupport.kernelToTest().cursors();
        try {
            List workerContexts = TestUtils.createContexts(this.tx, arg_0 -> ((CursorFactory)cursors).allocateNodeCursor(arg_0), numberOfWorkers);
            List<Future<LongList>> futures = service.invokeAll(TestUtils.createWorkers(32, scan, numberOfWorkers, workerContexts, NodeCursor::nodeReference));
            List ids = Futures.getAllResults(futures);
            TestUtils.closeWorkContexts(workerContexts);
            TestUtils.assertDistinct(ids);
            Assertions.assertEquals((Object)NODE_IDS, (Object)TestUtils.concat(ids).toSortedList());
        }
        finally {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllNodesFromMultipleThreadWithBigSizeHints() throws InterruptedException, ExecutionException {
        int numberOfWorkers = 4;
        ExecutorService service = Executors.newFixedThreadPool(numberOfWorkers);
        Scan scan = this.read.allNodesScan();
        CursorFactory cursors = testSupport.kernelToTest().cursors();
        try {
            List workerContexts = TestUtils.createContexts(this.tx, arg_0 -> ((CursorFactory)cursors).allocateNodeCursor(arg_0), numberOfWorkers);
            List<Future<LongList>> futures = service.invokeAll(TestUtils.createWorkers(100, scan, numberOfWorkers, workerContexts, NODE_GET));
            List ids = Futures.getAllResults(futures);
            TestUtils.closeWorkContexts(workerContexts);
            TestUtils.assertDistinct(ids);
            Assertions.assertEquals((Object)NODE_IDS, (Object)TestUtils.concat(ids).toSortedList());
        }
        finally {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllNodesFromRandomlySizedWorkers() throws InterruptedException, ExecutionException {
        int numberOfWorkers = 10;
        ExecutorService service = Executors.newFixedThreadPool(numberOfWorkers);
        Scan scan = this.read.allNodesScan();
        CursorFactory cursors = testSupport.kernelToTest().cursors();
        try {
            List workerContexts = TestUtils.createContexts(this.tx, arg_0 -> ((CursorFactory)cursors).allocateNodeCursor(arg_0), numberOfWorkers);
            List<Future<LongList>> futures = service.invokeAll(TestUtils.createRandomWorkers(scan, numberOfWorkers, workerContexts, NODE_GET));
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
            List lists = Futures.getAllResults(futures);
            TestUtils.closeWorkContexts(workerContexts);
            TestUtils.assertDistinct(lists);
            MutableLongList concat = TestUtils.concat(lists).toSortedList();
            Assertions.assertEquals((Object)NODE_IDS, (Object)concat);
        }
        finally {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    static {
        NODE_GET = NodeCursor::nodeReference;
    }
}

