/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.ToLongFunction;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.NodeIndexCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestSupport;
import org.neo4j.kernel.impl.newapi.TestUtils;
import org.neo4j.util.concurrent.Futures;

public abstract class ParallelNodeLabelScanTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static final int NUMBER_OF_NODES = 1000;
    private static int FOO_LABEL;
    private static int BAR_LABEL;
    private static LongSet FOO_NODES;
    private static LongSet BAR_NODES;
    private static final int[] ALL_LABELS;
    private static final ToLongFunction<NodeLabelIndexCursor> NODE_GET;

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        MutableLongSet fooNodes = LongSets.mutable.empty();
        MutableLongSet barNodes = LongSets.mutable.empty();
        try (KernelTransaction tx = ParallelNodeLabelScanTestBase.beginTransaction();){
            TokenWrite tokenWrite = tx.tokenWrite();
            FOO_LABEL = tokenWrite.labelGetOrCreateForName("foo");
            BAR_LABEL = tokenWrite.labelGetOrCreateForName("bar");
            Write write = tx.dataWrite();
            for (int i = 0; i < 1000; ++i) {
                long node = write.nodeCreate();
                if (i % 2 == 0) {
                    write.nodeAddLabel(node, FOO_LABEL);
                    fooNodes.add(node);
                    continue;
                }
                write.nodeAddLabel(node, BAR_LABEL);
                barNodes.add(node);
            }
            FOO_NODES = fooNodes;
            BAR_NODES = barNodes;
            tx.commit();
        }
        catch (KernelException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    void shouldScanASubsetOfNodes() {
        CursorContext cursorContext = this.tx.cursorContext();
        try (NodeLabelIndexCursor nodes = this.cursors.allocateNodeLabelIndexCursor(cursorContext);){
            for (int label : ALL_LABELS) {
                Scan scan = this.read.nodeLabelScan(label);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)nodes, 11, cursorContext, this.tx.securityContext().mode()));
                MutableLongList found = LongLists.mutable.empty();
                while (nodes.next()) {
                    found.add(nodes.nodeReference());
                }
                Assertions.assertThat((int)found.size()).isGreaterThan(0);
                if (label == FOO_LABEL) {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)FOO_NODES.containsAll((LongIterable)found));
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)found.noneSatisfy((LongPredicate & Serializable)f -> BAR_NODES.contains(f)));
                    continue;
                }
                if (label == BAR_LABEL) {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)BAR_NODES.containsAll((LongIterable)found));
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)found.noneSatisfy((LongPredicate & Serializable)f -> FOO_NODES.contains(f)));
                    continue;
                }
                org.junit.jupiter.api.Assertions.fail();
            }
        }
    }

    @Test
    void shouldHandleSizeHintOverflow() {
        CursorContext cursorContext = this.tx.cursorContext();
        try (NodeLabelIndexCursor nodes = this.cursors.allocateNodeLabelIndexCursor(this.tx.cursorContext());){
            Scan scan = this.read.nodeLabelScan(FOO_LABEL);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)nodes, 2000, cursorContext, this.tx.securityContext().mode()));
            MutableLongList ids = LongLists.mutable.empty();
            while (nodes.next()) {
                ids.add(nodes.nodeReference());
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)FOO_NODES.size(), (int)ids.size());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)FOO_NODES.containsAll((LongIterable)ids));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)ids.noneSatisfy((LongPredicate & Serializable)f -> BAR_NODES.contains(f)));
        }
    }

    @Test
    void shouldFailForSizeHintZero() {
        CursorContext cursorContext = this.tx.cursorContext();
        try (NodeLabelIndexCursor nodes = this.cursors.allocateNodeLabelIndexCursor(cursorContext);){
            Scan scan = this.read.nodeLabelScan(FOO_LABEL);
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> scan.reserveBatch((Cursor)nodes, 0, cursorContext, this.tx.securityContext().mode()));
        }
    }

    @Test
    void shouldScanAllNodesInBatches() {
        CursorContext cursorContext = this.tx.cursorContext();
        try (NodeLabelIndexCursor nodes = this.cursors.allocateNodeLabelIndexCursor(cursorContext);){
            Scan scan = this.read.nodeLabelScan(FOO_LABEL);
            MutableLongList ids = LongLists.mutable.empty();
            while (scan.reserveBatch((Cursor)nodes, 3, cursorContext, this.tx.securityContext().mode())) {
                while (nodes.next()) {
                    ids.add(nodes.nodeReference());
                }
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)FOO_NODES.size(), (int)ids.size());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)FOO_NODES.containsAll((LongIterable)ids));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)ids.noneSatisfy((LongPredicate & Serializable)f -> BAR_NODES.contains(f)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllNodesFromMultipleThreads() throws InterruptedException, ExecutionException {
        int numberOfWorkers = 4;
        int sizeHint = 1000 / numberOfWorkers;
        ExecutorService service = Executors.newFixedThreadPool(numberOfWorkers);
        Scan scan = this.read.nodeLabelScan(BAR_LABEL);
        try {
            List workers = TestUtils.createContexts(this.tx, c -> this.cursors.allocateNodeLabelIndexCursor((CursorContext)c), numberOfWorkers);
            List<Future<LongList>> futures = service.invokeAll(TestUtils.createWorkers(sizeHint, scan, numberOfWorkers, workers, NODE_GET));
            List results = Futures.getAllResults(futures);
            TestUtils.closeWorkContexts(workers);
            LongList[] longListsArray = (LongList[])results.toArray(LongList[]::new);
            TestUtils.assertDistinct(longListsArray);
            org.junit.jupiter.api.Assertions.assertEquals((Object)BAR_NODES, (Object)LongSets.immutable.withAll((LongIterable)TestUtils.concat(longListsArray)));
        }
        finally {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllNodesFromRandomlySizedWorkers() throws InterruptedException, ExecutionException {
        int numberOfWorkers = 10;
        ExecutorService service = Executors.newFixedThreadPool(numberOfWorkers);
        Scan scan = this.read.nodeLabelScan(FOO_LABEL);
        try {
            List workers = TestUtils.createContexts(this.tx, c -> this.cursors.allocateNodeLabelIndexCursor((CursorContext)c), numberOfWorkers);
            List<Future<LongList>> futures = service.invokeAll(TestUtils.createRandomWorkers(scan, numberOfWorkers, workers, NODE_GET));
            List lists = Futures.getAllResults(futures);
            TestUtils.closeWorkContexts(workers);
            TestUtils.assertDistinct(lists);
            org.junit.jupiter.api.Assertions.assertEquals((Object)FOO_NODES, (Object)LongSets.immutable.withAll((LongIterable)TestUtils.concat(lists)));
        }
        finally {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    static {
        ALL_LABELS = new int[]{FOO_LABEL, BAR_LABEL};
        NODE_GET = NodeIndexCursor::nodeReference;
    }
}

