/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.WriteTestSupport;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class PointIndexTransactionStateTest
extends KernelAPIWriteTestBase<WriteTestSupport> {
    private static final String INDEX_NAME = "myIndex";
    private static final String DEFAULT_PROPERTY_NAME = "prop";

    PointIndexTransactionStateTest() {
    }

    @ParameterizedTest
    @EnumSource(value=EntityOperations.class)
    void shouldPerformScan(EntityOperations ops) throws Exception {
        long entityToChange2;
        long entityToChange;
        long entityToDelete;
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (KernelTransaction tx = PointIndexTransactionStateTest.beginTransaction();){
            expected.add(ops.entityWithProp(tx, this.point(-1, 1)));
            expected.add(ops.entityWithProp(tx, this.point(-2, 2)));
            entityToDelete = PointIndexTransactionStateTest.entityWithPropId(ops, tx, this.point(-3, 3));
            entityToChange = PointIndexTransactionStateTest.entityWithPropId(ops, tx, this.point(-4, 4));
            entityToChange2 = PointIndexTransactionStateTest.entityWithPropId(ops, tx, this.point(-5, 5));
            tx.commit();
        }
        ops.createIndex();
        tx = PointIndexTransactionStateTest.beginTransaction();
        try {
            expected.add(ops.entityWithProp(tx, this.point(-6, 6)));
            ops.entityWithProp(tx, "some string");
            ops.deleteEntity(tx, entityToDelete);
            ops.removeProperty(tx, entityToChange);
            ops.setProperty(tx, entityToChange2, "some string");
            IndexDescriptor index = tx.schemaRead().indexGetForName(INDEX_NAME);
            ops.assertEntityAndValueForScan(expected, tx, index, this.point(-7, 7));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=EntityOperations.class)
    void shouldPerformEqualitySeek(EntityOperations ops) throws Exception {
        long entityToChange3;
        long entityToChange2;
        long entityToChange;
        long entityToDelete;
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (KernelTransaction tx = PointIndexTransactionStateTest.beginTransaction();){
            expected.add(ops.entityWithProp(tx, this.point(-1, 1)));
            expected.add(ops.entityWithProp(tx, this.point(-1, 1)));
            entityToDelete = PointIndexTransactionStateTest.entityWithPropId(ops, tx, this.point(-1, 1));
            entityToChange = PointIndexTransactionStateTest.entityWithPropId(ops, tx, this.point(-1, 1));
            entityToChange2 = PointIndexTransactionStateTest.entityWithPropId(ops, tx, this.point(-1, 1));
            entityToChange3 = PointIndexTransactionStateTest.entityWithPropId(ops, tx, this.point(-1, 1));
            tx.commit();
        }
        ops.createIndex();
        tx = PointIndexTransactionStateTest.beginTransaction();
        try {
            expected.add(ops.entityWithProp(tx, this.point(-1, 1)));
            ops.entityWithProp(tx, this.point(-2, 2));
            ops.entityWithProp(tx, "some string");
            ops.deleteEntity(tx, entityToDelete);
            ops.removeProperty(tx, entityToChange);
            ops.setProperty(tx, entityToChange2, "some string");
            ops.setProperty(tx, entityToChange3, this.point(-2, 2));
            IndexDescriptor index = tx.schemaRead().indexGetForName(INDEX_NAME);
            int prop = tx.tokenRead().propertyKey(DEFAULT_PROPERTY_NAME);
            ops.assertEntityAndValueForSeek(expected, tx, index, this.point(-1, 1), (PropertyIndexQuery)PropertyIndexQuery.exact((int)prop, (Object)this.point(-1, 1)));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=EntityOperations.class)
    void shouldPerformBoundingBoxSeek(EntityOperations ops) throws Exception {
        long entityToChange3;
        long entityToChange2;
        long entityToChange;
        long entityToDelete;
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (KernelTransaction tx = PointIndexTransactionStateTest.beginTransaction();){
            expected.add(ops.entityWithProp(tx, this.point(1, 1)));
            expected.add(ops.entityWithProp(tx, this.point(2, 2)));
            entityToDelete = PointIndexTransactionStateTest.entityWithPropId(ops, tx, this.point(1, 1));
            entityToChange = PointIndexTransactionStateTest.entityWithPropId(ops, tx, this.point(1, 1));
            entityToChange2 = PointIndexTransactionStateTest.entityWithPropId(ops, tx, this.point(1, 1));
            entityToChange3 = PointIndexTransactionStateTest.entityWithPropId(ops, tx, this.point(1, 1));
            tx.commit();
        }
        ops.createIndex();
        tx = PointIndexTransactionStateTest.beginTransaction();
        try {
            expected.add(ops.entityWithProp(tx, this.point(3, 3)));
            ops.entityWithProp(tx, this.point(-1, 1));
            ops.entityWithProp(tx, "some string");
            ops.deleteEntity(tx, entityToDelete);
            ops.removeProperty(tx, entityToChange);
            ops.setProperty(tx, entityToChange2, "some string");
            ops.setProperty(tx, entityToChange3, this.point(-1, 1));
            IndexDescriptor index = tx.schemaRead().indexGetForName(INDEX_NAME);
            int prop = tx.tokenRead().propertyKey(DEFAULT_PROPERTY_NAME);
            ops.assertEntityAndValueForSeek(expected, tx, index, this.point(1, 1), (PropertyIndexQuery)PropertyIndexQuery.boundingBox((int)prop, (PointValue)this.point(0, 0), (PointValue)this.point(3, 3)));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private PointValue point(int x, int y) {
        return Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{x, y});
    }

    @Override
    public WriteTestSupport newTestSupport() {
        return new WriteTestSupport();
    }

    static long entityWithPropId(EntityOperations ops, KernelTransaction tx, Object value) throws Exception {
        return (Long)ops.entityWithProp(tx, value).first();
    }

    private static void assertEntityAndValue(EntityOperations ops, Set<Pair<Long, Value>> expected, KernelTransaction tx, Object anotherValueFoundByQuery, EntityValueIndexCursor entities) throws Exception {
        PointIndexTransactionStateTest.entityWithPropId(ops, tx, anotherValueFoundByQuery);
        HashSet<Pair> found = new HashSet<Pair>();
        while (entities.next()) {
            found.add(Pair.of((Object)entities.entityReference(), (Object)entities.propertyValue(0)));
        }
        Assertions.assertThat(found).isEqualTo(expected);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum EntityOperations {
        NODE{
            private static final String DEFAULT_LABEL = "Node";

            @Override
            Pair<Long, Value> entityWithProp(KernelTransaction tx, Object value) throws Exception {
                Write write = tx.dataWrite();
                long node = write.nodeCreate();
                write.nodeAddLabel(node, tx.tokenWrite().labelGetOrCreateForName(DEFAULT_LABEL));
                Value val = Values.of((Object)value);
                write.nodeSetProperty(node, tx.tokenWrite().propertyKeyGetOrCreateForName(PointIndexTransactionStateTest.DEFAULT_PROPERTY_NAME), val);
                return Pair.of((Object)node, (Object)val);
            }

            @Override
            void createIndex() {
                try (Transaction tx = KernelAPIWriteTestBase.graphDb.beginTx();){
                    tx.schema().indexFor(Label.label((String)DEFAULT_LABEL)).on(PointIndexTransactionStateTest.DEFAULT_PROPERTY_NAME).withIndexType(IndexType.POINT).withName(PointIndexTransactionStateTest.INDEX_NAME).create();
                    tx.commit();
                }
                tx = KernelAPIWriteTestBase.graphDb.beginTx();
                try {
                    tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }

            @Override
            void deleteEntity(KernelTransaction tx, long entity) throws Exception {
                tx.dataWrite().nodeDelete(entity);
            }

            @Override
            void removeProperty(KernelTransaction tx, long entity) throws Exception {
                int propertyKey = tx.tokenRead().propertyKey(PointIndexTransactionStateTest.DEFAULT_PROPERTY_NAME);
                tx.dataWrite().nodeRemoveProperty(entity, propertyKey);
            }

            @Override
            void setProperty(KernelTransaction tx, long entity, Object value) throws Exception {
                int propertyKey = tx.tokenRead().propertyKey(PointIndexTransactionStateTest.DEFAULT_PROPERTY_NAME);
                tx.dataWrite().nodeSetProperty(entity, propertyKey, Values.of((Object)value));
            }

            @Override
            void assertEntityAndValueForSeek(Set<Pair<Long, Value>> expected, KernelTransaction tx, IndexDescriptor index, Object anotherValueFoundByQuery, PropertyIndexQuery query) throws Exception {
                try (NodeValueIndexCursor nodes = tx.cursors().allocateNodeValueIndexCursor(tx.cursorContext(), tx.memoryTracker());){
                    IndexReadSession indexSession = tx.dataRead().indexReadSession(index);
                    tx.dataRead().nodeIndexSeek(tx.queryContext(), indexSession, nodes, IndexQueryConstraints.unordered((boolean)true), new PropertyIndexQuery[]{query});
                    PointIndexTransactionStateTest.assertEntityAndValue(this, expected, tx, anotherValueFoundByQuery, new NodeCursorAdapter(nodes));
                }
            }

            @Override
            void assertEntityAndValueForScan(Set<Pair<Long, Value>> expected, KernelTransaction tx, IndexDescriptor index, Object anotherValueFoundByQuery) throws Exception {
                IndexReadSession indexSession = tx.dataRead().indexReadSession(index);
                try (NodeValueIndexCursor nodes = tx.cursors().allocateNodeValueIndexCursor(tx.cursorContext(), tx.memoryTracker());){
                    tx.dataRead().nodeIndexScan(indexSession, nodes, IndexQueryConstraints.unordered((boolean)true));
                    PointIndexTransactionStateTest.assertEntityAndValue(this, expected, tx, anotherValueFoundByQuery, new NodeCursorAdapter(nodes));
                }
            }
        }
        ,
        RELATIONSHIP{
            private static final String DEFAULT_REl_TYPE = "Rel";

            @Override
            Pair<Long, Value> entityWithProp(KernelTransaction tx, Object value) throws Exception {
                Write write = tx.dataWrite();
                long sourceNode = write.nodeCreate();
                long targetNode = write.nodeCreate();
                long rel = write.relationshipCreate(sourceNode, tx.tokenWrite().relationshipTypeGetOrCreateForName(DEFAULT_REl_TYPE), targetNode);
                Value val = Values.of((Object)value);
                write.relationshipSetProperty(rel, tx.tokenWrite().propertyKeyGetOrCreateForName(PointIndexTransactionStateTest.DEFAULT_PROPERTY_NAME), val);
                return Pair.of((Object)rel, (Object)val);
            }

            @Override
            void createIndex() {
                try (Transaction tx = KernelAPIWriteTestBase.graphDb.beginTx();){
                    tx.schema().indexFor(RelationshipType.withName((String)DEFAULT_REl_TYPE)).on(PointIndexTransactionStateTest.DEFAULT_PROPERTY_NAME).withIndexType(IndexType.POINT).withName(PointIndexTransactionStateTest.INDEX_NAME).create();
                    tx.commit();
                }
                tx = KernelAPIWriteTestBase.graphDb.beginTx();
                try {
                    tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }

            @Override
            void deleteEntity(KernelTransaction tx, long entity) throws Exception {
                tx.dataWrite().relationshipDelete(entity);
            }

            @Override
            void removeProperty(KernelTransaction tx, long entity) throws Exception {
                int propertyKey = tx.tokenRead().propertyKey(PointIndexTransactionStateTest.DEFAULT_PROPERTY_NAME);
                tx.dataWrite().relationshipRemoveProperty(entity, propertyKey);
            }

            @Override
            void setProperty(KernelTransaction tx, long entity, Object value) throws Exception {
                int propertyKey = tx.tokenRead().propertyKey(PointIndexTransactionStateTest.DEFAULT_PROPERTY_NAME);
                tx.dataWrite().relationshipSetProperty(entity, propertyKey, Values.of((Object)value));
            }

            @Override
            void assertEntityAndValueForSeek(Set<Pair<Long, Value>> expected, KernelTransaction tx, IndexDescriptor index, Object anotherValueFoundByQuery, PropertyIndexQuery query) throws Exception {
                try (RelationshipValueIndexCursor relationships = tx.cursors().allocateRelationshipValueIndexCursor(tx.cursorContext(), tx.memoryTracker());){
                    IndexReadSession indexSession = tx.dataRead().indexReadSession(index);
                    tx.dataRead().relationshipIndexSeek(tx.queryContext(), indexSession, relationships, IndexQueryConstraints.unordered((boolean)true), new PropertyIndexQuery[]{query});
                    PointIndexTransactionStateTest.assertEntityAndValue(this, expected, tx, anotherValueFoundByQuery, new RelationshipCursorAdapter(relationships));
                }
            }

            @Override
            void assertEntityAndValueForScan(Set<Pair<Long, Value>> expected, KernelTransaction tx, IndexDescriptor index, Object anotherValueFoundByQuery) throws Exception {
                IndexReadSession indexSession = tx.dataRead().indexReadSession(index);
                try (RelationshipValueIndexCursor relationships = tx.cursors().allocateRelationshipValueIndexCursor(tx.cursorContext(), tx.memoryTracker());){
                    tx.dataRead().relationshipIndexScan(indexSession, relationships, IndexQueryConstraints.unordered((boolean)true));
                    PointIndexTransactionStateTest.assertEntityAndValue(this, expected, tx, anotherValueFoundByQuery, new RelationshipCursorAdapter(relationships));
                }
            }
        };


        abstract Pair<Long, Value> entityWithProp(KernelTransaction var1, Object var2) throws Exception;

        abstract void createIndex();

        abstract void deleteEntity(KernelTransaction var1, long var2) throws Exception;

        abstract void removeProperty(KernelTransaction var1, long var2) throws Exception;

        abstract void setProperty(KernelTransaction var1, long var2, Object var4) throws Exception;

        abstract void assertEntityAndValueForSeek(Set<Pair<Long, Value>> var1, KernelTransaction var2, IndexDescriptor var3, Object var4, PropertyIndexQuery var5) throws Exception;

        abstract void assertEntityAndValueForScan(Set<Pair<Long, Value>> var1, KernelTransaction var2, IndexDescriptor var3, Object var4) throws Exception;
    }

    static interface EntityValueIndexCursor {
        public boolean next();

        public Value propertyValue(int var1);

        public long entityReference();
    }

    private static class RelationshipCursorAdapter
    implements EntityValueIndexCursor {
        private final RelationshipValueIndexCursor relationships;

        private RelationshipCursorAdapter(RelationshipValueIndexCursor relationships) {
            this.relationships = relationships;
        }

        @Override
        public boolean next() {
            return this.relationships.next();
        }

        @Override
        public Value propertyValue(int offset) {
            return this.relationships.propertyValue(offset);
        }

        @Override
        public long entityReference() {
            return this.relationships.relationshipReference();
        }
    }

    private static class NodeCursorAdapter
    implements EntityValueIndexCursor {
        private final NodeValueIndexCursor nodes;

        NodeCursorAdapter(NodeValueIndexCursor nodes) {
            this.nodes = nodes;
        }

        @Override
        public boolean next() {
            return this.nodes.next();
        }

        @Override
        public Value propertyValue(int offset) {
            return this.nodes.propertyValue(offset);
        }

        @Override
        public long entityReference() {
            return this.nodes.nodeReference();
        }
    }
}

