/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.neo4j.internal.kernel.api.KernelReadTracer;

public class TestKernelReadTracer
implements KernelReadTracer {
    static final TraceEvent ON_ALL_NODES_SCAN = new TraceEvent(TraceEventKind.AllNodesScan);
    private final List<TraceEvent> traceEvents = new ArrayList<TraceEvent>();

    TestKernelReadTracer() {
    }

    public void onNode(long nodeReference) {
        this.traceEvents.add(TestKernelReadTracer.nodeEvent(nodeReference));
    }

    public void onAllNodesScan() {
        this.traceEvents.add(ON_ALL_NODES_SCAN);
    }

    public void onLabelScan(int label) {
        this.traceEvents.add(TestKernelReadTracer.labelScanEvent(label));
    }

    public void onRelationshipTypeScan(int type) {
        this.traceEvents.add(TestKernelReadTracer.relationshipTypeScanEvent(type));
    }

    public void onIndexSeek() {
        this.traceEvents.add(TestKernelReadTracer.indexSeekEvent());
    }

    public void onRelationship(long relationshipReference) {
        this.traceEvents.add(TestKernelReadTracer.relationshipEvent(relationshipReference));
    }

    public void onProperty(int propertyKey) {
        this.traceEvents.add(TestKernelReadTracer.propertyEvent(propertyKey));
    }

    public void onHasLabel(int label) {
        this.traceEvents.add(TestKernelReadTracer.hasLabelEvent(label));
    }

    public void onHasLabel() {
        this.traceEvents.add(TestKernelReadTracer.hasLabelEvent());
    }

    public void dbHit() {
        throw new UnsupportedOperationException();
    }

    void assertEvents(TraceEvent ... expected) {
        this.assertEvents(Arrays.asList(expected));
    }

    void assertEvents(List<TraceEvent> expected) {
        Assertions.assertThat(this.traceEvents).isEqualTo(expected);
        this.clear();
    }

    void clear() {
        this.traceEvents.clear();
    }

    static TraceEvent nodeEvent(long nodeReference) {
        return new TraceEvent(TraceEventKind.Node, nodeReference);
    }

    static TraceEvent labelScanEvent(int label) {
        return new TraceEvent(TraceEventKind.LabelScan, label);
    }

    static TraceEvent relationshipTypeScanEvent(int type) {
        return new TraceEvent(TraceEventKind.RelationshipTypeScan, type);
    }

    static TraceEvent indexSeekEvent() {
        return new TraceEvent(TraceEventKind.IndexSeek, 1L);
    }

    static TraceEvent relationshipEvent(long relationshipReference) {
        return new TraceEvent(TraceEventKind.Relationship, relationshipReference);
    }

    static TraceEvent propertyEvent(int propertyKey) {
        return new TraceEvent(TraceEventKind.Property, propertyKey);
    }

    static TraceEvent hasLabelEvent(int label) {
        return new TraceEvent(TraceEventKind.HasLabel, label);
    }

    static TraceEvent hasLabelEvent() {
        return new TraceEvent(TraceEventKind.HasLabel);
    }

    static class TraceEvent {
        final TraceEventKind kind;
        final long hash;

        TraceEvent(TraceEventKind kind) {
            this(kind, 1L);
        }

        TraceEvent(TraceEventKind kind, long hash) {
            this.kind = kind;
            this.hash = hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TraceEvent that = (TraceEvent)o;
            return this.hash == that.hash && this.kind == that.kind;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind, this.hash});
        }

        public String toString() {
            return String.format("%s[%d]", new Object[]{this.kind, this.hash});
        }
    }

    static enum TraceEventKind {
        Node,
        AllNodesScan,
        LabelScan,
        RelationshipTypeScan,
        IndexSeek,
        Relationship,
        Property,
        HasLabel;

    }
}

