/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi.index;

import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.exceptions.KernelException;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.ValueIndexCursor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.ReadTestSupport;
import org.neo4j.kernel.impl.newapi.index.EntityParams;
import org.neo4j.kernel.impl.newapi.index.IndexParams;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public abstract class EntityValueIndexCursorTestBase<ENTITY_VALUE_INDEX_CURSOR extends Cursor & ValueIndexCursor>
extends KernelAPIReadTestBase<ReadTestSupport> {
    private static final int TOTAL_ENTITY_COUNT = 37;
    private static final String COMPOSITE_INDEX_NAME = "compositeIndex";
    protected static final String PROP_INDEX_NAME = "nodeProp";
    private static final String PROP_2_INDEX_NAME = "nodeProp2";
    private static final String PROP_3_INDEX_NAME = "nodeProp3";
    private static final String WHAT_EVER_INDEX_NAME = "whatEver";
    public static final String DEFAULT_ENTITY_TOKEN = "Token";
    public static final String PROP_NAME = "prop";
    public static final String PROP_2_NAME = "prop2";
    public static final String PROP_3_NAME = "prop3";
    public static final String FIRSTNAME_PROP_NAME = "firstname";
    public static final String SURNAME_PROP_NAME = "surname";
    public static final String PERSON_TOKEN = "Person";
    public static final String WHAT_TOKEN = "What";
    public static final String EVER_PROP_NAME = "ever";
    protected static long strOne;
    protected static long strTwo1;
    protected static long strTwo2;
    protected static long strThree1;
    protected static long strThree2;
    protected static long strThree3;
    private static long boolTrue;
    private static long num5;
    private static long num6;
    private static long num12a;
    private static long num12b;
    private static long strOneNoLabel;
    private static long joeDalton;
    private static long williamDalton;
    private static long jackDalton;
    private static long averellDalton;
    private static long date891;
    private static long date892;
    private static long date86;
    private static long[] entitiesOfAllPropertyTypes;
    private static long whateverPoint;
    private static Value whateverPointValue;
    private static final PointValue POINT_1;
    private static final PointValue POINT_2;
    protected final EntityParams<ENTITY_VALUE_INDEX_CURSOR> entityParams = this.getEntityParams();
    protected final IndexParams indexParams = this.getIndexParams();

    protected abstract EntityParams<ENTITY_VALUE_INDEX_CURSOR> getEntityParams();

    protected abstract IndexType getIndexType();

    @Override
    public ReadTestSupport newTestSupport() {
        return new ReadTestSupport();
    }

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            this.entityParams.createEntityIndex(tx, DEFAULT_ENTITY_TOKEN, PROP_NAME, PROP_INDEX_NAME, this.getIndexType());
            this.entityParams.createEntityIndex(tx, DEFAULT_ENTITY_TOKEN, PROP_2_NAME, PROP_2_INDEX_NAME, this.getIndexType());
            this.entityParams.createEntityIndex(tx, DEFAULT_ENTITY_TOKEN, PROP_3_NAME, PROP_3_INDEX_NAME, this.getIndexType());
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            this.entityParams.createEntityIndex(tx, WHAT_TOKEN, EVER_PROP_NAME, WHAT_EVER_INDEX_NAME, this.getIndexType());
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try {
            tx = graphDb.beginTx();
            try {
                this.entityParams.createCompositeEntityIndex(tx, PERSON_TOKEN, FIRSTNAME_PROP_NAME, SURNAME_PROP_NAME, COMPOSITE_INDEX_NAME, this.getIndexType());
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        tx = graphDb.beginTx();
        try {
            tx.schema().awaitIndexesOnline(5L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = graphDb.beginTx();
        try {
            strOne = this.entityWithProp(tx, "one");
            strTwo1 = this.entityWithProp(tx, "two");
            strTwo2 = this.entityWithProp(tx, "two");
            strThree1 = this.entityWithProp(tx, "three");
            strThree2 = this.entityWithProp(tx, "three");
            strThree3 = this.entityWithProp(tx, "three");
            this.entityWithProp(tx, false);
            boolTrue = this.entityWithProp(tx, true);
            this.entityWithProp(tx, 3);
            this.entityWithProp(tx, 3);
            this.entityWithProp(tx, 3);
            this.entityWithProp(tx, 2);
            this.entityWithProp(tx, 2);
            this.entityWithProp(tx, 1);
            this.entityWithProp(tx, 4);
            num5 = this.entityWithProp(tx, 5);
            num6 = this.entityWithProp(tx, 6);
            num12a = this.entityWithProp(tx, 12.0);
            num12b = this.entityWithProp(tx, 12.0);
            this.entityWithProp(tx, 18);
            this.entityWithProp(tx, 24);
            this.entityWithProp(tx, 30);
            this.entityWithProp(tx, 36);
            this.entityWithProp(tx, 42);
            strOneNoLabel = this.entityParams.tokenlessEntitySupported() ? this.entityWithNoLabel(tx, "one") : -1L;
            joeDalton = this.person(tx, "Joe", "Dalton");
            williamDalton = this.person(tx, "William", "Dalton");
            jackDalton = this.person(tx, "Jack", "Dalton");
            averellDalton = this.person(tx, "Averell", "Dalton");
            this.entityWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{1.0, 0.0}));
            this.entityWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{0.0, 0.0}));
            this.entityWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{0.0, 0.0}));
            this.entityWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{0.0, 0.0}));
            this.entityWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{0.0, 1.0}));
            this.entityWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN_3D, (double[])new double[]{0.0, 0.0, 0.0}));
            this.entityWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84, (double[])new double[]{0.0, 0.0}));
            this.entityWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84_3D, (double[])new double[]{0.0, 0.0, 0.0}));
            date891 = this.entityWithProp(tx, DateValue.date((int)1989, (int)3, (int)24));
            date86 = this.entityWithProp(tx, DateValue.date((int)1986, (int)11, (int)18));
            date892 = this.entityWithProp(tx, DateValue.date((int)1989, (int)3, (int)24));
            this.entityWithProp(tx, new String[]{"first", "second", "third"});
            this.entityWithProp(tx, new String[]{"fourth", "fifth", "sixth", "seventh"});
            MutableLongList listOfIds = LongLists.mutable.empty();
            listOfIds.add(this.entityWithWhatever(tx, "string"));
            listOfIds.add(this.entityWithWhatever(tx, false));
            listOfIds.add(this.entityWithWhatever(tx, 3));
            listOfIds.add(this.entityWithWhatever(tx, 13.0));
            whateverPointValue = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{1.0, 0.0});
            whateverPoint = this.entityWithWhatever(tx, whateverPointValue);
            listOfIds.add(whateverPoint);
            listOfIds.add(this.entityWithWhatever(tx, DateValue.date((int)1989, (int)3, (int)24)));
            listOfIds.add(this.entityWithWhatever(tx, new String[]{"first", "second", "third"}));
            entitiesOfAllPropertyTypes = listOfIds.toArray();
            EntityValueIndexCursorTestBase.assertSameDerivedValue(POINT_1, POINT_2);
            this.entityWithProp(tx, PROP_3_NAME, POINT_1.asObjectCopy());
            this.entityWithProp(tx, PROP_3_NAME, POINT_2.asObjectCopy());
            this.entityWithProp(tx, PROP_3_NAME, POINT_2.asObjectCopy());
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    protected abstract IndexParams getIndexParams();

    protected static void assertSameDerivedValue(PointValue p1, PointValue p2) {
        ConfiguredSpaceFillingCurveSettingsCache settingsFactory = new ConfiguredSpaceFillingCurveSettingsCache(Config.defaults());
        SpaceFillingCurveSettings spaceFillingCurveSettings = settingsFactory.forCRS(CoordinateReferenceSystem.WGS_84);
        SpaceFillingCurve curve = spaceFillingCurveSettings.curve();
        org.junit.jupiter.api.Assertions.assertEquals((Long)curve.derivedValueFor(p1.coordinate()), (Long)curve.derivedValueFor(p2.coordinate()));
    }

    @Test
    void shouldPerformExactLookup() throws Exception {
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.tx.dataRead().indexReadSession(this.tx.schemaRead().indexGetForName(PROP_INDEX_NAME));
        try (ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(this.tx, this.cursors);){
            LongHashSet uniqueIds = new LongHashSet();
            this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)"zero")});
            this.assertFoundEntitiesAndNoValue(cursor, (MutableLongSet)uniqueIds, new long[0]);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)"one")});
            this.assertFoundEntitiesAndNoValue(cursor, (MutableLongSet)uniqueIds, strOne);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)"two")});
            this.assertFoundEntitiesAndNoValue(cursor, (MutableLongSet)uniqueIds, strTwo1, strTwo2);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)"three")});
            this.assertFoundEntitiesAndNoValue(cursor, (MutableLongSet)uniqueIds, strThree1, strThree2, strThree3);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)1)});
            this.assertFoundEntitiesAndNoValue(cursor, 1, (MutableLongSet)uniqueIds);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)2)});
            this.assertFoundEntitiesAndNoValue(cursor, 2, (MutableLongSet)uniqueIds);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)3)});
            this.assertFoundEntitiesAndNoValue(cursor, 3, (MutableLongSet)uniqueIds);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)6)});
            this.assertFoundEntitiesAndNoValue(cursor, (MutableLongSet)uniqueIds, num6);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)12.0)});
            this.assertFoundEntitiesAndNoValue(cursor, (MutableLongSet)uniqueIds, num12a, num12b);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)true)});
            this.assertFoundEntitiesAndNoValue(cursor, (MutableLongSet)uniqueIds, boolTrue);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{0.0, 0.0}))});
            this.assertFoundEntitiesAndNoValue(cursor, 3, (MutableLongSet)uniqueIds);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN_3D, (double[])new double[]{0.0, 0.0, 0.0}))});
            this.assertFoundEntitiesAndNoValue(cursor, 1, (MutableLongSet)uniqueIds);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84, (double[])new double[]{0.0, 0.0}))});
            this.assertFoundEntitiesAndNoValue(cursor, 1, (MutableLongSet)uniqueIds);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84_3D, (double[])new double[]{0.0, 0.0, 0.0}))});
            this.assertFoundEntitiesAndNoValue(cursor, 1, (MutableLongSet)uniqueIds);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)DateValue.date((int)1989, (int)3, (int)24))});
            this.assertFoundEntitiesAndNoValue(cursor, 2, (MutableLongSet)uniqueIds);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)DateValue.date((int)1986, (int)11, (int)18))});
            this.assertFoundEntitiesAndNoValue(cursor, 1, (MutableLongSet)uniqueIds);
        }
    }

    @Test
    void shouldPerformExactLookupInCompositeIndex() throws Exception {
        int firstName = this.token.propertyKey(FIRSTNAME_PROP_NAME);
        int surname = this.token.propertyKey(SURNAME_PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(COMPOSITE_INDEX_NAME));
        try (ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(this.tx, this.cursors);){
            LongHashSet uniqueIds = new LongHashSet();
            this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)firstName, (Object)"Joe"), PropertyIndexQuery.exact((int)surname, (Object)"Dalton")});
            Assertions.assertThat((int)((ValueIndexCursor)cursor).numberOfProperties()).isEqualTo(2);
            this.assertFoundEntitiesAndNoValue(cursor, 1, (MutableLongSet)uniqueIds);
        }
    }

    @Test
    void shouldPerformStringPrefixSearch() throws Exception {
        boolean needsValues = this.indexParams.indexProvidesStringValues();
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        try (ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(this.tx, this.cursors);){
            LongHashSet uniqueIds = new LongHashSet();
            this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.unordered((boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.stringPrefix((int)prop, (TextValue)Values.stringValue((String)"t"))});
            Assertions.assertThat((int)((ValueIndexCursor)cursor).numberOfProperties()).isEqualTo(1);
            this.assertFoundEntitiesAndValue(cursor, (MutableLongSet)uniqueIds, index.reference().getCapability().supportsReturningValues(), needsValues, strTwo1, strTwo2, strThree1, strThree2, strThree3);
        }
    }

    @Test
    void shouldPerformStringSuffixSearch() throws Exception {
        Assumptions.assumeTrue((boolean)this.indexParams.indexSupportsStringSuffixAndContains());
        boolean needsValues = this.indexParams.indexProvidesStringValues();
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        try (ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(this.tx, this.cursors);){
            LongHashSet uniqueIds = new LongHashSet();
            this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.unordered((boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.stringSuffix((int)prop, (TextValue)Values.stringValue((String)"e"))});
            Assertions.assertThat((int)((ValueIndexCursor)cursor).numberOfProperties()).isEqualTo(1);
            this.assertFoundEntitiesAndValue(cursor, (MutableLongSet)uniqueIds, index.reference().getCapability().supportsReturningValues(), needsValues, strOne, strThree1, strThree2, strThree3);
        }
    }

    @Test
    void shouldPerformStringContainmentSearch() throws Exception {
        Assumptions.assumeTrue((boolean)this.indexParams.indexSupportsStringSuffixAndContains());
        boolean needsValues = this.indexParams.indexProvidesStringValues();
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        try (ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(this.tx, this.cursors);){
            LongHashSet uniqueIds = new LongHashSet();
            this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.unordered((boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.stringContains((int)prop, (TextValue)Values.stringValue((String)"o"))});
            Assertions.assertThat((int)((ValueIndexCursor)cursor).numberOfProperties()).isEqualTo(1);
            this.assertFoundEntitiesAndValue(cursor, (MutableLongSet)uniqueIds, index.reference().getCapability().supportsReturningValues(), needsValues, strOne, strTwo1, strTwo2);
        }
    }

    @Test
    void shouldPerformStringRangeSearch() throws Exception {
        boolean needsValues = this.indexParams.indexProvidesStringValues();
        IndexQueryConstraints constraints = IndexQueryConstraints.unordered((boolean)needsValues);
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        boolean supportsValues = index.reference().getCapability().supportsReturningValues();
        try (ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(this.tx, this.cursors);){
            LongHashSet uniqueIds = new LongHashSet();
            this.entityParams.entityIndexSeek(this.tx, index, cursor, constraints, new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (String)"one", (boolean)true, (String)"three", (boolean)true)});
            this.assertFoundEntitiesAndValue(cursor, (MutableLongSet)uniqueIds, supportsValues, needsValues, strOne, strThree1, strThree2, strThree3);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, constraints, new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (String)"one", (boolean)true, (String)"three", (boolean)false)});
            this.assertFoundEntitiesAndValue(cursor, (MutableLongSet)uniqueIds, supportsValues, needsValues, strOne);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, constraints, new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (String)"one", (boolean)false, (String)"three", (boolean)true)});
            this.assertFoundEntitiesAndValue(cursor, (MutableLongSet)uniqueIds, supportsValues, needsValues, strThree1, strThree2, strThree3);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, constraints, new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (String)"one", (boolean)false, (String)"two", (boolean)false)});
            this.assertFoundEntitiesAndValue(cursor, (MutableLongSet)uniqueIds, supportsValues, needsValues, strThree1, strThree2, strThree3);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, constraints, new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (String)"one", (boolean)true, (String)"two", (boolean)true)});
            this.assertFoundEntitiesAndValue(cursor, (MutableLongSet)uniqueIds, supportsValues, needsValues, strOne, strThree1, strThree2, strThree3, strTwo1, strTwo2);
        }
    }

    @Test
    void shouldPerformNumericRangeSearch() throws Exception {
        boolean needsValues = this.indexParams.indexProvidesNumericValues();
        IndexQueryConstraints constraints = IndexQueryConstraints.unordered((boolean)needsValues);
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        boolean supportsValues = index.reference().getCapability().supportsReturningValues();
        try (ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(this.tx, this.cursors);){
            LongHashSet uniqueIds = new LongHashSet();
            this.entityParams.entityIndexSeek(this.tx, index, cursor, constraints, new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (Number)5, (boolean)true, (Number)12, (boolean)true)});
            this.assertFoundEntitiesAndValue(cursor, (MutableLongSet)uniqueIds, supportsValues, needsValues, num5, num6, num12a, num12b);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, constraints, new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (Number)5, (boolean)true, (Number)12, (boolean)false)});
            this.assertFoundEntitiesAndValue(cursor, (MutableLongSet)uniqueIds, supportsValues, needsValues, num5, num6);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, constraints, new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (Number)5, (boolean)false, (Number)12, (boolean)true)});
            this.assertFoundEntitiesAndValue(cursor, (MutableLongSet)uniqueIds, supportsValues, needsValues, num6, num12a, num12b);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, constraints, new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (Number)5, (boolean)false, (Number)12, (boolean)false)});
            this.assertFoundEntitiesAndValue(cursor, (MutableLongSet)uniqueIds, supportsValues, needsValues, num6);
        }
    }

    @Test
    void shouldPerformTemporalRangeSearch() throws KernelException {
        boolean needsValues = this.indexParams.indexProvidesTemporalValues();
        IndexQueryConstraints constraints = IndexQueryConstraints.unordered((boolean)needsValues);
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        boolean supportsValues = index.reference().getCapability().supportsReturningValues();
        try (ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(this.tx, this.cursors);){
            LongHashSet uniqueIds = new LongHashSet();
            this.entityParams.entityIndexSeek(this.tx, index, cursor, constraints, new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (Value)DateValue.date((int)1986, (int)11, (int)18), (boolean)true, (Value)DateValue.date((int)1989, (int)3, (int)24), (boolean)true)});
            this.assertFoundEntitiesAndValue(cursor, (MutableLongSet)uniqueIds, supportsValues, needsValues, date86, date891, date892);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, constraints, new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (Value)DateValue.date((int)1986, (int)11, (int)18), (boolean)true, (Value)DateValue.date((int)1989, (int)3, (int)24), (boolean)false)});
            this.assertFoundEntitiesAndValue(cursor, (MutableLongSet)uniqueIds, supportsValues, needsValues, date86);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, constraints, new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (Value)DateValue.date((int)1986, (int)11, (int)18), (boolean)false, (Value)DateValue.date((int)1989, (int)3, (int)24), (boolean)true)});
            this.assertFoundEntitiesAndValue(cursor, (MutableLongSet)uniqueIds, supportsValues, needsValues, date891, date892);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, constraints, new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (Value)DateValue.date((int)1986, (int)11, (int)18), (boolean)false, (Value)DateValue.date((int)1989, (int)3, (int)24), (boolean)false)});
            this.assertFoundEntitiesAndValue(cursor, (MutableLongSet)uniqueIds, supportsValues, needsValues, new long[0]);
        }
    }

    @Test
    void shouldPerformBooleanSearch() throws KernelException {
        boolean needsValues = this.indexParams.indexProvidesBooleanValues();
        IndexQueryConstraints constraints = IndexQueryConstraints.unordered((boolean)needsValues);
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        boolean supportsValues = index.reference().getCapability().supportsReturningValues();
        try (ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(this.tx, this.cursors);){
            LongHashSet uniqueIds = new LongHashSet();
            this.entityParams.entityIndexSeek(this.tx, index, cursor, constraints, new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)false)});
            this.assertFoundEntitiesAndValue(cursor, 1, (MutableLongSet)uniqueIds, supportsValues, needsValues);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, constraints, new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)true)});
            this.assertFoundEntitiesAndValue(cursor, 1, (MutableLongSet)uniqueIds, supportsValues, needsValues);
        }
    }

    @Test
    void shouldPerformTextArraySearch() throws KernelException {
        boolean needsValues = this.indexParams.indexProvidesArrayValues();
        IndexQueryConstraints constraints = IndexQueryConstraints.unordered((boolean)needsValues);
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        boolean supportsValues = index.reference().getCapability().supportsReturningValues();
        try (ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(this.tx, this.cursors);){
            LongHashSet uniqueIds = new LongHashSet();
            this.entityParams.entityIndexSeek(this.tx, index, cursor, constraints, new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)new String[]{"first", "second", "third"})});
            this.assertFoundEntitiesAndValue(cursor, 1, (MutableLongSet)uniqueIds, supportsValues, needsValues);
            this.entityParams.entityIndexSeek(this.tx, index, cursor, constraints, new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)new String[]{"fourth", "fifth", "sixth", "seventh"})});
            this.assertFoundEntitiesAndValue(cursor, 1, (MutableLongSet)uniqueIds, supportsValues, needsValues);
        }
    }

    @Test
    void shouldPerformIndexScan() throws Exception {
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        try (ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(this.tx, this.cursors);){
            LongHashSet uniqueIds = new LongHashSet();
            this.entityParams.entityIndexScan(this.tx, index, cursor, IndexQueryConstraints.unordered((boolean)this.indexParams.indexProvidesAllValues()));
            Assertions.assertThat((int)((ValueIndexCursor)cursor).numberOfProperties()).isEqualTo(1);
            this.assertFoundEntitiesAndValue(cursor, 37, (MutableLongSet)uniqueIds, index.reference().getCapability().supportsReturningValues(), this.indexParams.indexProvidesAllValues());
        }
    }

    @Test
    void shouldRespectOrderCapabilitiesForNumbers() throws Exception {
        boolean needsValues = this.indexParams.indexProvidesNumericValues();
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        try (ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(this.tx, this.cursors);){
            if (index.reference().getCapability().supportsOrdering()) {
                this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)IndexOrder.ASCENDING, (boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (Number)1, (boolean)true, (Number)42, (boolean)true)});
                this.assertFoundEntitiesInOrder(cursor, IndexOrder.ASCENDING);
                this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)IndexOrder.DESCENDING, (boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (Number)1, (boolean)true, (Number)42, (boolean)true)});
                this.assertFoundEntitiesInOrder(cursor, IndexOrder.DESCENDING);
            }
        }
    }

    @Test
    void shouldRespectOrderCapabilitiesForStrings() throws Exception {
        boolean needsValues = this.indexParams.indexProvidesStringValues();
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        try (ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(this.tx, this.cursors);){
            if (index.reference().getCapability().supportsOrdering()) {
                this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)IndexOrder.ASCENDING, (boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (String)"one", (boolean)true, (String)"two", (boolean)true)});
                this.assertFoundEntitiesInOrder(cursor, IndexOrder.ASCENDING);
                this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)IndexOrder.DESCENDING, (boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (String)"one", (boolean)true, (String)"two", (boolean)true)});
                this.assertFoundEntitiesInOrder(cursor, IndexOrder.DESCENDING);
            }
        }
    }

    @Test
    void shouldRespectOrderCapabilitiesForTemporal() throws KernelException {
        boolean needsValues = this.indexParams.indexProvidesTemporalValues();
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        try (ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(this.tx, this.cursors);){
            if (index.reference().getCapability().supportsOrdering()) {
                this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)IndexOrder.ASCENDING, (boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (Value)DateValue.date((int)1986, (int)11, (int)18), (boolean)true, (Value)DateValue.date((int)1989, (int)3, (int)24), (boolean)true)});
                this.assertFoundEntitiesInOrder(cursor, IndexOrder.ASCENDING);
                this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)IndexOrder.DESCENDING, (boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (Value)DateValue.date((int)1986, (int)11, (int)18), (boolean)true, (Value)DateValue.date((int)1989, (int)3, (int)24), (boolean)true)});
                this.assertFoundEntitiesInOrder(cursor, IndexOrder.DESCENDING);
            }
        }
    }

    @Test
    void shouldRespectOrderCapabilitiesForStringArray() throws KernelException {
        boolean needsValues = this.indexParams.indexProvidesSpatialValues();
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        try (ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(this.tx, this.cursors);){
            if (index.reference().getCapability().supportsOrdering()) {
                this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)IndexOrder.ASCENDING, (boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (Value)Values.of((Object)new String[]{"first", "second", "third"}), (boolean)true, (Value)Values.of((Object)new String[]{"fourth", "fifth", "sixth", "seventh"}), (boolean)true)});
                this.assertFoundEntitiesInOrder(cursor, IndexOrder.ASCENDING);
                this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)IndexOrder.DESCENDING, (boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (Value)Values.of((Object)new String[]{"first", "second", "third"}), (boolean)true, (Value)Values.of((Object)new String[]{"fourth", "fifth", "sixth", "seventh"}), (boolean)true)});
                this.assertFoundEntitiesInOrder(cursor, IndexOrder.DESCENDING);
            }
        }
    }

    @Test
    void shouldRespectOrderCapabilitiesForWildcard() throws Exception {
        boolean needsValues = false;
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        try (ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(this.tx, this.cursors);){
            if (index.reference().getCapability().supportsOrdering()) {
                this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)IndexOrder.ASCENDING, (boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.exists((int)prop)});
                this.assertFoundEntitiesInOrder(cursor, IndexOrder.ASCENDING);
                this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)IndexOrder.DESCENDING, (boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.exists((int)prop)});
                this.assertFoundEntitiesInOrder(cursor, IndexOrder.DESCENDING);
            }
        }
    }

    @Test
    void shouldProvideValuesForPoints() throws Exception {
        Assumptions.assumeTrue((boolean)this.indexParams.indexProvidesSpatialValues());
        int prop = this.token.propertyKey(EVER_PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(WHAT_EVER_INDEX_NAME));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)index.reference().getCapability().supportsReturningValues());
        try (ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(this.tx, this.cursors);){
            LongHashSet uniqueIds = new LongHashSet();
            this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.unorderedValues(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)whateverPointValue)});
            this.assertFoundEntitiesAndValue(cursor, (MutableLongSet)uniqueIds, index.reference().getCapability().supportsReturningValues(), true, whateverPoint);
        }
    }

    @Test
    void shouldProvideValuesForAllTypes() throws Exception {
        Assumptions.assumeTrue((boolean)this.indexParams.indexProvidesAllValues());
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(WHAT_EVER_INDEX_NAME));
        boolean supportsValues = index.reference().getCapability().supportsReturningValues();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)supportsValues);
        try (ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(this.tx, this.cursors);){
            LongHashSet uniqueIds = new LongHashSet();
            this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.unorderedValues(), new PropertyIndexQuery[]{PropertyIndexQuery.allEntries()});
            this.assertFoundEntitiesAndValue(cursor, (MutableLongSet)uniqueIds, supportsValues, true, entitiesOfAllPropertyTypes);
        }
    }

    @Test
    void shouldProvideValuesForAllTypesOnPropKey() throws Exception {
        Assumptions.assumeTrue((boolean)this.indexParams.indexProvidesAllValues());
        int prop = this.token.propertyKey(EVER_PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(WHAT_EVER_INDEX_NAME));
        boolean supportsValues = index.reference().getCapability().supportsReturningValues();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)supportsValues);
        try (ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(this.tx, this.cursors);){
            LongHashSet uniqueIds = new LongHashSet();
            this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.unorderedValues(), new PropertyIndexQuery[]{PropertyIndexQuery.exists((int)prop)});
            this.assertFoundEntitiesAndValue(cursor, (MutableLongSet)uniqueIds, supportsValues, true, entitiesOfAllPropertyTypes);
        }
    }

    private void assertFoundEntitiesInOrder(ENTITY_VALUE_INDEX_CURSOR cursor, IndexOrder indexOrder) {
        Value currentValue = null;
        while (cursor.next()) {
            long reference = this.entityParams.entityReference(cursor);
            Value storedValue = this.entityParams.getPropertyValueFromStore(this.tx, this.cursors, reference);
            if (storedValue instanceof PointValue) continue;
            if (currentValue != null) {
                switch (indexOrder) {
                    case ASCENDING: {
                        org.junit.jupiter.api.Assertions.assertTrue((Values.COMPARATOR.compare(currentValue, storedValue) <= 0 ? 1 : 0) != 0, (String)("Requested ordering " + indexOrder + " was not respected."));
                        break;
                    }
                    case DESCENDING: {
                        org.junit.jupiter.api.Assertions.assertTrue((Values.COMPARATOR.compare(currentValue, storedValue) >= 0 ? 1 : 0) != 0, (String)("Requested ordering " + indexOrder + " was not respected."));
                        break;
                    }
                    case NONE: {
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Can not verify ordering for " + indexOrder);
                    }
                }
            }
            currentValue = storedValue;
        }
    }

    private void assertFoundEntitiesAndValue(ENTITY_VALUE_INDEX_CURSOR cursor, int expectedCount, MutableLongSet uniqueIds, boolean expectValue, boolean indexProvidesValues) {
        uniqueIds.clear();
        for (int i = 0; i < expectedCount; ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(), (String)("at least " + expectedCount + " entities, was " + uniqueIds.size()));
            long reference = this.entityParams.entityReference(cursor);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)uniqueIds.add(reference), (String)"all entities are unique");
            if (expectValue) {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)((ValueIndexCursor)cursor).hasValue(), (String)("Value capability said index would have value for " + expectValue + ", but didn't"));
            }
            if (!indexProvidesValues) continue;
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((ValueIndexCursor)cursor).hasValue(), (String)"Index did not provide values");
            Value storedValue = this.entityParams.getPropertyValueFromStore(this.tx, this.cursors, reference);
            ((ObjectAssert)Assertions.assertThat((Object)((ValueIndexCursor)cursor).propertyValue(0)).as("has correct value", new Object[0])).isEqualTo((Object)storedValue);
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next(), (String)("no more than " + expectedCount + " entities"));
    }

    private void assertFoundEntitiesAndNoValue(ENTITY_VALUE_INDEX_CURSOR cursor, int expectedCount, MutableLongSet uniqueIds) {
        uniqueIds.clear();
        for (int i = 0; i < expectedCount; ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(), (String)("at least " + expectedCount + " entities, was " + uniqueIds.size()));
            long reference = this.entityParams.entityReference(cursor);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)uniqueIds.add(reference), (String)"all entities are unique");
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next(), (String)("no more than " + expectedCount + " entities"));
    }

    protected void assertFoundEntitiesAndValue(ENTITY_VALUE_INDEX_CURSOR cursor, MutableLongSet uniqueIds, boolean expectValue, boolean indexProvidesValues, long ... expected) {
        this.assertFoundEntitiesAndValue(cursor, expected.length, uniqueIds, expectValue, indexProvidesValues);
        for (long expectedEntity : expected) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)uniqueIds.contains(expectedEntity), (String)("expected entity " + expectedEntity));
        }
    }

    private void assertFoundEntitiesAndNoValue(ENTITY_VALUE_INDEX_CURSOR cursor, MutableLongSet uniqueIds, long ... expected) {
        this.assertFoundEntitiesAndNoValue(cursor, expected.length, uniqueIds);
        for (long expectedEntity : expected) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)uniqueIds.contains(expectedEntity), (String)("expected entity " + expectedEntity));
        }
    }

    @Test
    void shouldGetNoIndexForMissingTokens() {
        int tokenId = this.entityParams.entityTokenId(this.tx, DEFAULT_ENTITY_TOKEN);
        int prop = this.token.propertyKey(PROP_NAME);
        int badTokenId = tokenId + 1000;
        int badProp = prop + 1000;
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.schemaRead.index(this.entityParams.schemaDescriptor(badTokenId, prop)).hasNext(), (String)"bad tokenId");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.schemaRead.index(this.entityParams.schemaDescriptor(tokenId, badProp)).hasNext(), (String)"bad prop");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.schemaRead.index(this.entityParams.schemaDescriptor(badTokenId, badProp)).hasNext(), (String)"just bad");
    }

    @Test
    void shouldGetNoIndexForUnknownTokens() {
        int label = this.entityParams.entityTokenId(this.tx, DEFAULT_ENTITY_TOKEN);
        int prop = this.token.propertyKey(PROP_NAME);
        int badLabel = Integer.MAX_VALUE;
        int badProp = Integer.MAX_VALUE;
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.schemaRead.index(this.entityParams.schemaDescriptor(badLabel, prop)).hasNext(), (String)"bad label");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.schemaRead.index(this.entityParams.schemaDescriptor(label, badProp)).hasNext(), (String)"bad prop");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.schemaRead.index(this.entityParams.schemaDescriptor(badLabel, badProp)).hasNext(), (String)"just bad");
    }

    @Test
    void shouldGetVersionAndKeyFromIndexReference() {
        IndexDescriptor index = this.schemaRead.indexGetForName(PROP_INDEX_NAME);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.indexParams.providerKey(), (Object)index.getIndexProvider().getKey());
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.indexParams.providerVersion(), (Object)index.getIndexProvider().getVersion());
    }

    @Test
    void shouldNotFindDeletedEntityInIndexScan() throws Exception {
        boolean needsValues = this.indexParams.indexProvidesAllValues();
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        boolean supportsValues = index.reference().getCapability().supportsReturningValues();
        try (KernelTransaction tx = EntityValueIndexCursorTestBase.beginTransaction();
             ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(tx, this.cursors);){
            LongHashSet uniqueIds = new LongHashSet();
            this.entityParams.entityIndexScan(tx, index, cursor, IndexQueryConstraints.unordered((boolean)needsValues));
            Assertions.assertThat((int)((ValueIndexCursor)cursor).numberOfProperties()).isEqualTo(1);
            this.assertFoundEntitiesAndValue(cursor, 37, (MutableLongSet)uniqueIds, supportsValues, needsValues);
            this.entityParams.entityDelete(tx, strOne);
            this.entityParams.entityIndexScan(tx, index, cursor, IndexQueryConstraints.unordered((boolean)needsValues));
            this.assertFoundEntitiesAndValue(cursor, 36, (MutableLongSet)uniqueIds, supportsValues, needsValues);
        }
    }

    @Test
    void shouldNotFindDeletedEntityInIndexSeek() throws Exception {
        boolean needsValues = false;
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        try (KernelTransaction tx = EntityValueIndexCursorTestBase.beginTransaction();
             ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(tx, this.cursors);){
            this.entityParams.entityDelete(tx, strOne);
            this.entityParams.entityIndexSeek(tx, index, cursor, IndexQueryConstraints.unordered((boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)"one")});
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
        }
    }

    @Test
    void shouldNotFindEntityWithRemovedTokenInIndexSeek() throws Exception {
        Assumptions.assumeTrue((boolean)this.entityParams.tokenlessEntitySupported());
        boolean needsValues = false;
        int label = this.entityParams.entityTokenId(this.tx, DEFAULT_ENTITY_TOKEN);
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        try (KernelTransaction tx = EntityValueIndexCursorTestBase.beginTransaction();
             ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(tx, this.cursors);){
            this.entityParams.entityRemoveToken(tx, strOne, label);
            this.entityParams.entityIndexSeek(tx, index, cursor, IndexQueryConstraints.unordered((boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)"one")});
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
        }
    }

    @Test
    void shouldNotFindUpdatedEntityInIndexSeek() throws Exception {
        boolean needsValues = false;
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        try (KernelTransaction tx = EntityValueIndexCursorTestBase.beginTransaction();
             ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(tx, this.cursors);){
            this.entityParams.entitySetProperty(tx, strOne, prop, "ett");
            this.entityParams.entityIndexSeek(tx, index, cursor, IndexQueryConstraints.unordered((boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)"one")});
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
        }
    }

    @Test
    void shouldFindUpdatedEntityInIndexSeek() throws Exception {
        boolean needsValues = false;
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        try (KernelTransaction tx = EntityValueIndexCursorTestBase.beginTransaction();
             ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(tx, this.cursors);){
            this.entityParams.entitySetProperty(tx, strOne, prop, "ett");
            this.entityParams.entityIndexSeek(tx, index, cursor, IndexQueryConstraints.unordered((boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)"ett")});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            org.junit.jupiter.api.Assertions.assertEquals((long)strOne, (long)this.entityParams.entityReference(cursor));
        }
    }

    @Test
    void shouldFindSwappedEntityInIndexSeek() throws Exception {
        Assumptions.assumeTrue((boolean)this.entityParams.tokenlessEntitySupported());
        boolean needsValues = false;
        int label = this.entityParams.entityTokenId(this.tx, DEFAULT_ENTITY_TOKEN);
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        try (KernelTransaction tx = EntityValueIndexCursorTestBase.beginTransaction();
             ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(tx, this.cursors);){
            this.entityParams.entityRemoveToken(tx, strOne, label);
            this.entityParams.entityAddToken(tx, strOneNoLabel, label);
            this.entityParams.entityIndexSeek(tx, index, cursor, IndexQueryConstraints.unordered((boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)"one")});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            org.junit.jupiter.api.Assertions.assertEquals((long)strOneNoLabel, (long)this.entityParams.entityReference(cursor));
        }
    }

    @Test
    void shouldNotFindDeletedEntityInRangeSearch() throws Exception {
        boolean needsValues = this.indexParams.indexProvidesStringValues();
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        try (KernelTransaction tx = EntityValueIndexCursorTestBase.beginTransaction();
             ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(tx, this.cursors);){
            this.entityParams.entityDelete(tx, strOne);
            this.entityParams.entityDelete(tx, strThree1);
            this.entityParams.entityDelete(tx, strThree2);
            this.entityParams.entityDelete(tx, strThree3);
            this.entityParams.entityIndexSeek(tx, index, cursor, IndexQueryConstraints.unordered((boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (String)"one", (boolean)true, (String)"three", (boolean)true)});
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
        }
    }

    @Test
    void shouldNotFindEntityWithRemovedLabelInRangeSearch() throws Exception {
        Assumptions.assumeTrue((boolean)this.entityParams.tokenlessEntitySupported());
        boolean needsValues = this.indexParams.indexProvidesStringValues();
        int label = this.entityParams.entityTokenId(this.tx, DEFAULT_ENTITY_TOKEN);
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        try (KernelTransaction tx = EntityValueIndexCursorTestBase.beginTransaction();
             ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(tx, this.cursors);){
            this.entityParams.entityRemoveToken(tx, strOne, label);
            this.entityParams.entityRemoveToken(tx, strThree1, label);
            this.entityParams.entityRemoveToken(tx, strThree2, label);
            this.entityParams.entityRemoveToken(tx, strThree3, label);
            this.entityParams.entityIndexSeek(tx, index, cursor, IndexQueryConstraints.unordered((boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (String)"one", (boolean)true, (String)"three", (boolean)true)});
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
        }
    }

    @Test
    void shouldNotFindUpdatedEntityInRangeSearch() throws Exception {
        boolean needsValues = this.indexParams.indexProvidesStringValues();
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        try (KernelTransaction tx = EntityValueIndexCursorTestBase.beginTransaction();
             ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(tx, this.cursors);){
            this.entityParams.entitySetProperty(tx, strOne, prop, "ett");
            this.entityParams.entitySetProperty(tx, strThree1, prop, "tre");
            this.entityParams.entitySetProperty(tx, strThree2, prop, "tre");
            this.entityParams.entitySetProperty(tx, strThree3, prop, "tre");
            this.entityParams.entityIndexSeek(tx, index, cursor, IndexQueryConstraints.unordered((boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (String)"one", (boolean)true, (String)"three", (boolean)true)});
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
        }
    }

    @Test
    void shouldFindUpdatedEntityInRangeSearch() throws Exception {
        boolean needsValues = this.indexParams.indexProvidesStringValues();
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        try (KernelTransaction tx = EntityValueIndexCursorTestBase.beginTransaction();
             ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(tx, this.cursors);){
            this.entityParams.entitySetProperty(tx, strOne, prop, "ett");
            this.entityParams.entityIndexSeek(tx, index, cursor, IndexQueryConstraints.unordered((boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (String)"ett", (boolean)true, (String)"tre", (boolean)true)});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            org.junit.jupiter.api.Assertions.assertEquals((long)strOne, (long)this.entityParams.entityReference(cursor));
        }
    }

    @Test
    void shouldFindSwappedEntityInRangeSearch() throws Exception {
        Assumptions.assumeTrue((boolean)this.entityParams.tokenlessEntitySupported());
        boolean needsValues = this.indexParams.indexProvidesStringValues();
        int label = this.entityParams.entityTokenId(this.tx, DEFAULT_ENTITY_TOKEN);
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        try (KernelTransaction tx = EntityValueIndexCursorTestBase.beginTransaction();
             ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(tx, this.cursors);){
            this.entityParams.entityRemoveToken(tx, strOne, label);
            this.entityParams.entityAddToken(tx, strOneNoLabel, label);
            this.entityParams.entityIndexSeek(tx, index, cursor, IndexQueryConstraints.unordered((boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (String)"one", (boolean)true, (String)"ones", (boolean)true)});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            org.junit.jupiter.api.Assertions.assertEquals((long)strOneNoLabel, (long)this.entityParams.entityReference(cursor));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
        }
    }

    @Test
    void shouldNotFindDeletedEntityInPrefixSearch() throws Exception {
        boolean needsValues = this.indexParams.indexProvidesStringValues();
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        try (KernelTransaction tx = EntityValueIndexCursorTestBase.beginTransaction();
             ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(tx, this.cursors);){
            this.entityParams.entityDelete(tx, strOne);
            this.entityParams.entityIndexSeek(tx, index, cursor, IndexQueryConstraints.unordered((boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.stringPrefix((int)prop, (TextValue)Values.stringValue((String)"on"))});
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
        }
    }

    @Test
    void shouldNotFindEntityWithRemovedLabelInPrefixSearch() throws Exception {
        Assumptions.assumeTrue((boolean)this.entityParams.tokenlessEntitySupported());
        boolean needsValues = this.indexParams.indexProvidesStringValues();
        int label = this.entityParams.entityTokenId(this.tx, DEFAULT_ENTITY_TOKEN);
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        try (KernelTransaction tx = EntityValueIndexCursorTestBase.beginTransaction();
             ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(tx, this.cursors);){
            this.entityParams.entityRemoveToken(tx, strOne, label);
            this.entityParams.entityIndexSeek(tx, index, cursor, IndexQueryConstraints.unordered((boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.stringPrefix((int)prop, (TextValue)Values.stringValue((String)"on"))});
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
        }
    }

    @Test
    void shouldNotFindUpdatedEntityInPrefixSearch() throws Exception {
        boolean needsValues = this.indexParams.indexProvidesStringValues();
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        try (KernelTransaction tx = EntityValueIndexCursorTestBase.beginTransaction();
             ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(tx, this.cursors);){
            this.entityParams.entitySetProperty(tx, strOne, prop, "ett");
            this.entityParams.entityIndexSeek(tx, index, cursor, IndexQueryConstraints.unordered((boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.stringPrefix((int)prop, (TextValue)Values.stringValue((String)"on"))});
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
        }
    }

    @Test
    void shouldFindUpdatedEntityInPrefixSearch() throws Exception {
        boolean needsValues = this.indexParams.indexProvidesStringValues();
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        try (KernelTransaction tx = EntityValueIndexCursorTestBase.beginTransaction();
             ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(tx, this.cursors);){
            this.entityParams.entitySetProperty(tx, strOne, prop, "ett");
            this.entityParams.entityIndexSeek(tx, index, cursor, IndexQueryConstraints.unordered((boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.stringPrefix((int)prop, (TextValue)Values.stringValue((String)"et"))});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            org.junit.jupiter.api.Assertions.assertEquals((long)strOne, (long)this.entityParams.entityReference(cursor));
        }
    }

    @Test
    void shouldFindSwappedEntityInPrefixSearch() throws Exception {
        Assumptions.assumeTrue((boolean)this.entityParams.tokenlessEntitySupported());
        boolean needsValues = this.indexParams.indexProvidesStringValues();
        int label = this.entityParams.entityTokenId(this.tx, DEFAULT_ENTITY_TOKEN);
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX_NAME));
        try (KernelTransaction tx = EntityValueIndexCursorTestBase.beginTransaction();
             ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(tx, this.cursors);){
            this.entityParams.entityRemoveToken(tx, strOne, label);
            this.entityParams.entityAddToken(tx, strOneNoLabel, label);
            this.entityParams.entityIndexSeek(tx, index, cursor, IndexQueryConstraints.unordered((boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.stringPrefix((int)prop, (TextValue)Values.stringValue((String)"on"))});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            org.junit.jupiter.api.Assertions.assertEquals((long)strOneNoLabel, (long)this.entityParams.entityReference(cursor));
        }
    }

    @Test
    void shouldNotFindDeletedEntityInCompositeIndex() throws Exception {
        boolean needsValues = false;
        int firstName = this.token.propertyKey(FIRSTNAME_PROP_NAME);
        int surname = this.token.propertyKey(SURNAME_PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(COMPOSITE_INDEX_NAME));
        try (KernelTransaction tx = EntityValueIndexCursorTestBase.beginTransaction();
             ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(tx, this.cursors);){
            this.entityParams.entityDelete(tx, jackDalton);
            this.entityParams.entityIndexSeek(tx, index, cursor, IndexQueryConstraints.unordered((boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)firstName, (Object)"Jack"), PropertyIndexQuery.exact((int)surname, (Object)"Dalton")});
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
        }
    }

    @Test
    void shouldNotFindEntityWithRemovedLabelInCompositeIndex() throws Exception {
        Assumptions.assumeTrue((boolean)this.entityParams.tokenlessEntitySupported());
        boolean needsValues = false;
        int label = this.entityParams.entityTokenId(this.tx, PERSON_TOKEN);
        int firstName = this.token.propertyKey(FIRSTNAME_PROP_NAME);
        int surname = this.token.propertyKey(SURNAME_PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(COMPOSITE_INDEX_NAME));
        try (KernelTransaction tx = EntityValueIndexCursorTestBase.beginTransaction();
             ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(tx, this.cursors);){
            this.entityParams.entityRemoveToken(tx, joeDalton, label);
            this.entityParams.entityIndexSeek(tx, index, cursor, IndexQueryConstraints.unordered((boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)firstName, (Object)"Joe"), PropertyIndexQuery.exact((int)surname, (Object)"Dalton")});
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
        }
    }

    @Test
    void shouldNotFindUpdatedEntityInCompositeIndex() throws Exception {
        boolean needsValues = false;
        int firstName = this.token.propertyKey(FIRSTNAME_PROP_NAME);
        int surname = this.token.propertyKey(SURNAME_PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(COMPOSITE_INDEX_NAME));
        try (KernelTransaction tx = EntityValueIndexCursorTestBase.beginTransaction();
             ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(tx, this.cursors);){
            this.entityParams.entitySetProperty(tx, jackDalton, firstName, "Jesse");
            this.entityParams.entitySetProperty(tx, jackDalton, surname, "James");
            this.entityParams.entityIndexSeek(tx, index, cursor, IndexQueryConstraints.unordered((boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)firstName, (Object)"Jack"), PropertyIndexQuery.exact((int)surname, (Object)"Dalton")});
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
        }
    }

    @Test
    void shouldFindUpdatedEntityInCompositeIndex() throws Exception {
        boolean needsValues = false;
        int firstName = this.token.propertyKey(FIRSTNAME_PROP_NAME);
        int surname = this.token.propertyKey(SURNAME_PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(COMPOSITE_INDEX_NAME));
        try (KernelTransaction tx = EntityValueIndexCursorTestBase.beginTransaction();
             ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(tx, this.cursors);){
            this.entityParams.entitySetProperty(tx, jackDalton, firstName, "Jesse");
            this.entityParams.entitySetProperty(tx, jackDalton, surname, "James");
            this.entityParams.entityIndexSeek(tx, index, cursor, IndexQueryConstraints.unordered((boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)firstName, (Object)"Jesse"), PropertyIndexQuery.exact((int)surname, (Object)"James")});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            org.junit.jupiter.api.Assertions.assertEquals((long)jackDalton, (long)this.entityParams.entityReference(cursor));
        }
    }

    @Test
    void shouldFindSwappedEntityInCompositeIndex() throws Exception {
        Assumptions.assumeTrue((boolean)this.entityParams.tokenlessEntitySupported());
        boolean needsValues = false;
        int label = this.entityParams.entityTokenId(this.tx, PERSON_TOKEN);
        int firstName = this.token.propertyKey(FIRSTNAME_PROP_NAME);
        int surname = this.token.propertyKey(SURNAME_PROP_NAME);
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(COMPOSITE_INDEX_NAME));
        try (KernelTransaction tx = EntityValueIndexCursorTestBase.beginTransaction();
             ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(tx, this.cursors);){
            this.entityParams.entityRemoveToken(tx, joeDalton, label);
            this.entityParams.entityAddToken(tx, strOneNoLabel, label);
            this.entityParams.entitySetProperty(tx, strOneNoLabel, firstName, "Jesse");
            this.entityParams.entitySetProperty(tx, strOneNoLabel, surname, "James");
            this.entityParams.entityIndexSeek(tx, index, cursor, IndexQueryConstraints.unordered((boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)firstName, (Object)"Jesse"), PropertyIndexQuery.exact((int)surname, (Object)"James")});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            org.junit.jupiter.api.Assertions.assertEquals((long)strOneNoLabel, (long)this.entityParams.entityReference(cursor));
        }
    }

    @Test
    void shouldHandleOrderedExactSeekWithNeedsValuesTrue() throws Exception {
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.tx.dataRead().indexReadSession(this.tx.schemaRead().indexGetForName(PROP_INDEX_NAME));
        try (ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(this.tx, this.cursors);){
            this.entityParams.entityIndexSeek(this.tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)IndexOrder.ASCENDING, (boolean)true), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)5)});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((ValueIndexCursor)cursor).hasValue());
            org.junit.jupiter.api.Assertions.assertEquals((Object)((ValueIndexCursor)cursor).propertyValue(0), (Object)Values.intValue((int)5));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
        }
    }

    @Test
    void shouldHandleOrderedExactSeekWithNeedsValuesTrueWithTxChanges() throws Exception {
        int prop = this.token.propertyKey(PROP_NAME);
        IndexReadSession index = this.tx.dataRead().indexReadSession(this.tx.schemaRead().indexGetForName(PROP_INDEX_NAME));
        int label = this.entityParams.entityTokenId(this.tx, DEFAULT_ENTITY_TOKEN);
        try (KernelTransaction tx = EntityValueIndexCursorTestBase.beginTransaction();
             ENTITY_VALUE_INDEX_CURSOR cursor = this.entityParams.allocateEntityValueIndexCursor(tx, this.cursors);){
            long newEntity = this.entityParams.entityCreateNew(tx, label);
            this.entityParams.entitySetProperty(tx, newEntity, prop, (Value)Values.intValue((int)5));
            this.entityParams.entityIndexSeek(tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)IndexOrder.ASCENDING, (boolean)true), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)5)});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((ValueIndexCursor)cursor).hasValue());
            org.junit.jupiter.api.Assertions.assertEquals((Object)((ValueIndexCursor)cursor).propertyValue(0), (Object)Values.intValue((int)5));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((ValueIndexCursor)cursor).hasValue());
            org.junit.jupiter.api.Assertions.assertEquals((Object)((ValueIndexCursor)cursor).propertyValue(0), (Object)Values.intValue((int)5));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
        }
    }

    private long entityWithProp(Transaction tx, Object value) {
        return this.entityWithProp(tx, PROP_NAME, value);
    }

    private long entityWithProp(Transaction tx, String key, Object value) {
        return this.entityParams.entityWithProp(tx, DEFAULT_ENTITY_TOKEN, key, value);
    }

    private long entityWithWhatever(Transaction tx, Object value) {
        return this.entityParams.entityWithProp(tx, WHAT_TOKEN, EVER_PROP_NAME, value);
    }

    private long entityWithNoLabel(Transaction tx, Object value) {
        return this.entityParams.entityNoTokenWithProp(tx, PROP_NAME, value);
    }

    private long person(Transaction tx, String firstName, String surname) {
        return this.entityParams.entityWithTwoProps(tx, PERSON_TOKEN, FIRSTNAME_PROP_NAME, firstName, SURNAME_PROP_NAME, surname);
    }

    static {
        POINT_1 = PointValue.parse((CharSequence)"{latitude: 40.7128, longitude: -74.0060, crs: 'wgs-84'}");
        POINT_2 = PointValue.parse((CharSequence)"{latitude: 40.7128, longitude: -74.006000001, crs: 'wgs-84'}");
    }
}

