/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi.index;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.index.EntityParams;
import org.neo4j.kernel.impl.newapi.index.EntityValueIndexCursorTestBase;
import org.neo4j.kernel.impl.newapi.index.IndexParams;
import org.neo4j.kernel.impl.newapi.index.Range10IndexParams;
import org.neo4j.kernel.impl.newapi.index.RelationshipParams;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

public class RelationshipValueIndexCursorRange10Test
extends EntityValueIndexCursorTestBase<RelationshipValueIndexCursor> {
    @Override
    protected IndexParams getIndexParams() {
        return new Range10IndexParams();
    }

    @Override
    protected EntityParams<RelationshipValueIndexCursor> getEntityParams() {
        return new RelationshipParams();
    }

    @Override
    protected IndexType getIndexType() {
        return IndexType.RANGE;
    }

    @Test
    void shouldReadRelationshipOnReadFromStore() throws Exception {
        long first;
        boolean needsValues = this.indexParams.indexProvidesStringValues();
        IndexQueryConstraints constraints = IndexQueryConstraints.unordered((boolean)needsValues);
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName("nodeProp"));
        try (KernelTransaction tx = RelationshipValueIndexCursorRange10Test.beginTransaction();){
            int tokenId = this.entityParams.entityTokenId(tx, "Token");
            first = this.entityParams.entityCreateNew(tx, tokenId);
            this.entityParams.entitySetProperty(tx, first, tx.tokenRead().propertyKey("prop"), "aaaaa");
            tx.commit();
        }
        try (RelationshipValueIndexCursor cursor = (RelationshipValueIndexCursor)this.entityParams.allocateEntityValueIndexCursor(this.tx, this.cursors);){
            long relTargetNode;
            long relSourceNode;
            int relType;
            try (KernelTransaction tx = RelationshipValueIndexCursorRange10Test.beginTransaction();
                 RelationshipScanCursor relationshipScanCursor = tx.cursors().allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);){
                tx.dataRead().singleRelationship(first, relationshipScanCursor);
                relationshipScanCursor.next();
                relType = relationshipScanCursor.type();
                relSourceNode = relationshipScanCursor.sourceNodeReference();
                relTargetNode = relationshipScanCursor.targetNodeReference();
            }
            this.entityParams.entityIndexSeek(this.tx, index, cursor, constraints, new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (String)"a", (boolean)true, (String)"three", (boolean)true)});
            Assertions.assertThat((boolean)cursor.next()).isTrue();
            Assertions.assertThat((boolean)cursor.readFromStore()).isTrue();
            tx = RelationshipValueIndexCursorRange10Test.beginTransaction();
            try {
                this.entityParams.entityDelete(tx, first);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            Assertions.assertThat((int)cursor.type()).isEqualTo(relType);
            Assertions.assertThat((long)cursor.sourceNodeReference()).isEqualTo(relSourceNode);
            Assertions.assertThat((long)cursor.targetNodeReference()).isEqualTo(relTargetNode);
            Assertions.assertThat((boolean)cursor.next()).isTrue();
            Assertions.assertThat((long)cursor.relationshipReference()).isEqualTo(strOne);
            Assertions.assertThat((boolean)cursor.next()).isTrue();
            Assertions.assertThat((long)cursor.relationshipReference()).isEqualTo(strThree1);
            Assertions.assertThat((boolean)cursor.next()).isTrue();
            Assertions.assertThat((long)cursor.relationshipReference()).isEqualTo(strThree2);
            Assertions.assertThat((boolean)cursor.next()).isTrue();
            Assertions.assertThat((long)cursor.relationshipReference()).isEqualTo(strThree3);
            Assertions.assertThat((boolean)cursor.next()).isFalse();
        }
    }

    @Test
    void shouldNotLoadDeletedRelationshipOnReadFromStore() throws Exception {
        long first;
        boolean needsValues = this.indexParams.indexProvidesStringValues();
        IndexQueryConstraints constraints = IndexQueryConstraints.unordered((boolean)needsValues);
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName("nodeProp"));
        try (KernelTransaction tx = RelationshipValueIndexCursorRange10Test.beginTransaction();){
            int tokenId = this.entityParams.entityTokenId(tx, "Token");
            first = this.entityParams.entityCreateNew(tx, tokenId);
            this.entityParams.entitySetProperty(tx, first, tx.tokenRead().propertyKey("prop"), "aaaaa");
            tx.commit();
        }
        try (RelationshipValueIndexCursor cursor = (RelationshipValueIndexCursor)this.entityParams.allocateEntityValueIndexCursor(this.tx, this.cursors);){
            this.entityParams.entityIndexSeek(this.tx, index, cursor, constraints, new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (String)"a", (boolean)true, (String)"three", (boolean)true)});
            Assertions.assertThat((boolean)cursor.next()).isTrue();
            try (KernelTransaction tx = RelationshipValueIndexCursorRange10Test.beginTransaction();){
                this.entityParams.entityDelete(tx, first);
                tx.commit();
            }
            Assertions.assertThat((boolean)cursor.readFromStore()).isFalse();
            Assertions.assertThat((boolean)cursor.next()).isTrue();
            Assertions.assertThat((long)cursor.relationshipReference()).isEqualTo(strOne);
            Assertions.assertThat((boolean)cursor.next()).isTrue();
            Assertions.assertThat((long)cursor.relationshipReference()).isEqualTo(strThree1);
            Assertions.assertThat((boolean)cursor.next()).isTrue();
            Assertions.assertThat((long)cursor.relationshipReference()).isEqualTo(strThree2);
            Assertions.assertThat((boolean)cursor.next()).isTrue();
            Assertions.assertThat((long)cursor.relationshipReference()).isEqualTo(strThree3);
            Assertions.assertThat((boolean)cursor.next()).isFalse();
        }
    }

    @Test
    void shouldFailOnReadRelationshipBeforeReadFromStore() throws Exception {
        boolean needsValues = this.indexParams.indexProvidesStringValues();
        IndexQueryConstraints constraints = IndexQueryConstraints.unordered((boolean)needsValues);
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName("nodeProp"));
        try (RelationshipValueIndexCursor cursor = (RelationshipValueIndexCursor)this.entityParams.allocateEntityValueIndexCursor(this.tx, this.cursors);
             NodeCursor nodeCursor = this.tx.cursors().allocateNodeCursor(CursorContext.NULL_CONTEXT);
             PropertyCursor propertyCursor = this.tx.cursors().allocatePropertyCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            this.entityParams.entityIndexSeek(this.tx, index, cursor, constraints, new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (String)"one", (boolean)true, (String)"three", (boolean)true)});
            Assertions.assertThat((boolean)cursor.next()).isTrue();
            Assertions.assertThatThrownBy(() -> cursor.source(nodeCursor)).isInstanceOf(IllegalStateException.class);
            Assertions.assertThatThrownBy(() -> ((RelationshipValueIndexCursor)cursor).sourceNodeReference()).isInstanceOf(IllegalStateException.class);
            Assertions.assertThatThrownBy(() -> cursor.target(nodeCursor)).isInstanceOf(IllegalStateException.class);
            Assertions.assertThatThrownBy(() -> ((RelationshipValueIndexCursor)cursor).targetNodeReference()).isInstanceOf(IllegalStateException.class);
            Assertions.assertThatThrownBy(() -> ((RelationshipValueIndexCursor)cursor).type()).isInstanceOf(IllegalStateException.class);
            Assertions.assertThatThrownBy(() -> cursor.properties(propertyCursor)).isInstanceOf(IllegalStateException.class);
            Assertions.assertThatThrownBy(() -> ((RelationshipValueIndexCursor)cursor).propertiesReference()).isInstanceOf(IllegalStateException.class);
            Assertions.assertThat((long)cursor.relationshipReference()).isEqualTo(strOne);
        }
    }
}

