/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi.parallel;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.IOUtils;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.TransactionExecutionStatistic;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.time.Clocks;
import org.neo4j.util.concurrent.Futures;

@DbmsExtension
public class ExecutionContextIT {
    private static final int NUMBER_OF_WORKERS = 20;
    @Inject
    private GraphDatabaseAPI databaseAPI;
    private ExecutorService executors;

    @BeforeEach
    void setUp() {
        this.executors = Executors.newFixedThreadPool(20);
    }

    @AfterEach
    void tearDown() {
        this.executors.shutdown();
    }

    @RepeatedTest(value=10)
    void contextMemoryTracking() throws ExecutionException {
        try (Transaction transaction = this.databaseAPI.beginTx();){
            KernelTransactionImplementation ktx = (KernelTransactionImplementation)((InternalTransaction)transaction).kernelTransaction();
            ArrayList futures = new ArrayList(20);
            ArrayList<ExecutionContext> contexts = new ArrayList<ExecutionContext>(20);
            for (int i = 0; i < 20; ++i) {
                ExecutionContext executionContext = ktx.createExecutionContext();
                futures.add(this.executors.submit(() -> {
                    for (int j = 0; j < 5; ++j) {
                        executionContext.memoryTracker().allocateHeap(10L);
                    }
                    executionContext.complete();
                }));
                contexts.add(executionContext);
            }
            Futures.getAll(futures);
            KernelTransactions kernelTransactions = (KernelTransactions)this.databaseAPI.getDependencyResolver().resolveDependency(KernelTransactions.class);
            KernelTransactionHandle transactionHandle = kernelTransactions.activeTransactions().stream().filter(tx -> tx.isUnderlyingTransaction((KernelTransaction)ktx)).findFirst().orElseThrow();
            Assertions.assertEquals((long)ByteUnit.mebiBytes((long)40L), (Long)transactionHandle.transactionStatistic().getEstimatedUsedHeapMemory());
            Assertions.assertEquals((long)0L, (Long)transactionHandle.transactionStatistic().getNativeAllocatedBytes());
            IOUtils.closeAllUnchecked(contexts);
            Assertions.assertEquals((long)ByteUnit.mebiBytes((long)40L), (Long)transactionHandle.transactionStatistic().getEstimatedUsedHeapMemory());
            Assertions.assertEquals((long)0L, (Long)transactionHandle.transactionStatistic().getNativeAllocatedBytes());
            transaction.close();
            TransactionExecutionStatistic statistic = new TransactionExecutionStatistic(ktx, Clocks.nanoClock(), 0L);
            Assertions.assertEquals((long)0L, (Long)statistic.getEstimatedUsedHeapMemory());
            Assertions.assertEquals((long)0L, (Long)statistic.getNativeAllocatedBytes());
        }
    }

    @RepeatedTest(value=10)
    void contextAccessNodeExist() throws ExecutionException {
        int numberOfNodes = 1024;
        long[] nodeIds = new long[numberOfNodes];
        try (Transaction transaction = this.databaseAPI.beginTx();){
            for (int i = 0; i < numberOfNodes; ++i) {
                Node node = transaction.createNode();
                nodeIds[i] = node.getId();
            }
            transaction.commit();
        }
        transaction = this.databaseAPI.beginTx();
        try {
            KernelTransaction ktx = ((InternalTransaction)transaction).kernelTransaction();
            ArrayList futures = new ArrayList(20);
            ArrayList<ExecutionContext> contexts = new ArrayList<ExecutionContext>(20);
            for (int i = 0; i < 20; ++i) {
                ExecutionContext executionContext = ktx.createExecutionContext();
                futures.add(this.executors.submit(() -> {
                    for (long nodeId : nodeIds) {
                        Assertions.assertTrue((boolean)executionContext.dataRead().nodeExists(nodeId));
                    }
                    executionContext.complete();
                }));
                contexts.add(executionContext);
            }
            Futures.getAll(futures);
            IOUtils.closeAllUnchecked(contexts);
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @RepeatedTest(value=10)
    void contextAccessRelationshipExist() throws ExecutionException {
        int numberOfRelationships = 1024;
        long[] relIds = new long[numberOfRelationships];
        try (Transaction transaction = this.databaseAPI.beginTx();){
            for (int i = 0; i < numberOfRelationships; ++i) {
                Node start = transaction.createNode();
                Node end = transaction.createNode();
                Relationship relationship = start.createRelationshipTo(end, RelationshipType.withName((String)"maker"));
                relIds[i] = relationship.getId();
            }
            transaction.commit();
        }
        transaction = this.databaseAPI.beginTx();
        try {
            KernelTransaction ktx = ((InternalTransaction)transaction).kernelTransaction();
            ArrayList futures = new ArrayList(20);
            ArrayList<ExecutionContext> contexts = new ArrayList<ExecutionContext>(20);
            for (int i = 0; i < 20; ++i) {
                ExecutionContext executionContext = ktx.createExecutionContext();
                futures.add(this.executors.submit(() -> {
                    for (long relId : relIds) {
                        Assertions.assertTrue((boolean)executionContext.dataRead().relationshipExists(relId));
                    }
                    executionContext.complete();
                }));
                contexts.add(executionContext);
            }
            Futures.getAll(futures);
            IOUtils.closeAllUnchecked(contexts);
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @RepeatedTest(value=10)
    void contextPeriodicReport() throws ExecutionException {
        int numberOfNodes = 32768;
        long[] nodeIds = new long[numberOfNodes];
        try (Transaction transaction = this.databaseAPI.beginTx();){
            for (int i = 0; i < numberOfNodes; ++i) {
                Node node = transaction.createNode();
                nodeIds[i] = node.getId();
            }
            transaction.commit();
        }
        int nodeSize = this.databaseAPI.databaseLayout() instanceof RecordDatabaseLayout ? 15 : 128;
        int nodesPerPage = 8192 / nodeSize;
        int numPages = (int)Math.ceil((double)numberOfNodes / (double)nodesPerPage);
        int numPins = numPages * 20;
        try (Transaction transaction = this.databaseAPI.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)transaction).kernelTransaction();
            ArrayList futures = new ArrayList(20);
            ArrayList<ExecutionContext> contexts = new ArrayList<ExecutionContext>(20);
            for (int i = 0; i < 20; ++i) {
                ExecutionContext executionContext = ktx.createExecutionContext();
                futures.add(this.executors.submit(() -> {
                    for (long nodeId : nodeIds) {
                        Assertions.assertTrue((boolean)executionContext.dataRead().nodeExists(nodeId));
                        if (nodeId % 100L != 0L) continue;
                        executionContext.report();
                    }
                    executionContext.complete();
                }));
                contexts.add(executionContext);
            }
            Futures.getAll(futures);
            IOUtils.closeAllUnchecked(contexts);
            PageCursorTracer tracer = ktx.cursorContext().getCursorTracer();
            Assertions.assertEquals((long)numPins, (long)tracer.pins());
            Assertions.assertEquals((long)numPins, (long)tracer.unpins());
            Assertions.assertEquals((long)numPins, (long)tracer.hits());
        }
    }

    @Test
    void closingExecutionContextDoNotLeakCursors() {
        for (int i = 0; i < 1024; ++i) {
            try (Transaction transaction = this.databaseAPI.beginTx();){
                KernelTransaction ktx = ((InternalTransaction)transaction).kernelTransaction();
                try (ExecutionContext executionContext = ktx.createExecutionContext();){
                    executionContext.complete();
                    continue;
                }
            }
        }
    }
}

