/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.extension.DbmsController;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class PropertyKeyTest {
    @Inject
    private GraphDatabaseService db;
    @Inject
    DbmsController dbmsController;

    PropertyKeyTest() {
    }

    @Test
    void lazyLoadWithinWriteTransaction() throws IOException {
        String nodeId;
        Node node;
        int count = 1000;
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            PropertyKeyTest.mapWithManyProperties(count).forEach((arg_0, arg_1) -> ((Node)node).setProperty(arg_0, arg_1));
            nodeId = node.getElementId();
            tx.commit();
        }
        this.dbmsController.restartDbms();
        Assertions.assertThat((boolean)this.db.isAvailable(TimeUnit.MINUTES.toMillis(5L))).isTrue();
        tx = this.db.beginTx();
        try {
            tx.createNode();
            node = tx.getNodeByElementId(nodeId);
            Assertions.assertThat((Iterable)node.getPropertyKeys()).hasSize(count);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static Map<String, Object> mapWithManyProperties(int count) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (int i = 0; i < count; ++i) {
            properties.put("key:" + i, "value");
        }
        return properties;
    }
}

