/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.IndexingTestUtil;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorPredicates;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.SchemaNameUtil;
import org.neo4j.internal.schema.SchemaRulesAccessor;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.index.schema.RangeIndexProvider;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class SchemaStorageIT {
    private static final String LABEL1 = "Label1";
    private static final String LABEL2 = "Label2";
    private static final String TYPE1 = "Type1";
    private static final String PROP1 = "prop1";
    private static final String PROP2 = "prop2";
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private StorageEngine storageEngine;
    private StoreCursors storageCursors;
    private SchemaRulesAccessor schemaRules;

    SchemaStorageIT() {
    }

    @BeforeEach
    void initStorage() throws Exception {
        try (Transaction transaction = this.db.beginTx();){
            TokenWrite tokenWrite = ((InternalTransaction)transaction).kernelTransaction().tokenWrite();
            tokenWrite.propertyKeyGetOrCreateForName(PROP1);
            tokenWrite.propertyKeyGetOrCreateForName(PROP2);
            tokenWrite.labelGetOrCreateForName(LABEL1);
            tokenWrite.labelGetOrCreateForName(LABEL2);
            tokenWrite.relationshipTypeGetOrCreateForName(TYPE1);
            transaction.commit();
        }
        this.storageCursors = this.storageEngine.createStorageCursors(CursorContext.NULL_CONTEXT);
        this.schemaRules = this.storageEngine.schemaRulesAccessor();
    }

    @Test
    void shouldReturnIndexRuleForLabelAndProperty() {
        this.createSchema(SchemaStorageIT.index(LABEL1, PROP1), SchemaStorageIT.index(LABEL1, PROP2), SchemaStorageIT.index(LABEL2, PROP1));
        IndexDescriptor rule = (IndexDescriptor)ArrayUtil.single((Object[])this.schemaRules.indexesGetForDescriptor(this.indexDescriptor(LABEL1, PROP2).schema(), this.storageCursors));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)rule);
        this.assertRule(rule, LABEL1, PROP2, false);
    }

    @Test
    void shouldReturnIndexRuleForLabelAndPropertyComposite() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String f = "f";
        this.createSchema(tx -> tx.schema().indexFor(Label.label((String)LABEL1)).on(a).on(b).on(c).on(d).on(e).on(f).create());
        IndexDescriptor rule = (IndexDescriptor)ArrayUtil.single((Object[])this.schemaRules.indexesGetForDescriptor(TestIndexDescriptorFactory.forLabel((int)this.labelId(LABEL1), (int[])new int[]{this.propId(a), this.propId(b), this.propId(c), this.propId(d), this.propId(e), this.propId(f)}).schema(), this.storageCursors));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)rule);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasLabel((SchemaDescriptorSupplier)rule, (int)this.labelId(LABEL1)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(a)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(b)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(c)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(d)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(e)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(f)));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)rule.isUnique());
    }

    @Test
    void shouldReturnIndexRuleForLabelAndVeryManyPropertiesComposite() {
        String[] props = "abcdefghijklmnopqrstuvwxyzABCDEFGHJILKMNOPQRSTUVWXYZ".split("\\B");
        this.createSchema(tx -> {
            IndexCreator indexCreator = tx.schema().indexFor(Label.label((String)LABEL1));
            for (String prop : props) {
                indexCreator = indexCreator.on(prop);
            }
            indexCreator.create();
        });
        IndexDescriptor rule = (IndexDescriptor)ArrayUtil.single((Object[])this.schemaRules.indexesGetForDescriptor(TestIndexDescriptorFactory.forLabel((int)this.labelId(LABEL1), (int[])Arrays.stream(props).mapToInt(this::propId).toArray()).schema(), this.storageCursors));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)rule);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasLabel((SchemaDescriptorSupplier)rule, (int)this.labelId(LABEL1)));
        for (String prop : props) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(prop)));
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)rule.isUnique());
    }

    @Test
    void shouldReturnEmptyArrayIfIndexRuleForLabelAndPropertyDoesNotExist() {
        this.createSchema(SchemaStorageIT.index(LABEL1, PROP1));
        IndexDescriptor[] rules = this.schemaRules.indexesGetForDescriptor(this.indexDescriptor(LABEL1, PROP2).schema(), this.storageCursors);
        Assertions.assertThat((int)rules.length).isEqualTo(0);
    }

    @Test
    void shouldListIndexRulesForLabelPropertyAndKind() {
        this.createSchema(SchemaStorageIT.uniquenessConstraint(LABEL1, PROP1), SchemaStorageIT.index(LABEL1, PROP2));
        IndexDescriptor rule = (IndexDescriptor)ArrayUtil.single((Object[])this.schemaRules.indexesGetForDescriptor(this.uniqueIndexDescriptor(LABEL1, PROP1).schema(), this.storageCursors));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)rule);
        this.assertRule(rule, LABEL1, PROP1, true);
    }

    @Test
    void shouldListAllIndexRules() {
        IndexingTestUtil.dropAllIndexes((GraphDatabaseService)this.db);
        this.createSchema(SchemaStorageIT.index(LABEL1, PROP1), SchemaStorageIT.index(LABEL1, PROP2), SchemaStorageIT.uniquenessConstraint(LABEL2, PROP1));
        Set listedRules = Iterators.asSet((Iterator)this.schemaRules.indexesGetAll(this.storageCursors));
        HashSet<IndexDescriptor> expectedRules = new HashSet<IndexDescriptor>();
        expectedRules.add(this.makeIndexRule(3L, LABEL1, PROP1));
        expectedRules.add(this.makeIndexRule(4L, LABEL1, PROP2));
        expectedRules.add(this.makeIndexRuleForConstraint(5L, LABEL2, PROP1, 0L));
        org.junit.jupiter.api.Assertions.assertEquals(expectedRules, (Object)listedRules);
    }

    @Test
    void shouldReturnCorrectUniquenessRuleForLabelAndProperty() {
        this.createSchema(SchemaStorageIT.uniquenessConstraint(LABEL1, PROP1), SchemaStorageIT.uniquenessConstraint(LABEL2, PROP1));
        ConstraintDescriptor rule = (ConstraintDescriptor)ArrayUtil.single((Object[])this.schemaRules.constraintsGetForDescriptor((ConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)this.labelId(LABEL1), (int[])new int[]{this.propId(PROP1)}), this.storageCursors));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)rule);
        this.assertRule(rule, LABEL1, PROP1, ConstraintType.UNIQUE);
    }

    private void assertRule(IndexDescriptor rule, String label, String propertyKey, boolean isUnique) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasLabel((SchemaDescriptorSupplier)rule, (int)this.labelId(label)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(propertyKey)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)isUnique, (Object)rule.isUnique());
    }

    private void assertRule(ConstraintDescriptor constraint, String label, String propertyKey, ConstraintType type) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasLabel((SchemaDescriptorSupplier)constraint, (int)this.labelId(label)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)constraint, (int)this.propId(propertyKey)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)type, (Object)constraint.type());
    }

    private IndexDescriptor indexDescriptor(String label, String property) {
        return TestIndexDescriptorFactory.forLabel((int)this.labelId(label), (int[])new int[]{this.propId(property)});
    }

    private IndexDescriptor uniqueIndexDescriptor(String label, String property) {
        return TestIndexDescriptorFactory.uniqueForLabel((int)this.labelId(label), (int[])new int[]{this.propId(property)});
    }

    private IndexDescriptor makeIndexRule(long ruleId, String label, String propertyKey) {
        LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)this.labelId(label), (int[])new int[]{this.propId(propertyKey)});
        IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)RangeIndexProvider.DESCRIPTOR);
        prototype = prototype.withName(SchemaNameUtil.generateName((SchemaDescriptorSupplier)prototype, (String[])new String[]{label}, (String[])new String[]{propertyKey}));
        return prototype.materialise(ruleId);
    }

    private IndexDescriptor makeIndexRuleForConstraint(long ruleId, String label, String propertyKey, long constraintId) {
        LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)this.labelId(label), (int[])new int[]{this.propId(propertyKey)});
        IndexPrototype prototype = IndexPrototype.uniqueForSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)RangeIndexProvider.DESCRIPTOR);
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)schema);
        prototype = prototype.withName(SchemaNameUtil.generateName((SchemaDescriptorSupplier)constraint, (String[])new String[]{label}, (String[])new String[]{propertyKey}));
        return prototype.materialise(ruleId).withOwningConstraintId(constraintId);
    }

    private int labelId(String labelName) {
        try (Transaction tx = this.db.beginTx();){
            int n = ((InternalTransaction)tx).kernelTransaction().tokenRead().nodeLabel(labelName);
            return n;
        }
    }

    private int propId(String propName) {
        try (Transaction tx = this.db.beginTx();){
            int n = ((InternalTransaction)tx).kernelTransaction().tokenRead().propertyKey(propName);
            return n;
        }
    }

    private static Consumer<Transaction> index(String label, String prop) {
        return tx -> tx.schema().indexFor(Label.label((String)label)).on(prop).create();
    }

    private static Consumer<Transaction> uniquenessConstraint(String label, String prop) {
        return tx -> tx.schema().constraintFor(Label.label((String)label)).assertPropertyIsUnique(prop).create();
    }

    @SafeVarargs
    private void createSchema(Consumer<Transaction> ... creators) {
        try (Transaction tx = this.db.beginTx();){
            for (Consumer<Transaction> rule : creators) {
                rule.accept(tx);
            }
            tx.commit();
        }
        this.awaitIndexes();
    }

    private void awaitIndexes() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
    }
}

