/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.fs.ReadableChecksumChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.api.TestCommand;
import org.neo4j.kernel.impl.api.TestCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSets;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StorageCommand;

class LogEntryParserDispatcherV6Test {
    private final KernelVersion version = KernelVersion.LATEST;
    private final CommandReaderFactory commandReader = new TestCommandReaderFactory();
    private final LogPositionMarker marker = new LogPositionMarker();
    private final LogPosition position = new LogPosition(0L, 25L);

    LogEntryParserDispatcherV6Test() {
    }

    @Test
    void shouldParserStartEntry() throws IOException {
        LogEntryStart start = new LogEntryStart(this.version, 1L, 2L, 3, new byte[]{4}, this.position);
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        channel.putLong(start.getTimeWritten());
        channel.putLong(start.getLastCommittedTxWhenTransactionStarted());
        channel.putInt(start.getPreviousChecksum());
        channel.putInt(start.getAdditionalHeader().length);
        channel.put(start.getAdditionalHeader(), start.getAdditionalHeader().length);
        channel.getCurrentPosition(this.marker);
        LogEntryParser parser = LogEntryParserSets.parserSet((KernelVersion)KernelVersion.LATEST).select((byte)1);
        LogEntry logEntry = parser.parse(this.version, (ReadableChecksumChannel)channel, this.marker, this.commandReader);
        Assertions.assertEquals((Object)start, (Object)logEntry);
    }

    @Test
    void shouldParserOnePhaseCommitEntry() throws IOException {
        LogEntryCommit commit = new LogEntryCommit(this.version, 42L, 21L, -361070784);
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        channel.putLong(commit.getTxId());
        channel.putLong(commit.getTimeWritten());
        channel.putChecksum();
        channel.getCurrentPosition(this.marker);
        LogEntryParser parser = LogEntryParserSets.parserSet((KernelVersion)KernelVersion.LATEST).select((byte)5);
        LogEntry logEntry = parser.parse(this.version, (ReadableChecksumChannel)channel, this.marker, this.commandReader);
        Assertions.assertEquals((Object)commit, (Object)logEntry);
    }

    @Test
    void shouldParserCommandsUsingAGivenFactory() throws IOException {
        TestCommand testCommand = new TestCommand(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        LogEntryCommand command = new LogEntryCommand(this.version, (StorageCommand)testCommand);
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        testCommand.serialize((WritableChannel)channel);
        channel.getCurrentPosition(this.marker);
        LogEntryParser parser = LogEntryParserSets.parserSet((KernelVersion)KernelVersion.LATEST).select((byte)3);
        LogEntry logEntry = parser.parse(this.version, (ReadableChecksumChannel)channel, this.marker, this.commandReader);
        Assertions.assertEquals((Object)command, (Object)logEntry);
    }

    @Test
    void shouldThrowWhenParsingUnknownEntry() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> LogEntryParserSets.parserSet((KernelVersion)KernelVersion.LATEST).select((byte)42));
    }
}

