/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.nio.file.Path;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@EphemeralTestDirectoryExtension
class TestTxEntries {
    @Inject
    private EphemeralFileSystemAbstraction fs;
    @Inject
    private TestDirectory testDirectory;

    TestTxEntries() {
    }

    @Test
    void testStartEntryWrittenOnceOnRollback() {
        Path storeDir = this.testDirectory.homePath();
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(storeDir).setFileSystem((FileSystemAbstraction)this.fs).build();
        GraphDatabaseService db = managementService.database("neo4j");
        TestTxEntries.createSomeTransactions(db);
        EphemeralFileSystemAbstraction snapshot = this.fs.snapshot();
        managementService.shutdown();
        managementService = new TestDatabaseManagementServiceBuilder(storeDir).setFileSystem((FileSystemAbstraction)snapshot).build();
        managementService.shutdown();
    }

    private static void createSomeTransactions(GraphDatabaseService db) {
        Node node1;
        try (Transaction tx = db.beginTx();){
            node1 = tx.createNode();
            Node node2 = tx.createNode();
            node1.createRelationshipTo(node2, RelationshipType.withName((String)"relType1"));
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.getNodeById(node1.getId()).delete();
            Assertions.assertThrows(ConstraintViolationException.class, () -> ((Transaction)tx).commit());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = db.beginTx();
        try {
            tx.getNodeById(node1.getId()).setProperty("foo", (Object)"bar");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

