/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.CommonDatabaseStores;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.store.StoreFileListing;
import org.neo4j.kernel.impl.store.StoreFileProvider;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StoreFileMetadata;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.utils.TestDirectory;

@DbmsExtension
class StoreFileListingTest {
    private final Predicate<Path> DEFAULT_FILENAME_FILTER = IOUtils.uncheckedPredicate(TransactionLogFiles.DEFAULT_FILENAME_FILTER::accept);
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction filesystem;
    @Inject
    private Database database;

    StoreFileListingTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        this.createIndexDbFile();
    }

    @Test
    void shouldCloseIndexSnapshots() throws Exception {
        String indexDir = "indexes";
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        DatabaseLayout databaseLayout = (DatabaseLayout)Mockito.mock(DatabaseLayout.class);
        Mockito.when((Object)databaseLayout.pathForStore((CommonDatabaseStores)ArgumentMatchers.eq((Object)CommonDatabaseStores.METADATA))).thenReturn((Object)((Path)Mockito.mock(Path.class)));
        LogFiles logFiles = (LogFiles)Mockito.mock(LogFiles.class);
        StoreFileListingTest.filesInStoreDirAre(databaseLayout, indexDir);
        StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
        IdGeneratorFactory idGeneratorFactory = (IdGeneratorFactory)Mockito.mock(IdGeneratorFactory.class);
        StoreFileListing fileListing = new StoreFileListing(databaseLayout, logFiles, indexingService, storageEngine, idGeneratorFactory);
        ResourceIterator<Path> indexSnapshot = StoreFileListingTest.indexFilesAre(indexingService, new String[]{indexDir + "/mock/my.index"});
        ResourceIterator result = fileListing.builder().excludeLogFiles().build();
        result.close();
        ((ResourceIterator)Mockito.verify(indexSnapshot)).close();
    }

    @Test
    void shouldListMetaDataStoreLast() throws Exception {
        StoreFileMetadata fileMetadata = (StoreFileMetadata)Iterators.last((Iterator)this.database.listStoreFiles(false));
        org.junit.jupiter.api.Assertions.assertEquals((Object)fileMetadata.path(), (Object)this.database.getDatabaseLayout().pathForStore(CommonDatabaseStores.METADATA));
    }

    @Test
    void shouldListMetaDataStoreLastWithTxLogs() throws Exception {
        StoreFileMetadata fileMetadata = (StoreFileMetadata)Iterators.last((Iterator)this.database.listStoreFiles(true));
        org.junit.jupiter.api.Assertions.assertEquals((Object)fileMetadata.path(), (Object)this.database.getDatabaseLayout().pathForStore(CommonDatabaseStores.METADATA));
    }

    @Test
    void shouldListTransactionLogsFromCustomAbsoluteLocationWhenConfigured() throws IOException {
        Path customLogLocation = this.testDirectory.directory("customLogLocation");
        this.verifyLogFilesWithCustomPathListing(customLogLocation.toAbsolutePath());
    }

    @Test
    void shouldListTxLogFiles() throws Exception {
        try (ResourceIterator storeFiles = this.database.listStoreFiles(true);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)storeFiles.stream().map(metaData -> metaData.path().getFileName()).anyMatch(this.DEFAULT_FILENAME_FILTER));
        }
    }

    @Test
    void shouldNotListTxLogFiles() throws Exception {
        try (ResourceIterator storeFiles = this.database.listStoreFiles(false);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)storeFiles.stream().map(metaData -> metaData.path().getFileName()).noneMatch(this.DEFAULT_FILENAME_FILTER));
        }
    }

    @Test
    void shouldListStoreFiles() throws Exception {
        DatabaseLayout layout = this.database.getDatabaseLayout();
        Path statsPath = layout.pathForStore(CommonDatabaseStores.INDEX_STATISTICS);
        HashSet expectedFiles = new HashSet(layout.storeFiles());
        expectedFiles.remove(statsPath);
        StoreFileListing.Builder fileListingBuilder = this.database.getStoreFileListing().builder();
        fileListingBuilder.excludeIdFiles();
        fileListingBuilder.excludeLogFiles();
        fileListingBuilder.excludeSchemaIndexStoreFiles();
        try (ResourceIterator storeFiles = fileListingBuilder.build();){
            Set listedStoreFiles = storeFiles.stream().map(StoreFileMetadata::path).collect(Collectors.toSet());
            Assertions.assertThat(listedStoreFiles).containsExactlyInAnyOrderElementsOf(expectedFiles);
        }
    }

    @Test
    void doNotListFilesFromAdditionalProviderThatRegisterTwice() throws IOException {
        StoreFileListing storeFileListing = this.database.getStoreFileListing();
        MarkerFileProvider provider = new MarkerFileProvider();
        storeFileListing.registerStoreFileProvider((StoreFileProvider)provider);
        storeFileListing.registerStoreFileProvider((StoreFileProvider)provider);
        try (ResourceIterator storeFiles = storeFileListing.builder().build();){
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)storeFiles.stream().filter(metadata -> "marker".equals(metadata.path().getFileName().toString())).count());
        }
    }

    private void verifyLogFilesWithCustomPathListing(Path path) throws IOException {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath("customDb")).setConfig(GraphDatabaseSettings.transaction_logs_root_path, (Object)path).build();
        GraphDatabaseAPI graphDatabase = (GraphDatabaseAPI)managementService.database("neo4j");
        Database database = (Database)graphDatabase.getDependencyResolver().resolveDependency(Database.class);
        LogFiles logFiles = (LogFiles)graphDatabase.getDependencyResolver().resolveDependency(LogFiles.class);
        try (ResourceIterator storeFiles = database.listStoreFiles(true);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)storeFiles.stream().anyMatch(metadata -> metadata.isLogFile() && logFiles.isLogFile(metadata.path())));
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)path.getFileName().toString(), (Object)logFiles.logFilesDirectory().getParent().getFileName().toString());
        managementService.shutdown();
    }

    private static void filesInStoreDirAre(DatabaseLayout databaseLayout, String indexDir) {
        String[] mockDbFiles = new String[]{"biff", "baff", "boff.log", "mockstore", "mockstore.id", "mockstore.counts.db", "mockstore.labeltokenstore.db", "mockstore.labeltokenstore.db.id", "mockstore.labeltokenstore.db.names", "mockstore.labeltokenstore.db.names.id", "mockstore.nodestore.db", "mockstore.nodestore.db.id", "mockstore.nodestore.db.labels", "mockstore.nodestore.db.labels.id", "mockstore.propertystore.db", "mockstore.propertystore.db.arrays", "mockstore.propertystore.db.arrays.id", "mockstore.propertystore.db.id", "mockstore.propertystore.db.index", "mockstore.propertystore.db.index.id", "mockstore.propertystore.db.index.keys", "mockstore.propertystore.db.index.keys.id", "mockstore.propertystore.db.strings", "mockstore.propertystore.db.strings.id", "mockstore.relationshipgroupstore.db", "mockstore.relationshipgroupstore.db.id", "mockstore.relationshipstore.db", "mockstore.relationshipstore.db.id", "mockstore.relationshiptypestore.db", "mockstore.relationshiptypestore.db.id", "mockstore.relationshiptypestore.db.names", "mockstore.relationshiptypestore.db.names.id", "mockstore.schemastore.db", "mockstore.schemastore.db.id", "mockstore.transaction.db.0", "mockstore.transaction.db.1", "mockstore.transaction.db.2", "mockstore_lock"};
        String[] mockDirectories = new String[]{"foo", "bar", "baz", indexDir};
        ArrayList<Path> files = new ArrayList<Path>();
        StoreFileListingTest.mockFiles(mockDbFiles, files, false);
        StoreFileListingTest.mockFiles(mockDirectories, files, true);
        Mockito.when((Object)databaseLayout.listDatabaseFiles((FileSystemAbstraction)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).thenReturn((Object)files.toArray(new Path[0]));
    }

    private static ResourceIterator<Path> indexFilesAre(IndexingService indexingService, String[] fileNames) throws IOException {
        ArrayList<Path> files = new ArrayList<Path>();
        StoreFileListingTest.mockFiles(fileNames, files, false);
        ResourceIterator snapshot = (ResourceIterator)Mockito.spy((Object)Iterators.asResourceIterator(files.iterator()));
        Mockito.when((Object)indexingService.snapshotIndexFiles()).thenReturn((Object)snapshot);
        return snapshot;
    }

    private void createIndexDbFile() throws IOException {
        DatabaseLayout databaseLayout = this.db.databaseLayout();
        Path indexFile = databaseLayout.file("index.db");
        this.filesystem.write(indexFile).close();
    }

    private static void mockFiles(String[] filenames, List<Path> files, boolean isDirectories) {
        for (String filename : filenames) {
            File file = (File)Mockito.mock(File.class);
            Path path = (Path)Mockito.mock(Path.class);
            String[] fileNameParts = filename.split("/");
            Mockito.when((Object)file.getName()).thenReturn((Object)fileNameParts[fileNameParts.length - 1]);
            Mockito.when((Object)file.isFile()).thenReturn((Object)(!isDirectories ? 1 : 0));
            Mockito.when((Object)file.isDirectory()).thenReturn((Object)isDirectories);
            Mockito.when((Object)file.exists()).thenReturn((Object)true);
            Mockito.when((Object)file.getPath()).thenReturn((Object)filename);
            Mockito.when((Object)path.toFile()).thenReturn((Object)file);
            files.add(path);
        }
    }

    private static class MarkerFileProvider
    implements StoreFileProvider {
        private MarkerFileProvider() {
        }

        public Resource addFilesTo(Collection<StoreFileMetadata> fileMetadataCollection) {
            fileMetadataCollection.add(new StoreFileMetadata(Path.of("marker", new String[0]), 0));
            return Resource.EMPTY;
        }
    }
}

