/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class MissingStoreFilesRecoveryIT {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fileSystem;
    private DatabaseManagementService managementService;
    private DatabaseLayout databaseLayout;
    private TestDatabaseManagementServiceBuilder serviceBuilder;
    private NamedDatabaseId defaultNamedDatabaseId;
    private static final Label testNodes = Label.label((String)"testNodes");

    MissingStoreFilesRecoveryIT() {
    }

    @BeforeEach
    void setUp() throws IOException {
        this.serviceBuilder = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath());
        this.managementService = this.serviceBuilder.build();
        GraphDatabaseAPI databaseApi = MissingStoreFilesRecoveryIT.defaultDatabase(this.managementService);
        MissingStoreFilesRecoveryIT.createSomeData(databaseApi);
        this.databaseLayout = databaseApi.databaseLayout();
        this.defaultNamedDatabaseId = (NamedDatabaseId)this.getDatabaseManager().databaseIdRepository().getByName("neo4j").orElseThrow();
        this.managementService.shutdown();
    }

    @AfterEach
    void tearDown() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
    }

    @Test
    void databaseStartFailingOnMissingFilesAndMissedTxLogs() throws IOException {
        Path storeFile = MissingStoreFilesRecoveryIT.getStoreFile(this.databaseLayout);
        this.fileSystem.deleteFile(storeFile);
        this.fileSystem.deleteRecursively(this.databaseLayout.getTransactionLogsDirectory());
        this.managementService = this.serviceBuilder.build();
        DatabaseStateService dbStateService = this.getDatabaseStateService();
        Assertions.assertThat((Throwable)((Throwable)dbStateService.causeOfFailure(this.defaultNamedDatabaseId).orElseThrow())).hasRootCauseMessage(String.format("Store files [%s] is(are) missing and recovery is not possible. Please restore from a consistent backup.", storeFile.toAbsolutePath()));
    }

    @Test
    void failToStartOnMissingFilesAndPartialTransactionLogs() throws IOException {
        LogFiles logFiles = this.prepareDatabaseWithTwoTxLogFiles();
        this.fileSystem.deleteFile(logFiles.getLogFile().getLogFileForVersion(0L));
        Path storeFile = MissingStoreFilesRecoveryIT.getStoreFile(this.databaseLayout);
        this.fileSystem.deleteFile(storeFile);
        DatabaseStateService dbStateService = this.getDatabaseStateService();
        Optional failure = dbStateService.causeOfFailure(this.defaultNamedDatabaseId);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)failure.isPresent());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.fileSystem.fileExists(storeFile));
    }

    private static Path getStoreFile(DatabaseLayout layout) {
        return layout.mandatoryStoreFiles().stream().filter(Predicate.not(layout.pathForExistsMarker()::equals)).findAny().orElseThrow();
    }

    private LogFiles prepareDatabaseWithTwoTxLogFiles() throws IOException {
        this.managementService = this.serviceBuilder.build();
        GraphDatabaseAPI databaseApi = MissingStoreFilesRecoveryIT.defaultDatabase(this.managementService);
        LogFiles logFiles = MissingStoreFilesRecoveryIT.rotateTransactionLogs(databaseApi);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)logFiles.getLogFile().getLogFileForVersion(1L));
        MissingStoreFilesRecoveryIT.createSomeData(databaseApi);
        this.managementService.shutdown();
        return logFiles;
    }

    private DatabaseContextProvider getDatabaseManager() {
        return (DatabaseContextProvider)MissingStoreFilesRecoveryIT.defaultDatabase(this.managementService).getDependencyResolver().resolveDependency(DatabaseContextProvider.class);
    }

    private DatabaseStateService getDatabaseStateService() {
        return (DatabaseStateService)MissingStoreFilesRecoveryIT.defaultDatabase(this.managementService).getDependencyResolver().resolveDependency(DatabaseStateService.class);
    }

    private static GraphDatabaseAPI defaultDatabase(DatabaseManagementService managementService) {
        return (GraphDatabaseAPI)managementService.database("neo4j");
    }

    private static LogFiles rotateTransactionLogs(GraphDatabaseAPI databaseApi) throws IOException {
        LogFiles logFiles = (LogFiles)databaseApi.getDependencyResolver().resolveDependency(LogFiles.class);
        LogFile logFile = logFiles.getLogFile();
        logFile.rotate();
        return logFiles;
    }

    private static void createSomeData(GraphDatabaseAPI databaseApi) throws IOException {
        MissingStoreFilesRecoveryIT.insertData(databaseApi);
        CheckPointer checkPointer = (CheckPointer)databaseApi.getDependencyResolver().resolveDependency(CheckPointer.class);
        checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("forcedCheckpointInTheMiddle"));
        MissingStoreFilesRecoveryIT.insertData(databaseApi);
    }

    private static void insertData(GraphDatabaseAPI databaseApi) {
        for (int i = 0; i < 100; ++i) {
            try (Transaction transaction = databaseApi.beginTx();){
                Node nodeA = transaction.createNode(new Label[]{testNodes});
                Node nodeB = transaction.createNode(new Label[]{testNodes});
                nodeA.createRelationshipTo(nodeB, RelationshipType.withName((String)String.valueOf(i)));
                transaction.commit();
                continue;
            }
        }
    }
}

