/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.util.function.Predicate;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.Condition;
import org.mockito.Mockito;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.recovery.RecoveryIT;
import org.neo4j.lock.LockGroup;
import org.neo4j.lock.LockService;
import org.neo4j.storageengine.api.CommandStream;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

class ParallelRecoveryIT
extends RecoveryIT {
    ParallelRecoveryIT() {
    }

    @Override
    void additionalConfiguration(Config config) {
        super.additionalConfiguration(config);
        config.set(GraphDatabaseInternalSettings.do_parallel_recovery, (Object)true);
    }

    @Override
    TestDatabaseManagementServiceBuilder additionalConfiguration(TestDatabaseManagementServiceBuilder builder) {
        return builder.setConfig(GraphDatabaseInternalSettings.do_parallel_recovery, (Object)true);
    }

    @Override
    protected GraphDatabaseAPI createDatabase(long logThreshold) {
        GraphDatabaseAPI db = super.createDatabase(logThreshold);
        DependencyResolver dependencyResolver = db.getDependencyResolver();
        if (dependencyResolver.containsDependency(StorageEngine.class)) {
            StorageEngine storageEngine = (StorageEngine)dependencyResolver.resolveDependency(StorageEngine.class);
            this.assumeParallelRecoveryImplemented(storageEngine);
        }
        return db;
    }

    private void assumeParallelRecoveryImplemented(StorageEngine engine) {
        Assumptions.assumeThatThrownBy(() -> engine.lockRecoveryCommands((CommandStream)Mockito.mock(CommandStream.class), (LockService)Mockito.mock(LockService.class), (LockGroup)Mockito.mock(LockGroup.class), TransactionApplicationMode.EXTERNAL)).is(new Condition(Predicate.not(UnsupportedOperationException.class::isInstance), "Supported operation", new Object[0]));
    }
}

