/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.recovery;

import java.io.File;
import java.io.IOException;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.index.internal.gbptree.MultiRootGBPTree;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.impl.index.schema.RangeIndexProvider;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Health;
import org.neo4j.monitoring.Monitors;
import org.neo4j.test.Barrier;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Values;

@TestDirectoryExtension
class RecoveryCleanupIT {
    @Inject
    private TestDirectory testDirectory;
    private GraphDatabaseService db;
    private TestDatabaseManagementServiceBuilder factory;
    private final ExecutorService executor = Executors.newFixedThreadPool(2);
    private final Label label = Label.label((String)"label");
    private final String propKey = "propKey";
    private final Map<Setting<?>, Object> testSpecificConfig = new HashMap();
    private DatabaseManagementService managementService;

    RecoveryCleanupIT() {
    }

    @BeforeEach
    void setup() {
        this.factory = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath());
    }

    @AfterEach
    void tearDown() throws InterruptedException {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
        this.executor.shutdown();
        this.executor.awaitTermination(10L, TimeUnit.SECONDS);
    }

    @Test
    void recoveryCleanupShouldBlockRecoveryWritingToCleanedIndexes() throws IOException, ExecutionException, InterruptedException {
        this.dirtyDatabase();
        Barrier.Control recoveryCompleteBarrier = new Barrier.Control();
        RecoveryBarrierMonitor recoveryBarrierMonitor = new RecoveryBarrierMonitor(recoveryCompleteBarrier);
        this.setMonitor((Object)recoveryBarrierMonitor);
        Future<GraphDatabaseService> recovery = this.executor.submit(() -> {
            this.db = this.startDatabase();
            return this.db;
        });
        recoveryCompleteBarrier.awaitUninterruptibly();
        RecoveryCleanupIT.shouldWait(recovery);
        recoveryCompleteBarrier.release();
        recovery.get();
    }

    @Test
    void scanStoreMustLogCrashPointerCleanupDuringRecovery() throws Exception {
        this.dirtyDatabase();
        AssertableLogProvider logProvider = new AssertableLogProvider(true);
        this.factory.setUserLogProvider((LogProvider)logProvider);
        this.factory.setInternalLogProvider((InternalLogProvider)logProvider);
        this.startDatabase();
        this.managementService.shutdown();
        LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessageWithAll(new String[]{"Schema index cleanup job registered", "descriptor", "type='LOOKUP'", "schema=(:<any-labels>)", "indexFile="}).containsMessageWithAll(new String[]{"Schema index cleanup job started", "descriptor", "type='LOOKUP'", "schema=(:<any-labels>)", "indexFile="}).containsMessageWithAll(new String[]{"Schema index cleanup job closed", "descriptor", "type='LOOKUP'", "schema=(:<any-labels>)", "indexFile="}).containsMessageWithAll(new String[]{"Schema index cleanup job finished", "descriptor", "type='LOOKUP'", "schema=(:<any-labels>)", "indexFile=", "Number of pages visited", "Number of cleaned crashed pointers", "Time spent"});
    }

    @Test
    void nativeIndexRangeMustLogCrashPointerCleanupDuringRecovery() throws Exception {
        this.dirtyDatabase();
        AssertableLogProvider logProvider = new AssertableLogProvider(true);
        this.factory.setInternalLogProvider((InternalLogProvider)logProvider);
        this.startDatabase();
        this.managementService.shutdown();
        String providerString = RangeIndexProvider.DESCRIPTOR.name();
        LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessageWithAll(RecoveryCleanupIT.indexRecoveryLogMatcher("Schema index cleanup job registered", providerString)).containsMessageWithAll(RecoveryCleanupIT.indexRecoveryLogMatcher("Schema index cleanup job started", providerString)).containsMessageWithAll(RecoveryCleanupIT.indexRecoveryFinishedLogMatcher(providerString)).containsMessageWithAll(RecoveryCleanupIT.indexRecoveryLogMatcher("Schema index cleanup job closed", providerString));
    }

    private static String[] indexRecoveryLogMatcher(String logMessage, String providerString) {
        return new String[]{logMessage, "descriptor", "type='RANGE'", "indexFile=", File.separator + providerString};
    }

    private static String[] indexRecoveryFinishedLogMatcher(String providerString) {
        return new String[]{"Schema index cleanup job finished", "descriptor", "type='RANGE'", "indexFile=", File.separator + providerString, "Number of pages visited", "Number of cleaned crashed pointers", "Time spent"};
    }

    private void dirtyDatabase() throws IOException {
        this.db = this.startDatabase();
        Health databaseHealth = RecoveryCleanupIT.databaseHealth(this.db);
        this.index(this.db);
        this.someData(this.db);
        RecoveryCleanupIT.checkpoint(this.db);
        this.someData(this.db);
        databaseHealth.panic(new Throwable("Trigger recovery on next startup"));
        this.managementService.shutdown();
        this.db = null;
    }

    private <T> void setTestConfig(Setting<T> setting, T value) {
        this.testSpecificConfig.put(setting, value);
    }

    private void setMonitor(Object monitor) {
        Monitors monitors = new Monitors();
        monitors.addMonitorListener(monitor, new String[0]);
        this.factory.setMonitors(monitors);
    }

    private void index(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            tx.schema().indexFor(this.label).on("propKey").create();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static void checkpoint(GraphDatabaseService db) throws IOException {
        CheckPointer checkPointer = RecoveryCleanupIT.checkPointer(db);
        checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
    }

    private void someData(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            tx.createNode(new Label[]{this.label}).setProperty("propKey", (Object)1);
            tx.createNode(new Label[]{this.label}).setProperty("propKey", (Object)"string");
            tx.createNode(new Label[]{this.label}).setProperty("propKey", (Object)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{0.5, 0.5}));
            tx.createNode(new Label[]{this.label}).setProperty("propKey", (Object)LocalTime.of(0, 0));
            tx.commit();
        }
    }

    private static void shouldWait(Future<?> future) {
        Assertions.assertThrows(TimeoutException.class, () -> future.get(200L, TimeUnit.MILLISECONDS));
    }

    private GraphDatabaseService startDatabase() {
        this.factory.setConfig(this.testSpecificConfig);
        this.managementService = this.factory.build();
        return this.managementService.database("neo4j");
    }

    private static Health databaseHealth(GraphDatabaseService db) {
        return (Health)RecoveryCleanupIT.dependencyResolver(db).resolveDependency(DatabaseHealth.class);
    }

    private static CheckPointer checkPointer(GraphDatabaseService db) {
        DependencyResolver dependencyResolver = RecoveryCleanupIT.dependencyResolver(db);
        return (CheckPointer)((Database)dependencyResolver.resolveDependency(Database.class)).getDependencyResolver().resolveDependency(CheckPointer.class);
    }

    private static DependencyResolver dependencyResolver(GraphDatabaseService db) {
        return ((GraphDatabaseAPI)db).getDependencyResolver();
    }

    private static class RecoveryBarrierMonitor
    extends MultiRootGBPTree.Monitor.Adaptor {
        private final Barrier.Control barrier;

        RecoveryBarrierMonitor(Barrier.Control barrier) {
            this.barrier = barrier;
        }

        public void cleanupFinished(long numberOfPagesVisited, long numberOfTreeNodes, long numberOfCleanedCrashPointers, long durationMillis) {
            this.barrier.reached();
        }
    }
}

