/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.recovery;

import java.io.IOException;
import java.nio.file.Path;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.utils.TestDirectory;

@Neo4jLayoutExtension
class RecoveryLogIT {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private DatabaseLayout databaseLayout;
    private DatabaseManagementService managementService;

    RecoveryLogIT() {
    }

    @AfterEach
    void tearDown() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
    }

    @Test
    void transactionsRecoveryLogContainsTimeSpent() throws IOException {
        Path[] txLogs;
        Path tmpLogDir = this.testDirectory.directory("logs");
        this.managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            Path[] node1 = tx.createNode();
            Node node2 = tx.createNode();
            node1.createRelationshipTo(node2, RelationshipType.withName((String)"likes"));
            tx.commit();
        }
        for (Path file : txLogs = LogFilesBuilder.logFilesBasedOnlyBuilder((Path)this.databaseLayout.getTransactionLogsDirectory(), (FileSystemAbstraction)this.fileSystem).build().logFiles()) {
            this.fileSystem.copyToDirectory(file, tmpLogDir);
        }
        this.managementService.shutdown();
        for (Path txLog : this.fileSystem.listFiles(this.databaseLayout.getTransactionLogsDirectory())) {
            this.fileSystem.deleteFile(txLog);
        }
        for (Path file : LogFilesBuilder.logFilesBasedOnlyBuilder((Path)tmpLogDir, (FileSystemAbstraction)this.fileSystem).build().logFiles()) {
            this.fileSystem.moveToDirectory(file, this.databaseLayout.getTransactionLogsDirectory());
        }
        AssertableLogProvider provider = new AssertableLogProvider();
        this.managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setInternalLogProvider((InternalLogProvider)provider).build();
        this.managementService.database("neo4j");
        LogAssertions.assertThat((AssertableLogProvider)provider).containsMessages(new String[]{"Recovery completed", "time spent"});
    }
}

