/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tracers;

import java.util.Iterator;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.LongAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.graphdb.event.TransactionEventListenerAdapter;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@ExtendWith(value={SoftAssertionsExtension.class})
@DbmsExtension
class TransactionTracingIT {
    private static final int ENTITY_COUNT = 1000;
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private DatabaseManagementService managementService;
    @InjectSoftAssertions
    private SoftAssertions softly;

    TransactionTracingIT() {
    }

    @Test
    void tracePageCacheAccessOnAllNodesAccess() {
        try (Transaction transaction = this.database.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                transaction.createNode();
            }
            transaction.commit();
        }
        transaction = (InternalTransaction)this.database.beginTx();
        try {
            CursorContext cursorContext = transaction.kernelTransaction().cursorContext();
            this.assertZeroCursor(cursorContext);
            ((LongAssert)this.softly.assertThat(Iterables.count((Iterable)transaction.getAllNodes())).as("Number of expected nodes", new Object[0])).isEqualTo(1000L);
            this.assertTraces(cursorContext, this.isRecordFormat() ? this.traces(2, 2, 2) : this.traces(16, 15, 16));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void tracePageCacheAccessOnNodeCreation() {
        try (InternalTransaction transaction = (InternalTransaction)this.database.beginTx();){
            CursorContext cursorContext = transaction.kernelTransaction().cursorContext();
            CommitCursorChecker commitCursorChecker = new CommitCursorChecker(cursorContext, this.isRecordFormat() ? this.traces(1001, 1001, 999, 2) : this.traces(2001, 2001, 1985, 16));
            this.managementService.registerTransactionEventListener(this.database.databaseName(), (TransactionEventListener)commitCursorChecker);
            for (int i = 0; i < 1000; ++i) {
                transaction.createNode();
            }
            this.assertZeroCursor(cursorContext);
            transaction.commit();
            ((BooleanAssert)this.softly.assertThat(commitCursorChecker.isInvoked()).as("Transaction committed", new Object[0])).isTrue();
        }
    }

    @Test
    void tracePageCacheAccessOnAllRelationshipsAccess() {
        try (Transaction transaction = this.database.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                Node source = transaction.createNode();
                source.createRelationshipTo(transaction.createNode(), RelationshipType.withName((String)"connection"));
            }
            transaction.commit();
        }
        transaction = (InternalTransaction)this.database.beginTx();
        try {
            CursorContext cursorContext = transaction.kernelTransaction().cursorContext();
            this.assertZeroCursor(cursorContext);
            ((LongAssert)this.softly.assertThat(Iterables.count((Iterable)transaction.getAllRelationships())).as("Number of expected relationships", new Object[0])).isEqualTo(1000L);
            this.assertTraces(cursorContext, this.isRecordFormat() ? this.traces(5, 5, 5) : this.traces(32, 31, 32));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void tracePageCacheAccessOnFindNodes() {
        Label marker = Label.label((String)"marker");
        RelationshipType type = RelationshipType.withName((String)"connection");
        try (Transaction transaction = this.database.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                Node source = transaction.createNode(new Label[]{marker});
                source.createRelationshipTo(transaction.createNode(), type);
            }
            transaction.commit();
        }
        transaction = (InternalTransaction)this.database.beginTx();
        try {
            CursorContext cursorContext = transaction.kernelTransaction().cursorContext();
            this.assertZeroCursor(cursorContext);
            ((LongAssert)this.softly.assertThat(Iterators.count((Iterator)transaction.findNodes(marker))).as("Number of expected nodes", new Object[0])).isEqualTo(1000L);
            ((LongAssert)this.softly.assertThat(cursorContext.getCursorTracer().pins()).as("Number of cursor pins", new Object[0])).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(cursorContext.getCursorTracer().unpins()).as("Number of cursor unpins", new Object[0])).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(cursorContext.getCursorTracer().hits()).as("Number of cursor hits", new Object[0])).isEqualTo(1L);
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void tracePageCacheAccessOnFindRelationships() {
        Label marker = Label.label((String)"marker");
        RelationshipType type = RelationshipType.withName((String)"connection");
        try (Transaction transaction = this.database.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                Node source = transaction.createNode(new Label[]{marker});
                source.createRelationshipTo(transaction.createNode(), type);
            }
            transaction.commit();
        }
        transaction = (InternalTransaction)this.database.beginTx();
        try {
            CursorContext cursorContext = transaction.kernelTransaction().cursorContext();
            this.assertZeroCursor(cursorContext);
            ((LongAssert)this.softly.assertThat(Iterators.count((Iterator)transaction.findRelationships(type))).as("Number of expected relationships", new Object[0])).isEqualTo(1000L);
            this.assertTraces(cursorContext, this.isRecordFormat() ? this.traces(1, 1, 1) : this.traces(33, 32, 33));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void tracePageCacheAccessOnDetachDelete() throws KernelException {
        long sourceId;
        RelationshipType type = RelationshipType.withName((String)"connection");
        try (Transaction transaction = this.database.beginTx();){
            Node source = transaction.createNode();
            for (int i = 0; i < 10; ++i) {
                source.createRelationshipTo(transaction.createNode(), type);
            }
            sourceId = source.getId();
            transaction.commit();
        }
        transaction = (InternalTransaction)this.database.beginTx();
        try {
            CursorContext cursorContext = transaction.kernelTransaction().cursorContext();
            this.assertZeroCursor(cursorContext);
            transaction.kernelTransaction().dataWrite().nodeDetachDelete(sourceId);
            this.assertTraces(cursorContext, this.isRecordFormat() ? this.traces(5, 1, 5) : this.traces(1, 0, 1));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    private void assertZeroCursor(CursorContext cursorContext) {
        this.assertTraces(cursorContext, this.traces(0, 0, 0, 0));
    }

    void assertTraces(CursorContext cursorContext, int[] traces) {
        ((LongAssert)this.softly.assertThat(cursorContext.getCursorTracer().pins()).as("Number of cursor pins", new Object[0])).isEqualTo((long)traces[0]);
        ((LongAssert)this.softly.assertThat(cursorContext.getCursorTracer().unpins()).as("Number of cursor unpins", new Object[0])).isEqualTo((long)traces[1]);
        ((LongAssert)this.softly.assertThat(cursorContext.getCursorTracer().hits()).as("Number of cursor hits", new Object[0])).isEqualTo((long)traces[2]);
        if (traces.length == 4) {
            ((LongAssert)this.softly.assertThat(cursorContext.getCursorTracer().faults()).as("Number of cursor faults", new Object[0])).isEqualTo((long)traces[3]);
        }
    }

    int[] traces(int ... traces) {
        return traces;
    }

    boolean isRecordFormat() {
        return this.database.getDependencyResolver().resolveDependency(StorageEngine.class) instanceof RecordStorageEngine;
    }

    private class CommitCursorChecker
    extends TransactionEventListenerAdapter<Object> {
        private final CursorContext cursorContext;
        private final int[] traces;
        private volatile boolean invoked;

        CommitCursorChecker(CursorContext cursorContext, int[] traces) {
            this.cursorContext = cursorContext;
            this.traces = traces;
        }

        public boolean isInvoked() {
            return this.invoked;
        }

        public void afterCommit(TransactionData data, Object state, GraphDatabaseService databaseService) {
            TransactionTracingIT.this.assertTraces(this.cursorContext, this.traces);
            this.invoked = true;
        }
    }
}

