/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl;

import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.format.FormatFamily;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

@ResourceLock(value="sharedContext")
public abstract class AbstractNeo4jTestCase {
    private static DatabaseManagementService managementService;
    private static GraphDatabaseAPI graphDb;

    @BeforeAll
    static void beforeAll() {
        AbstractNeo4jTestCase.startDb();
    }

    @AfterAll
    static void afterAll() {
        AbstractNeo4jTestCase.stopDb();
    }

    protected static void startDb() {
        managementService = new TestDatabaseManagementServiceBuilder().setConfig(GraphDatabaseSettings.db_format, (Object)FormatFamily.ALIGNED.name()).impermanent().build();
        graphDb = (GraphDatabaseAPI)managementService.database("neo4j");
    }

    protected static void stopDb() {
        managementService.shutdown();
    }

    public static GraphDatabaseService getGraphDb() {
        return graphDb;
    }

    public static DatabaseManagementService getManagementService() {
        return managementService;
    }

    protected static GraphDatabaseAPI getGraphDbAPI() {
        return graphDb;
    }

    protected static Node createNode() {
        Node node;
        try (Transaction transaction = graphDb.beginTx();){
            node = transaction.createNode();
            transaction.commit();
        }
        return node;
    }

    protected static IdGenerator getIdGenerator(IdType idType) {
        return ((IdGeneratorFactory)graphDb.getDependencyResolver().resolveDependency(IdGeneratorFactory.class)).get(idType);
    }

    protected static long propertyRecordsInUse() {
        return AbstractNeo4jTestCase.numberOfRecordsInUse(AbstractNeo4jTestCase.propertyStore());
    }

    private static <RECORD extends AbstractBaseRecord> int numberOfRecordsInUse(RecordStore<RECORD> store) {
        int inUse = 0;
        try (PageCursor cursor = store.openPageCursorForReading(0L, CursorContext.NULL_CONTEXT);){
            for (long id = (long)store.getNumberOfReservedLowIds(); id < store.getHighId(); ++id) {
                AbstractBaseRecord record = store.getRecordByCursor(id, store.newRecord(), RecordLoad.FORCE, cursor);
                if (!record.inUse()) continue;
                ++inUse;
            }
        }
        return inUse;
    }

    protected static <RECORD extends AbstractBaseRecord> long lastUsedRecordId(RecordStore<RECORD> store) {
        try (PageCursor cursor = store.openPageCursorForReading(store.getHighId(), CursorContext.NULL_CONTEXT);){
            for (long id = store.getHighId(); id > (long)store.getNumberOfReservedLowIds(); --id) {
                AbstractBaseRecord record = store.getRecordByCursor(id, store.newRecord(), RecordLoad.FORCE, cursor);
                if (!record.inUse()) continue;
                long l = id;
                return l;
            }
        }
        return 0L;
    }

    protected static long dynamicStringRecordsInUse() {
        return AbstractNeo4jTestCase.numberOfRecordsInUse(AbstractNeo4jTestCase.propertyStore().getStringStore());
    }

    protected static long dynamicArrayRecordsInUse() {
        return AbstractNeo4jTestCase.numberOfRecordsInUse(AbstractNeo4jTestCase.propertyStore().getArrayStore());
    }

    protected static StoreCursors createStoreCursors() {
        RecordStorageEngine storageEngine = (RecordStorageEngine)graphDb.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
        return storageEngine.createStorageCursors(CursorContext.NULL_CONTEXT);
    }

    protected static PropertyStore propertyStore() {
        return ((RecordStorageEngine)graphDb.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores().getPropertyStore();
    }
}

