/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ProxyableObjectAssert;
import org.assertj.core.util.Streams;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.recordstorage.RecordStorageEngineFactory;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@EphemeralTestDirectoryExtension
class SchemaRecoveryIT {
    @Inject
    private volatile EphemeralFileSystemAbstraction fs;
    @Inject
    private TestDirectory testDirectory;
    private GraphDatabaseAPI db;
    private DatabaseManagementService managementService;

    SchemaRecoveryIT() {
    }

    @AfterEach
    void shutdownDatabase() {
        if (this.db != null) {
            this.managementService.shutdown();
            this.db = null;
        }
    }

    @Test
    void schemaTransactionsShouldSurviveRecovery() {
        long initialIndexCount;
        long initialConstraintCount;
        Label label = Label.label((String)"User");
        String property = "email";
        this.startDb();
        try (Transaction tx = this.db.beginTx();){
            initialConstraintCount = Streams.stream((Iterable)tx.schema().getConstraints()).count();
            initialIndexCount = Streams.stream((Iterable)tx.schema().getIndexes()).count();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().constraintFor(label).assertPropertyIsUnique(property).create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.createNode(new Label[]{label}).setProperty(property, (Object)"neo4j@neo4j.com");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.killDb();
        this.startDb();
        Assertions.assertEquals((long)(initialConstraintCount + 1L), (long)SchemaRecoveryIT.constraints((GraphDatabaseService)this.db).size());
        Assertions.assertEquals((long)(initialIndexCount + 1L), (long)SchemaRecoveryIT.indexes((GraphDatabaseService)this.db).size());
    }

    @Test
    void inconsistentlyFlushedTokensShouldBeRecovered() {
        long initialIndexCount;
        long initialConstraintCount;
        Label label = Label.label((String)"User");
        String property = "email";
        this.startDb();
        ((ProxyableObjectAssert)Assumptions.assumeThat((Object)((StorageEngineFactory)this.db.getDependencyResolver().resolveDependency(StorageEngineFactory.class))).as("Separate tokens & token names is a record storage thing", new Object[0])).isInstanceOf(RecordStorageEngineFactory.class);
        try (Transaction tx = this.db.beginTx();){
            initialConstraintCount = Streams.stream((Iterable)tx.schema().getConstraints()).count();
            initialIndexCount = Streams.stream((Iterable)tx.schema().getIndexes()).count();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().constraintFor(label).assertPropertyIsUnique(property).create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        RecordStorageEngine storageEngine = (RecordStorageEngine)this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
        storageEngine.testAccessNeoStores().getPropertyKeyTokenStore().flush(FileFlushEvent.NULL, CursorContext.NULL_CONTEXT);
        this.killDb();
        this.startDb();
        Assertions.assertEquals((long)(initialConstraintCount + 1L), (long)SchemaRecoveryIT.constraints((GraphDatabaseService)this.db).size());
        Assertions.assertEquals((long)(initialIndexCount + 1L), (long)SchemaRecoveryIT.indexes((GraphDatabaseService)this.db).size());
    }

    private void startDb() {
        if (this.db != null) {
            this.managementService.shutdown();
        }
        this.managementService = this.configure(new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setFileSystem((FileSystemAbstraction)this.fs)).build();
        this.db = (GraphDatabaseAPI)this.managementService.database("neo4j");
    }

    protected TestDatabaseManagementServiceBuilder configure(TestDatabaseManagementServiceBuilder builder) {
        return builder;
    }

    private void killDb() {
        if (this.db != null) {
            this.fs = this.fs.snapshot();
            this.managementService.shutdown();
        }
    }

    private static List<ConstraintDefinition> constraints(GraphDatabaseService database) {
        try (Transaction tx = database.beginTx();){
            List list = Iterables.asList((Iterable)tx.schema().getConstraints());
            return list;
        }
    }

    private static List<IndexDefinition> indexes(GraphDatabaseService database) {
        try (Transaction tx = database.beginTx();){
            List list = Iterables.asList((Iterable)tx.schema().getIndexes());
            return list;
        }
    }
}

