/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;

class TestProperties
extends AbstractNeo4jTestCase {
    private static final int VALUE_RANGE_SPLIT = 20;

    TestProperties() {
    }

    @Test
    void addAndRemovePropertiesWithinOneTransaction() {
        Node node = TestProperties.createNode();
        try (Transaction transaction = TestProperties.getGraphDb().beginTx();){
            Node txNode = transaction.getNodeById(node.getId());
            txNode.setProperty("name", (Object)"oscar");
            txNode.setProperty("favourite_numbers", (Object)new Long[]{1L, 2L, 3L});
            txNode.setProperty("favourite_colors", (Object)new String[]{"blue", "red"});
            txNode.removeProperty("favourite_colors");
            transaction.commit();
        }
        transaction = TestProperties.getGraphDb().beginTx();
        try {
            Assertions.assertNotNull((Object)transaction.getNodeById(node.getId()).getProperty("favourite_numbers", null));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void addAndRemovePropertiesWithinOneTransaction2() {
        Node node = TestProperties.createNode();
        try (Transaction transaction = TestProperties.getGraphDb().beginTx();){
            transaction.getNodeById(node.getId()).setProperty("foo", (Object)"bar");
            transaction.commit();
        }
        transaction = TestProperties.getGraphDb().beginTx();
        try {
            Node txNode = transaction.getNodeById(node.getId());
            txNode.setProperty("foo2", (Object)"bar");
            txNode.removeProperty("foo");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = TestProperties.getGraphDb().beginTx();
        try {
            Assertions.assertThrows(NotFoundException.class, () -> transaction.getNodeById(node.getId()).getProperty("foo"));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void removeAndAddSameProperty() {
        Node txNode;
        Node node = TestProperties.createNode();
        try (Transaction transaction = TestProperties.getGraphDb().beginTx();){
            transaction.getNodeById(node.getId()).setProperty("foo", (Object)"bar");
            transaction.commit();
        }
        transaction = TestProperties.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeById(node.getId());
            txNode.removeProperty("foo");
            txNode.setProperty("foo", (Object)"bar");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = TestProperties.getGraphDb().beginTx();
        try {
            Assertions.assertEquals((Object)"bar", (Object)transaction.getNodeById(node.getId()).getProperty("foo"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = TestProperties.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeById(node.getId());
            txNode.setProperty("foo", (Object)"bar");
            txNode.removeProperty("foo");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = TestProperties.getGraphDb().beginTx();
        try {
            Assertions.assertNull((Object)transaction.getNodeById(node.getId()).getProperty("foo", null));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void removeSomeAndSetSome() {
        Node txNode;
        Node node = TestProperties.createNode();
        try (Transaction transaction = TestProperties.getGraphDb().beginTx();){
            transaction.getNodeById(node.getId()).setProperty("remove me", (Object)"trash");
            transaction.commit();
        }
        transaction = TestProperties.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeById(node.getId());
            txNode.removeProperty("remove me");
            txNode.setProperty("foo", (Object)"bar");
            txNode.setProperty("baz", (Object)17);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = TestProperties.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeById(node.getId());
            Assertions.assertEquals((Object)"bar", (Object)txNode.getProperty("foo"));
            Assertions.assertEquals((Object)17, (Object)txNode.getProperty("baz"));
            Assertions.assertNull((Object)txNode.getProperty("remove me", null));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void removeOneOfThree() {
        Node node = TestProperties.createNode();
        try (Transaction transaction = TestProperties.getGraphDb().beginTx();){
            Node txNode = transaction.getNodeById(node.getId());
            txNode.setProperty("1", (Object)1);
            txNode.setProperty("2", (Object)2);
            txNode.setProperty("3", (Object)3);
            transaction.commit();
        }
        transaction = TestProperties.getGraphDb().beginTx();
        try {
            transaction.getNodeById(node.getId()).removeProperty("2");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = TestProperties.getGraphDb().beginTx();
        try {
            Assertions.assertNull((Object)transaction.getNodeById(node.getId()).getProperty("2", null));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testLongPropertyValues() {
        Node n = TestProperties.createNode();
        TestProperties.setPropertyAndAssertIt(n, -134217728L);
        TestProperties.setPropertyAndAssertIt(n, -134217729L);
    }

    @Test
    void testIntPropertyValues() {
        Node n = TestProperties.createNode();
        TestProperties.setPropertyAndAssertIt(n, -134217728);
        TestProperties.setPropertyAndAssertIt(n, -134217729);
    }

    @Test
    void booleanRange() {
        Node node = TestProperties.createNode();
        TestProperties.setPropertyAndAssertIt(node, false);
        TestProperties.setPropertyAndAssertIt(node, true);
    }

    @Test
    void byteRange() {
        Node node = TestProperties.createNode();
        int stride = 6;
        byte i = -128;
        while (i < 127) {
            TestProperties.setPropertyAndAssertIt(node, i);
            i = i > 0 && 127 - i < stride ? (byte)127 : (byte)(i + stride);
        }
    }

    @Test
    void charRange() {
        Node node = TestProperties.createNode();
        int stride = 3276;
        char i = '\u0000';
        while (i < '\uffff') {
            TestProperties.setPropertyAndAssertIt(node, Character.valueOf(i));
            i = i > '\u0000' && 65535 - i < stride ? (char)65535 : (char)(i + stride);
        }
    }

    @Test
    void shortRange() {
        Node node = TestProperties.createNode();
        int stride = 1638;
        short i = Short.MIN_VALUE;
        while (i < Short.MAX_VALUE) {
            TestProperties.setPropertyAndAssertIt(node, i);
            i = i > 0 && Short.MAX_VALUE - i < stride ? (short)Short.MAX_VALUE : (short)(i + stride);
        }
    }

    @Test
    void intRange() {
        Node node = TestProperties.createNode();
        int stride = 0x6666666;
        int i = Integer.MIN_VALUE;
        while (i < Integer.MAX_VALUE) {
            TestProperties.setPropertyAndAssertIt(node, i);
            i = i > 0 && Integer.MAX_VALUE - i < stride ? Integer.MAX_VALUE : i + stride;
        }
    }

    @Test
    void longRange() {
        Node node = TestProperties.createNode();
        long stride = 0x666666666666666L;
        long i = Long.MIN_VALUE;
        while (i < Long.MAX_VALUE) {
            TestProperties.setPropertyAndAssertIt(node, i);
            i = i > 0L && Long.MAX_VALUE - i < stride ? Long.MAX_VALUE : i + stride;
        }
    }

    @Test
    void floatRange() {
        Node node = TestProperties.createNode();
        float stride = 16.0f;
        for (float i = Float.MIN_VALUE; i < Float.MAX_VALUE; i *= stride) {
            TestProperties.setPropertyAndAssertIt(node, Float.valueOf(i));
            TestProperties.setPropertyAndAssertIt(node, Float.valueOf(-i));
        }
    }

    @Test
    void doubleRange() {
        Node node = TestProperties.createNode();
        double stride = 4194304.0;
        for (double i = Double.MIN_VALUE; i < Double.MAX_VALUE; i *= stride) {
            TestProperties.setPropertyAndAssertIt(node, i);
            TestProperties.setPropertyAndAssertIt(node, -i);
        }
    }

    private static void setPropertyAndAssertIt(Node node, Object value) {
        try (Transaction transaction = TestProperties.getGraphDb().beginTx();){
            Node txNode = transaction.getNodeById(node.getId());
            txNode.setProperty("key", value);
            Assertions.assertEquals((Object)value, (Object)txNode.getProperty("key"));
            transaction.commit();
        }
    }

    @Test
    void loadManyProperties() {
        Node node = TestProperties.createNode();
        try (Transaction transaction = TestProperties.getGraphDb().beginTx();){
            Node txNode = transaction.getNodeById(node.getId());
            for (int i = 0; i < 200; ++i) {
                txNode.setProperty("property " + i, (Object)"value");
            }
            transaction.commit();
        }
        transaction = TestProperties.getGraphDb().beginTx();
        try {
            Assertions.assertEquals((Object)"value", (Object)transaction.getNodeById(node.getId()).getProperty("property 0"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void name() {
        Node node = TestProperties.createNode();
        try (Transaction transaction = TestProperties.getGraphDb().beginTx();){
            Node txNode = transaction.getNodeById(node.getId());
            txNode.setProperty("name", (Object)"yo");
            txNode.getProperty("name");
            transaction.commit();
        }
        try (Transaction tx = TestProperties.getGraphDb().beginTx();){
            tx.getNodeById(node.getId()).getProperty("name");
            tx.commit();
        }
    }
}

