/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.EntityCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.ElementIdMapper;
import org.neo4j.values.storable.Value;

@TestDirectoryExtension
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@ResourceLock(value="sharedContext")
public abstract class KernelAPIWriteTestBase<WriteSupport extends KernelAPIWriteTestSupport> {
    protected static KernelAPIWriteTestSupport testSupport;
    protected static GraphDatabaseService graphDb;
    private static final TokenHolders tokenHolders;
    private static final QueryExecutionEngine engine;
    private static final TransactionalContextFactory contextFactory;
    private static final DatabaseAvailabilityGuard availabilityGuard;
    private static final ElementIdMapper elementIdMapper;
    @Inject
    private TestDirectory testDirectory;

    public abstract WriteSupport newTestSupport();

    @BeforeAll
    public void setupGraph() {
        testSupport = this.newTestSupport();
        testSupport.setup(this.testDirectory.homePath(), this::createSystemGraph);
        graphDb = testSupport.graphBackdoor();
    }

    @BeforeEach
    public void clearGraph() {
        testSupport.clearGraph();
    }

    @AfterAll
    public static void tearDown() {
        testSupport.tearDown();
    }

    public void createSystemGraph(GraphDatabaseService graphDb) {
    }

    protected static KernelTransaction beginTransaction() throws TransactionFailureException {
        return KernelAPIWriteTestBase.beginTransaction(LoginContext.AUTH_DISABLED);
    }

    protected static KernelTransaction beginTransaction(LoginContext loginContext) throws TransactionFailureException {
        Kernel kernel = testSupport.kernelToTest();
        KernelTransaction kernelTransaction = kernel.beginTransaction(KernelTransaction.Type.IMPLICIT, loginContext);
        new TransactionImpl(tokenHolders, contextFactory, availabilityGuard, engine, kernelTransaction, elementIdMapper);
        return kernelTransaction;
    }

    protected static void transaction(ThrowingConsumer<KernelTransaction, Exception> action) throws Exception {
        try (KernelTransaction tx = KernelAPIWriteTestBase.beginTransaction();){
            action.accept((Object)tx);
            tx.commit();
        }
    }

    protected static CursorFactory cursorFactory(KernelTransaction ktx) {
        return ((Read)ktx.dataRead()).cursors();
    }

    protected void assertProperties(EntityCursor entityCursor, PropertyCursor propertyCursor, IntObjectMap<Value> expectedProperties) {
        entityCursor.properties(propertyCursor, PropertySelection.ALL_PROPERTIES);
        MutableIntObjectMap readProperties = IntObjectMaps.mutable.empty();
        while (propertyCursor.next()) {
            readProperties.put(propertyCursor.propertyKey(), (Object)propertyCursor.propertyValue());
        }
        Assertions.assertThat((Iterable)readProperties).isEqualTo(expectedProperties);
    }

    static {
        tokenHolders = (TokenHolders)Mockito.mock(TokenHolders.class);
        engine = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
        contextFactory = (TransactionalContextFactory)Mockito.mock(TransactionalContextFactory.class);
        availabilityGuard = (DatabaseAvailabilityGuard)Mockito.mock(DatabaseAvailabilityGuard.class);
        elementIdMapper = (ElementIdMapper)Mockito.mock(ElementIdMapper.class, (Answer)Answers.RETURNS_MOCKS);
    }
}

