/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Nested;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.IndexOrderTestBase;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class RelationshipIndexOrderTest {
    RelationshipIndexOrderTest() {
    }

    @Nested
    class RangeIndexTest
    extends RelationshipIndexOrderTestBase {
        RangeIndexTest() {
        }

        @Override
        IndexType indexType() {
            return IndexType.RANGE;
        }
    }

    static abstract class RelationshipIndexOrderTestBase
    extends IndexOrderTestBase<RelationshipValueIndexCursor> {
        private static final String DEFAULT_REl_TYPE = "Rel";

        RelationshipIndexOrderTestBase() {
        }

        @Override
        protected Pair<Long, Value> entityWithProp(KernelTransaction tx, Object value) throws Exception {
            Write write = tx.dataWrite();
            long sourceNode = write.nodeCreate();
            long targetNode = write.nodeCreate();
            long rel = write.relationshipCreate(sourceNode, tx.tokenWrite().relationshipTypeGetOrCreateForName(DEFAULT_REl_TYPE), targetNode);
            Value val = Values.of((Object)value);
            write.relationshipSetProperty(rel, tx.tokenWrite().propertyKeyGetOrCreateForName("prop"), val);
            return Pair.of((Object)rel, (Object)val);
        }

        @Override
        protected void createIndex() {
            try (Transaction tx = graphDb.beginTx();){
                tx.schema().indexFor(RelationshipType.withName((String)DEFAULT_REl_TYPE)).on("prop").withName("myIndex").withIndexType(this.indexType()).create();
                tx.commit();
            }
            tx = graphDb.beginTx();
            try {
                tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }

        @Override
        protected long entityReference(RelationshipValueIndexCursor cursor) {
            return cursor.relationshipReference();
        }

        @Override
        protected RelationshipValueIndexCursor getEntityValueIndexCursor(KernelTransaction tx) {
            return tx.cursors().allocateRelationshipValueIndexCursor(tx.cursorContext(), tx.memoryTracker());
        }

        @Override
        protected void entityIndexSeek(KernelTransaction tx, IndexReadSession index, RelationshipValueIndexCursor cursor, IndexQueryConstraints constraints, PropertyIndexQuery query) throws KernelException {
            tx.dataRead().relationshipIndexSeek(tx.queryContext(), index, cursor, constraints, new PropertyIndexQuery[]{query});
        }

        @Override
        protected void entityIndexScan(KernelTransaction tx, IndexReadSession index, RelationshipValueIndexCursor cursor, IndexQueryConstraints constraints) throws KernelException {
            tx.dataRead().relationshipIndexScan(index, cursor, constraints);
        }

        @Override
        protected void createCompositeIndex() {
            try (Transaction tx = graphDb.beginTx();){
                tx.schema().indexFor(RelationshipType.withName((String)DEFAULT_REl_TYPE)).on("prop1").on("prop2").withName("myIndex").withIndexType(this.indexType()).create();
                tx.commit();
            }
            tx = graphDb.beginTx();
            try {
                tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }

        @Override
        protected Pair<Long, Value[]> entityWithTwoProps(KernelTransaction tx, Object value1, Object value2) throws Exception {
            Write write = tx.dataWrite();
            long sourceNode = write.nodeCreate();
            long targetNode = write.nodeCreate();
            long rel = write.relationshipCreate(sourceNode, tx.tokenWrite().relationshipTypeGetOrCreateForName(DEFAULT_REl_TYPE), targetNode);
            Value val1 = Values.of((Object)value1);
            Value val2 = Values.of((Object)value2);
            write.relationshipSetProperty(rel, tx.tokenWrite().propertyKeyGetOrCreateForName("prop1"), val1);
            write.relationshipSetProperty(rel, tx.tokenWrite().propertyKeyGetOrCreateForName("prop2"), val2);
            return Pair.of((Object)rel, (Object)new Value[]{val1, val2});
        }

        abstract IndexType indexType();
    }
}

