/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestSupport;
import org.neo4j.kernel.impl.newapi.RelationshipTestSupport;
import org.neo4j.storageengine.api.Degrees;
import org.neo4j.storageengine.api.RelationshipSelection;

public abstract class RelationshipTraversalCursorTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static long bare;
    private static long start;
    private static long end;
    private static RelationshipTestSupport.StartNode sparse;
    private static RelationshipTestSupport.StartNode dense;

    private static boolean supportsDirectTraversal() {
        return true;
    }

    private static boolean supportsSparseNodes() {
        return true;
    }

    private static void bareStartAndEnd(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            bare = tx.createNode().getId();
            Node x = tx.createNode();
            Node y = tx.createNode();
            start = x.getId();
            end = y.getId();
            x.createRelationshipTo(y, RelationshipType.withName((String)"GEN"));
            tx.commit();
        }
    }

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        RelationshipTestSupport.someGraph(graphDb);
        RelationshipTraversalCursorTestBase.bareStartAndEnd(graphDb);
        sparse = RelationshipTestSupport.sparse(graphDb);
        dense = RelationshipTestSupport.dense(graphDb);
    }

    @Test
    void shouldTraverseRelationshipsOfGivenType() {
        try (NodeCursor node = this.cursors.allocateNodeCursor(CursorContext.NULL_CONTEXT);
             RelationshipTraversalCursor relationship = this.cursors.allocateRelationshipTraversalCursor(CursorContext.NULL_CONTEXT);){
            int empty = 0;
            this.read.allNodesScan(node);
            while (node.next()) {
                Degrees degrees = node.degrees(RelationshipSelection.ALL_RELATIONSHIPS);
                boolean none = true;
                for (int type : degrees.types()) {
                    none = false;
                    Sizes degree = new Sizes();
                    node.relationships(relationship, RelationshipSelection.selection((int)type, (Direction)Direction.BOTH));
                    while (relationship.next()) {
                        Assertions.assertEquals((int)type, (int)relationship.type(), (String)("node #" + node.nodeReference() + " relationship has label not part of selection"));
                        if (relationship.sourceNodeReference() == node.nodeReference()) {
                            ++degree.outgoing;
                        }
                        if (relationship.targetNodeReference() == node.nodeReference()) {
                            ++degree.incoming;
                        }
                        ++degree.total;
                    }
                    Assertions.assertNotEquals((int)0, (int)degree.total, (String)"all");
                    Assertions.assertEquals((int)degrees.outgoingDegree(type), (int)degree.outgoing, (String)("node #" + node.nodeReference() + " outgoing"));
                    Assertions.assertEquals((int)degrees.incomingDegree(type), (int)degree.incoming, (String)("node #" + node.nodeReference() + " incoming"));
                    Assertions.assertEquals((int)degrees.totalDegree(type), (int)degree.total, (String)("node #" + node.nodeReference() + " all = incoming + outgoing - loop"));
                }
                if (!none) continue;
                ++empty;
            }
            Assertions.assertEquals((int)1, (int)empty, (String)"number of empty nodes");
        }
    }

    @Test
    void shouldFollowSpecificRelationship() {
        try (NodeCursor node = this.cursors.allocateNodeCursor(CursorContext.NULL_CONTEXT);
             RelationshipTraversalCursor relationship = this.cursors.allocateRelationshipTraversalCursor(CursorContext.NULL_CONTEXT);){
            this.read.singleNode(start, node);
            Assertions.assertTrue((boolean)node.next(), (String)"access start node");
            int[] types = node.relationshipTypes();
            Assertions.assertTrue((types.length > 0 ? 1 : 0) != 0);
            node.relationships(relationship, RelationshipSelection.selection((int)types[0], (Direction)Direction.OUTGOING));
            Assertions.assertTrue((boolean)relationship.next(), (String)"access outgoing relationships");
            Assertions.assertEquals((long)start, (long)relationship.sourceNodeReference(), (String)"source node");
            Assertions.assertEquals((long)end, (long)relationship.targetNodeReference(), (String)"target node");
            Assertions.assertEquals((long)start, (long)relationship.originNodeReference(), (String)"node of origin");
            Assertions.assertEquals((long)end, (long)relationship.otherNodeReference(), (String)"neighbouring node");
            Assertions.assertEquals((int)types[0], (int)relationship.type(), (String)"relationship should have correct label");
            Assertions.assertFalse((boolean)relationship.next(), (String)"only a single relationship");
            node.relationships(relationship, RelationshipSelection.selection((int)types[0], (Direction)Direction.INCOMING));
            Assertions.assertFalse((boolean)relationship.next(), (String)"no incoming relationships");
            this.read.singleNode(end, node);
            Assertions.assertTrue((boolean)node.next(), (String)"access start node");
            types = node.relationshipTypes();
            Assertions.assertTrue((types.length > 0 ? 1 : 0) != 0);
            node.relationships(relationship, RelationshipSelection.selection((int)types[0], (Direction)Direction.INCOMING));
            Assertions.assertTrue((boolean)relationship.next(), (String)"access incoming relationships");
            Assertions.assertEquals((long)start, (long)relationship.sourceNodeReference(), (String)"source node");
            Assertions.assertEquals((long)end, (long)relationship.targetNodeReference(), (String)"target node");
            Assertions.assertEquals((long)end, (long)relationship.originNodeReference(), (String)"node of origin");
            Assertions.assertEquals((long)start, (long)relationship.otherNodeReference(), (String)"neighbouring node");
            Assertions.assertEquals((int)types[0], (int)relationship.type(), (String)"relationship should have correct label");
            Assertions.assertFalse((boolean)relationship.next(), (String)"only a single relationship");
            node.relationships(relationship, RelationshipSelection.selection((int)types[0], (Direction)Direction.OUTGOING));
            Assertions.assertFalse((boolean)relationship.next(), (String)"no outgoing relationships");
        }
    }

    @Test
    void shouldHaveBeenAbleToCreateDenseAndSparseNodes() {
        try (NodeCursor node = this.cursors.allocateNodeCursor(CursorContext.NULL_CONTEXT);){
            this.read.singleNode(RelationshipTraversalCursorTestBase.dense.id, node);
            Assertions.assertTrue((boolean)node.next(), (String)"access dense node");
            Assertions.assertTrue((boolean)node.supportsFastDegreeLookup(), (String)"dense node");
            this.read.singleNode(RelationshipTraversalCursorTestBase.sparse.id, node);
            Assertions.assertTrue((boolean)node.next(), (String)"access sparse node");
            Assertions.assertFalse((node.supportsFastDegreeLookup() && RelationshipTraversalCursorTestBase.supportsSparseNodes() ? 1 : 0) != 0, (String)"sparse node");
        }
    }

    @Test
    void shouldTraverseSparseNode() throws Exception {
        Assumptions.assumeTrue((RelationshipTraversalCursorTestBase.supportsSparseNodes() && RelationshipTraversalCursorTestBase.supportsDirectTraversal() ? 1 : 0) != 0);
        this.traverse(sparse, false);
    }

    @Test
    void shouldTraverseDenseNode() throws Exception {
        Assumptions.assumeTrue((boolean)RelationshipTraversalCursorTestBase.supportsDirectTraversal());
        this.traverse(dense, false);
    }

    @Test
    void shouldTraverseSparseNodeWithDetachedReferences() throws Exception {
        Assumptions.assumeTrue((boolean)RelationshipTraversalCursorTestBase.supportsSparseNodes());
        this.traverse(sparse, true);
    }

    @Test
    void shouldTraverseDenseNodeWithDetachedReferences() throws Exception {
        Assumptions.assumeTrue((boolean)RelationshipTraversalCursorTestBase.supportsDirectTraversal());
        this.traverse(dense, true);
    }

    private void traverse(RelationshipTestSupport.StartNode start, boolean detached) throws KernelException {
        try (NodeCursor node = this.cursors.allocateNodeCursor(CursorContext.NULL_CONTEXT);
             RelationshipTraversalCursor relationship = this.cursors.allocateRelationshipTraversalCursor(CursorContext.NULL_CONTEXT);){
            this.read.singleNode(start.id, node);
            Assertions.assertTrue((boolean)node.next(), (String)"access node");
            if (detached) {
                this.read.relationships(start.id, node.relationshipsReference(), RelationshipSelection.ALL_RELATIONSHIPS, relationship);
            } else {
                node.relationships(relationship, RelationshipSelection.ALL_RELATIONSHIPS);
            }
            Map<String, Integer> counts = RelationshipTestSupport.count(this.tx, relationship);
            RelationshipTestSupport.assertCounts(start.expectedCounts(), counts);
        }
    }

    private static class Sizes {
        int incoming;
        int outgoing;
        int total;

        private Sizes() {
        }
    }
}

