/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.Config;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.IndexingTestUtil;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.transaction.state.storeview.DynamicIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.FullScanStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.TestTokenScanConsumer;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.lock.LockService;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.ReadableStorageEngine;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.test.Race;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.token.TokenHolders;

@ExtendWith(value={RandomExtension.class})
@DbmsExtension
public class DynamicIndexStoreViewIT {
    private static final Label PERSON = Label.label((String)"person");
    private static final RelationshipType FRIEND = RelationshipType.withName((String)"friend");
    @Inject
    private RandomSupport random;
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private LockService lockService;
    @Inject
    private Locks locks;
    @Inject
    private IndexingService indexingService;
    @Inject
    private StorageEngine storageEngine;
    @Inject
    private TokenHolders tokenHolders;
    @Inject
    private JobScheduler scheduler;
    private DynamicIndexStoreView storeView;

    @BeforeEach
    void setUp() {
        IndexingTestUtil.assertOnlyDefaultTokenIndexesExists((GraphDatabaseService)this.database);
        this.storeView = new DynamicIndexStoreView(new FullScanStoreView(this.lockService, (ReadableStorageEngine)this.storageEngine, Config.defaults(), this.scheduler), this.locks, this.lockService, Config.defaults(), indexDescriptor -> this.indexingService.getIndexProxy(indexDescriptor), (ReadableStorageEngine)this.storageEngine, (InternalLogProvider)NullLogProvider.getInstance());
    }

    @Disabled(value="disabled until we have token indexes on by default")
    @Test
    void shouldHandleConcurrentDeletionOfTokenIndexDuringNodeScan() throws Throwable {
        long nodes = this.populateNodes();
        TestTokenScanConsumer consumer = new TestTokenScanConsumer();
        StoreScan storeScan = this.nodeStoreScan(consumer);
        Race race = new Race();
        race.addContestant(() -> storeScan.run((StoreScan.ExternalUpdatesCheck)new ContainsExternalUpdates()));
        race.addContestant(() -> IndexingTestUtil.dropTokenIndexes((GraphDatabaseService)this.database), 5);
        race.go();
        Assertions.assertThat((long)storeScan.getProgress().getTotal()).isEqualTo(nodes);
        Assertions.assertThat((long)consumer.consumedEntities()).isEqualTo(nodes);
        storeScan.stop();
    }

    @Disabled(value="disabled until we have token indexes on by default")
    @Test
    void shouldHandleConcurrentDeletionOfTokenIndexDuringRelationshipScan() throws Throwable {
        long relationships = this.populateRelationships();
        TestTokenScanConsumer consumer = new TestTokenScanConsumer();
        StoreScan storeScan = this.relationshipStoreScan(consumer);
        Race race = new Race();
        race.addContestant(() -> storeScan.run((StoreScan.ExternalUpdatesCheck)new ContainsExternalUpdates()));
        race.addContestant(() -> IndexingTestUtil.dropTokenIndexes((GraphDatabaseService)this.database), 5);
        race.go();
        Assertions.assertThat((long)storeScan.getProgress().getTotal()).isEqualTo(relationships);
        Assertions.assertThat((long)consumer.consumedEntities()).isEqualTo(relationships);
        storeScan.stop();
    }

    private StoreScan nodeStoreScan(TestTokenScanConsumer consumer) {
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)new DefaultPageCacheTracer(), EmptyVersionContextSupplier.EMPTY);
        return this.storeView.visitNodes(this.getLabelIds(), Predicates.ALWAYS_TRUE_INT, null, (TokenScanConsumer)consumer, false, true, contextFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    private StoreScan relationshipStoreScan(TestTokenScanConsumer consumer) {
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)new DefaultPageCacheTracer(), EmptyVersionContextSupplier.EMPTY);
        return this.storeView.visitRelationships(this.getRelationTypeIds(), Predicates.ALWAYS_TRUE_INT, null, (TokenScanConsumer)consumer, false, true, contextFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    private int[] getLabelIds() {
        return new int[]{this.tokenHolders.labelTokens().getIdByName(PERSON.name())};
    }

    private int[] getRelationTypeIds() {
        return new int[]{this.tokenHolders.relationshipTypeTokens().getIdByName(FRIEND.name())};
    }

    private long populateNodes() {
        long nodes = Configuration.DEFAULT.batchSize() + 100;
        try (Transaction tx = this.database.beginTx();){
            int i = 0;
            while ((long)i < nodes) {
                tx.createNode(new Label[]{PERSON});
                ++i;
            }
            tx.commit();
        }
        return nodes;
    }

    private long populateRelationships() {
        long relations = Configuration.DEFAULT.batchSize() + 100;
        try (Transaction tx = this.database.beginTx();){
            int i = 0;
            while ((long)i < relations) {
                tx.createNode(new Label[]{PERSON}).createRelationshipTo(tx.createNode(new Label[]{PERSON}), FRIEND);
                ++i;
            }
            tx.commit();
        }
        return relations;
    }

    private class ContainsExternalUpdates
    implements StoreScan.ExternalUpdatesCheck {
        private ContainsExternalUpdates() {
        }

        public boolean needToApplyExternalUpdates() {
            return DynamicIndexStoreViewIT.this.random.nextBoolean();
        }

        public void applyExternalUpdates(long id) {
        }
    }
}

