/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipDataAccessor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.DirectedTypes;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
public class RelationshipSelectionsIT {
    private static final RelationshipType relationshipType = RelationshipType.withName((String)"relType");
    private static final RelationshipType O1 = RelationshipType.withName((String)"O1");
    private static final RelationshipType O2 = RelationshipType.withName((String)"O2");
    private static final RelationshipType I1 = RelationshipType.withName((String)"I1");
    private static final RelationshipType I2 = RelationshipType.withName((String)"I2");
    private static final RelationshipType L1 = RelationshipType.withName((String)"L1");
    private static final RelationshipType L2 = RelationshipType.withName((String)"L2");
    @Inject
    private GraphDatabaseAPI database;

    @Test
    void tracePageCacheAccessOnOutgoingCursor() {
        long nodeId = this.getSparseNodeId();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            int typeId = kernelTransaction.tokenRead().relationshipType(relationshipType.name());
            CursorContext cursorContext = kernelTransaction.cursorContext();
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(cursorContext);){
                RelationshipSelectionsIT.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 1);
                try (RelationshipTraversalCursor cursor = RelationshipSelections.outgoingCursor((CursorFactory)cursors, (NodeCursor)nodeCursor, (int[])new int[]{typeId}, (CursorContext)cursorContext);){
                    RelationshipSelectionsIT.consumeCursor(cursor);
                }
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 2);
            }
        }
    }

    @Test
    void tracePageCacheAccessOnIncomingCursor() {
        long nodeId = this.getSparseNodeId();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            int typeId = kernelTransaction.tokenRead().relationshipType(relationshipType.name());
            CursorContext cursorContext = kernelTransaction.cursorContext();
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(cursorContext);){
                RelationshipSelectionsIT.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 1);
                try (RelationshipTraversalCursor cursor = RelationshipSelections.incomingCursor((CursorFactory)cursors, (NodeCursor)nodeCursor, (int[])new int[]{typeId}, (CursorContext)cursorContext);){
                    RelationshipSelectionsIT.consumeCursor(cursor);
                }
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 2);
            }
        }
    }

    @Test
    void tracePageCacheAccessOnAllCursor() {
        long nodeId = this.getSparseNodeId();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            int typeId = kernelTransaction.tokenRead().relationshipType(relationshipType.name());
            CursorContext cursorContext = kernelTransaction.cursorContext();
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(cursorContext);){
                RelationshipSelectionsIT.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 1);
                try (RelationshipTraversalCursor cursor = RelationshipSelections.allCursor((CursorFactory)cursors, (NodeCursor)nodeCursor, (int[])new int[]{typeId}, (CursorContext)cursorContext);){
                    RelationshipSelectionsIT.consumeCursor(cursor);
                }
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 2);
            }
        }
    }

    @Test
    void tracePageCacheAccessOnOutgoingIterator() {
        long nodeId = this.getSparseNodeId();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            int typeId = kernelTransaction.tokenRead().relationshipType(relationshipType.name());
            CursorContext cursorContext = kernelTransaction.cursorContext();
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(cursorContext);){
                RelationshipSelectionsIT.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 1);
                try (ResourceIterator iterator = RelationshipSelections.outgoingIterator((CursorFactory)cursors, (NodeCursor)nodeCursor, (int[])new int[]{typeId}, RelationshipDataAccessor::relationshipReference, (CursorContext)cursorContext);){
                    org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)Iterators.count((Iterator)iterator));
                }
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 2);
            }
        }
    }

    @Test
    void tracePageCacheAccessOnIncomingIterator() {
        long nodeId = this.getSparseNodeId();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            int typeId = kernelTransaction.tokenRead().relationshipType(relationshipType.name());
            CursorContext cursorContext = kernelTransaction.cursorContext();
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(cursorContext);){
                RelationshipSelectionsIT.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 1);
                try (ResourceIterator iterator = RelationshipSelections.incomingIterator((CursorFactory)cursors, (NodeCursor)nodeCursor, (int[])new int[]{typeId}, RelationshipDataAccessor::relationshipReference, (CursorContext)cursorContext);){
                    org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)Iterators.count((Iterator)iterator));
                }
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 2);
            }
        }
    }

    @Test
    void tracePageCacheAccessOnAllIterator() {
        long nodeId = this.getSparseNodeId();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            int typeId = kernelTransaction.tokenRead().relationshipType(relationshipType.name());
            CursorContext cursorContext = kernelTransaction.cursorContext();
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(cursorContext);){
                RelationshipSelectionsIT.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 1);
                try (ResourceIterator iterator = RelationshipSelections.allIterator((CursorFactory)cursors, (NodeCursor)nodeCursor, (int[])new int[]{typeId}, RelationshipDataAccessor::relationshipReference, (CursorContext)cursorContext);){
                    org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)Iterators.count((Iterator)iterator));
                }
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 2);
            }
        }
    }

    @Test
    void tracePageCacheAccessOnOutgoingDenseCursor() {
        long nodeId = this.getDenseNodeId();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            int typeId = kernelTransaction.tokenRead().relationshipType(relationshipType.name());
            CursorContext cursorContext = kernelTransaction.cursorContext();
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(cursorContext);){
                RelationshipSelectionsIT.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 1);
                try (RelationshipTraversalCursor cursor = RelationshipSelections.outgoingCursor((CursorFactory)cursors, (NodeCursor)nodeCursor, (int[])new int[]{typeId}, (CursorContext)cursorContext);){
                    RelationshipSelectionsIT.consumeCursor(cursor);
                }
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 3);
            }
        }
    }

    @Test
    void tracePageCacheAccessOnIncomingDenseCursor() {
        long nodeId = this.getDenseNodeId();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            int typeId = kernelTransaction.tokenRead().relationshipType(relationshipType.name());
            CursorContext cursorContext = kernelTransaction.cursorContext();
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(cursorContext);){
                RelationshipSelectionsIT.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 1);
                try (RelationshipTraversalCursor cursor = RelationshipSelections.incomingCursor((CursorFactory)cursors, (NodeCursor)nodeCursor, (int[])new int[]{typeId}, (CursorContext)cursorContext);){
                    RelationshipSelectionsIT.consumeCursor(cursor);
                }
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 3);
            }
        }
    }

    @Test
    void tracePageCacheAccessOnAllDenseCursor() {
        long nodeId = this.getDenseNodeId();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            int typeId = kernelTransaction.tokenRead().relationshipType(relationshipType.name());
            CursorContext cursorContext = kernelTransaction.cursorContext();
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(cursorContext);){
                RelationshipSelectionsIT.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 1);
                try (RelationshipTraversalCursor cursor = RelationshipSelections.allCursor((CursorFactory)cursors, (NodeCursor)nodeCursor, (int[])new int[]{typeId}, (CursorContext)cursorContext);){
                    RelationshipSelectionsIT.consumeCursor(cursor);
                }
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 3);
            }
        }
    }

    @Test
    void tracePageCacheAccessOnOutgoingDenseIterator() {
        long nodeId = this.getDenseNodeId();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            int typeId = kernelTransaction.tokenRead().relationshipType(relationshipType.name());
            CursorContext cursorContext = kernelTransaction.cursorContext();
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(cursorContext);){
                RelationshipSelectionsIT.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 1);
                try (ResourceIterator iterator = RelationshipSelections.outgoingIterator((CursorFactory)cursors, (NodeCursor)nodeCursor, (int[])new int[]{typeId}, RelationshipDataAccessor::relationshipReference, (CursorContext)cursorContext);){
                    org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)Iterators.count((Iterator)iterator));
                }
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 3);
            }
        }
    }

    @Test
    void tracePageCacheAccessOnIncomingDenseIterator() {
        long nodeId = this.getDenseNodeId();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            int typeId = kernelTransaction.tokenRead().relationshipType(relationshipType.name());
            CursorContext cursorContext = kernelTransaction.cursorContext();
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(cursorContext);){
                RelationshipSelectionsIT.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 1);
                try (ResourceIterator iterator = RelationshipSelections.incomingIterator((CursorFactory)cursors, (NodeCursor)nodeCursor, (int[])new int[]{typeId}, RelationshipDataAccessor::relationshipReference, (CursorContext)cursorContext);){
                    org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)Iterators.count((Iterator)iterator));
                }
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 3);
            }
        }
    }

    @Test
    void tracePageCacheAccessOnAllDenseIterator() {
        long nodeId = this.getDenseNodeId();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            int typeId = kernelTransaction.tokenRead().relationshipType(relationshipType.name());
            CursorContext cursorContext = kernelTransaction.cursorContext();
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(cursorContext);){
                RelationshipSelectionsIT.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 1);
                try (ResourceIterator iterator = RelationshipSelections.allIterator((CursorFactory)cursors, (NodeCursor)nodeCursor, (int[])new int[]{typeId}, RelationshipDataAccessor::relationshipReference, (CursorContext)cursorContext);){
                    org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)Iterators.count((Iterator)iterator));
                }
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 3);
            }
        }
    }

    @Test
    void multiDirectionalMultiType() {
        long nodeId = this.getNodeWithManyDifferentIncidentTypes();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            CursorContext cursorContext = kernelTransaction.cursorContext();
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(cursorContext);
                 RelationshipTraversalCursor relCursor = cursors.allocateRelationshipTraversalCursor(cursorContext);){
                RelationshipSelectionsIT.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 1);
                int[] everyType = new int[]{kernelTransaction.tokenRead().relationshipType(O1.name()), kernelTransaction.tokenRead().relationshipType(O2.name()), kernelTransaction.tokenRead().relationshipType(I1.name()), kernelTransaction.tokenRead().relationshipType(I2.name()), kernelTransaction.tokenRead().relationshipType(L1.name()), kernelTransaction.tokenRead().relationshipType(L2.name())};
                DirectedTypes directedTypes = new DirectedTypes(kernelTransaction.memoryTracker());
                int N_COMBINATIONS = 4096;
                IntArrayList expectedTraversedTypes = new IntArrayList();
                IntArrayList traversedTypes = new IntArrayList();
                for (int iteration = 0; iteration < 4096; ++iteration) {
                    directedTypes.clear();
                    expectedTraversedTypes.clear();
                    block21: for (int typeIndex = 0; typeIndex < everyType.length; ++typeIndex) {
                        switch ((iteration >> typeIndex * 2) % 4) {
                            case 0: {
                                if (typeIndex < 2 || typeIndex >= 4) {
                                    expectedTraversedTypes.add(everyType[typeIndex]);
                                }
                                directedTypes.addTypes(new int[]{everyType[typeIndex]}, Direction.OUTGOING);
                                continue block21;
                            }
                            case 1: {
                                if (typeIndex >= 2) {
                                    expectedTraversedTypes.add(everyType[typeIndex]);
                                }
                                directedTypes.addTypes(new int[]{everyType[typeIndex]}, Direction.INCOMING);
                                continue block21;
                            }
                            case 2: {
                                expectedTraversedTypes.add(everyType[typeIndex]);
                                directedTypes.addTypes(new int[]{everyType[typeIndex]}, Direction.BOTH);
                                continue block21;
                            }
                        }
                    }
                    directedTypes.compact();
                    RelationshipTraversalCursor traversalCursor = RelationshipSelections.multiTypeMultiDirectionCursor((RelationshipTraversalCursor)relCursor, (NodeCursor)nodeCursor, (DirectedTypes)directedTypes);
                    traversedTypes.clear();
                    while (traversalCursor.next()) {
                        traversedTypes.add(traversalCursor.type());
                    }
                    org.junit.jupiter.api.Assertions.assertEquals((Object)expectedTraversedTypes.sortThis(), (Object)traversedTypes.sortThis());
                }
            }
        }
    }

    @Test
    void multiDirectionalMultiTypeWriteInSameTx() {
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            CursorContext cursorContext = kernelTransaction.cursorContext();
            long nodeId = this.getNodeWithManyDifferentIncidentTypes(transaction);
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(cursorContext);
                 RelationshipTraversalCursor relCursor = cursors.allocateRelationshipTraversalCursor(cursorContext);){
                RelationshipSelectionsIT.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 1);
                int[] everyType = new int[]{kernelTransaction.tokenRead().relationshipType(O1.name()), kernelTransaction.tokenRead().relationshipType(O2.name()), kernelTransaction.tokenRead().relationshipType(I1.name()), kernelTransaction.tokenRead().relationshipType(I2.name()), kernelTransaction.tokenRead().relationshipType(L1.name()), kernelTransaction.tokenRead().relationshipType(L2.name())};
                DirectedTypes directedTypes = new DirectedTypes(kernelTransaction.memoryTracker());
                int N_COMBINATIONS = 4096;
                IntArrayList expectedTraversedTypes = new IntArrayList();
                IntArrayList traversedTypes = new IntArrayList();
                for (int iteration = 0; iteration < 4096; ++iteration) {
                    directedTypes.clear();
                    expectedTraversedTypes.clear();
                    block21: for (int typeIndex = 0; typeIndex < everyType.length; ++typeIndex) {
                        switch ((iteration >> typeIndex * 2) % 4) {
                            case 0: {
                                if (typeIndex < 2 || typeIndex >= 4) {
                                    expectedTraversedTypes.add(everyType[typeIndex]);
                                }
                                directedTypes.addTypes(new int[]{everyType[typeIndex]}, Direction.OUTGOING);
                                continue block21;
                            }
                            case 1: {
                                if (typeIndex >= 2) {
                                    expectedTraversedTypes.add(everyType[typeIndex]);
                                }
                                directedTypes.addTypes(new int[]{everyType[typeIndex]}, Direction.INCOMING);
                                continue block21;
                            }
                            case 2: {
                                expectedTraversedTypes.add(everyType[typeIndex]);
                                directedTypes.addTypes(new int[]{everyType[typeIndex]}, Direction.BOTH);
                                continue block21;
                            }
                        }
                    }
                    directedTypes.compact();
                    RelationshipTraversalCursor traversalCursor = RelationshipSelections.multiTypeMultiDirectionCursor((RelationshipTraversalCursor)relCursor, (NodeCursor)nodeCursor, (DirectedTypes)directedTypes);
                    traversedTypes.clear();
                    while (traversalCursor.next()) {
                        traversedTypes.add(traversalCursor.type());
                    }
                    org.junit.jupiter.api.Assertions.assertEquals((Object)expectedTraversedTypes.sortThis(), (Object)traversedTypes.sortThis());
                }
            }
        }
    }

    @Test
    void multiDirectionalMultiTypeWriteBothInAndOutOfTx() {
        Transaction tx = this.database.beginTx();
        Node source = tx.createNode();
        Node target = tx.createNode();
        String sourceId = source.getElementId();
        String targetId = target.getElementId();
        source.createRelationshipTo(target, O1);
        source.createRelationshipTo(target, O2);
        target.createRelationshipTo(source, I1);
        target.createRelationshipTo(source, I2);
        source.createRelationshipTo(source, L1);
        source.createRelationshipTo(source, L2);
        tx.commit();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            CursorContext cursorContext = kernelTransaction.cursorContext();
            Node sourceInTx = transaction.getNodeByElementId(sourceId);
            Node targetInTx = transaction.getNodeByElementId(targetId);
            sourceInTx.createRelationshipTo(targetInTx, O1);
            sourceInTx.createRelationshipTo(targetInTx, O2);
            targetInTx.createRelationshipTo(sourceInTx, I1);
            targetInTx.createRelationshipTo(sourceInTx, I2);
            sourceInTx.createRelationshipTo(sourceInTx, L1);
            sourceInTx.createRelationshipTo(sourceInTx, L2);
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(cursorContext);
                 RelationshipTraversalCursor relCursor = cursors.allocateRelationshipTraversalCursor(cursorContext);){
                RelationshipSelectionsIT.setNodeCursor(sourceInTx.getId(), kernelTransaction, nodeCursor);
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 1);
                int[] typeOfEveryRelationship = new int[]{kernelTransaction.tokenRead().relationshipType(O1.name()), kernelTransaction.tokenRead().relationshipType(O2.name()), kernelTransaction.tokenRead().relationshipType(I1.name()), kernelTransaction.tokenRead().relationshipType(I2.name()), kernelTransaction.tokenRead().relationshipType(L1.name()), kernelTransaction.tokenRead().relationshipType(L2.name())};
                DirectedTypes directedTypes = new DirectedTypes(kernelTransaction.memoryTracker());
                int N_COMBINATIONS = 4096;
                IntArrayList expectedTraversedTypes = new IntArrayList();
                IntArrayList traversedTypes = new IntArrayList();
                for (int iteration = 0; iteration < 4096; ++iteration) {
                    directedTypes.clear();
                    expectedTraversedTypes.clear();
                    block21: for (int typeIndex = 0; typeIndex < typeOfEveryRelationship.length; ++typeIndex) {
                        switch ((iteration >> typeIndex * 2) % 4) {
                            case 0: {
                                if (typeIndex < 2 || typeIndex >= 4) {
                                    expectedTraversedTypes.add(typeOfEveryRelationship[typeIndex]);
                                    expectedTraversedTypes.add(typeOfEveryRelationship[typeIndex]);
                                }
                                directedTypes.addTypes(new int[]{typeOfEveryRelationship[typeIndex]}, Direction.OUTGOING);
                                continue block21;
                            }
                            case 1: {
                                if (typeIndex >= 2) {
                                    expectedTraversedTypes.add(typeOfEveryRelationship[typeIndex]);
                                    expectedTraversedTypes.add(typeOfEveryRelationship[typeIndex]);
                                }
                                directedTypes.addTypes(new int[]{typeOfEveryRelationship[typeIndex]}, Direction.INCOMING);
                                continue block21;
                            }
                            case 2: {
                                expectedTraversedTypes.add(typeOfEveryRelationship[typeIndex]);
                                expectedTraversedTypes.add(typeOfEveryRelationship[typeIndex]);
                                directedTypes.addTypes(new int[]{typeOfEveryRelationship[typeIndex]}, Direction.BOTH);
                                continue block21;
                            }
                        }
                    }
                    directedTypes.compact();
                    RelationshipTraversalCursor traversalCursor = RelationshipSelections.multiTypeMultiDirectionCursor((RelationshipTraversalCursor)relCursor, (NodeCursor)nodeCursor, (DirectedTypes)directedTypes);
                    traversedTypes.clear();
                    while (traversalCursor.next()) {
                        traversedTypes.add(traversalCursor.type());
                    }
                    org.junit.jupiter.api.Assertions.assertEquals((Object)expectedTraversedTypes.sortThis(), (Object)traversedTypes.sortThis());
                }
            }
        }
    }

    @Test
    void multiDirectionalMultiTypeAllOutgoing() {
        long nodeId = this.getNodeWithManyDifferentIncidentTypes();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            CursorContext cursorContext = kernelTransaction.cursorContext();
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(cursorContext);
                 RelationshipTraversalCursor relCursor = cursors.allocateRelationshipTraversalCursor(cursorContext);){
                RelationshipSelectionsIT.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 1);
                int[] everyType = new int[]{kernelTransaction.tokenRead().relationshipType(O1.name()), kernelTransaction.tokenRead().relationshipType(O2.name()), kernelTransaction.tokenRead().relationshipType(I1.name()), kernelTransaction.tokenRead().relationshipType(I2.name()), kernelTransaction.tokenRead().relationshipType(L1.name()), kernelTransaction.tokenRead().relationshipType(L2.name())};
                DirectedTypes directedTypes = new DirectedTypes(kernelTransaction.memoryTracker());
                int N_COMBINATIONS = 64;
                IntArrayList expectedTraversedTypes = new IntArrayList();
                IntArrayList traversedTypes = new IntArrayList();
                for (int iteration = 0; iteration < 64; ++iteration) {
                    directedTypes.clear();
                    directedTypes.addUntyped(Direction.OUTGOING);
                    expectedTraversedTypes.clear();
                    block19: for (int typeIndex = 0; typeIndex < everyType.length; ++typeIndex) {
                        switch (iteration >> typeIndex & 1) {
                            case 0: {
                                expectedTraversedTypes.add(everyType[typeIndex]);
                                directedTypes.addTypes(new int[]{everyType[typeIndex]}, Direction.BOTH);
                                continue block19;
                            }
                        }
                    }
                    if (!expectedTraversedTypes.contains(everyType[0])) {
                        expectedTraversedTypes.add(everyType[0]);
                    }
                    if (!expectedTraversedTypes.contains(everyType[1])) {
                        expectedTraversedTypes.add(everyType[1]);
                    }
                    if (!expectedTraversedTypes.contains(everyType[4])) {
                        expectedTraversedTypes.add(everyType[4]);
                    }
                    if (!expectedTraversedTypes.contains(everyType[5])) {
                        expectedTraversedTypes.add(everyType[5]);
                    }
                    directedTypes.compact();
                    RelationshipTraversalCursor traversalCursor = RelationshipSelections.multiTypeMultiDirectionCursor((RelationshipTraversalCursor)relCursor, (NodeCursor)nodeCursor, (DirectedTypes)directedTypes);
                    traversedTypes.clear();
                    while (traversalCursor.next()) {
                        traversedTypes.add(traversalCursor.type());
                    }
                    org.junit.jupiter.api.Assertions.assertEquals((Object)expectedTraversedTypes.sortThis(), (Object)traversedTypes.sortThis());
                }
            }
        }
    }

    @Test
    void multiDirectionalMultiTypeAllOutgoingWriteInSameTx() {
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            CursorContext cursorContext = kernelTransaction.cursorContext();
            long nodeId = this.getNodeWithManyDifferentIncidentTypes(transaction);
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(cursorContext);
                 RelationshipTraversalCursor relCursor = cursors.allocateRelationshipTraversalCursor(cursorContext);){
                RelationshipSelectionsIT.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 1);
                int[] everyType = new int[]{kernelTransaction.tokenRead().relationshipType(O1.name()), kernelTransaction.tokenRead().relationshipType(O2.name()), kernelTransaction.tokenRead().relationshipType(I1.name()), kernelTransaction.tokenRead().relationshipType(I2.name()), kernelTransaction.tokenRead().relationshipType(L1.name()), kernelTransaction.tokenRead().relationshipType(L2.name())};
                DirectedTypes directedTypes = new DirectedTypes(kernelTransaction.memoryTracker());
                int N_COMBINATIONS = 64;
                IntArrayList expectedTraversedTypes = new IntArrayList();
                IntArrayList traversedTypes = new IntArrayList();
                for (int iteration = 0; iteration < 64; ++iteration) {
                    directedTypes.clear();
                    directedTypes.addUntyped(Direction.OUTGOING);
                    expectedTraversedTypes.clear();
                    block19: for (int typeIndex = 0; typeIndex < everyType.length; ++typeIndex) {
                        switch (iteration >> typeIndex & 1) {
                            case 0: {
                                expectedTraversedTypes.add(everyType[typeIndex]);
                                directedTypes.addTypes(new int[]{everyType[typeIndex]}, Direction.BOTH);
                                continue block19;
                            }
                        }
                    }
                    if (!expectedTraversedTypes.contains(everyType[0])) {
                        expectedTraversedTypes.add(everyType[0]);
                    }
                    if (!expectedTraversedTypes.contains(everyType[1])) {
                        expectedTraversedTypes.add(everyType[1]);
                    }
                    if (!expectedTraversedTypes.contains(everyType[4])) {
                        expectedTraversedTypes.add(everyType[4]);
                    }
                    if (!expectedTraversedTypes.contains(everyType[5])) {
                        expectedTraversedTypes.add(everyType[5]);
                    }
                    directedTypes.compact();
                    RelationshipTraversalCursor traversalCursor = RelationshipSelections.multiTypeMultiDirectionCursor((RelationshipTraversalCursor)relCursor, (NodeCursor)nodeCursor, (DirectedTypes)directedTypes);
                    traversedTypes.clear();
                    while (traversalCursor.next()) {
                        traversedTypes.add(traversalCursor.type());
                    }
                    org.junit.jupiter.api.Assertions.assertEquals((Object)expectedTraversedTypes.sortThis(), (Object)traversedTypes.sortThis());
                }
            }
        }
    }

    @Test
    void multiDirectionalMultiTypeAllIncoming() {
        long nodeId = this.getNodeWithManyDifferentIncidentTypes();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            CursorContext cursorContext = kernelTransaction.cursorContext();
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(cursorContext);
                 RelationshipTraversalCursor relCursor = cursors.allocateRelationshipTraversalCursor(cursorContext);){
                RelationshipSelectionsIT.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 1);
                int[] everyType = new int[]{kernelTransaction.tokenRead().relationshipType(O1.name()), kernelTransaction.tokenRead().relationshipType(O2.name()), kernelTransaction.tokenRead().relationshipType(I1.name()), kernelTransaction.tokenRead().relationshipType(I2.name()), kernelTransaction.tokenRead().relationshipType(L1.name()), kernelTransaction.tokenRead().relationshipType(L2.name())};
                DirectedTypes directedTypes = new DirectedTypes(kernelTransaction.memoryTracker());
                int N_COMBINATIONS = 64;
                IntArrayList expectedTraversedTypes = new IntArrayList();
                IntArrayList traversedTypes = new IntArrayList();
                for (int iteration = 0; iteration < 64; ++iteration) {
                    directedTypes.clear();
                    directedTypes.addUntyped(Direction.INCOMING);
                    expectedTraversedTypes.clear();
                    block19: for (int typeIndex = 0; typeIndex < everyType.length; ++typeIndex) {
                        switch (iteration >> typeIndex & 1) {
                            case 0: {
                                expectedTraversedTypes.add(everyType[typeIndex]);
                                directedTypes.addTypes(new int[]{everyType[typeIndex]}, Direction.BOTH);
                                continue block19;
                            }
                        }
                    }
                    if (!expectedTraversedTypes.contains(everyType[2])) {
                        expectedTraversedTypes.add(everyType[2]);
                    }
                    if (!expectedTraversedTypes.contains(everyType[3])) {
                        expectedTraversedTypes.add(everyType[3]);
                    }
                    if (!expectedTraversedTypes.contains(everyType[4])) {
                        expectedTraversedTypes.add(everyType[4]);
                    }
                    if (!expectedTraversedTypes.contains(everyType[5])) {
                        expectedTraversedTypes.add(everyType[5]);
                    }
                    directedTypes.compact();
                    RelationshipTraversalCursor traversalCursor = RelationshipSelections.multiTypeMultiDirectionCursor((RelationshipTraversalCursor)relCursor, (NodeCursor)nodeCursor, (DirectedTypes)directedTypes);
                    traversedTypes.clear();
                    while (traversalCursor.next()) {
                        traversedTypes.add(traversalCursor.type());
                    }
                    org.junit.jupiter.api.Assertions.assertEquals((Object)expectedTraversedTypes.sortThis(), (Object)traversedTypes.sortThis());
                }
            }
        }
    }

    @Test
    void multiDirectionalMultiTypeAllIncomingWriteInSameTx() {
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            CursorContext cursorContext = kernelTransaction.cursorContext();
            long nodeId = this.getNodeWithManyDifferentIncidentTypes(transaction);
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(cursorContext);
                 RelationshipTraversalCursor relCursor = cursors.allocateRelationshipTraversalCursor(cursorContext);){
                RelationshipSelectionsIT.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                RelationshipSelectionsIT.assertCursorHits(cursorContext, 1);
                int[] everyType = new int[]{kernelTransaction.tokenRead().relationshipType(O1.name()), kernelTransaction.tokenRead().relationshipType(O2.name()), kernelTransaction.tokenRead().relationshipType(I1.name()), kernelTransaction.tokenRead().relationshipType(I2.name()), kernelTransaction.tokenRead().relationshipType(L1.name()), kernelTransaction.tokenRead().relationshipType(L2.name())};
                DirectedTypes directedTypes = new DirectedTypes(kernelTransaction.memoryTracker());
                int N_COMBINATIONS = 64;
                IntArrayList expectedTraversedTypes = new IntArrayList();
                IntArrayList traversedTypes = new IntArrayList();
                for (int iteration = 0; iteration < 64; ++iteration) {
                    directedTypes.clear();
                    directedTypes.addUntyped(Direction.INCOMING);
                    expectedTraversedTypes.clear();
                    expectedTraversedTypes.clear();
                    block19: for (int typeIndex = 0; typeIndex < everyType.length; ++typeIndex) {
                        switch (iteration >> typeIndex & 1) {
                            case 0: {
                                expectedTraversedTypes.add(everyType[typeIndex]);
                                directedTypes.addTypes(new int[]{everyType[typeIndex]}, Direction.BOTH);
                                continue block19;
                            }
                        }
                    }
                    if (!expectedTraversedTypes.contains(everyType[2])) {
                        expectedTraversedTypes.add(everyType[2]);
                    }
                    if (!expectedTraversedTypes.contains(everyType[3])) {
                        expectedTraversedTypes.add(everyType[3]);
                    }
                    if (!expectedTraversedTypes.contains(everyType[4])) {
                        expectedTraversedTypes.add(everyType[4]);
                    }
                    if (!expectedTraversedTypes.contains(everyType[5])) {
                        expectedTraversedTypes.add(everyType[5]);
                    }
                    directedTypes.compact();
                    RelationshipTraversalCursor traversalCursor = RelationshipSelections.multiTypeMultiDirectionCursor((RelationshipTraversalCursor)relCursor, (NodeCursor)nodeCursor, (DirectedTypes)directedTypes);
                    traversedTypes.clear();
                    while (traversalCursor.next()) {
                        traversedTypes.add(traversalCursor.type());
                    }
                    org.junit.jupiter.api.Assertions.assertEquals((Object)expectedTraversedTypes.sortThis(), (Object)traversedTypes.sortThis());
                }
            }
        }
    }

    private long getSparseNodeId() {
        try (Transaction tx = this.database.beginTx();){
            Node source = tx.createNode();
            Node endNode1 = tx.createNode();
            Node endNode2 = tx.createNode();
            source.createRelationshipTo(endNode1, relationshipType);
            source.createRelationshipTo(endNode2, relationshipType);
            endNode1.createRelationshipTo(source, relationshipType);
            endNode2.createRelationshipTo(source, relationshipType);
            long nodeId = source.getId();
            tx.commit();
            long l = nodeId;
            return l;
        }
    }

    private long getDenseNodeId() {
        try (Transaction tx = this.database.beginTx();){
            Node source = tx.createNode();
            Node endNode1 = tx.createNode();
            Node endNode2 = tx.createNode();
            source.createRelationshipTo(endNode1, relationshipType);
            source.createRelationshipTo(endNode2, relationshipType);
            endNode1.createRelationshipTo(source, relationshipType);
            endNode2.createRelationshipTo(source, relationshipType);
            RelationshipType other = RelationshipType.withName((String)"other");
            for (int i = 0; i < 100; ++i) {
                Node node = tx.createNode();
                source.createRelationshipTo(node, other);
            }
            long nodeId = source.getId();
            tx.commit();
            long l = nodeId;
            return l;
        }
    }

    private long getNodeWithManyDifferentIncidentTypes() {
        try (Transaction tx = this.database.beginTx();){
            long source = this.getNodeWithManyDifferentIncidentTypes(tx);
            tx.commit();
            long l = source;
            return l;
        }
    }

    private long getNodeWithManyDifferentIncidentTypes(Transaction tx) {
        Node source = tx.createNode();
        Node target = tx.createNode();
        source.createRelationshipTo(target, O1);
        source.createRelationshipTo(target, O2);
        target.createRelationshipTo(source, I1);
        target.createRelationshipTo(source, I2);
        source.createRelationshipTo(source, L1);
        source.createRelationshipTo(source, L2);
        return source.getId();
    }

    private static void setNodeCursor(long nodeId, KernelTransaction kernelTransaction, NodeCursor nodeCursor) {
        kernelTransaction.dataRead().singleNode(nodeId, nodeCursor);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)nodeCursor.next());
    }

    private static void consumeCursor(RelationshipTraversalCursor cursor) {
        while (cursor.next()) {
        }
    }

    private static void assertCursorHits(CursorContext cursorContext, int atMostHits) {
        PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
        Assertions.assertThat((long)cursorTracer.hits()).isLessThanOrEqualTo((long)atMostHits).isLessThanOrEqualTo(cursorTracer.pins());
    }
}

