/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.iterator.LongIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.PropertyIndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracker;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

abstract class CompositeIndexPopulatorCompatibility
extends PropertyIndexProviderCompatibilityTestSuite.Compatibility {
    CompositeIndexPopulatorCompatibility(PropertyIndexProviderCompatibilityTestSuite testSuite, IndexPrototype prototype) {
        super(testSuite, prototype);
    }

    static abstract class Unique
    extends CompositeIndexPopulatorCompatibility {
        Value value1 = Values.of((Object)"value1");
        Value value2 = Values.of((Object)"value2");
        Value value3 = Values.of((Object)"value3");
        int nodeId1 = 3;
        int nodeId2 = 4;

        Unique(PropertyIndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1000, (int[])new int[]{100, 200})));
        }

        @Test
        void shouldEnforceUniqueConstraintsDirectly() throws Exception {
            IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(this.config);
            this.withPopulator(this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup, Sets.immutable.empty(), StorageEngineIndexingBehaviour.EMPTY), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
                try {
                    p.add(Arrays.asList(IndexEntryUpdate.add((long)this.nodeId1, (SchemaDescriptorSupplier)this.descriptor, (Value[])new Value[]{this.value1, this.value2}), IndexEntryUpdate.add((long)this.nodeId2, (SchemaDescriptorSupplier)this.descriptor, (Value[])new Value[]{this.value1, this.value2})), CursorContext.NULL_CONTEXT);
                    p.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL_CONTEXT);
                    Assertions.fail((String)"expected exception");
                }
                catch (IndexEntryConflictException conflict) {
                    Assertions.assertEquals((long)this.nodeId1, (long)conflict.getExistingEntityId());
                    Assertions.assertEquals((Object)ValueTuple.of((Value[])new Value[]{this.value1, this.value2}), (Object)conflict.getPropertyValues());
                    Assertions.assertEquals((long)this.nodeId2, (long)conflict.getAddedEntityId());
                }
            }), false);
        }

        @Test
        void shouldNotRestrictUpdatesDifferingOnSecondProperty() throws Exception {
            IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(this.config);
            this.withPopulator(this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup, Sets.immutable.empty(), StorageEngineIndexingBehaviour.EMPTY), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
                p.add(Arrays.asList(IndexEntryUpdate.add((long)this.nodeId1, (SchemaDescriptorSupplier)this.descriptor, (Value[])new Value[]{this.value1, this.value2}), IndexEntryUpdate.add((long)this.nodeId2, (SchemaDescriptorSupplier)this.descriptor, (Value[])new Value[]{this.value1, this.value3})), CursorContext.NULL_CONTEXT);
                p.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL_CONTEXT);
            }));
        }
    }

    static abstract class General
    extends CompositeIndexPopulatorCompatibility {
        General(PropertyIndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1000, (int[])new int[]{100, 200})));
        }

        @Test
        void shouldProvidePopulatorThatAcceptsDuplicateEntries() throws Exception {
            IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(this.config);
            this.withPopulator(this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup, Sets.immutable.empty(), StorageEngineIndexingBehaviour.EMPTY), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> p.add(Arrays.asList(IndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)this.descriptor, (Value[])new Value[]{Values.of((Object)"v1"), Values.of((Object)"v2")}), IndexEntryUpdate.add((long)2L, (SchemaDescriptorSupplier)this.descriptor, (Value[])new Value[]{Values.of((Object)"v1"), Values.of((Object)"v2")})), CursorContext.NULL_CONTEXT)));
            try (IndexAccessor accessor = this.indexProvider.getOnlineAccessor(this.descriptor, indexSamplingConfig, this.tokenNameLookup, Sets.immutable.empty(), StorageEngineIndexingBehaviour.EMPTY);
                 ValueIndexReader reader = accessor.newValueReader(IndexUsageTracker.NO_USAGE_TRACKER);
                 NodeValueIterator nodes = new NodeValueIterator();){
                reader.query((IndexProgressor.EntityValueClient)nodes, QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.READ, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)1, (Object)"v1"), PropertyIndexQuery.exact((int)1, (Object)"v2")});
                Assertions.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L, 2L}), (Object)PrimitiveLongCollections.toSet((LongIterator)nodes));
            }
        }
    }
}

