/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.graphdb.schema.IndexSettingUtil;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.impl.schema.vector.VectorSimilarityFunction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.Tags;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
public class VectorIndexCreationTest {
    private static final Label LABEL = (Label)Tags.Suppliers.UUID.LABEL.get();
    private static final RelationshipType REL_TYPE = (RelationshipType)Tags.Suppliers.UUID.RELATIONSHIP_TYPE.get();
    private static final List<String> PROP_KEYS = Tags.Suppliers.UUID.PROPERTY_KEY.get(2);
    @Inject
    private GraphDatabaseAPI db;
    private int labelId;
    private int relTypeId;
    private int[] propKeyIds;

    @BeforeEach
    void setup() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            this.labelId = Tags.Factories.LABEL.getId(ktx, LABEL);
            this.relTypeId = Tags.Factories.RELATIONSHIP_TYPE.getId(ktx, REL_TYPE);
            this.propKeyIds = Tags.Factories.PROPERTY_KEY.getIds(ktx, PROP_KEYS).stream().mapToInt(k -> k).toArray();
            tx.commit();
        }
    }

    @Test
    void shouldAcceptNodeVectorIndex() {
        Assertions.assertThatCode(() -> this.createVectorIndex((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.labelId, (int[])new int[]{this.propKeyIds[0]}), VectorIndexCreationTest.defaultConfig())).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.createNodeVectorIndexCoreAPI(PROP_KEYS.get(1), VectorIndexCreationTest.defaultSettings())).doesNotThrowAnyException();
    }

    @Test
    void shouldRejectRelationshipVectorIndex() {
        VectorIndexCreationTest.assertUnsupportedRelationshipIndex(() -> this.createVectorIndex((SchemaDescriptor)SchemaDescriptors.forRelType((int)this.relTypeId, (int[])new int[]{this.propKeyIds[0]}), VectorIndexCreationTest.defaultConfig()));
        VectorIndexCreationTest.assertUnsupportedRelationshipIndex(() -> this.createRelVectorIndexCoreAPI(PROP_KEYS.get(1), VectorIndexCreationTest.defaultSettings()));
    }

    @ParameterizedTest
    @ValueSource(ints={1, 738, 1024, 1408, 1536, 2048, 2048})
    void shouldAcceptValidDimensions(int dimensions) {
        Assertions.assertThatCode(() -> this.createVectorIndex((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.labelId, (int[])new int[]{this.propKeyIds[0]}), VectorIndexCreationTest.defaultConfigWith(IndexSetting.vector_Dimensions(), dimensions))).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.createNodeVectorIndexCoreAPI(PROP_KEYS.get(1), VectorIndexCreationTest.defaultSettingsWith(IndexSetting.vector_Dimensions(), dimensions))).doesNotThrowAnyException();
    }

    @ParameterizedTest
    @ValueSource(ints={-1, 0})
    void shouldRejectIllegalDimensions(int dimensions) {
        VectorIndexCreationTest.assertIllegalDimensions(() -> this.createVectorIndex((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.labelId, (int[])new int[]{this.propKeyIds[0]}), VectorIndexCreationTest.defaultConfigWith(IndexSetting.vector_Dimensions(), dimensions)));
        VectorIndexCreationTest.assertIllegalDimensions(() -> this.createNodeVectorIndexCoreAPI(PROP_KEYS.get(1), VectorIndexCreationTest.defaultSettingsWith(IndexSetting.vector_Dimensions(), dimensions)));
    }

    @Test
    void shouldRejectUnsupportedDimensions() {
        int dimensions = 2049;
        VectorIndexCreationTest.assertUnsupportedDimensions(() -> this.createVectorIndex((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.labelId, (int[])new int[]{this.propKeyIds[0]}), VectorIndexCreationTest.defaultConfigWith(IndexSetting.vector_Dimensions(), 2049)));
        VectorIndexCreationTest.assertUnsupportedDimensions(() -> this.createNodeVectorIndexCoreAPI(PROP_KEYS.get(1), VectorIndexCreationTest.defaultSettingsWith(IndexSetting.vector_Dimensions(), 2049)));
    }

    @ParameterizedTest
    @EnumSource
    void shouldAcceptValidSimilarityFunction(VectorSimilarityFunction similarityFunction) {
        String validSimilarityFunctionName = similarityFunction.name();
        Assertions.assertThatCode(() -> this.createVectorIndex((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.labelId, (int[])new int[]{this.propKeyIds[0]}), VectorIndexCreationTest.defaultConfigWith(IndexSetting.vector_Similarity_Function(), validSimilarityFunctionName))).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.createNodeVectorIndexCoreAPI(PROP_KEYS.get(1), VectorIndexCreationTest.defaultSettingsWith(IndexSetting.vector_Similarity_Function(), validSimilarityFunctionName))).doesNotThrowAnyException();
    }

    @Test
    void shouldRejectIllegalSimilarityFunction() {
        String invalidSimilarityFunctionName = "ClearlyThisIsNotASimilarityFunction";
        VectorIndexCreationTest.assertIllegalSimilarityFunction(() -> this.createVectorIndex((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.labelId, (int[])new int[]{this.propKeyIds[0]}), VectorIndexCreationTest.defaultConfigWith(IndexSetting.vector_Similarity_Function(), "ClearlyThisIsNotASimilarityFunction")));
        VectorIndexCreationTest.assertIllegalSimilarityFunction(() -> this.createNodeVectorIndexCoreAPI(PROP_KEYS.get(1), VectorIndexCreationTest.defaultSettingsWith(IndexSetting.vector_Similarity_Function(), "ClearlyThisIsNotASimilarityFunction")));
    }

    @Test
    void shouldRejectCompositeKeys() {
        VectorIndexCreationTest.assertUnsupportedComposite(() -> this.createVectorIndex((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.labelId, (int[])this.propKeyIds), VectorIndexCreationTest.defaultConfig()));
        VectorIndexCreationTest.assertUnsupportedComposite(() -> this.createVectorIndex((SchemaDescriptor)SchemaDescriptors.forRelType((int)this.relTypeId, (int[])this.propKeyIds), VectorIndexCreationTest.defaultConfig()));
        VectorIndexCreationTest.assertUnsupportedComposite(() -> this.createNodeVectorIndexCoreAPI(PROP_KEYS, VectorIndexCreationTest.defaultSettings()));
        VectorIndexCreationTest.assertUnsupportedComposite(() -> this.createRelVectorIndexCoreAPI(PROP_KEYS, VectorIndexCreationTest.defaultSettings()));
    }

    private void createVectorIndex(SchemaDescriptor schema, IndexConfig config) throws Exception {
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema).withIndexType(IndexType.VECTOR).withIndexConfig(config);
            ktx.schemaWrite().indexCreate(prototype);
            tx.commit();
        }
    }

    private void createNodeVectorIndexCoreAPI(String propKey, Map<IndexSetting, Object> settings) {
        this.createNodeVectorIndexCoreAPI(List.of(propKey), settings);
    }

    private void createNodeVectorIndexCoreAPI(List<String> propKeys, Map<IndexSetting, Object> settings) {
        try (Transaction tx = this.db.beginTx();){
            IndexCreator creator = tx.schema().indexFor(LABEL).withIndexType(IndexType.VECTOR.toPublicApi()).withIndexConfiguration(settings);
            for (String propKey : propKeys) {
                creator = creator.on(propKey);
            }
            creator.create();
            tx.commit();
        }
    }

    private void createRelVectorIndexCoreAPI(String propKey, Map<IndexSetting, Object> settings) {
        this.createRelVectorIndexCoreAPI(List.of(propKey), settings);
    }

    private void createRelVectorIndexCoreAPI(List<String> propKeys, Map<IndexSetting, Object> settings) {
        try (Transaction tx = this.db.beginTx();){
            IndexCreator creator = tx.schema().indexFor(REL_TYPE).withIndexType(IndexType.VECTOR.toPublicApi()).withIndexConfiguration(settings);
            for (String propKey : propKeys) {
                creator = creator.on(propKey);
            }
            creator.create();
            tx.commit();
        }
    }

    private static IndexConfig defaultConfig() {
        return IndexSettingUtil.defaultConfigForTest((org.neo4j.graphdb.schema.IndexType)IndexType.VECTOR.toPublicApi());
    }

    private static IndexConfig defaultConfigWith(IndexSetting setting, Object value) {
        return VectorIndexCreationTest.configFrom(VectorIndexCreationTest.defaultSettingsWith(setting, value));
    }

    private static IndexConfig configFrom(Map<IndexSetting, Object> settings) {
        return IndexSettingUtil.toIndexConfigFromIndexSettingObjectMap(settings);
    }

    private static Map<IndexSetting, Object> defaultSettings() {
        return IndexSettingUtil.defaultSettingsForTesting((org.neo4j.graphdb.schema.IndexType)IndexType.VECTOR.toPublicApi());
    }

    private static Map<IndexSetting, Object> defaultSettingsWith(IndexSetting setting, Object value) {
        HashMap<IndexSetting, Object> settings = new HashMap<IndexSetting, Object>(VectorIndexCreationTest.defaultSettings());
        settings.put(setting, value);
        return Collections.unmodifiableMap(settings);
    }

    private static void assertUnsupportedRelationshipIndex(ThrowableAssert.ThrowingCallable callable) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(UnsupportedOperationException.class)).hasMessageContainingAll(new CharSequence[]{"Relationship indexes are not supported for", IndexType.VECTOR.name(), "index type"});
    }

    private static void assertIllegalDimensions(ThrowableAssert.ThrowingCallable callable) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(IllegalArgumentException.class)).cause().hasMessageContainingAll(new CharSequence[]{IndexSetting.vector_Dimensions().getSettingName(), "is expected to be positive"});
    }

    private static void assertUnsupportedDimensions(ThrowableAssert.ThrowingCallable callable) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(UnsupportedOperationException.class)).hasMessageContainingAll(new CharSequence[]{IndexSetting.vector_Dimensions().getSettingName(), "set greater than"});
    }

    private static void assertIllegalSimilarityFunction(ThrowableAssert.ThrowingCallable callable) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(IllegalArgumentException.class)).cause().hasMessageContainingAll(new CharSequence[]{"is an unsupported vector similarity function", "Supported", VectorSimilarityFunction.SUPPORTED.toString()});
    }

    private static void assertUnsupportedComposite(ThrowableAssert.ThrowingCallable callable) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(UnsupportedOperationException.class)).hasMessageContainingAll(new CharSequence[]{"Composite indexes are not supported for", IndexType.VECTOR.name(), "index type"});
    }
}

