/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.io.IOException;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexSettingUtil;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.ZippedStore;
import org.neo4j.kernel.ZippedStoreCommunity;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.UpgradeTestUtil;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class VectorIndexOnDatabaseUpgradeTransactionIT {
    private static final Label LABEL = Label.label((String)"Label");
    private static final String PROP_KEY = "propKey";
    @Inject
    private TestDirectory testDirectory;
    private DatabaseManagementService dbms;
    private GraphDatabaseAPI database;

    VectorIndexOnDatabaseUpgradeTransactionIT() {
    }

    @AfterEach
    void tearDown() {
        if (this.dbms != null) {
            this.dbms.shutdown();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"indexes"})
    void shouldBeBlockedFromCreatingVectorIndexOnOlderVersion(EntityType entityType, KernelVersion introduced, VectorIndexCreator vectorIndex) {
        KernelVersion previousVersion = this.previousFrom(introduced);
        this.setup(previousVersion);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            try (Transaction tx = this.database.beginTx();){
                vectorIndex.create(tx.schema());
                tx.commit();
            }
        }).isInstanceOf(UnsupportedOperationException.class)).hasMessageContainingAll(new CharSequence[]{"Failed to create node vector index", "Version was", previousVersion.name(), "but required version for operation is", KernelVersion.VERSION_NODE_VECTOR_INDEX_INTRODUCED.name(), "Please upgrade dbms using 'dbms.upgrade()'"});
    }

    @ParameterizedTest
    @MethodSource(value={"indexes"})
    void shouldBePossibleToCreateVectorIndexAfterUpgrade(EntityType entityType, KernelVersion introduced, VectorIndexCreator vectorIndex) {
        KernelVersion previousVersion = this.previousFrom(introduced);
        this.setup(previousVersion);
        UpgradeTestUtil.upgradeDatabase((DatabaseManagementService)this.dbms, (GraphDatabaseAPI)this.database, (KernelVersion)previousVersion, (KernelVersion)LatestVersions.LATEST_KERNEL_VERSION);
        try (Transaction tx = this.database.beginTx();){
            vectorIndex.create(tx.schema());
            tx.commit();
        }
        tx = this.database.beginTx();
        try {
            Assertions.assertThat((Iterable)tx.schema().getIndexes()).hasSize(1);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"indexes"})
    void createVectorIndexShouldTriggerUpgrade(EntityType entityType, KernelVersion introduced, VectorIndexCreator vectorIndex) {
        KernelVersion previousVersion = this.previousFrom(introduced);
        this.setup(previousVersion);
        UpgradeTestUtil.upgradeDbms((DatabaseManagementService)this.dbms);
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)this.database, (KernelVersion)previousVersion);
        try (Transaction tx = this.database.beginTx();){
            vectorIndex.create(tx.schema());
            tx.commit();
        }
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)this.database, (KernelVersion)LatestVersions.LATEST_KERNEL_VERSION);
        tx = this.database.beginTx();
        try {
            Assertions.assertThat((Iterable)tx.schema().getIndexes()).hasSize(1);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static Stream<Arguments> indexes() {
        return Stream.of(Arguments.of((Object[])new Object[]{EntityType.NODE, KernelVersion.VERSION_NODE_VECTOR_INDEX_INTRODUCED, schema -> schema.indexFor(LABEL).on(PROP_KEY).withIndexType(IndexType.VECTOR).withIndexConfiguration(IndexSettingUtil.defaultSettingsForTesting((IndexType)IndexType.VECTOR)).create()}));
    }

    private KernelVersion previousFrom(KernelVersion kernelVersion) {
        if (kernelVersion == KernelVersion.GLORIOUS_FUTURE) {
            return LatestVersions.LATEST_KERNEL_VERSION;
        }
        byte previous = (byte)(kernelVersion.version() - 1);
        return KernelVersion.getForVersion((byte)previous);
    }

    private void setup(KernelVersion kernelVersion) {
        switch (kernelVersion) {
            case V5_10: {
                break;
            }
            default: {
                throw new InvalidArgumentException("Test not setup to find a %s for %s.".formatted(ZippedStore.class.getSimpleName(), kernelVersion));
            }
        }
        ZippedStoreCommunity store = ZippedStoreCommunity.REC_AF11_V510_EMPTY;
        this.setup(store);
    }

    private void setup(ZippedStoreCommunity snapshot) {
        try {
            snapshot.unzip(this.testDirectory.homePath());
        }
        catch (IOException exc) {
            Assertions.fail((String)"Could not setup %s:%s".formatted(snapshot.name(), exc));
        }
        this.dbms = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setConfig(GraphDatabaseInternalSettings.automatic_upgrade_enabled, (Object)false).build();
        this.database = (GraphDatabaseAPI)this.dbms.database("neo4j");
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)this.database, (KernelVersion)snapshot.statistics().kernelVersion());
    }

    @FunctionalInterface
    private static interface VectorIndexCreator {
        public IndexDefinition create(Schema var1);
    }
}

