/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionHandle;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.procedure.ProcedureView;
import org.neo4j.kernel.impl.api.TokenHoldersIdLookup;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserAggregationResult;
import org.neo4j.procedure.UserAggregationUpdate;
import org.neo4j.procedure.UserFunction;
import org.neo4j.procedure.impl.GlobalProceduresRegistry;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;

class TokenHoldersIdLookupTest {
    private static LoginContext.IdLookup idLookup;
    private static HashMap<String, Integer> procName2id;
    private static HashMap<String, Integer> funcName2id;

    TokenHoldersIdLookupTest() {
    }

    @BeforeAll
    static void setup() throws KernelException {
        GlobalProceduresRegistry reg = new GlobalProceduresRegistry();
        reg.registerProcedure(TestProcedures.class);
        reg.registerFunction(TestProcedures.class);
        reg.registerAggregationFunction(TestProcedures.class);
        ProcedureView procs = reg.getCurrentView();
        procName2id = new HashMap();
        for (ProcedureSignature signature2 : procs.getAllProcedures()) {
            QualifiedName name = signature2.name();
            ProcedureHandle procedure = procs.procedure(name);
            procName2id.put(name.toString(), procedure.id());
        }
        funcName2id = new HashMap();
        procs.getAllNonAggregatingFunctions().forEach(signature -> {
            QualifiedName name = signature.name();
            UserFunctionHandle function = procs.function(name);
            funcName2id.put(name.toString(), function.id());
        });
        procs.getAllAggregatingFunctions().forEach(signature -> {
            QualifiedName name = signature.name();
            UserFunctionHandle function = procs.aggregationFunction(name);
            funcName2id.put(name.toString(), function.id());
        });
        idLookup = new TokenHoldersIdLookup(TokenHoldersIdLookupTest.mockedTokenHolders(), procs, () -> false);
    }

    private static TokenHolders mockedTokenHolders() {
        return new TokenHolders((TokenHolder)Mockito.mock(TokenHolder.class), (TokenHolder)Mockito.mock(TokenHolder.class), (TokenHolder)Mockito.mock(TokenHolder.class));
    }

    @Test
    void shouldLookupProcedureByName() {
        int[] ids = idLookup.getProcedureIds("test.proc1");
        Assertions.assertThat((int[])ids).hasSize(1);
        Assertions.assertThat((int)ids[0]).isEqualTo((Object)procName2id.get("test.proc1"));
    }

    @Test
    void shouldLookupAllProceduresWithStar() {
        int[] ids = idLookup.getProcedureIds("*");
        Assertions.assertThat((int[])ids).hasSize(6);
        Assertions.assertThat((int[])ids).containsExactlyInAnyOrder(new int[]{procName2id.get("test.proc1"), procName2id.get("test.proc2"), procName2id.get("test.other.proc1"), procName2id.get("test.other.proc42"), procName2id.get("other.test.proc1"), procName2id.get("test.(-_-).proc1")});
    }

    @Test
    void shouldLookupProcedureEndingWith() {
        int[] ids = idLookup.getProcedureIds("*.proc1");
        Assertions.assertThat((int[])ids).hasSize(4);
        Assertions.assertThat((int[])ids).containsExactlyInAnyOrder(new int[]{procName2id.get("test.proc1"), procName2id.get("test.other.proc1"), procName2id.get("other.test.proc1"), procName2id.get("test.(-_-).proc1")});
    }

    @Test
    void shouldLookupProcedureStartingWith() {
        int[] ids = idLookup.getProcedureIds("other.*");
        Assertions.assertThat((int[])ids).hasSize(1);
        Assertions.assertThat((int)ids[0]).isEqualTo((Object)procName2id.get("other.test.proc1"));
    }

    @Test
    void shouldLookupWithStarAndQuestionMark() {
        int[] ids = idLookup.getProcedureIds("test.*.proc?");
        Assertions.assertThat((int[])ids).hasSize(2);
        Assertions.assertThat((int[])ids).containsExactlyInAnyOrder(new int[]{procName2id.get("test.other.proc1"), procName2id.get("test.(-_-).proc1")});
        ids = idLookup.getProcedureIds("test.*.proc??");
        Assertions.assertThat((int[])ids).hasSize(1);
        Assertions.assertThat((int)ids[0]).isEqualTo((Object)procName2id.get("test.other.proc42"));
    }

    @Test
    void shouldLookupWithMatchSingleCharacter() {
        int[] ids = idLookup.getProcedureIds("test.proc?");
        Assertions.assertThat((int[])ids).hasSize(2);
        Assertions.assertThat((int[])ids).containsExactlyInAnyOrder(new int[]{procName2id.get("test.proc1"), procName2id.get("test.proc2")});
    }

    @Test
    void shouldMatchNoneWithMistake() {
        Assertions.assertThat((int[])idLookup.getProcedureIds("test.?.proc1")).isEmpty();
        Assertions.assertThat((int[])idLookup.getProcedureIds("*.*.*.proc1")).isEmpty();
        Assertions.assertThat((int[])idLookup.getProcedureIds("*.proc")).isEmpty();
    }

    @Test
    void matchingWithRegexFails() {
        Assertions.assertThat((int[])idLookup.getProcedureIds("(\\w+.)+\\w+")).isEmpty();
        Assertions.assertThat((int[])idLookup.getProcedureIds("(\\w+.)*\\w+")).isEmpty();
    }

    @Test
    void matchingWithSpecialCharacters() {
        int[] ids = idLookup.getProcedureIds("test.(-_-).proc1");
        Assertions.assertThat((int[])ids).hasSize(1);
        Assertions.assertThat((int)ids[0]).isEqualTo((Object)procName2id.get("test.(-_-).proc1"));
    }

    @Test
    void shouldLookupFunctionByName() {
        int[] ids = idLookup.getFunctionIds("test.func1");
        Assertions.assertThat((int[])ids).hasSize(1);
        Assertions.assertThat((int)ids[0]).isEqualTo((Object)funcName2id.get("test.func1"));
    }

    @Test
    void shouldLookupAllFunctionsWithStar() {
        int[] ids = idLookup.getFunctionIds("*");
        Assertions.assertThat((int[])ids).hasSize(2);
        Assertions.assertThat((int[])ids).containsExactlyInAnyOrder(new int[]{funcName2id.get("test.func1"), funcName2id.get("test.func42")});
    }

    @Test
    void shouldLookupFunctionEndingWith() {
        int[] ids = idLookup.getFunctionIds("*.func1");
        Assertions.assertThat((int[])ids).hasSize(1);
        Assertions.assertThat((int)ids[0]).isEqualTo((Object)funcName2id.get("test.func1"));
    }

    @Test
    void shouldLookupFunctionStartingWith() {
        int[] ids = idLookup.getFunctionIds("test.*");
        Assertions.assertThat((int[])ids).hasSize(2);
        Assertions.assertThat((int[])ids).containsExactlyInAnyOrder(new int[]{funcName2id.get("test.func1"), funcName2id.get("test.func42")});
    }

    @Test
    void shouldLookupFunctionWithStarAndQuestionMark() {
        int[] ids = idLookup.getFunctionIds("te*.func?");
        Assertions.assertThat((int[])ids).hasSize(1);
        Assertions.assertThat((int)ids[0]).isEqualTo((Object)funcName2id.get("test.func1"));
        ids = idLookup.getFunctionIds("tes*.func??");
        Assertions.assertThat((int[])ids).hasSize(1);
        Assertions.assertThat((int)ids[0]).isEqualTo((Object)funcName2id.get("test.func42"));
        ids = idLookup.getFunctionIds("tes*.fun?42");
        Assertions.assertThat((int[])ids).hasSize(1);
        Assertions.assertThat((int)ids[0]).isEqualTo((Object)funcName2id.get("test.func42"));
    }

    public static class TestProcedures {
        @Procedure(name="test.proc1")
        public void proc1() {
        }

        @Procedure(name="test.proc2")
        public void proc2() {
        }

        @Procedure(name="test.other.proc1")
        public void proc3() {
        }

        @Procedure(name="test.other.proc42")
        public void proc4() {
        }

        @Procedure(name="other.test.proc1")
        public void proc5() {
        }

        @Procedure(name="test.(-_-).proc1")
        public void proc6() {
        }

        @UserFunction(value="test.func1")
        public long func1() {
            return 0L;
        }

        @UserFunction(value="test.func42")
        public long func2() {
            return 0L;
        }

        @UserAggregationFunction(value="test.agg.func1")
        public AggFunc1 aggFunc1() {
            return new AggFunc1();
        }

        @UserAggregationFunction(value="test.agg.(-_-).func1")
        public AggFunc2 aggFunc2() {
            return new AggFunc2();
        }

        public static class AggFunc1 {
            @UserAggregationUpdate
            public void update(@Name(value="in") long in) {
            }

            @UserAggregationResult
            public long result() {
                return 42L;
            }
        }

        public static class AggFunc2 {
            @UserAggregationUpdate
            public void update(@Name(value="in") long in) {
            }

            @UserAggregationResult
            public long result() {
                return 42L;
            }
        }
    }
}

