/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.neo4j.collection.RawIterator;
import org.neo4j.cypher.internal.cache.CypherQueryCaches;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.index.IndexSamplingMode;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.kernel.impl.api.integrationtest.ProcedureITBase;
import org.neo4j.kernel.impl.query.CacheMetrics;
import org.neo4j.kernel.impl.query.QueryCacheStatistics;
import org.neo4j.kernel.internal.Version;
import org.neo4j.monitoring.Monitors;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualValues;

class BuiltInProceduresIT
extends KernelIntegrationTest
implements ProcedureITBase {
    BuiltInProceduresIT() {
    }

    @Test
    void listAllLabels() throws Throwable {
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long nodeId = transaction.dataWrite().nodeCreate();
        int labelId = transaction.tokenWrite().labelGetOrCreateForName("MyLabel");
        transaction.dataWrite().nodeAddLabel(nodeId, labelId);
        this.commit();
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            RawIterator stream = procs.procedureCallRead(procs.procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "labels"})).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).containsExactly((Object[])new AnyValue[][]{{Values.stringValue((String)"MyLabel")}});
        }
    }

    @Test
    void databaseInfo() throws ProcedureException {
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            RawIterator stream = procs.procedureCallRead(procs.procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "info"})).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            List procedureResult = Iterators.asList((RawIterator)stream);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)procedureResult.isEmpty());
            Object[] dbInfoRow = (AnyValue[])procedureResult.get(0);
            Assertions.assertThat((Object[])dbInfoRow).contains((Object[])new AnyValue[]{Values.stringValue((String)this.db.databaseName())});
            Assertions.assertThat((Object[])dbInfoRow).hasSize(3);
        }
    }

    @Test
    void dbmsInfo() throws ProcedureException {
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            RawIterator stream = procs.procedureCallRead(procs.procedureGet(ProcedureSignature.procedureName((String[])new String[]{"dbms", "info"})).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            List procedureResult = Iterators.asList((RawIterator)stream);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)procedureResult.isEmpty());
            Object[] dbmsInfoRow = (AnyValue[])procedureResult.get(0);
            Assertions.assertThat((Object[])dbmsInfoRow).contains((Object[])new AnyValue[]{Values.stringValue((String)"system")});
            Assertions.assertThat((Object[])dbmsInfoRow).hasSize(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=6L, unit=TimeUnit.MINUTES)
    void listAllLabelsMustNotBlockOnConstraintCreatingTransaction() throws Throwable {
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long nodeId = transaction.dataWrite().nodeCreate();
        int labelId = transaction.tokenWrite().labelGetOrCreateForName("MyLabel");
        int propKey = transaction.tokenWrite().propertyKeyCreateForName("prop", false);
        transaction.dataWrite().nodeAddLabel(nodeId, labelId);
        this.commit();
        CountDownLatch constraintLatch = new CountDownLatch(1);
        CountDownLatch commitLatch = new CountDownLatch(1);
        FutureTask<Void> createConstraintTask = new FutureTask<Void>(() -> {
            SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
            try (Resource ignore = this.captureTransaction();){
                IndexPrototype prototype = IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propKey})).withName("constraint name");
                schemaWrite.uniquePropertyConstraintCreate(prototype);
                constraintLatch.countDown();
                commitLatch.await();
            }
            this.rollback();
            return null;
        });
        Thread constraintCreator = new Thread(createConstraintTask);
        constraintCreator.start();
        constraintLatch.await();
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            RawIterator stream = procs.procedureCallRead(procs.procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "labels"})).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            try {
                Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).containsExactly((Object[])new AnyValue[][]{{Values.stringValue((String)"MyLabel")}});
            }
            finally {
                commitLatch.countDown();
            }
        }
        createConstraintTask.get();
        constraintCreator.join();
    }

    @Test
    void listPropertyKeys() throws Throwable {
        TokenWrite ops = this.tokenWriteInNewTransaction();
        ops.propertyKeyGetOrCreateForName("MyProp");
        this.commit();
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            RawIterator stream = procs.procedureCallRead(procs.procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "propertyKeys"})).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).containsExactly((Object[])new AnyValue[][]{{Values.stringValue((String)"MyProp")}});
        }
    }

    @Test
    void listRelationshipTypes() throws Throwable {
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int relType = transaction.tokenWrite().relationshipTypeGetOrCreateForName("MyRelType");
        long startNodeId = transaction.dataWrite().nodeCreate();
        long endNodeId = transaction.dataWrite().nodeCreate();
        transaction.dataWrite().relationshipCreate(startNodeId, relType, endNodeId);
        this.commit();
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            RawIterator stream = procs.procedureCallRead(procs.procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "relationshipTypes"})).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).containsExactly((Object[])new AnyValue[][]{{Values.stringValue((String)"MyRelType")}});
        }
    }

    @Test
    void failWhenCallingNonExistingProcedures() {
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            org.junit.jupiter.api.Assertions.assertThrows(ProcedureException.class, () -> procs.procedureCallDbms(-1, new AnyValue[0], ProcedureCallContext.EMPTY));
        }
    }

    @Test
    void listAllComponents() throws Throwable {
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            RawIterator stream = procs.procedureCallRead(procs.procedureGet(ProcedureSignature.procedureName((String[])new String[]{"dbms", "components"})).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).containsExactly((Object[])new AnyValue[][]{{Values.stringValue((String)"Neo4j Kernel"), VirtualValues.list((AnyValue[])new AnyValue[]{Values.stringValue((String)Version.getNeo4jVersion())}), Values.stringValue((String)"community")}});
        }
        this.commit();
    }

    @Test
    void prepareForReplanningShouldEmptyQueryCache() {
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute("MATCH (n) RETURN n").close();
            transaction.commit();
        }
        CacheMetrics cacheMetrics = this.preParserCacheMetricsMonitor();
        long flushesBefore = cacheMetrics.getCacheFlushes();
        long discardsBefore = cacheMetrics.getDiscards();
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute("CALL db.prepareForReplanning()").close();
            transaction.commit();
        }
        Assertions.assertThat((long)(cacheMetrics.getCacheFlushes() - flushesBefore)).isEqualTo(1L);
        Assertions.assertThat((long)(cacheMetrics.getDiscards() - discardsBefore)).isEqualTo(2L);
    }

    @Test
    void prepareForReplanningShouldTriggerIndexesSampling() {
        IndexSamplingMonitor monitor = this.indexSamplingMonitor();
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute("CALL db.prepareForReplanning()").close();
            transaction.commit();
        }
        IndexSamplingMode mode = monitor.samplingMode();
        org.junit.jupiter.api.Assertions.assertNotEquals((long)0L, (long)mode.millisToWaitForCompletion());
        Assertions.assertThat((long)mode.millisToWaitForCompletion()).isGreaterThan(0L);
    }

    private IndexSamplingMonitor indexSamplingMonitor() {
        Monitors monitors = (Monitors)this.dependencyResolver.resolveDependency(Monitors.class);
        IndexSamplingMonitor monitorListener = new IndexSamplingMonitor();
        monitors.addMonitorListener((Object)monitorListener, new String[0]);
        return monitorListener;
    }

    private CacheMetrics preParserCacheMetricsMonitor() {
        QueryCacheStatistics statistics = (QueryCacheStatistics)this.dependencyResolver.resolveDependency(QueryCacheStatistics.class);
        return (CacheMetrics)statistics.metricsPerCacheKind().get(CypherQueryCaches.PreParserCache$.MODULE$.kind());
    }

    private static class IndexSamplingMonitor
    extends IndexMonitor.MonitorAdapter {
        private IndexSamplingMode samplingMode;

        private IndexSamplingMonitor() {
        }

        public void indexSamplingTriggered(IndexSamplingMode mode) {
            this.samplingMode = mode;
        }

        IndexSamplingMode samplingMode() {
            return this.samplingMode;
        }
    }
}

