/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.AnyTokens;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
@ExtendWith(value={SoftAssertionsExtension.class})
class IndexDefinitionToStringTest {
    @Inject
    private GraphDatabaseService db;
    @InjectSoftAssertions
    protected SoftAssertions softly;

    IndexDefinitionToStringTest() {
    }

    @BeforeEach
    void setup() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().getIndexes().forEach(IndexDefinition::drop);
            tx.commit();
        }
    }

    @Test
    void testToString() {
        try (Transaction tx = this.db.beginTx();){
            IndexDefinition labelTokenIndex = tx.schema().indexFor(AnyTokens.ANY_LABELS).withName("labelTokenIndex").create();
            IndexDefinition rangeLabelProperties = tx.schema().indexFor(Label.label((String)"someLabel")).on("someProperty").on("someOtherProperty").withName("rangeLabelIndexNames").create();
            IndexDefinition fulltextLabelProperty = tx.schema().indexFor(Label.label((String)"Label")).on("prop").withIndexType(IndexType.FULLTEXT).withName("fulltextLabelPropertyIndex").create();
            IndexDefinition fulltextLabelsProperties = tx.schema().indexFor(new Label[]{Label.label((String)"Label"), Label.label((String)"otherLabel")}).on("prop").on("otherProp").withIndexType(IndexType.FULLTEXT).withName("fulltextLabelPropertiesIndex").create();
            IndexDefinition textLabelProperty = tx.schema().indexFor(Label.label((String)"Label")).on("prop").withIndexType(IndexType.TEXT).withName("textLabelPropertyIndex").create();
            IndexDefinition pointLabelProperty = tx.schema().indexFor(Label.label((String)"Label")).on("prop").withIndexType(IndexType.POINT).withName("pointLabelPropertyIndex").create();
            IndexDefinition relTypeTokenIndex = tx.schema().indexFor(AnyTokens.ANY_RELATIONSHIP_TYPES).withName("relTypeTokenIndex").create();
            IndexDefinition rangeRelTypeProperties = tx.schema().indexFor(RelationshipType.withName((String)"someRelationship")).on("someProperty").on("someOtherProperty").withName("rangeRelTypeIndexNames").create();
            IndexDefinition fulltextRelTypeProperty = tx.schema().indexFor(RelationshipType.withName((String)"TYPE")).on("prop").withIndexType(IndexType.FULLTEXT).withName("fulltextRelTypePropertyIndex").create();
            IndexDefinition fulltextRelTypesProperties = tx.schema().indexFor(new RelationshipType[]{RelationshipType.withName((String)"TYPE"), RelationshipType.withName((String)"OTHER_TYPE")}).on("prop").on("otherProp").withIndexType(IndexType.FULLTEXT).withName("fulltextRelTypesPropertiesIndex").create();
            IndexDefinition textRelTypeProperty = tx.schema().indexFor(RelationshipType.withName((String)"TYPE")).on("prop").withIndexType(IndexType.TEXT).withName("textRelTypePropertyIndex").create();
            IndexDefinition pointRelTypeProperty = tx.schema().indexFor(RelationshipType.withName((String)"TYPE")).on("prop").withIndexType(IndexType.POINT).withName("pointRelTypePropertyIndex").create();
            this.assertIndexString(labelTokenIndex, "IndexDefinition[label:<any-labels>] (Index( id=%d, name='labelTokenIndex', type='LOOKUP', schema=(:<any-labels>), indexProvider='token-lookup-1.0' ))");
            this.assertIndexString(rangeLabelProperties, "IndexDefinition[label:someLabel on:someProperty,someOtherProperty] (Index( id=%d, name='rangeLabelIndexNames', type='RANGE', schema=(:someLabel {someProperty, someOtherProperty}), indexProvider='range-1.0' ))");
            this.assertIndexString(fulltextLabelProperty, "IndexDefinition[label:Label on:prop] (Index( id=%d, name='fulltextLabelPropertyIndex', type='FULLTEXT', schema=(:Label {prop}), indexProvider='fulltext-1.0' ))");
            this.assertIndexString(fulltextLabelsProperties, "IndexDefinition[labels:Label,otherLabel on:prop,otherProp] (Index( id=%d, name='fulltextLabelPropertiesIndex', type='FULLTEXT', schema=(:Label:otherLabel {prop, otherProp}), indexProvider='fulltext-1.0' ))");
            this.assertIndexString(textLabelProperty, "IndexDefinition[label:Label on:prop] (Index( id=%d, name='textLabelPropertyIndex', type='TEXT', schema=(:Label {prop}), indexProvider='text-2.0' ))");
            this.assertIndexString(pointLabelProperty, "IndexDefinition[label:Label on:prop] (Index( id=%d, name='pointLabelPropertyIndex', type='POINT', schema=(:Label {prop}), indexProvider='point-1.0' ))");
            this.assertIndexString(relTypeTokenIndex, "IndexDefinition[relationship type:<any-types>] (Index( id=%d, name='relTypeTokenIndex', type='LOOKUP', schema=()-[:<any-types>]-(), indexProvider='token-lookup-1.0' ))");
            this.assertIndexString(rangeRelTypeProperties, "IndexDefinition[relationship type:someRelationship on:someProperty,someOtherProperty] (Index( id=%d, name='rangeRelTypeIndexNames', type='RANGE', schema=()-[:someRelationship {someProperty, someOtherProperty}]-(), indexProvider='range-1.0' ))");
            this.assertIndexString(fulltextRelTypeProperty, "IndexDefinition[relationship type:TYPE on:prop] (Index( id=%d, name='fulltextRelTypePropertyIndex', type='FULLTEXT', schema=()-[:TYPE {prop}]-(), indexProvider='fulltext-1.0' ))");
            this.assertIndexString(fulltextRelTypesProperties, "IndexDefinition[relationship types:TYPE,OTHER_TYPE on:prop,otherProp] (Index( id=%d, name='fulltextRelTypesPropertiesIndex', type='FULLTEXT', schema=()-[:TYPE:OTHER_TYPE {prop, otherProp}]-(), indexProvider='fulltext-1.0' ))");
            this.assertIndexString(textRelTypeProperty, "IndexDefinition[relationship type:TYPE on:prop] (Index( id=%d, name='textRelTypePropertyIndex', type='TEXT', schema=()-[:TYPE {prop}]-(), indexProvider='text-2.0' ))");
            this.assertIndexString(pointRelTypeProperty, "IndexDefinition[relationship type:TYPE on:prop] (Index( id=%d, name='pointRelTypePropertyIndex', type='POINT', schema=()-[:TYPE {prop}]-(), indexProvider='point-1.0' ))");
        }
    }

    private void assertIndexString(IndexDefinition index, String expectedStringFormat) {
        this.softly.assertThat(index.toString()).isEqualTo(expectedStringFormat, new Object[]{((IndexDefinitionImpl)index).getIndexReference().getId()});
    }
}

