/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeIndexCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.PartitionedScan;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestSupport;
import org.neo4j.kernel.impl.newapi.TestUtils;
import org.neo4j.util.concurrent.Futures;

public abstract class ParallelPartitionedNodeLabelScanCursorTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static final int NUMBER_OF_NODES = 1000;
    private static int FOO_LABEL;
    private static int BAR_LABEL;
    private static LongSet FOO_NODES;
    private static LongSet BAR_NODES;

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        MutableLongSet fooNodes = LongSets.mutable.empty();
        MutableLongSet barNodes = LongSets.mutable.empty();
        try (KernelTransaction tx = this.beginTransaction();){
            TokenWrite tokenWrite = tx.tokenWrite();
            FOO_LABEL = tokenWrite.labelGetOrCreateForName("foo");
            BAR_LABEL = tokenWrite.labelGetOrCreateForName("bar");
            Write write = tx.dataWrite();
            for (int i = 0; i < 1000; ++i) {
                long node = write.nodeCreate();
                if (i % 2 == 0) {
                    write.nodeAddLabel(node, FOO_LABEL);
                    fooNodes.add(node);
                    continue;
                }
                write.nodeAddLabel(node, BAR_LABEL);
                barNodes.add(node);
            }
            FOO_NODES = fooNodes;
            BAR_NODES = barNodes;
            tx.commit();
        }
        catch (KernelException e) {
            throw new AssertionError((Object)e);
        }
    }

    @ParameterizedTest
    @EnumSource(value=TestUtils.PartitionedScanAPI.class)
    void shouldScanASubsetOfFooNodes(TestUtils.PartitionedScanAPI api) throws KernelException {
        try (Statement statement = this.tx.acquireStatement();
             ExecutionContext executionContext = this.tx.createExecutionContext();
             NodeLabelIndexCursor nodes = this.cursors.allocateNodeLabelIndexCursor(CursorContext.NULL_CONTEXT);){
            TokenReadSession tokenReadSession = this.read.tokenReadSession((IndexDescriptor)this.tx.schemaRead().index((SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.NODE)).next());
            PartitionedScan scan = this.read.nodeLabelScan(tokenReadSession, 32, CursorContext.NULL_CONTEXT, new TokenPredicate(FOO_LABEL));
            Assertions.assertThat((boolean)api.reservePartition(scan, nodes, this.tx, executionContext)).isTrue();
            while (nodes.next()) {
                Assertions.assertThat((boolean)FOO_NODES.contains(nodes.nodeReference())).isTrue();
            }
            executionContext.complete();
        }
    }

    @ParameterizedTest
    @EnumSource(value=TestUtils.PartitionedScanAPI.class)
    void shouldHandleSinglePartition(TestUtils.PartitionedScanAPI api) throws KernelException {
        try (Statement statement = this.tx.acquireStatement();
             ExecutionContext executionContext = this.tx.createExecutionContext();
             NodeLabelIndexCursor nodes = this.cursors.allocateNodeLabelIndexCursor(CursorContext.NULL_CONTEXT);){
            TokenReadSession tokenReadSession = this.read.tokenReadSession((IndexDescriptor)this.tx.schemaRead().index((SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.NODE)).next());
            PartitionedScan scan = this.read.nodeLabelScan(tokenReadSession, 1, CursorContext.NULL_CONTEXT, new TokenPredicate(FOO_LABEL));
            Assertions.assertThat((boolean)api.reservePartition(scan, nodes, this.tx, executionContext)).isTrue();
            LongArrayList ids = new LongArrayList();
            while (nodes.next()) {
                ids.add(nodes.nodeReference());
            }
            Assertions.assertThat((boolean)FOO_NODES.containsAll((LongIterable)ids)).isTrue();
            Assertions.assertThat((boolean)BAR_NODES.containsNone((LongIterable)ids)).isTrue();
            executionContext.complete();
        }
    }

    @Test
    void shouldFailOnZeroPartitions() throws KernelException {
        try (Statement statement = this.tx.acquireStatement();
             ExecutionContext executionContext = this.tx.createExecutionContext();){
            TokenReadSession tokenReadSession = this.read.tokenReadSession((IndexDescriptor)this.tx.schemaRead().index((SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.NODE)).next());
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.read.nodeLabelScan(tokenReadSession, 0, CursorContext.NULL_CONTEXT, new TokenPredicate(FOO_LABEL)));
            executionContext.complete();
        }
    }

    @ParameterizedTest
    @EnumSource(value=TestUtils.PartitionedScanAPI.class)
    void shouldScanFooNodesInBatchesWithGetNumberOfPartitions(TestUtils.PartitionedScanAPI api) throws KernelException {
        TokenReadSession tokenReadSession = this.read.tokenReadSession((IndexDescriptor)this.tx.schemaRead().index((SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.NODE)).next());
        PartitionedScan scan = this.read.nodeLabelScan(tokenReadSession, 32, CursorContext.NULL_CONTEXT, new TokenPredicate(FOO_LABEL));
        LongArrayList ids = new LongArrayList();
        for (int i = 0; i < scan.getNumberOfPartitions(); ++i) {
            try (Statement statement = this.tx.acquireStatement();
                 ExecutionContext executionContext = this.tx.createExecutionContext();
                 NodeLabelIndexCursor nodes = this.cursors.allocateNodeLabelIndexCursor(CursorContext.NULL_CONTEXT);){
                api.reservePartition(scan, nodes, this.tx, executionContext);
                while (nodes.next()) {
                    ids.add(nodes.nodeReference());
                }
                executionContext.complete();
                continue;
            }
        }
        Assertions.assertThat((int)ids.size()).isEqualTo(FOO_NODES.size());
        Assertions.assertThat((boolean)ids.containsAll((LongIterable)FOO_NODES)).isTrue();
        Assertions.assertThat((boolean)ids.containsNone((LongIterable)BAR_NODES)).isTrue();
    }

    @ParameterizedTest
    @EnumSource(value=TestUtils.PartitionedScanAPI.class)
    void shouldScanFooNodesInBatchesWithoutGetNumberOfPartitions(TestUtils.PartitionedScanAPI api) throws KernelException {
        TokenReadSession tokenReadSession = this.read.tokenReadSession((IndexDescriptor)this.tx.schemaRead().index((SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.NODE)).next());
        PartitionedScan scan = this.read.nodeLabelScan(tokenReadSession, 32, CursorContext.NULL_CONTEXT, new TokenPredicate(FOO_LABEL));
        LongArrayList ids = new LongArrayList();
        try (Statement statement = this.tx.acquireStatement();
             ExecutionContext executionContext = this.tx.createExecutionContext();
             NodeLabelIndexCursor nodes = this.cursors.allocateNodeLabelIndexCursor(CursorContext.NULL_CONTEXT);){
            while (api.reservePartition(scan, nodes, this.tx, executionContext)) {
                while (nodes.next()) {
                    ids.add(nodes.nodeReference());
                }
            }
            executionContext.complete();
        }
        Assertions.assertThat((int)ids.size()).isEqualTo(FOO_NODES.size());
        Assertions.assertThat((boolean)ids.containsAll((LongIterable)FOO_NODES)).isTrue();
        Assertions.assertThat((boolean)ids.containsNone((LongIterable)BAR_NODES)).isTrue();
    }

    @ParameterizedTest
    @EnumSource(value=TestUtils.PartitionedScanAPI.class)
    void shouldHandleMorePartitionsThanNodes(TestUtils.PartitionedScanAPI api) throws KernelException {
        TokenReadSession tokenReadSession = this.read.tokenReadSession((IndexDescriptor)this.tx.schemaRead().index((SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.NODE)).next());
        PartitionedScan scan = this.read.nodeLabelScan(tokenReadSession, 2000, CursorContext.NULL_CONTEXT, new TokenPredicate(FOO_LABEL));
        LongArrayList ids = new LongArrayList();
        for (int i = 0; i < scan.getNumberOfPartitions(); ++i) {
            try (Statement statement = this.tx.acquireStatement();
                 ExecutionContext executionContext = this.tx.createExecutionContext();
                 NodeLabelIndexCursor nodes = this.cursors.allocateNodeLabelIndexCursor(CursorContext.NULL_CONTEXT);){
                api.reservePartition(scan, nodes, this.tx, executionContext);
                while (nodes.next()) {
                    ids.add(nodes.nodeReference());
                }
                executionContext.complete();
                continue;
            }
        }
        Assertions.assertThat((int)ids.size()).isEqualTo(FOO_NODES.size());
        Assertions.assertThat((boolean)ids.containsAll((LongIterable)FOO_NODES)).isTrue();
        Assertions.assertThat((boolean)ids.containsNone((LongIterable)BAR_NODES)).isTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanFooNodesFromMultipleThreads() throws InterruptedException, ExecutionException, KernelException {
        TokenReadSession tokenReadSession = this.read.tokenReadSession((IndexDescriptor)this.tx.schemaRead().index((SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.NODE)).next());
        PartitionedScan scan = this.read.nodeLabelScan(tokenReadSession, 32, CursorContext.NULL_CONTEXT, new TokenPredicate(FOO_LABEL));
        ExecutorService service = Executors.newFixedThreadPool(scan.getNumberOfPartitions());
        CursorFactory cursors = this.testSupport.kernelToTest().cursors();
        try {
            List workerContexts = TestUtils.createContexts(this.tx, arg_0 -> ((CursorFactory)cursors).allocateNodeLabelIndexCursor(arg_0), scan.getNumberOfPartitions());
            List<Future<LongList>> futures = service.invokeAll(TestUtils.createWorkers(scan, workerContexts, NodeIndexCursor::nodeReference));
            List ids = Futures.getAllResults(futures);
            TestUtils.closeWorkContexts(workerContexts);
            TestUtils.assertDistinct(ids);
            Assertions.assertThat((boolean)FOO_NODES.containsAll((LongIterable)TestUtils.concat(ids))).isTrue();
        }
        finally {
            service.shutdown();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)service.awaitTermination(1L, TimeUnit.MINUTES));
        }
    }

    @ParameterizedTest
    @EnumSource(value=TestUtils.PartitionedScanAPI.class)
    void shouldBeReadCommitted(TestUtils.PartitionedScanAPI api) throws ExecutionException, InterruptedException, TimeoutException, KernelException {
        LongHashSet ids = new LongHashSet();
        TokenReadSession tokenReadSession = this.read.tokenReadSession((IndexDescriptor)this.tx.schemaRead().index((SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.NODE)).next());
        PartitionedScan scan = this.read.nodeLabelScan(tokenReadSession, 32, CursorContext.NULL_CONTEXT, new TokenPredicate(FOO_LABEL));
        LongList newFooNodes = this.createNodesInSeparateTransaction(5, FOO_LABEL);
        LongList newBarNodes = this.createNodesInSeparateTransaction(5, BAR_LABEL);
        for (int i = 0; i < scan.getNumberOfPartitions(); ++i) {
            try (Statement statement = this.tx.acquireStatement();
                 ExecutionContext executionContext = this.tx.createExecutionContext();
                 NodeLabelIndexCursor nodes = this.cursors.allocateNodeLabelIndexCursor(CursorContext.NULL_CONTEXT);){
                api.reservePartition(scan, nodes, this.tx, executionContext);
                while (nodes.next()) {
                    ids.add(nodes.nodeReference());
                }
                executionContext.complete();
                continue;
            }
        }
        Assertions.assertThat((boolean)ids.containsAll((LongIterable)newFooNodes)).isTrue();
        Assertions.assertThat((boolean)ids.containsNone((LongIterable)newBarNodes)).isTrue();
        newFooNodes.forEach((LongProcedure & Serializable)newNode -> {
            try {
                this.tx.dataWrite().nodeDelete(newNode);
            }
            catch (InvalidTransactionTypeKernelException e) {
                throw new AssertionError((Object)e);
            }
        });
        newBarNodes.forEach((LongProcedure & Serializable)newNode -> {
            try {
                this.tx.dataWrite().nodeDelete(newNode);
            }
            catch (InvalidTransactionTypeKernelException e) {
                throw new AssertionError((Object)e);
            }
        });
    }

    private LongList createNodesInSeparateTransaction(int numberOfNodesToCreate, int label) throws ExecutionException, InterruptedException, TimeoutException {
        ExecutorService service = Executors.newSingleThreadExecutor();
        Future<LongList> futureList = service.submit(() -> {
            LongArrayList newNodes = new LongArrayList(numberOfNodesToCreate);
            try (KernelTransaction tx = this.testSupport.kernelToTest().beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);){
                for (int i = 0; i < numberOfNodesToCreate; ++i) {
                    long newNode = tx.dataWrite().nodeCreate();
                    tx.dataWrite().nodeAddLabel(newNode, label);
                    newNodes.add(newNode);
                }
                tx.commit();
            }
            return newNodes;
        });
        return futureList.get(1L, TimeUnit.MINUTES);
    }
}

