/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.SchemaReadCore;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.internal.schema.constraints.SchemaValueType;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public abstract class SchemaReadWriteTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    private int label;
    private int label2;
    private int type;
    private int prop1;
    private int prop2;
    private int prop3;

    @BeforeEach
    void setUp() throws Exception {
        try (KernelTransaction transaction = this.beginTransaction();){
            SchemaRead schemaRead = transaction.schemaRead();
            SchemaWrite schemaWrite = transaction.schemaWrite();
            Iterator constraints = schemaRead.constraintsGetAll();
            while (constraints.hasNext()) {
                schemaWrite.constraintDrop((ConstraintDescriptor)constraints.next());
            }
            Iterator indexes = schemaRead.indexesGetAll();
            while (indexes.hasNext()) {
                schemaWrite.indexDrop((IndexDescriptor)indexes.next());
            }
            TokenWrite tokenWrite = transaction.tokenWrite();
            this.label = tokenWrite.labelGetOrCreateForName("label");
            this.label2 = tokenWrite.labelGetOrCreateForName("label2");
            this.type = tokenWrite.relationshipTypeGetOrCreateForName("relationship");
            this.prop1 = tokenWrite.propertyKeyGetOrCreateForName("prop1");
            this.prop2 = tokenWrite.propertyKeyGetOrCreateForName("prop2");
            this.prop3 = tokenWrite.propertyKeyGetOrCreateForName("prop3");
            transaction.commit();
        }
    }

    @Test
    void shouldNotFindNonExistentIndex() throws Exception {
        try (KernelTransaction transaction = this.beginTransaction();){
            SchemaRead schemaRead = transaction.schemaRead();
            Assertions.assertThat((Iterator)schemaRead.index((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1}))).isExhausted();
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexType.class)
    void shouldNotFindNonExistentIndexWithType(IndexType type) throws Exception {
        try (KernelTransaction transaction = this.beginTransaction();){
            SchemaRead schemaRead = transaction.schemaRead();
            Assertions.assertThat((Object)schemaRead.index((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1}), type)).isEqualTo((Object)IndexDescriptor.NO_INDEX);
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexType.class, names={"RANGE", "TEXT", "POINT"})
    void shouldCreateIndex(IndexType type) throws Exception {
        IndexDescriptor index;
        try (KernelTransaction transaction = this.beginTransaction();){
            index = transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).withIndexType(type).withName("my index"));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            Assertions.assertThat((Object)((IndexDescriptor)Iterators.single((Iterator)schemaRead.index((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1}))))).isEqualTo((Object)index);
            Assertions.assertThat((Object)schemaRead.index((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1}), type)).isEqualTo((Object)index);
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void createdIndexShouldPopulateInTx() throws Exception {
        try (KernelTransaction tx = this.beginTransaction();){
            SchemaReadCore before = tx.schemaRead().snapshot();
            IndexDescriptor index = tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("my index"));
            Assertions.assertThat((Comparable)tx.schemaRead().indexGetState(index)).isEqualTo((Object)InternalIndexState.POPULATING);
            Assertions.assertThat((Comparable)tx.schemaRead().snapshot().indexGetState(index)).isEqualTo((Object)InternalIndexState.POPULATING);
            Assertions.assertThat((Comparable)before.indexGetState(index)).isEqualTo((Object)InternalIndexState.POPULATING);
            tx.commit();
        }
    }

    @Test
    void shouldGetIndexStateNonLocking() throws Exception {
        IndexDescriptor index;
        SchemaReadCore before;
        try (KernelTransaction tx = this.beginTransaction();){
            before = tx.schemaRead().snapshot();
            index = tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("my index"));
            Assertions.assertThat((Comparable)tx.schemaRead().indexGetStateNonLocking(index)).isEqualTo((Object)InternalIndexState.POPULATING);
            Assertions.assertThat((Comparable)tx.schemaRead().snapshot().indexGetStateNonLocking(index)).isEqualTo((Object)InternalIndexState.POPULATING);
            Assertions.assertThat((Comparable)before.indexGetStateNonLocking(index)).isEqualTo((Object)InternalIndexState.POPULATING);
            org.junit.jupiter.api.Assertions.assertNotEquals((long)((KernelTransactionImplementation)tx).lockClient().activeLockCount(), (long)0L);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            before = tx.schemaRead().snapshot();
            Assertions.assertThat((Comparable)tx.schemaRead().indexGetStateNonLocking(index)).isNotEqualTo((Object)InternalIndexState.FAILED);
            Assertions.assertThat((Comparable)tx.schemaRead().snapshot().indexGetStateNonLocking(index)).isNotEqualTo((Object)InternalIndexState.FAILED);
            Assertions.assertThat((Comparable)before.indexGetStateNonLocking(index)).isNotEqualTo((Object)InternalIndexState.FAILED);
            org.junit.jupiter.api.Assertions.assertEquals((long)((KernelTransactionImplementation)tx).lockClient().activeLockCount(), (long)0L);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexType.class, names={"RANGE", "TEXT", "POINT"})
    void shouldDropIndex(IndexType type) throws Exception {
        IndexDescriptor index;
        try (KernelTransaction transaction = this.beginTransaction();){
            index = transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).withIndexType(type).withName("my index"));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            transaction.schemaWrite().indexDrop(index);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)schemaRead.index((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).hasNext());
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexType.class, names={"RANGE", "TEXT", "POINT"})
    void shouldDropIndexByName(IndexType type) throws Exception {
        String indexName = "My fancy index";
        try (KernelTransaction transaction = this.beginTransaction();){
            transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).withIndexType(type).withName(indexName));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            transaction.schemaWrite().indexDrop(indexName);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)schemaRead.index((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).hasNext());
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldFailToDropNoIndex() throws Exception {
        try (KernelTransaction transaction = this.beginTransaction();){
            org.junit.jupiter.api.Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().indexDrop(IndexDescriptor.NO_INDEX));
            transaction.commit();
        }
    }

    @Test
    void shouldFailToDropNonExistentIndex() throws Exception {
        IndexDescriptor index;
        try (KernelTransaction transaction = this.beginTransaction();){
            index = transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("my index"));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            transaction.schemaWrite().indexDrop(index);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().indexDrop(index));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldFailToDropNonExistentIndexByName() throws Exception {
        String indexName = "My fancy index";
        try (KernelTransaction transaction = this.beginTransaction();){
            transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName(indexName));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            transaction.schemaWrite().indexDrop(indexName);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().indexDrop(indexName));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexType.class, names={"RANGE", "TEXT", "POINT"})
    void shouldFailIfExistingIndex(IndexType type) throws Exception {
        try (KernelTransaction transaction = this.beginTransaction();){
            transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).withIndexType(type).withName("my index"));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).withIndexType(type).withName("my other index")));
            org.junit.jupiter.api.Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop2})).withIndexType(type).withName("my index")));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldSeeIndexFromTransaction() throws Exception {
        try (KernelTransaction transaction = this.beginTransaction();){
            transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("my index"));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop2});
            IndexDescriptor otherIndex = transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)schema).withName("my other index"));
            SchemaRead schemaRead = transaction.schemaRead();
            IndexDescriptor index = (IndexDescriptor)Iterators.single((Iterator)schemaRead.index((SchemaDescriptor)schema));
            Assertions.assertThat((Object)index).isEqualTo((Object)otherIndex);
            IndexDescriptor indexByType = schemaRead.index((SchemaDescriptor)schema, IndexType.RANGE);
            Assertions.assertThat((Object)indexByType).isEqualTo((Object)otherIndex);
            Assertions.assertThat((int)2).isEqualTo(Iterators.asList((Iterator)schemaRead.indexesGetAll()).size());
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldSeeIndexFromTransactionInSnapshot() throws Exception {
        try (KernelTransaction transaction = this.beginTransaction();){
            transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("my index 1"));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop2});
            SchemaReadCore schemaReadBefore = transaction.schemaRead().snapshot();
            IndexDescriptor createdIndex = transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)schema).withName("my index 2"));
            SchemaReadCore schemaReadAfter = transaction.schemaRead().snapshot();
            IndexDescriptor index = (IndexDescriptor)Iterators.single((Iterator)schemaReadBefore.index((SchemaDescriptor)schema));
            Assertions.assertThat((Object)index).isEqualTo((Object)createdIndex);
            IndexDescriptor indexByType = schemaReadBefore.index((SchemaDescriptor)schema, IndexType.RANGE);
            Assertions.assertThat((Object)indexByType).isEqualTo((Object)createdIndex);
            Assertions.assertThat((Object)schemaReadBefore.indexGetForName("my index 2")).isEqualTo((Object)createdIndex);
            Assertions.assertThat((int)2).isEqualTo(Iterators.asList((Iterator)schemaReadBefore.indexesGetAll()).size());
            index = (IndexDescriptor)Iterators.single((Iterator)schemaReadAfter.index((SchemaDescriptor)schema));
            Assertions.assertThat((Object)index).isEqualTo((Object)createdIndex);
            indexByType = schemaReadAfter.index((SchemaDescriptor)schema, IndexType.RANGE);
            Assertions.assertThat((Object)indexByType).isEqualTo((Object)createdIndex);
            Assertions.assertThat((Object)schemaReadAfter.indexGetForName("my index 2")).isEqualTo((Object)createdIndex);
            Assertions.assertThat((int)2).isEqualTo(Iterators.asList((Iterator)schemaReadAfter.indexesGetAll()).size());
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldNotSeeDroppedIndexFromTransaction() throws Exception {
        IndexDescriptor index;
        try (KernelTransaction transaction = this.beginTransaction();){
            index = transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("my index"));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            transaction.schemaWrite().indexDrop(index);
            SchemaRead schemaRead = transaction.schemaRead();
            Assertions.assertThat((Iterator)schemaRead.index(index.schema())).isExhausted();
            Assertions.assertThat((Object)schemaRead.index(index.schema(), index.getIndexType())).isEqualTo((Object)IndexDescriptor.NO_INDEX);
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldNotSeeDroppedIndexFromTransactionInSnapshot() throws Exception {
        IndexDescriptor index;
        try (KernelTransaction transaction = this.beginTransaction();){
            index = transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("my index"));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaReadCore schemaReadBefore = transaction.schemaRead().snapshot();
            transaction.schemaWrite().indexDrop(index);
            SchemaReadCore schemaReadAfter = transaction.schemaRead().snapshot();
            Assertions.assertThat((Iterator)schemaReadBefore.index(index.schema())).isExhausted();
            Assertions.assertThat((Object)schemaReadBefore.index(index.schema(), index.getIndexType())).isEqualTo((Object)IndexDescriptor.NO_INDEX);
            Assertions.assertThat((Object)schemaReadBefore.indexGetForName("my index")).isEqualTo((Object)IndexDescriptor.NO_INDEX);
            Assertions.assertThat((Iterator)schemaReadAfter.index(index.schema())).isExhausted();
            Assertions.assertThat((Object)schemaReadAfter.index(index.schema(), index.getIndexType())).isEqualTo((Object)IndexDescriptor.NO_INDEX);
            Assertions.assertThat((Object)schemaReadAfter.indexGetForName("my index")).isEqualTo((Object)IndexDescriptor.NO_INDEX);
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldListAllIndexes() throws Exception {
        IndexDescriptor toDrop;
        IndexDescriptor toRetain2;
        IndexDescriptor toRetain;
        try (KernelTransaction tx = this.beginTransaction();){
            toRetain = tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("a"));
            toRetain2 = tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label2, (int[])new int[]{this.prop1})).withName("b"));
            toDrop = tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop2})).withName("c"));
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            IndexDescriptor created = tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label2, (int[])new int[]{this.prop2})).withName("d"));
            tx.schemaWrite().indexDrop(toDrop);
            Iterable allIndexes = () -> tx.schemaRead().indexesGetAll();
            Assertions.assertThat(allIndexes).contains((Object[])new IndexDescriptor[]{toRetain, toRetain2, created});
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldListAllIndexesInSnapshot() throws Exception {
        IndexDescriptor toDrop;
        IndexDescriptor toRetain2;
        IndexDescriptor toRetain;
        try (KernelTransaction tx = this.beginTransaction();){
            toRetain = tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("a"));
            toRetain2 = tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label2, (int[])new int[]{this.prop1})).withName("b"));
            toDrop = tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop2})).withName("c"));
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            SchemaReadCore before = tx.schemaRead().snapshot();
            IndexDescriptor created = tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label2, (int[])new int[]{this.prop2})).withName("d"));
            tx.schemaWrite().indexDrop(toDrop);
            SchemaReadCore after = tx.schemaRead().snapshot();
            Assertions.assertThat((Iterator)before.indexesGetAll()).toIterable().contains((Object[])new IndexDescriptor[]{toRetain, toRetain2, created});
            Assertions.assertThat((Iterator)after.indexesGetAll()).toIterable().contains((Object[])new IndexDescriptor[]{toRetain, toRetain2, created});
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldListIndexesByLabel() throws Exception {
        IndexDescriptor droppedInTx;
        IndexDescriptor inStore;
        int wrongLabel;
        try (KernelTransaction tx = this.beginTransaction();){
            wrongLabel = tx.tokenWrite().labelGetOrCreateForName("wrongLabel");
            tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)wrongLabel, (int[])new int[]{this.prop1})));
            inStore = tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("a"));
            droppedInTx = tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop2})).withName("b"));
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            IndexDescriptor createdInTx = tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop3})).withName("c"));
            tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)wrongLabel, (int[])new int[]{this.prop2})).withName("d"));
            tx.schemaWrite().indexDrop(droppedInTx);
            Iterable indexes = () -> tx.schemaRead().indexesGetForLabel(this.label);
            Assertions.assertThat(indexes).contains((Object[])new IndexDescriptor[]{inStore, createdInTx});
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldListIndexesByLabelNonLocking() throws Exception {
        Iterable indexesBySchema;
        Iterable labelIndexes;
        IndexDescriptor createdInTx;
        IndexDescriptor droppedInTx;
        IndexDescriptor inStore;
        try (KernelTransaction tx = this.beginTransaction();){
            inStore = tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("a"));
            droppedInTx = tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop2})).withName("b"));
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            createdInTx = tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop3})).withName("c"));
            tx.schemaWrite().indexDrop(droppedInTx);
            labelIndexes = () -> tx.schemaRead().getLabelIndexesNonLocking(this.label);
            indexesBySchema = () -> tx.schemaRead().indexForSchemaNonLocking(createdInTx.schema());
            Assertions.assertThat(labelIndexes).contains((Object[])new IndexDescriptor[]{inStore, createdInTx});
            Assertions.assertThat(indexesBySchema).contains((Object[])new IndexDescriptor[]{createdInTx});
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.beginTransaction();
        try {
            labelIndexes = () -> tx.schemaRead().getLabelIndexesNonLocking(this.label);
            indexesBySchema = () -> tx.schemaRead().indexForSchemaNonLocking(createdInTx.schema());
            Assertions.assertThat(labelIndexes).contains((Object[])new IndexDescriptor[]{inStore, createdInTx});
            Assertions.assertThat(indexesBySchema).contains((Object[])new IndexDescriptor[]{createdInTx});
            org.junit.jupiter.api.Assertions.assertEquals((long)((KernelTransactionImplementation)tx).lockClient().activeLockCount(), (long)0L);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldListIndexesByLabelInSnapshot() throws Exception {
        IndexDescriptor droppedInTx;
        IndexDescriptor inStore;
        int wrongLabel;
        try (KernelTransaction tx = this.beginTransaction();){
            wrongLabel = tx.tokenWrite().labelGetOrCreateForName("wrongLabel");
            tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)wrongLabel, (int[])new int[]{this.prop1})));
            inStore = tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("a"));
            droppedInTx = tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop2})).withName("b"));
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            SchemaReadCore before = tx.schemaRead().snapshot();
            IndexDescriptor createdInTx = tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop3})).withName("c"));
            tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)wrongLabel, (int[])new int[]{this.prop2})).withName("d"));
            tx.schemaWrite().indexDrop(droppedInTx);
            Iterable indexes = () -> tx.schemaRead().snapshot().indexesGetForLabel(this.label);
            Assertions.assertThat(indexes).contains((Object[])new IndexDescriptor[]{inStore, createdInTx});
            Assertions.assertThat((Iterator)before.indexesGetForLabel(this.label)).toIterable().contains((Object[])new IndexDescriptor[]{inStore, createdInTx});
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldListIndexesByRelationshipTypeNonLocking() throws Exception {
        Iterable indexes;
        IndexDescriptor createdInTx;
        IndexDescriptor droppedInTx;
        IndexDescriptor inStore;
        try (KernelTransaction tx = this.beginTransaction();){
            inStore = tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forRelType((int)this.type, (int[])new int[]{this.prop1})).withName("a"));
            droppedInTx = tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forRelType((int)this.type, (int[])new int[]{this.prop2})).withName("b"));
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            createdInTx = tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forRelType((int)this.type, (int[])new int[]{this.prop3})).withName("c"));
            tx.schemaWrite().indexDrop(droppedInTx);
            indexes = () -> tx.schemaRead().getRelTypeIndexesNonLocking(this.type);
            Assertions.assertThat(indexes).contains((Object[])new IndexDescriptor[]{inStore, createdInTx});
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.beginTransaction();
        try {
            indexes = () -> tx.schemaRead().getRelTypeIndexesNonLocking(this.type);
            Assertions.assertThat(indexes).contains((Object[])new IndexDescriptor[]{inStore, createdInTx});
            org.junit.jupiter.api.Assertions.assertEquals((long)((KernelTransactionImplementation)tx).lockClient().activeLockCount(), (long)0L);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldCreateUniquePropertyConstraint(EntityType entityType) throws Exception {
        ConstraintDescriptor constraint;
        int entityToken = entityType.selectEntityToken(this.label, this.type);
        try (KernelTransaction transaction = this.beginTransaction();){
            constraint = transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)entityType.createSchemaDescriptor(entityToken, this.prop1)));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)schemaRead.constraintExists(constraint));
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken((SchemaReadCore)schemaRead, entityToken))).isEqualTo(Collections.singletonList(constraint));
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken(schemaRead.snapshot(), entityToken))).isEqualTo(Collections.singletonList(constraint));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldDropUniquePropertyConstraint(EntityType entityType) throws Exception {
        ConstraintDescriptor constraint;
        int entityToken = entityType.selectEntityToken(this.label, this.type);
        try (KernelTransaction transaction = this.beginTransaction();){
            constraint = transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)entityType.createSchemaDescriptor(entityToken, this.prop1)));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            transaction.schemaWrite().constraintDrop(constraint);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)schemaRead.constraintExists(constraint));
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken((SchemaReadCore)schemaRead, entityToken))).isEmpty();
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken(schemaRead.snapshot(), entityToken))).isEmpty();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldDropConstraintByName() throws Exception {
        ConstraintDescriptor constraint;
        String constraintName = "my constraint";
        try (KernelTransaction transaction = this.beginTransaction();){
            constraint = transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName(constraintName));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            transaction.schemaWrite().constraintDrop(constraintName);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)schemaRead.constraintExists(constraint));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldFailToCreateUniqueConstraintIfExistingIndex(EntityType entityType) throws Exception {
        int entityToken = entityType.selectEntityToken(this.label, this.type);
        try (KernelTransaction transaction = this.beginTransaction();){
            transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)entityType.createSchemaDescriptor(entityToken, this.prop1)).withName("my index"));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)entityType.createSchemaDescriptor(entityToken, this.prop1)).withName("constraint name")));
            org.junit.jupiter.api.Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)entityType.createSchemaDescriptor(entityToken, this.prop2)).withName("my index")));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldFailToCreateIndexIfExistingUniqueConstraint(EntityType entityType) throws Exception {
        int entityToken = entityType.selectEntityToken(this.label, this.type);
        try (KernelTransaction transaction = this.beginTransaction();){
            transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)entityType.createSchemaDescriptor(entityToken, this.prop1)).withName("constraint name"));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)entityType.createSchemaDescriptor(entityToken, this.prop1)).withName("my index")));
            org.junit.jupiter.api.Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)entityType.createSchemaDescriptor(entityToken, this.prop2)).withName("constraint name")));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldFailToDropIndexIfExistingUniqueConstraint(EntityType entityType) throws Exception {
        int entityToken = entityType.selectEntityToken(this.label, this.type);
        String schemaName = "constraint name";
        try (KernelTransaction transaction = this.beginTransaction();){
            transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)entityType.createSchemaDescriptor(entityToken, this.prop1)).withName(schemaName));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            IndexDescriptor index = transaction.schemaRead().indexGetForName(schemaName);
            org.junit.jupiter.api.Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().indexDrop(index));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldFailToDropIndexByNameIfExistingUniqueConstraint(EntityType entityType) throws Exception {
        int entityToken = entityType.selectEntityToken(this.label, this.type);
        String schemaName = "constraint name";
        try (KernelTransaction transaction = this.beginTransaction();){
            transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)entityType.createSchemaDescriptor(entityToken, this.prop1)).withName(schemaName));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().indexDrop(schemaName));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldFailToCreateUniqueConstraintIfConstraintNotSatisfied(EntityType entityType) throws Exception {
        int entityToken = entityType.selectEntityToken(this.label, this.type);
        try (KernelTransaction transaction = this.beginTransaction();){
            entityType.createDataInconsistentWithConstraintOnSchema(transaction, entityToken, this.prop1);
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)entityType.createSchemaDescriptor(entityToken, this.prop1))));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldSeeUniqueConstraintFromTransaction(EntityType entityType) throws Exception {
        ConstraintDescriptor existing;
        int entityToken = entityType.selectEntityToken(this.label, this.type);
        try (KernelTransaction transaction = this.beginTransaction();){
            existing = transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)entityType.createSchemaDescriptor(entityToken, this.prop1)).withName("existing constraint"));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaReadCore before = transaction.schemaRead().snapshot();
            ConstraintDescriptor newConstraint = transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)entityType.createSchemaDescriptor(entityToken, this.prop2)).withName("new constraint"));
            SchemaRead schemaRead = transaction.schemaRead();
            SchemaReadCore after = schemaRead.snapshot();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)schemaRead.constraintExists(existing));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)schemaRead.constraintExists(newConstraint));
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken((SchemaReadCore)schemaRead, entityToken))).contains((Object[])new ConstraintDescriptor[]{existing, newConstraint});
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken(before, entityToken))).contains((Object[])new ConstraintDescriptor[]{existing, newConstraint});
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken(after, entityToken))).contains((Object[])new ConstraintDescriptor[]{existing, newConstraint});
            Assertions.assertThat((Object)before.constraintGetForName("existing constraint")).isEqualTo((Object)existing);
            Assertions.assertThat((Object)after.constraintGetForName("existing constraint")).isEqualTo((Object)existing);
            Assertions.assertThat((Object)before.constraintGetForName("new constraint")).isEqualTo((Object)newConstraint);
            Assertions.assertThat((Object)after.constraintGetForName("new constraint")).isEqualTo((Object)newConstraint);
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldNotSeeDroppedUniqueConstraintFromTransaction(EntityType entityType) throws Exception {
        ConstraintDescriptor existing;
        int entityToken = entityType.selectEntityToken(this.label, this.type);
        try (KernelTransaction transaction = this.beginTransaction();){
            existing = transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)entityType.createSchemaDescriptor(entityToken, this.prop1)));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaReadCore before = transaction.schemaRead().snapshot();
            transaction.schemaWrite().constraintDrop(existing);
            SchemaRead schemaRead = transaction.schemaRead();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)schemaRead.constraintExists(existing));
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken((SchemaReadCore)schemaRead, entityToken))).isEmpty();
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken(schemaRead.snapshot(), entityToken))).isEmpty();
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken(before, entityToken))).isEmpty();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldCreateKeyConstraint(EntityType entityType) throws Exception {
        ConstraintDescriptor constraint;
        int entityToken = entityType.selectEntityToken(this.label, this.type);
        try (KernelTransaction transaction = this.beginTransaction();){
            constraint = transaction.schemaWrite().keyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)entityType.createSchemaDescriptor(entityToken, this.prop1)));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)schemaRead.constraintExists(constraint));
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken((SchemaReadCore)schemaRead, entityToken))).isEqualTo(Collections.singletonList(constraint));
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken(schemaRead.snapshot(), entityToken))).isEqualTo(Collections.singletonList(constraint));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldDropKeyConstraint(EntityType entityType) throws Exception {
        ConstraintDescriptor constraint;
        int entityToken = entityType.selectEntityToken(this.label, this.type);
        try (KernelTransaction transaction = this.beginTransaction();){
            constraint = transaction.schemaWrite().keyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)entityType.createSchemaDescriptor(entityToken, this.prop1)));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            transaction.schemaWrite().constraintDrop(constraint);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)schemaRead.constraintExists(constraint));
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken((SchemaReadCore)schemaRead, entityToken))).isEmpty();
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken(schemaRead.snapshot(), entityToken))).isEmpty();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldFailToCreateKeyConstraintIfConstraintNotSatisfied(EntityType entityType) throws Exception {
        int entityToken = entityType.selectEntityToken(this.label, this.type);
        try (KernelTransaction transaction = this.beginTransaction();){
            entityType.createDataInconsistentWithExistenceConstraintOnSchema(transaction, entityToken);
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().keyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)entityType.createSchemaDescriptor(entityToken, this.prop1))));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldSeeKeyConstraintFromTransaction(EntityType entityType) throws Exception {
        ConstraintDescriptor existing;
        int entityToken = entityType.selectEntityToken(this.label, this.type);
        try (KernelTransaction transaction = this.beginTransaction();){
            existing = transaction.schemaWrite().keyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)entityType.createSchemaDescriptor(entityToken, this.prop1)).withName("existing constraint"));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaReadCore before = transaction.schemaRead().snapshot();
            ConstraintDescriptor newConstraint = transaction.schemaWrite().keyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)entityType.createSchemaDescriptor(entityToken, this.prop2)).withName("new constraint"));
            SchemaRead schemaRead = transaction.schemaRead();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)schemaRead.constraintExists(existing));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)schemaRead.constraintExists(newConstraint));
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken((SchemaReadCore)schemaRead, entityToken))).contains((Object[])new ConstraintDescriptor[]{existing, newConstraint});
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken(schemaRead.snapshot(), entityToken))).contains((Object[])new ConstraintDescriptor[]{existing, newConstraint});
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken(before, entityToken))).contains((Object[])new ConstraintDescriptor[]{existing, newConstraint});
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldNotSeeDroppedKeyConstraintFromTransaction(EntityType entityType) throws Exception {
        ConstraintDescriptor existing;
        int entityToken = entityType.selectEntityToken(this.label, this.type);
        try (KernelTransaction transaction = this.beginTransaction();){
            existing = transaction.schemaWrite().keyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)entityType.createSchemaDescriptor(entityToken, this.prop1)).withName("constraint name"));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaReadCore before = transaction.schemaRead().snapshot();
            transaction.schemaWrite().constraintDrop(existing);
            SchemaRead schemaRead = transaction.schemaRead();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)schemaRead.constraintExists(existing));
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken((SchemaReadCore)schemaRead, entityToken))).isEmpty();
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken(schemaRead.snapshot(), entityToken))).isEmpty();
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken(before, entityToken))).isEmpty();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldCreateNodePropertyExistenceConstraint() throws Exception {
        ConstraintDescriptor constraint;
        try (KernelTransaction transaction = this.beginTransaction();){
            constraint = transaction.schemaWrite().nodePropertyExistenceConstraintCreate(SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1}), "constraint name");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)schemaRead.constraintExists(constraint));
            Assertions.assertThat((List)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label))).isEqualTo(Collections.singletonList(constraint));
            Assertions.assertThat((List)Iterators.asList((Iterator)schemaRead.snapshot().constraintsGetForLabel(this.label))).isEqualTo(Collections.singletonList(constraint));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldDropNodePropertyExistenceConstraint() throws Exception {
        ConstraintDescriptor constraint;
        try (KernelTransaction transaction = this.beginTransaction();){
            constraint = transaction.schemaWrite().nodePropertyExistenceConstraintCreate(SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1}), "constraint name");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            transaction.schemaWrite().constraintDrop(constraint);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)schemaRead.constraintExists(constraint));
            Assertions.assertThat((List)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label))).isEmpty();
            Assertions.assertThat((List)Iterators.asList((Iterator)schemaRead.snapshot().constraintsGetForLabel(this.label))).isEmpty();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldFailToCreatePropertyExistenceConstraintIfConstraintNotSatisfied() throws Exception {
        try (KernelTransaction transaction = this.beginTransaction();){
            Write write = transaction.dataWrite();
            long node = write.nodeCreate();
            write.nodeAddLabel(node, this.label);
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().nodePropertyExistenceConstraintCreate(SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1}), "constraint name"));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldSeeNodePropertyExistenceConstraintFromTransaction() throws Exception {
        ConstraintDescriptor existing;
        try (KernelTransaction transaction = this.beginTransaction();){
            existing = transaction.schemaWrite().nodePropertyExistenceConstraintCreate(SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1}), "existing constraint");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaReadCore before = transaction.schemaRead().snapshot();
            ConstraintDescriptor newConstraint = transaction.schemaWrite().nodePropertyExistenceConstraintCreate(SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop2}), "new constraint");
            SchemaRead schemaRead = transaction.schemaRead();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)schemaRead.constraintExists(existing));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)schemaRead.constraintExists(newConstraint));
            Assertions.assertThat((List)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label))).contains((Object[])new ConstraintDescriptor[]{existing, newConstraint});
            Assertions.assertThat((List)Iterators.asList((Iterator)schemaRead.snapshot().constraintsGetForLabel(this.label))).contains((Object[])new ConstraintDescriptor[]{existing, newConstraint});
            Assertions.assertThat((List)Iterators.asList((Iterator)before.constraintsGetForLabel(this.label))).contains((Object[])new ConstraintDescriptor[]{existing, newConstraint});
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldNotSeeDroppedNodePropertyExistenceConstraintFromTransaction() throws Exception {
        ConstraintDescriptor existing;
        try (KernelTransaction transaction = this.beginTransaction();){
            existing = transaction.schemaWrite().nodePropertyExistenceConstraintCreate(SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1}), "constraint name");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaReadCore before = transaction.schemaRead().snapshot();
            transaction.schemaWrite().constraintDrop(existing);
            SchemaRead schemaRead = transaction.schemaRead();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)schemaRead.constraintExists(existing));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)schemaRead.index((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop2})).hasNext());
            Assertions.assertThat((List)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label))).isEmpty();
            Assertions.assertThat((List)Iterators.asList((Iterator)schemaRead.snapshot().constraintsGetForLabel(this.label))).isEmpty();
            Assertions.assertThat((List)Iterators.asList((Iterator)before.constraintsGetForLabel(this.label))).isEmpty();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldCreateRelationshipPropertyExistenceConstraint() throws Exception {
        ConstraintDescriptor constraint;
        try (KernelTransaction transaction = this.beginTransaction();){
            constraint = transaction.schemaWrite().relationshipPropertyExistenceConstraintCreate(SchemaDescriptors.forRelType((int)this.type, (int[])new int[]{this.prop1}), "constraint name");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)schemaRead.constraintExists(constraint));
            Assertions.assertThat((List)Iterators.asList((Iterator)schemaRead.constraintsGetForRelationshipType(this.type))).isEqualTo(Collections.singletonList(constraint));
            Assertions.assertThat((List)Iterators.asList((Iterator)schemaRead.snapshot().constraintsGetForRelationshipType(this.type))).isEqualTo(Collections.singletonList(constraint));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldDropRelationshipPropertyExistenceConstraint() throws Exception {
        ConstraintDescriptor constraint;
        try (KernelTransaction transaction = this.beginTransaction();){
            constraint = transaction.schemaWrite().relationshipPropertyExistenceConstraintCreate(SchemaDescriptors.forRelType((int)this.type, (int[])new int[]{this.prop1}), "constraint name");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            transaction.schemaWrite().constraintDrop(constraint);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)schemaRead.constraintExists(constraint));
            Assertions.assertThat((List)Iterators.asList((Iterator)schemaRead.constraintsGetForRelationshipType(this.type))).isEmpty();
            Assertions.assertThat((List)Iterators.asList((Iterator)schemaRead.snapshot().constraintsGetForRelationshipType(this.type))).isEmpty();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldFailToCreateRelationshipPropertyExistenceConstraintIfConstraintNotSatisfied() throws Exception {
        try (KernelTransaction transaction = this.beginTransaction();){
            Write write = transaction.dataWrite();
            write.relationshipCreate(write.nodeCreate(), this.type, write.nodeCreate());
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().relationshipPropertyExistenceConstraintCreate(SchemaDescriptors.forRelType((int)this.type, (int[])new int[]{this.prop1}), "constraint name"));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldSeeRelationshipPropertyExistenceConstraintFromTransaction() throws Exception {
        ConstraintDescriptor existing;
        try (KernelTransaction transaction = this.beginTransaction();){
            existing = transaction.schemaWrite().relationshipPropertyExistenceConstraintCreate(SchemaDescriptors.forRelType((int)this.type, (int[])new int[]{this.prop1}), "existing constraint");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaReadCore before = transaction.schemaRead().snapshot();
            ConstraintDescriptor newConstraint = transaction.schemaWrite().relationshipPropertyExistenceConstraintCreate(SchemaDescriptors.forRelType((int)this.type, (int[])new int[]{this.prop2}), "new constraint");
            SchemaRead schemaRead = transaction.schemaRead();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)schemaRead.constraintExists(existing));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)schemaRead.constraintExists(newConstraint));
            Assertions.assertThat((List)Iterators.asList((Iterator)schemaRead.constraintsGetForRelationshipType(this.type))).contains((Object[])new ConstraintDescriptor[]{existing, newConstraint});
            Assertions.assertThat((List)Iterators.asList((Iterator)schemaRead.snapshot().constraintsGetForRelationshipType(this.type))).contains((Object[])new ConstraintDescriptor[]{existing, newConstraint});
            Assertions.assertThat((List)Iterators.asList((Iterator)before.constraintsGetForRelationshipType(this.type))).contains((Object[])new ConstraintDescriptor[]{existing, newConstraint});
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldNotSeeDroppedRelationshipPropertyExistenceConstraintFromTransaction() throws Exception {
        ConstraintDescriptor existing;
        try (KernelTransaction transaction = this.beginTransaction();){
            existing = transaction.schemaWrite().relationshipPropertyExistenceConstraintCreate(SchemaDescriptors.forRelType((int)this.type, (int[])new int[]{this.prop1}), "constraint name");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaReadCore before = transaction.schemaRead().snapshot();
            transaction.schemaWrite().constraintDrop(existing);
            SchemaRead schemaRead = transaction.schemaRead();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)schemaRead.constraintExists(existing));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)schemaRead.index((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.type, (int[])new int[]{this.prop2})).hasNext());
            Assertions.assertThat((List)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label))).isEmpty();
            Assertions.assertThat((List)Iterators.asList((Iterator)schemaRead.snapshot().constraintsGetForLabel(this.label))).isEmpty();
            Assertions.assertThat((List)Iterators.asList((Iterator)before.constraintsGetForLabel(this.label))).isEmpty();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldListAllConstraints() throws Exception {
        ConstraintDescriptor toDrop;
        ConstraintDescriptor toRetain2;
        ConstraintDescriptor toRetain;
        try (KernelTransaction tx = this.beginTransaction();){
            toRetain = tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("first constraint"));
            toRetain2 = tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label2, (int[])new int[]{this.prop1})).withName("second constraint"));
            toDrop = tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop2})).withName("third constraint"));
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            ConstraintDescriptor created = tx.schemaWrite().nodePropertyExistenceConstraintCreate(SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1}), "new constraint");
            tx.schemaWrite().constraintDrop(toDrop);
            Iterable allConstraints = () -> tx.schemaRead().constraintsGetAll();
            Assertions.assertThat(allConstraints).contains((Object[])new ConstraintDescriptor[]{toRetain, toRetain2, created});
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldListAllConstraintsInSnapshot() throws Exception {
        ConstraintDescriptor toDrop;
        ConstraintDescriptor toRetain2;
        ConstraintDescriptor toRetain;
        try (KernelTransaction tx = this.beginTransaction();){
            toRetain = tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("first constraint"));
            toRetain2 = tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label2, (int[])new int[]{this.prop1})).withName("second constraint"));
            toDrop = tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop2})).withName("third constraint"));
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            SchemaReadCore before = tx.schemaRead().snapshot();
            ConstraintDescriptor created = tx.schemaWrite().nodePropertyExistenceConstraintCreate(SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1}), "new constraint");
            tx.schemaWrite().constraintDrop(toDrop);
            Iterable allConstraints = () -> tx.schemaRead().snapshot().constraintsGetAll();
            Assertions.assertThat(allConstraints).contains((Object[])new ConstraintDescriptor[]{toRetain, toRetain2, created});
            Assertions.assertThat((Iterator)before.constraintsGetAll()).toIterable().contains((Object[])new ConstraintDescriptor[]{toRetain, toRetain2, created});
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldListConstraintsByLabel() throws Exception {
        ConstraintDescriptor droppedInTx;
        ConstraintDescriptor inStore;
        int wrongLabel;
        try (KernelTransaction tx = this.beginTransaction();){
            wrongLabel = tx.tokenWrite().labelGetOrCreateForName("wrongLabel");
            tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)wrongLabel, (int[])new int[]{this.prop1})).withName("first constraint"));
            inStore = tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("second constraint"));
            droppedInTx = tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop2})).withName("third constraint"));
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            SchemaReadCore before = tx.schemaRead().snapshot();
            ConstraintDescriptor createdInTx = tx.schemaWrite().nodePropertyExistenceConstraintCreate(SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1}), "fourth constraint");
            tx.schemaWrite().nodePropertyExistenceConstraintCreate(SchemaDescriptors.forLabel((int)wrongLabel, (int[])new int[]{this.prop1}), "fifth constraint");
            tx.schemaWrite().constraintDrop(droppedInTx);
            Iterable allConstraints = () -> tx.schemaRead().constraintsGetForLabel(this.label);
            Assertions.assertThat(allConstraints).contains((Object[])new ConstraintDescriptor[]{inStore, createdInTx});
            Assertions.assertThat((Iterator)before.constraintsGetForLabel(this.label)).toIterable().contains((Object[])new ConstraintDescriptor[]{inStore, createdInTx});
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldListConstraintsByLabelNonLocking() throws Exception {
        ConstraintDescriptor createdInTx;
        ConstraintDescriptor droppedInTx;
        ConstraintDescriptor inStore;
        int wrongLabel;
        try (KernelTransaction tx = this.beginTransaction();){
            wrongLabel = tx.tokenWrite().labelGetOrCreateForName("wrongLabel");
            tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)wrongLabel, (int[])new int[]{this.prop1})).withName("first constraint"));
            inStore = tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("second constraint"));
            droppedInTx = tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop2})).withName("third constraint"));
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            SchemaReadCore before = tx.schemaRead().snapshot();
            createdInTx = tx.schemaWrite().nodePropertyExistenceConstraintCreate(SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1}), "fourth constraint");
            tx.schemaWrite().nodePropertyExistenceConstraintCreate(SchemaDescriptors.forLabel((int)wrongLabel, (int[])new int[]{this.prop1}), "fifth constraint");
            tx.schemaWrite().constraintDrop(droppedInTx);
            Iterable allConstraints = () -> tx.schemaRead().constraintsGetForLabelNonLocking(this.label);
            Iterable constraintBySchema = () -> tx.schemaRead().constraintsGetForSchemaNonLocking(createdInTx.schema());
            Assertions.assertThat(allConstraints).contains((Object[])new ConstraintDescriptor[]{inStore, createdInTx});
            Assertions.assertThat(constraintBySchema).contains((Object[])new ConstraintDescriptor[]{createdInTx});
            Assertions.assertThat((Iterator)before.constraintsGetForLabelNonLocking(this.label)).toIterable().contains((Object[])new ConstraintDescriptor[]{inStore, createdInTx});
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.beginTransaction();
        try {
            Iterable allConstraints = () -> tx.schemaRead().constraintsGetForLabelNonLocking(this.label);
            Iterable constraintBySchema = () -> tx.schemaRead().constraintsGetForSchemaNonLocking(createdInTx.schema());
            Assertions.assertThat(allConstraints).contains((Object[])new ConstraintDescriptor[]{inStore, createdInTx});
            Assertions.assertThat(constraintBySchema).contains((Object[])new ConstraintDescriptor[]{createdInTx});
            org.junit.jupiter.api.Assertions.assertEquals((long)((KernelTransactionImplementation)tx).lockClient().activeLockCount(), (long)0L);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldListConstraintsByRelTypeNonLocking() throws Exception {
        ConstraintDescriptor createdInTx;
        ConstraintDescriptor droppedInTx;
        ConstraintDescriptor inStore;
        try (KernelTransaction tx = this.beginTransaction();){
            inStore = tx.schemaWrite().relationshipPropertyExistenceConstraintCreate(SchemaDescriptors.forRelType((int)this.type, (int[])new int[]{this.prop1}), "second constraint");
            droppedInTx = tx.schemaWrite().relationshipPropertyExistenceConstraintCreate(SchemaDescriptors.forRelType((int)this.type, (int[])new int[]{this.prop2}), "third constraint");
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            SchemaReadCore before = tx.schemaRead().snapshot();
            createdInTx = tx.schemaWrite().relationshipPropertyExistenceConstraintCreate(SchemaDescriptors.forRelType((int)this.type, (int[])new int[]{this.prop3}), "fourth constraint");
            tx.schemaWrite().constraintDrop(droppedInTx);
            Iterable constraintsForRelType = () -> tx.schemaRead().constraintsGetForRelationshipTypeNonLocking(this.type);
            Assertions.assertThat(constraintsForRelType).contains((Object[])new ConstraintDescriptor[]{inStore, createdInTx});
            Assertions.assertThat((Iterator)before.constraintsGetForRelationshipTypeNonLocking(this.type)).toIterable().contains((Object[])new ConstraintDescriptor[]{inStore, createdInTx});
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.beginTransaction();
        try {
            Iterable constraintsForRelType = () -> tx.schemaRead().constraintsGetForRelationshipTypeNonLocking(this.type);
            Assertions.assertThat(constraintsForRelType).contains((Object[])new ConstraintDescriptor[]{inStore, createdInTx});
            org.junit.jupiter.api.Assertions.assertEquals((long)((KernelTransactionImplementation)tx).lockClient().activeLockCount(), (long)0L);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldListAllConstraintsNonLocking() throws Exception {
        ConstraintDescriptor createdInTx;
        ConstraintDescriptor droppedInTx;
        ConstraintDescriptor inStore;
        try (KernelTransaction tx = this.beginTransaction();){
            inStore = tx.schemaWrite().nodePropertyExistenceConstraintCreate(SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1}), "second constraint");
            droppedInTx = tx.schemaWrite().relationshipPropertyExistenceConstraintCreate(SchemaDescriptors.forRelType((int)this.type, (int[])new int[]{this.prop2}), "third constraint");
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            SchemaReadCore before = tx.schemaRead().snapshot();
            createdInTx = tx.schemaWrite().relationshipPropertyExistenceConstraintCreate(SchemaDescriptors.forRelType((int)this.type, (int[])new int[]{this.prop3}), "fourth constraint");
            tx.schemaWrite().constraintDrop(droppedInTx);
            Iterable constraintsForRelType = () -> tx.schemaRead().constraintsGetAllNonLocking();
            Assertions.assertThat(constraintsForRelType).contains((Object[])new ConstraintDescriptor[]{inStore, createdInTx});
            Assertions.assertThat((Iterator)before.constraintsGetAllNonLocking()).toIterable().contains((Object[])new ConstraintDescriptor[]{inStore, createdInTx});
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.beginTransaction();
        try {
            Iterable constraintsForRelType = () -> tx.schemaRead().constraintsGetAllNonLocking();
            Assertions.assertThat(constraintsForRelType).contains((Object[])new ConstraintDescriptor[]{inStore, createdInTx});
            org.junit.jupiter.api.Assertions.assertEquals((long)((KernelTransactionImplementation)tx).lockClient().activeLockCount(), (long)0L);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void oldSnapshotShouldNotSeeNewlyCommittedIndexes() throws Exception {
        try (KernelTransaction longRunning = this.beginTransaction();){
            SchemaReadCore snapshot = longRunning.schemaRead().snapshot();
            try (KernelTransaction overlapping = this.beginTransaction();){
                overlapping.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("a"));
                overlapping.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.fulltext((org.neo4j.common.EntityType)org.neo4j.common.EntityType.RELATIONSHIP, (int[])new int[]{this.type}, (int[])new int[]{this.prop2})).withIndexType(IndexType.FULLTEXT).withName("b"));
                overlapping.commit();
            }
            Assertions.assertThat((Object)snapshot.indexGetForName("a")).isEqualTo((Object)IndexDescriptor.NO_INDEX);
            Assertions.assertThat((Object)snapshot.indexGetForName("b")).isEqualTo((Object)IndexDescriptor.NO_INDEX);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)snapshot.indexesGetAll().hasNext());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)snapshot.index((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).hasNext());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)snapshot.indexesGetForLabel(this.label).hasNext());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)snapshot.indexesGetForRelationshipType(this.type).hasNext());
        }
    }

    @Test
    void oldSnapshotShouldNotSeeNewlyCommittedConstraints() throws Exception {
        try (KernelTransaction longRunning = this.beginTransaction();){
            SchemaReadCore snapshot = longRunning.schemaRead().snapshot();
            try (KernelTransaction overlapping = this.beginTransaction();){
                overlapping.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("a"));
                overlapping.schemaWrite().keyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label2, (int[])new int[]{this.prop1})).withName("b"));
                overlapping.schemaWrite().nodePropertyExistenceConstraintCreate(SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop2}), "c");
                overlapping.schemaWrite().relationshipPropertyExistenceConstraintCreate(SchemaDescriptors.forRelType((int)this.type, (int[])new int[]{this.prop1}), "d");
                overlapping.commit();
            }
            Assertions.assertThat((Object)snapshot.constraintGetForName("a")).isNull();
            Assertions.assertThat((Object)snapshot.indexGetForName("a")).isEqualTo((Object)IndexDescriptor.NO_INDEX);
            Assertions.assertThat((Object)snapshot.constraintGetForName("b")).isNull();
            Assertions.assertThat((Object)snapshot.indexGetForName("b")).isEqualTo((Object)IndexDescriptor.NO_INDEX);
            Assertions.assertThat((Object)snapshot.constraintGetForName("c")).isNull();
            Assertions.assertThat((Object)snapshot.constraintGetForName("d")).isNull();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)snapshot.constraintsGetAll().hasNext());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)snapshot.constraintsGetForLabel(this.label).hasNext());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)snapshot.constraintsGetForRelationshipType(this.type).hasNext());
        }
    }

    @Test
    void shouldFailIndexCreateForRepeatedProperties() throws Exception {
        try (KernelTransaction tx = this.beginTransaction();){
            org.junit.jupiter.api.Assertions.assertThrows(SchemaKernelException.class, () -> tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1, this.prop1})).withName("my index")));
        }
    }

    @Test
    void shouldFailUniquenessConstraintCreateForRepeatedProperties() throws Exception {
        try (KernelTransaction tx = this.beginTransaction();){
            org.junit.jupiter.api.Assertions.assertThrows(SchemaKernelException.class, () -> tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1, this.prop1}))));
        }
    }

    @Test
    void shouldFailNodeKeyCreateForRepeatedProperties() throws Exception {
        try (KernelTransaction tx = this.beginTransaction();){
            org.junit.jupiter.api.Assertions.assertThrows(SchemaKernelException.class, () -> tx.schemaWrite().keyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.label, (int[])new int[]{this.prop1, this.prop1}))));
        }
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldCreatePropertyTypeConstraint(EntityType entityType) throws Exception {
        ConstraintDescriptor constraint;
        int entityToken = entityType.selectEntityToken(this.label, this.type);
        try (KernelTransaction transaction = this.beginTransaction();){
            constraint = transaction.schemaWrite().propertyTypeConstraintCreate(entityType.createSchemaDescriptor(entityToken, this.prop1), null, PropertyTypeSet.of((SchemaValueType[])new SchemaValueType[]{SchemaValueType.BOOLEAN}));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)schemaRead.constraintExists(constraint));
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken((SchemaReadCore)schemaRead, entityToken))).isEqualTo(Collections.singletonList(constraint));
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken(schemaRead.snapshot(), entityToken))).isEqualTo(Collections.singletonList(constraint));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldDropPropertyTypeConstraint(EntityType entityType) throws Exception {
        ConstraintDescriptor constraint;
        int entityToken = entityType.selectEntityToken(this.label, this.type);
        try (KernelTransaction transaction = this.beginTransaction();){
            constraint = transaction.schemaWrite().propertyTypeConstraintCreate(entityType.createSchemaDescriptor(entityToken, this.prop1), null, PropertyTypeSet.of((SchemaValueType[])new SchemaValueType[]{SchemaValueType.BOOLEAN}));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            transaction.schemaWrite().constraintDrop(constraint);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)schemaRead.constraintExists(constraint));
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken((SchemaReadCore)schemaRead, entityToken))).isEmpty();
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken(schemaRead.snapshot(), entityToken))).isEmpty();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldSeePropertyTypeConstraintFromTransaction(EntityType entityType) throws Exception {
        ConstraintDescriptor existing;
        int entityToken = entityType.selectEntityToken(this.label, this.type);
        try (KernelTransaction transaction = this.beginTransaction();){
            existing = transaction.schemaWrite().propertyTypeConstraintCreate(entityType.createSchemaDescriptor(entityToken, this.prop1), "existing constraint", PropertyTypeSet.of((SchemaValueType[])new SchemaValueType[]{SchemaValueType.BOOLEAN}));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaReadCore before = transaction.schemaRead().snapshot();
            ConstraintDescriptor newConstraint = transaction.schemaWrite().propertyTypeConstraintCreate(entityType.createSchemaDescriptor(entityToken, this.prop2), "new constraint", PropertyTypeSet.of((SchemaValueType[])new SchemaValueType[]{SchemaValueType.BOOLEAN}));
            SchemaRead schemaRead = transaction.schemaRead();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)schemaRead.constraintExists(existing));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)schemaRead.constraintExists(newConstraint));
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken((SchemaReadCore)schemaRead, entityToken))).contains((Object[])new ConstraintDescriptor[]{existing, newConstraint});
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken(schemaRead.snapshot(), entityToken))).contains((Object[])new ConstraintDescriptor[]{existing, newConstraint});
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken(before, entityToken))).contains((Object[])new ConstraintDescriptor[]{existing, newConstraint});
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldNotSeeDroppedPropertyTypeConstraintFromTransaction(EntityType entityType) throws Exception {
        ConstraintDescriptor existing;
        int entityToken = entityType.selectEntityToken(this.label, this.type);
        try (KernelTransaction transaction = this.beginTransaction();){
            existing = transaction.schemaWrite().propertyTypeConstraintCreate(entityType.createSchemaDescriptor(entityToken, this.prop1), "constraint name", PropertyTypeSet.of((SchemaValueType[])new SchemaValueType[]{SchemaValueType.BOOLEAN}));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaReadCore before = transaction.schemaRead().snapshot();
            transaction.schemaWrite().constraintDrop(existing);
            SchemaRead schemaRead = transaction.schemaRead();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)schemaRead.constraintExists(existing));
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken((SchemaReadCore)schemaRead, entityToken))).isEmpty();
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken(schemaRead.snapshot(), entityToken))).isEmpty();
            Assertions.assertThat((List)Iterators.asList(entityType.constraintsGetForEntityToken(before, entityToken))).isEmpty();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum EntityType implements EntityControl
    {
        NODE{

            @Override
            public int selectEntityToken(int label, int type) {
                return label;
            }

            @Override
            public SchemaDescriptor createSchemaDescriptor(int entityToken, int propertyKey) {
                return SchemaDescriptors.forLabel((int)entityToken, (int[])new int[]{propertyKey});
            }

            @Override
            public Iterator<ConstraintDescriptor> constraintsGetForEntityToken(SchemaReadCore schemaRead, int entityToken) {
                return schemaRead.constraintsGetForLabel(entityToken);
            }

            @Override
            public void createDataInconsistentWithConstraintOnSchema(KernelTransaction tx, int entityToken, int propertyKey) throws KernelException {
                Write write = tx.dataWrite();
                long node1 = write.nodeCreate();
                write.nodeAddLabel(node1, entityToken);
                write.nodeSetProperty(node1, propertyKey, (Value)Values.intValue((int)42));
                long node2 = write.nodeCreate();
                write.nodeAddLabel(node2, entityToken);
                write.nodeSetProperty(node2, propertyKey, (Value)Values.intValue((int)42));
            }

            @Override
            public void createDataInconsistentWithExistenceConstraintOnSchema(KernelTransaction tx, int entityToken) throws KernelException {
                Write write = tx.dataWrite();
                long node = write.nodeCreate();
                write.nodeAddLabel(node, entityToken);
            }
        }
        ,
        RELATIONSHIP{

            @Override
            public int selectEntityToken(int label, int type) {
                return type;
            }

            @Override
            public SchemaDescriptor createSchemaDescriptor(int entityToken, int propertyKey) {
                return SchemaDescriptors.forRelType((int)entityToken, (int[])new int[]{propertyKey});
            }

            @Override
            public Iterator<ConstraintDescriptor> constraintsGetForEntityToken(SchemaReadCore schemaRead, int entityToken) {
                return schemaRead.constraintsGetForRelationshipType(entityToken);
            }

            @Override
            public void createDataInconsistentWithConstraintOnSchema(KernelTransaction tx, int entityToken, int propertyKey) throws KernelException {
                Write write = tx.dataWrite();
                long node1 = write.nodeCreate();
                long rel1 = write.relationshipCreate(node1, entityToken, node1);
                write.relationshipSetProperty(rel1, propertyKey, (Value)Values.intValue((int)42));
                long node2 = write.nodeCreate();
                long rel2 = write.relationshipCreate(node2, entityToken, node2);
                write.relationshipSetProperty(rel2, propertyKey, (Value)Values.intValue((int)42));
            }

            @Override
            public void createDataInconsistentWithExistenceConstraintOnSchema(KernelTransaction tx, int entityToken) throws KernelException {
                Write write = tx.dataWrite();
                long node = write.nodeCreate();
                write.relationshipCreate(node, entityToken, node);
            }
        };

    }

    static interface EntityControl {
        public int selectEntityToken(int var1, int var2);

        public SchemaDescriptor createSchemaDescriptor(int var1, int var2);

        public Iterator<ConstraintDescriptor> constraintsGetForEntityToken(SchemaReadCore var1, int var2);

        public void createDataInconsistentWithConstraintOnSchema(KernelTransaction var1, int var2, int var3) throws KernelException;

        public void createDataInconsistentWithExistenceConstraintOnSchema(KernelTransaction var1, int var2) throws KernelException;
    }
}

