/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.dbms.database.DbmsRuntimeRepository;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;

@TestDirectoryExtension
@DbmsExtension
class DbmsRuntimeVersionTest {
    private static final DbmsRuntimeVersion OVERRIDDEN_INITIAL_LATEST_VERSION = DbmsRuntimeVersion.V5_0;
    private static final DbmsRuntimeVersion OLDER_VERSION = DbmsRuntimeVersion.V4_4;
    @Inject
    private DatabaseContextProvider<DatabaseContext> databaseContextProvider;
    @Inject
    private DbmsRuntimeRepository dbmsRuntimeRepository;
    private GraphDatabaseService systemDb;

    DbmsRuntimeVersionTest() {
    }

    @BeforeEach
    void beforeEach() {
        this.systemDb = ((DatabaseContext)this.databaseContextProvider.getDatabaseContext(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID).get()).databaseFacade();
    }

    @Test
    void testBasicVersionLifecycle() {
        Assertions.assertSame((Object)LatestVersions.LATEST_RUNTIME_VERSION, (Object)this.dbmsRuntimeRepository.getVersion());
        this.setRuntimeVersion(OLDER_VERSION);
        Assertions.assertSame((Object)OLDER_VERSION, (Object)this.dbmsRuntimeRepository.getVersion());
        this.systemDb.executeTransactionally("CALL dbms.upgrade()");
        Assertions.assertSame((Object)LatestVersions.LATEST_RUNTIME_VERSION, (Object)this.dbmsRuntimeRepository.getVersion());
    }

    @Test
    void latestVersionIsRealLatestVersionByDefault() {
        Assertions.assertSame((Object)LatestVersions.LATEST_RUNTIME_VERSION, (Object)this.dbmsRuntimeRepository.getVersion());
    }

    @Test
    @DbmsExtension(configurationCallback="configuration")
    void latestVersionCanBeSetThroughConfigForTests() {
        Assertions.assertSame((Object)OVERRIDDEN_INITIAL_LATEST_VERSION, (Object)this.dbmsRuntimeRepository.getVersion());
        this.setRuntimeVersion(OLDER_VERSION);
        Assertions.assertSame((Object)OLDER_VERSION, (Object)this.dbmsRuntimeRepository.getVersion());
        this.systemDb.executeTransactionally("CALL dbms.upgrade()");
        Assertions.assertSame((Object)OVERRIDDEN_INITIAL_LATEST_VERSION, (Object)this.dbmsRuntimeRepository.getVersion());
    }

    @ExtensionCallback
    void configuration(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseInternalSettings.latest_runtime_version, (Object)OVERRIDDEN_INITIAL_LATEST_VERSION.getVersion());
    }

    private void setRuntimeVersion(DbmsRuntimeVersion runtimeVersion) {
        try (Transaction tx = this.systemDb.beginTx();
             ResourceIterator nodes = tx.findNodes(SystemGraphComponent.VERSION_LABEL);){
            nodes.stream().forEach(dbmsRuntimeNode -> dbmsRuntimeNode.setProperty(ComponentVersion.DBMS_RUNTIME_COMPONENT.name(), (Object)runtimeVersion.getVersion()));
            tx.commit();
        }
        this.dbmsRuntimeRepository.setVersion(runtimeVersion);
    }
}

