/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.ZippedStore;
import org.neo4j.kernel.ZippedStoreCommunity;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.test.Barrier;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
public class FailingDatabaseUpgradeTransactionIT {
    private static final ZippedStore ZIPPED_STORE = ZippedStoreCommunity.REC_AF11_V50_EMPTY;
    private static final KernelVersion OLD_KERNEL_VERSION = ZIPPED_STORE.statistics().kernelVersion();
    private static final DbmsRuntimeVersion OLD_DBMS_RUNTIME_VERSION = DbmsRuntimeVersion.VERSIONS.stream().filter(dbmsRuntimeVersion -> dbmsRuntimeVersion.kernelVersion() == OLD_KERNEL_VERSION).findFirst().orElseThrow();
    private static final int MAX_TRANSACTIONS = 10;
    @Inject
    protected TestDirectory testDirectory;
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    protected DatabaseManagementService dbms;
    protected GraphDatabaseAPI db;
    private GraphDatabaseAPI systemDb;
    protected KernelVersion oldKernelVersion;
    protected DbmsRuntimeVersion oldDbmsRuntimeVersion;

    @BeforeEach
    void setUp() throws IOException {
        this.createDbFiles();
        this.startDbms();
    }

    @AfterEach
    void tearDown() {
        if (this.dbms != null) {
            this.dbms.shutdown();
        }
    }

    protected void createDbFiles() throws IOException {
        this.oldKernelVersion = OLD_KERNEL_VERSION;
        this.oldDbmsRuntimeVersion = OLD_DBMS_RUNTIME_VERSION;
        ZIPPED_STORE.unzip(this.testDirectory.homePath());
    }

    protected TestDatabaseManagementServiceBuilder configure(TestDatabaseManagementServiceBuilder builder) {
        return builder.setDatabaseRootDirectory(this.testDirectory.homePath()).setInternalLogProvider((InternalLogProvider)this.logProvider).setConfig(GraphDatabaseInternalSettings.automatic_upgrade_enabled, (Object)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldHandleMaxTransactionReachedInUpgrade() throws Exception {
        Transaction tx;
        Barrier.Control barrier = new Barrier.Control();
        try (OtherThreadExecutor executor = new OtherThreadExecutor("Executor");){
            Future readTx = null;
            try {
                readTx = executor.executeDontWait(() -> {
                    ArrayList<Transaction> txs = new ArrayList<Transaction>();
                    try {
                        for (int i = 0; i < 9; ++i) {
                            txs.add(this.db.beginTx());
                        }
                    }
                    finally {
                        barrier.reached();
                        IOUtils.closeAll(txs);
                    }
                    return null;
                });
                this.set(LatestVersions.LATEST_RUNTIME_VERSION);
                barrier.await();
                tx = this.db.beginTx();
                try {
                    tx.createNode();
                    tx.commit();
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }
            finally {
                barrier.release();
                Assertions.assertThat((Future)readTx).isNotNull();
                readTx.get();
            }
        }
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessageWithArguments("Upgrade transaction from %s to %s not possible right now because maximum concurrently executed transactions was reached, will retry on next write. If this persists see setting %s.", new Object[]{this.oldKernelVersion, LatestVersions.LATEST_KERNEL_VERSION, GraphDatabaseSettings.max_concurrent_transactions.name()}).containsMessageWithArguments("Upgrade transaction from %s to %s started", new Object[]{this.oldKernelVersion, LatestVersions.LATEST_KERNEL_VERSION}).doesNotContainMessageWithArguments("Upgrade transaction from %s to %s completed", new Object[]{this.oldKernelVersion, LatestVersions.LATEST_KERNEL_VERSION});
        long originalNodeCount = this.originalNodeCount();
        ((AbstractLongAssert)Assertions.assertThat((long)this.getNodeCount()).as("tx triggering upgrade succeeded", new Object[0])).isEqualTo(originalNodeCount + 1L);
        Assertions.assertThat((Comparable)this.kernelVersion()).isEqualTo((Object)this.oldKernelVersion);
        tx = this.db.beginTx();
        try {
            tx.createNode();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        ((AbstractLongAssert)Assertions.assertThat((long)this.getNodeCount()).as("tx triggering upgrade succeeded", new Object[0])).isEqualTo(originalNodeCount + 2L);
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessageWithArguments("Upgrade transaction from %s to %s completed", new Object[]{this.oldKernelVersion, LatestVersions.LATEST_KERNEL_VERSION});
        Assertions.assertThat((Comparable)this.kernelVersion()).isEqualTo((Object)LatestVersions.LATEST_KERNEL_VERSION);
    }

    private long getNodeCount() {
        try (Transaction tx = this.db.beginTx();){
            long l = Iterables.count((Iterable)tx.getAllNodes());
            return l;
        }
    }

    protected void startDbms() {
        this.dbms = this.configure(this.createDbmsBuilder()).setConfig(GraphDatabaseSettings.max_concurrent_transactions, (Object)10).build();
        this.db = (GraphDatabaseAPI)this.dbms.database("neo4j");
        this.systemDb = (GraphDatabaseAPI)this.dbms.database("system");
    }

    protected TestDatabaseManagementServiceBuilder createDbmsBuilder() {
        return new TestDatabaseManagementServiceBuilder();
    }

    protected long originalNodeCount() {
        return ZIPPED_STORE.statistics().nodes();
    }

    private KernelVersion kernelVersion() {
        return this.get(this.db, KernelVersionProvider.class).kernelVersion();
    }

    protected <T> T get(GraphDatabaseAPI db, Class<T> cls) {
        return (T)db.getDependencyResolver().resolveDependency(cls);
    }

    protected void set(DbmsRuntimeVersion runtimeVersion) {
        try (Transaction tx = this.systemDb.beginTx();
             Stream nodes = tx.findNodes(SystemGraphComponent.VERSION_LABEL).stream();){
            nodes.forEach(dbmsRuntimeNode -> dbmsRuntimeNode.setProperty(ComponentVersion.DBMS_RUNTIME_COMPONENT.name(), (Object)runtimeVersion.getVersion()));
            tx.commit();
        }
    }
}

