/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.kernel.impl.locking.forseti.ForsetiClient;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.Race;
import org.neo4j.util.concurrent.BinaryLatch;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class RelationshipGetUniqueFromIndexSeekIT
extends KernelIntegrationTest {
    private int relationshipTypeId;
    private int propertyId1;
    private int propertyId2;

    RelationshipGetUniqueFromIndexSeekIT() {
    }

    @BeforeEach
    void createKeys() throws Exception {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        this.relationshipTypeId = tokenWrite.relationshipTypeGetOrCreateForName("R");
        this.propertyId1 = tokenWrite.propertyKeyGetOrCreateForName("foo");
        this.propertyId2 = tokenWrite.propertyKeyGetOrCreateForName("bar");
        this.commit();
    }

    @Test
    void shouldFindMatchingRelationship() throws Exception {
        IndexDescriptor index = this.createUniquenessConstraint(this.relationshipTypeId, this.propertyId1);
        Value value = Values.of((Object)"value");
        long relId = this.createRelationshipWithValue(value);
        KernelTransaction transaction = this.newTransaction();
        Read read = transaction.dataRead();
        int propertyId = index.schema().getPropertyIds()[0];
        try (RelationshipValueIndexCursor cursor = transaction.cursors().allocateRelationshipValueIndexCursor(transaction.cursorContext(), transaction.memoryTracker());){
            long foundId = read.lockingRelationshipUniqueIndexSeek(index, cursor, new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)propertyId, (Object)value)});
            Assertions.assertEquals((long)relId, (long)foundId, (String)"Created relationship was not found");
        }
        this.commit();
    }

    @Test
    void shouldNotFindNonMatchingRelationship() throws Exception {
        IndexDescriptor index = this.createUniquenessConstraint(this.relationshipTypeId, this.propertyId1);
        Value value = Values.of((Object)"value");
        this.createRelationshipWithValue(Values.of((Object)("other_" + value)));
        KernelTransaction transaction = this.newTransaction();
        try (RelationshipValueIndexCursor cursor = transaction.cursors().allocateRelationshipValueIndexCursor(transaction.cursorContext(), transaction.memoryTracker());){
            long foundId = transaction.dataRead().lockingRelationshipUniqueIndexSeek(index, cursor, new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)this.propertyId1, (Object)value)});
            Assertions.assertTrue((boolean)RelationshipGetUniqueFromIndexSeekIT.isNoSuchRelationship(foundId), (String)"Non-matching created relationship was found");
        }
        this.commit();
    }

    @Test
    void shouldCompositeFindMatchingRelationship() throws Exception {
        IndexDescriptor index = this.createUniquenessConstraint(this.relationshipTypeId, this.propertyId1, this.propertyId2);
        Value value1 = Values.of((Object)"value1");
        Value value2 = Values.of((Object)"value2");
        long relId = this.createRelationshipWithValues(value1, value2);
        KernelTransaction transaction = this.newTransaction();
        try (RelationshipValueIndexCursor cursor = transaction.cursors().allocateRelationshipValueIndexCursor(transaction.cursorContext(), transaction.memoryTracker());){
            long foundId = transaction.dataRead().lockingRelationshipUniqueIndexSeek(index, cursor, new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)this.propertyId1, (Object)value1), PropertyIndexQuery.exact((int)this.propertyId2, (Object)value2)});
            Assertions.assertEquals((long)relId, (long)foundId, (String)"Created relationship was not found");
        }
        this.commit();
    }

    @Test
    void shouldNotCompositeFindNonMatchingRelationship() throws Exception {
        IndexDescriptor index = this.createUniquenessConstraint(this.relationshipTypeId, this.propertyId1, this.propertyId2);
        Value value1 = Values.of((Object)"value1");
        Value value2 = Values.of((Object)"value2");
        this.createRelationshipWithValues(Values.of((Object)("other_" + value1)), Values.of((Object)("other_" + value2)));
        KernelTransaction transaction = this.newTransaction();
        try (RelationshipValueIndexCursor cursor = transaction.cursors().allocateRelationshipValueIndexCursor(transaction.cursorContext(), transaction.memoryTracker());){
            long foundId = transaction.dataRead().lockingRelationshipUniqueIndexSeek(index, cursor, new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)this.propertyId1, (Object)value1), PropertyIndexQuery.exact((int)this.propertyId2, (Object)value2)});
            Assertions.assertTrue((boolean)RelationshipGetUniqueFromIndexSeekIT.isNoSuchRelationship(foundId), (String)"Non-matching created relationship was found");
        }
        this.commit();
    }

    @Test
    void shouldBlockUniqueIndexSeekFromCompetingTransaction() throws Exception {
        BinaryLatch latch = new BinaryLatch();
        IndexDescriptor index = this.createUniquenessConstraint(this.relationshipTypeId, this.propertyId1);
        Value value = Values.of((Object)"value");
        Write write = this.dataWriteInNewTransaction();
        long relId = write.relationshipCreate(write.nodeCreate(), this.relationshipTypeId, write.nodeCreate());
        write.relationshipSetProperty(relId, this.propertyId1, value);
        try (OtherThreadExecutor other = new OtherThreadExecutor("Transaction Thread 2");){
            Future future = other.executeDontWait(() -> {
                latch.await();
                try (KernelTransaction tx = this.kernel.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);){
                    try (RelationshipValueIndexCursor cursor = tx.cursors().allocateRelationshipValueIndexCursor(tx.cursorContext(), tx.memoryTracker());){
                        tx.dataRead().lockingRelationshipUniqueIndexSeek(index, cursor, new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)this.propertyId1, (Object)value)});
                    }
                    tx.commit();
                }
                return null;
            });
            latch.release();
            other.waitUntilWaiting(details -> details.isAt(ForsetiClient.class, "acquireShared"));
            this.commit();
            future.get();
        }
    }

    @Test
    void shouldMakeSureWeBlockOtherThreadsFromCreatingRelationship() throws Throwable {
        IndexDescriptor index = this.createUniquenessConstraint(this.relationshipTypeId, this.propertyId1);
        Value value = Values.of((Object)"value");
        Race race = new Race();
        AtomicInteger readCounter = new AtomicInteger();
        AtomicInteger writeCounter = new AtomicInteger();
        int contestants = Runtime.getRuntime().availableProcessors();
        race.addContestants(contestants, Race.throwing(() -> {
            try (KernelTransaction tx = this.kernel.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);){
                try (RelationshipValueIndexCursor cursor = tx.cursors().allocateRelationshipValueIndexCursor(tx.cursorContext(), tx.memoryTracker());){
                    long relId = tx.dataRead().lockingRelationshipUniqueIndexSeek(index, cursor, new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)this.propertyId1, (Object)value)});
                    if (relId == -1L) {
                        Write write = tx.dataWrite();
                        relId = write.relationshipCreate(write.nodeCreate(), this.relationshipTypeId, write.nodeCreate());
                        write.relationshipSetProperty(relId, this.propertyId1, value);
                        writeCounter.incrementAndGet();
                    } else {
                        readCounter.incrementAndGet();
                    }
                }
                tx.commit();
            }
        }));
        race.go();
        Assertions.assertEquals((int)(contestants - 1), (int)readCounter.get());
        Assertions.assertEquals((int)1, (int)writeCounter.get());
    }

    private static boolean isNoSuchRelationship(long foundId) {
        return -1L == foundId;
    }

    private long createRelationshipWithValue(Value value) throws KernelException {
        Write write = this.dataWriteInNewTransaction();
        long relId = write.relationshipCreate(write.nodeCreate(), this.relationshipTypeId, write.nodeCreate());
        write.relationshipSetProperty(relId, this.propertyId1, value);
        this.commit();
        return relId;
    }

    private long createRelationshipWithValues(Value value1, Value value2) throws KernelException {
        Write write = this.dataWriteInNewTransaction();
        long relId = write.relationshipCreate(write.nodeCreate(), this.relationshipTypeId, write.nodeCreate());
        write.relationshipSetProperty(relId, this.propertyId1, value1);
        write.relationshipSetProperty(relId, this.propertyId2, value2);
        this.commit();
        return relId;
    }

    private IndexDescriptor createUniquenessConstraint(int typeId, int ... propertyIds) throws Exception {
        KernelTransaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        RelationTypeSchemaDescriptor schema = SchemaDescriptors.forRelType((int)typeId, (int[])propertyIds);
        ConstraintDescriptor constraint = transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)schema));
        IndexDescriptor index = transaction.schemaRead().indexGetForName(constraint.getName());
        this.commit();
        return index;
    }
}

