/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.ObjectArrayAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.entry.LogSegments;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;

@DbmsExtension(configurationCallback="configure")
public class CheckpointLogPruningIT {
    static final long CONFIG_ROTATION_THRESHOLD = ByteUnit.kibiBytes((long)1L);
    static final long ACTUAL_ROTATION_THRESHOLD = (long)LogSegments.DEFAULT_LOG_SEGMENT_SIZE * 2L;
    static final String CHECKPOINT_REASON = "checkpoint for rotation test";
    static final LogPosition LOG_POSITION = new LogPosition(1000L, 12345L);
    static final TransactionId TRANSACTION_ID = new TransactionId(100L, 101, 102L, 103L);
    @Inject
    private LogFiles logFiles;
    @Inject
    private CheckPointer checkPointer;

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseInternalSettings.checkpoint_logical_log_rotation_threshold, (Object)CONFIG_ROTATION_THRESHOLD).setConfig(GraphDatabaseInternalSettings.checkpoint_logical_log_keep_threshold, (Object)2);
    }

    @Test
    void pruneObsoleteCheckpointLogFiles() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        CheckpointLogPruningIT.fillWithCheckpoints(4, checkpointFile.getCheckpointAppender());
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo(CHECKPOINT_REASON));
        Object[] matchedFiles = checkpointFile.getDetachedCheckpointFiles();
        Assertions.assertThat((Object[])matchedFiles).hasSize(2);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])matchedFiles).areAtLeastOne(CheckpointLogPruningIT.fileNameCondition("checkpoint.3"))).areAtLeastOne(CheckpointLogPruningIT.fileNameCondition("checkpoint.4"));
    }

    @Test
    void doNotPruneFilesUntilConfigured() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        CheckpointLogPruningIT.fillWithCheckpoints(1, checkpointFile.getCheckpointAppender());
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo(CHECKPOINT_REASON));
        Object[] matchedFiles = checkpointFile.getDetachedCheckpointFiles();
        Assertions.assertThat((Object[])matchedFiles).hasSize(2);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])matchedFiles).areAtLeastOne(CheckpointLogPruningIT.fileNameCondition("checkpoint.0"))).areAtLeastOne(CheckpointLogPruningIT.fileNameCondition("checkpoint.1"));
    }

    @Test
    void pruneAsSoonAsHaveAnyEligibleFiles() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        CheckpointLogPruningIT.fillWithCheckpoints(2, checkpointFile.getCheckpointAppender());
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo(CHECKPOINT_REASON));
        Object[] matchedFiles = checkpointFile.getDetachedCheckpointFiles();
        Assertions.assertThat((Object[])matchedFiles).hasSize(2);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])matchedFiles).areAtLeastOne(CheckpointLogPruningIT.fileNameCondition("checkpoint.1"))).areAtLeastOne(CheckpointLogPruningIT.fileNameCondition("checkpoint.2"));
    }

    private static void fillWithCheckpoints(int files, CheckpointAppender appender) throws IOException {
        for (int fileCount = 0; fileCount < files; ++fileCount) {
            int startOffset;
            int i = startOffset = LatestVersions.LATEST_LOG_FORMAT.getHeaderSize() + (fileCount == 0 ? 232 : 0);
            while ((long)i < ACTUAL_ROTATION_THRESHOLD) {
                appender.checkPoint(LogCheckPointEvent.NULL, TRANSACTION_ID, LatestVersions.LATEST_KERNEL_VERSION, LOG_POSITION, Instant.now(), CHECKPOINT_REASON);
                i += 232;
            }
        }
    }

    private static Condition<Path> fileNameCondition(final String name) {
        return new Condition<Path>(){

            public boolean matches(Path file) {
                return name.equals(file.getFileName().toString());
            }
        };
    }
}

