/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.kernel.api.database.transaction.LogChannel;
import org.neo4j.kernel.api.database.transaction.TransactionLogChannels;
import org.neo4j.kernel.api.database.transaction.TransactionLogService;
import org.neo4j.kernel.availability.AvailabilityRequirement;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.availability.DescriptiveAvailabilityRequirement;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFile;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFileInformation;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitorAdapter;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.ClosedTransactionMetadata;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;

@DbmsExtension(configurationCallback="configure")
class TransactionLogServiceIT {
    private static final long THRESHOLD = ByteUnit.kibiBytes((long)128L);
    @Inject
    private GraphDatabaseAPI databaseAPI;
    @Inject
    private DatabaseManagementService managementService;
    @Inject
    private TransactionLogService logService;
    @Inject
    private LogFiles logFiles;
    @Inject
    private CheckPointer checkPointer;
    @Inject
    private LogicalTransactionStore transactionStore;
    @Inject
    private MetadataProvider metadataProvider;
    @Inject
    private DatabaseAvailabilityGuard availabilityGuard;

    TransactionLogServiceIT() {
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)THRESHOLD).setConfig(GraphDatabaseSettings.keep_logical_logs, (Object)"1 files");
    }

    @Test
    void rotationDuringTransactionLogReadingKeepNonAffectedChannelsOpen() throws IOException {
        String propertyValue = RandomStringUtils.randomAscii((int)((int)THRESHOLD));
        this.createNodeInIsolatedTransaction("any");
        int numberOfTransactions = 30;
        long lastCommittedBeforeWorkload = this.metadataProvider.getLastCommittedTransactionId();
        for (int i = 0; i < numberOfTransactions; ++i) {
            this.createNodeInIsolatedTransaction(propertyValue);
        }
        try (TransactionLogChannels logReaders = this.logService.logFilesChannels(lastCommittedBeforeWorkload + 29L);){
            List logFileChannels = logReaders.getChannels();
            Assertions.assertThat((List)logFileChannels).hasSize(2);
            Assertions.assertThat((Object[])this.logFiles.logFiles()).hasSizeGreaterThanOrEqualTo(numberOfTransactions);
            this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("Test checkpoint"));
            Assertions.assertThat((Object[])this.logFiles.logFiles()).hasSize(4);
            for (LogChannel logChannel : logFileChannels) {
                StoreChannel channel = logChannel.channel();
                org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.isOpen());
                org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> channel.size());
            }
        }
    }

    @Test
    void rotationDuringTransactionLogReading() throws IOException {
        String propertyValue = RandomStringUtils.randomAscii((int)((int)THRESHOLD));
        int numberOfTransactions = 30;
        for (int i = 0; i < numberOfTransactions; ++i) {
            this.createNodeInIsolatedTransaction(propertyValue);
        }
        try (TransactionLogChannels logReaders = this.logService.logFilesChannels(2L);){
            StoreChannel channel;
            List logFileChannels = logReaders.getChannels();
            Assertions.assertThat((List)logFileChannels).hasSizeGreaterThanOrEqualTo(numberOfTransactions);
            Assertions.assertThat((Object[])this.logFiles.logFiles()).hasSizeGreaterThanOrEqualTo(numberOfTransactions);
            this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("Test checkpoint"));
            int txLogsAfterCheckpoint = 3;
            int visibleTxLogsAfterCheckpoints = txLogsAfterCheckpoint - 1;
            int checkpointLogs = 1;
            Assertions.assertThat((Object[])this.logFiles.logFiles()).hasSize(txLogsAfterCheckpoint + checkpointLogs);
            List closedChannels = logFileChannels.subList(0, logFileChannels.size() - visibleTxLogsAfterCheckpoints);
            List openChannels = logFileChannels.subList(logFileChannels.size() - visibleTxLogsAfterCheckpoints, logFileChannels.size());
            org.junit.jupiter.api.Assertions.assertEquals((int)(closedChannels.size() + openChannels.size()), (int)logFileChannels.size());
            for (LogChannel logChannel : closedChannels) {
                channel = logChannel.channel();
                org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.isOpen());
                org.junit.jupiter.api.Assertions.assertThrows(ClosedChannelException.class, () -> channel.size());
            }
            for (LogChannel logChannel : openChannels) {
                channel = logChannel.channel();
                org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.isOpen());
                org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> channel.size());
            }
        }
    }

    @Test
    void closingReadersDoesAutomaticCleanup() throws Exception {
        String propertyValue = RandomStringUtils.randomAscii((int)((int)THRESHOLD));
        int numberOfTransactions = 30;
        for (int i = 0; i < numberOfTransactions; ++i) {
            this.createNodeInIsolatedTransaction(propertyValue);
        }
        try (TransactionLogChannels logReaders = this.logService.logFilesChannels(2L);){
            List logFileChannels = logReaders.getChannels();
            Assertions.assertThat((List)logFileChannels).hasSizeGreaterThanOrEqualTo(numberOfTransactions);
            Assertions.assertThat((Object[])this.logFiles.logFiles()).hasSizeGreaterThanOrEqualTo(numberOfTransactions);
            Assertions.assertThat((Map)((TransactionLogFile)this.logFiles.getLogFile()).getExternalFileReaders()).isNotEmpty();
        }
        Assertions.assertThat((Map)((TransactionLogFile)this.logFiles.getLogFile()).getExternalFileReaders()).isEmpty();
    }

    @Test
    void requestLogFileChannelsOfInvalidTransactions() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.logService.logFilesChannels(-1L));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.logService.logFilesChannels(100L));
    }

    @Test
    void requireDirectByteBufferForLogFileAppending() {
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.logService.append(ByteBuffer.allocate(5), OptionalLong.empty()));
    }

    @Test
    void logFileChannelsAreNonWritable() throws IOException {
        this.createNodeInIsolatedTransaction("a");
        this.createNodeInIsolatedTransaction("b");
        this.createNodeInIsolatedTransaction("c");
        try (TransactionLogChannels logReaders = this.logService.logFilesChannels(2L);){
            List logFileChannels = logReaders.getChannels();
            Assertions.assertThat((List)logFileChannels).hasSize(1);
            LogChannel channel = (LogChannel)logFileChannels.get(0);
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)channel.startTxId());
            StoreChannel storeChannel = channel.channel();
            org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> storeChannel.writeAll(ByteBuffers.allocate((int)1, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE)));
            org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> storeChannel.writeAll(ByteBuffers.allocate((int)1, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE), 1L));
            org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> storeChannel.truncate(1L));
            org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> storeChannel.write(ByteBuffers.allocate((int)1, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE)));
            org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> storeChannel.write(new ByteBuffer[0], 1, 1));
            org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> storeChannel.write(new ByteBuffer[0]));
        }
    }

    @Test
    void setsStartingTransactionIdCorrectlyForAllFiles() throws IOException {
        String propertyValue = RandomStringUtils.randomAscii((int)((int)THRESHOLD / 2));
        int numberOfTransactions = 40;
        for (int i = 0; i < numberOfTransactions; ++i) {
            this.createNodeInIsolatedTransaction(propertyValue);
        }
        int initialTxId = 17;
        try (TransactionLogChannels logReaders = this.logService.logFilesChannels((long)initialTxId);){
            List logFileChannels = logReaders.getChannels();
            Assertions.assertThat((List)logFileChannels).hasSize(14);
            long prevLastTxId = -1L;
            for (LogChannel logChannel : logFileChannels) {
                if (prevLastTxId != -1L) {
                    Assertions.assertThat((long)logChannel.startTxId()).isEqualTo(prevLastTxId + 1L);
                }
                prevLastTxId = logChannel.lastTxId();
            }
        }
    }

    @Test
    void setsLastTransactionIdCorrectlyForAllFiles() throws IOException {
        String propertyValue = RandomStringUtils.randomAscii((int)((int)THRESHOLD / 2));
        int numberOfTransactions = 40;
        for (int i = 0; i < numberOfTransactions; ++i) {
            this.createNodeInIsolatedTransaction(propertyValue);
        }
        int initialTxId = 17;
        try (TransactionLogChannels logReaders = this.logService.logFilesChannels((long)initialTxId);){
            List logFileChannels = logReaders.getChannels();
            Assertions.assertThat((List)logFileChannels).hasSize(14);
            long prevLastTxId = -1L;
            for (LogChannel logChannel : logFileChannels) {
                if (prevLastTxId != -1L) {
                    Assertions.assertThat((long)prevLastTxId).isEqualTo(logChannel.startTxId() - 1L);
                }
                prevLastTxId = logChannel.lastTxId();
            }
        }
    }

    @Test
    void endOffsetPositionedToEndOfFileOrLastClosedTransaction() throws IOException {
        String propertyValue = RandomStringUtils.randomAscii((int)((int)THRESHOLD));
        int numberOfTransactions = 30;
        for (int i = 0; i < numberOfTransactions; ++i) {
            this.createNodeInIsolatedTransaction(propertyValue);
        }
        try (TransactionLogChannels logReaders = this.logService.logFilesChannels(2L);){
            List channels = logReaders.getChannels();
            List fullChannels = channels.subList(0, channels.size() - 1);
            for (LogChannel fullChannel : fullChannels) {
                Assertions.assertThat((long)fullChannel.endOffset()).isEqualTo(fullChannel.channel().size());
            }
            LogChannel lastChannel = (LogChannel)channels.get(channels.size() - 1);
            ClosedTransactionMetadata lastClosedTransaction = this.metadataProvider.getLastClosedTransaction();
            Assertions.assertThat((long)lastChannel.endOffset()).isEqualTo(lastClosedTransaction.logPosition().getByteOffset());
        }
    }

    @Test
    void firstLogChannelIsProperlyPositionedToInitialTransaction() throws IOException {
        int numberOfTransactions = 20;
        for (int i = 0; i < numberOfTransactions; ++i) {
            this.createNodeInIsolatedTransaction("abc");
        }
        this.verifyReportedPositions(2, this.getTxOffset(2));
        this.verifyReportedPositions(3, this.getTxOffset(3));
        this.verifyReportedPositions(4, this.getTxOffset(4));
        this.verifyReportedPositions(5, this.getTxOffset(5));
        this.verifyReportedPositions(15, this.getTxOffset(15));
    }

    @Test
    void failBulkAppendOnNonAvailableDatabase() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.logService.append(ByteBuffer.wrap(new byte[]{1, 2, 3, 4, 5}), OptionalLong.empty()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void bulkAppendToTransactionLogsDoesNotChangeLastCommittedTransactionOffset() throws IOException {
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        ClosedTransactionMetadata metadataBefore = this.metadataProvider.getLastClosedTransaction();
        ByteBuffer buffer = TransactionLogServiceIT.createBuffer().put(new byte[]{1, 2, 3, 4, 5});
        try {
            for (int i = 0; i < 100; ++i) {
                buffer.rewind();
                this.logService.append(buffer, OptionalLong.empty());
            }
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)metadataBefore, (Object)this.metadataProvider.getLastClosedTransaction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void bulkAppendWithRotationDoesNotChangeLastClosedMetadata() throws IOException {
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        ClosedTransactionMetadata metadataBefore = this.metadataProvider.getLastClosedTransaction();
        long logVersionBefore = this.metadataProvider.getCurrentLogVersion();
        int appendIterations = 100;
        ByteBuffer appendData = TransactionLogServiceIT.createBuffer().put(RandomStringUtils.randomAscii((int)((int)(THRESHOLD + 1L))).getBytes(StandardCharsets.UTF_8));
        try {
            for (int i = 0; i < appendIterations; ++i) {
                this.logService.append(appendData, OptionalLong.of(i));
                appendData.rewind();
            }
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)appendData, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)metadataBefore, (Object)this.metadataProvider.getLastClosedTransaction());
        Object[] matchedFiles = this.logFiles.getLogFile().getMatchedFiles();
        Assertions.assertThat((Object[])matchedFiles).hasSize((int)(logVersionBefore + (long)appendIterations));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void bulkAppendWithRotationUpdatesMetadataProviderLogVersion() throws IOException {
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        long logVersionBefore = this.metadataProvider.getCurrentLogVersion();
        int appendIterations = 100;
        ByteBuffer appendData = TransactionLogServiceIT.createBuffer().put(RandomStringUtils.randomAscii((int)((int)(THRESHOLD + 1L))).getBytes(StandardCharsets.UTF_8));
        try {
            for (int i = 0; i < appendIterations; ++i) {
                this.logService.append(appendData, OptionalLong.of(i));
                appendData.rewind();
            }
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)appendData, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        long logVersionAfter = this.metadataProvider.getCurrentLogVersion();
        Assertions.assertThat((long)logVersionAfter).isEqualTo(logVersionBefore + (long)appendIterations - 1L).isNotEqualTo(logVersionBefore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void bulkAppendRotatedLogFilesHaveCorrectSupplierTransactionsFromHeader() throws IOException {
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        long logVersionBefore = this.metadataProvider.getCurrentLogVersion();
        int appendIterations = 100;
        int transactionalShift = 10;
        ByteBuffer appendData = TransactionLogServiceIT.createBuffer().put(RandomStringUtils.randomAscii((int)((int)(THRESHOLD + 1L))).getBytes(StandardCharsets.UTF_8));
        try {
            for (int i = 0; i < appendIterations; ++i) {
                this.logService.append(appendData, OptionalLong.of(transactionalShift + i));
                appendData.rewind();
            }
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)appendData, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        LogFile logFile = this.logFiles.getLogFile();
        TransactionLogFileInformation logFileInformation = logFile.getLogFileInformation();
        int version = (int)logVersionBefore + 1;
        while ((long)version < logVersionBefore + (long)appendIterations) {
            org.junit.jupiter.api.Assertions.assertEquals((long)(transactionalShift + version), (long)logFileInformation.getFirstEntryId((long)version));
            ++version;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void replayTransactionAfterBulkAppendOnNextRestart() throws IOException {
        LogPosition positionBeforeRecovery;
        GraphDatabaseAPI systemDatabase = (GraphDatabaseAPI)this.managementService.database("system");
        Assumptions.assumeThat((Object)((StorageEngineFactory)systemDatabase.getDependencyResolver().resolveDependency(StorageEngineFactory.class))).isEqualTo(this.databaseAPI.getDependencyResolver().resolveDependency(StorageEngineFactory.class));
        MetadataProvider systemMetadata = (MetadataProvider)systemDatabase.getDependencyResolver().resolveDependency(MetadataProvider.class);
        LogPosition positionBeforeTransaction = systemMetadata.getLastClosedTransaction().logPosition();
        for (int i = 0; i < 3; ++i) {
            try (Transaction transaction = systemDatabase.beginTx();){
                transaction.createNode();
                transaction.commit();
                continue;
            }
        }
        LogPosition positionAfterTransaction = systemMetadata.getLastClosedTransaction().logPosition();
        long systemLastClosedTransactionId = systemMetadata.getLastClosedTransactionId();
        ByteBuffer buffer = this.readTransactionIntoBuffer(systemDatabase, positionBeforeTransaction, positionAfterTransaction);
        try {
            this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
            long lastTransactionBeforeBufferAppend = this.metadataProvider.getLastClosedTransaction().transactionId();
            positionBeforeRecovery = this.metadataProvider.getLastClosedTransaction().logPosition();
            for (int i = 0; i < 3; ++i) {
                this.logService.append(buffer, OptionalLong.of(lastTransactionBeforeBufferAppend + (long)i + 1L));
                buffer.rewind();
            }
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        Database database = (Database)this.databaseAPI.getDependencyResolver().resolveDependency(Database.class);
        database.stop();
        database.start();
        MetadataProvider restartedProvider = (MetadataProvider)database.getDependencyResolver().resolveDependency(MetadataProvider.class);
        org.junit.jupiter.api.Assertions.assertEquals((long)systemLastClosedTransactionId, (long)restartedProvider.getLastClosedTransactionId());
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)positionBeforeRecovery, (Object)restartedProvider.getLastClosedTransaction().logPosition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void bulkAppendRotatedLogFilesMonitorEvents() throws IOException {
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        BulkAppendLogRotationMonitor monitorListener = new BulkAppendLogRotationMonitor();
        ((Monitors)this.databaseAPI.getDependencyResolver().resolveDependency(Monitors.class)).addMonitorListener((Object)monitorListener, new String[0]);
        int appendIterations = 100;
        int transactionalShift = 10;
        ByteBuffer appendData = TransactionLogServiceIT.createBuffer().put(RandomStringUtils.randomAscii((int)((int)(THRESHOLD + 1L))).getBytes(StandardCharsets.UTF_8));
        try {
            for (int i = 0; i < appendIterations; ++i) {
                this.logService.append(appendData, OptionalLong.of(transactionalShift + i));
                appendData.rewind();
            }
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)appendData, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        List<Long> observedVersions = monitorListener.getObservedVersions();
        ((ListAssert)Assertions.assertThat(observedVersions).hasSize(99)).containsExactlyElementsOf((Iterable)LongStream.range(0L, 99L).boxed().collect(Collectors.toList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void bulkAppendRotatedLogFilesTracingEvents() throws IOException {
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        DatabaseTracers databaseTracers = (DatabaseTracers)this.databaseAPI.getDependencyResolver().resolveDependency(DatabaseTracers.class);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)databaseTracers.getDatabaseTracer().numberOfLogRotations());
        int appendIterations = 100;
        int transactionalShift = 10;
        ByteBuffer appendData = TransactionLogServiceIT.createBuffer().put(RandomStringUtils.randomAscii((int)((int)(THRESHOLD + 1L))).getBytes(StandardCharsets.UTF_8));
        try {
            for (int i = 0; i < appendIterations; ++i) {
                this.logService.append(appendData, OptionalLong.of(transactionalShift + i));
                appendData.rewind();
            }
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)appendData, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        int expectedRotations = appendIterations - 1;
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedRotations, (long)databaseTracers.getDatabaseTracer().numberOfLogRotations());
    }

    @Test
    void restoreRequireNonAvailableDatabase() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.logService.restore(LogPosition.UNSPECIFIED));
    }

    @Test
    void failToRestoreWithLogPositionInHigherLogFile() {
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.logService.restore(new LogPosition(this.metadataProvider.getCurrentLogVersion() + 5L, 100L))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Log position requested for restore points to the log file that is higher than existing available highest log file. Requested restore position: LogPosition{logVersion=5, byteOffset=100}, current log file version: 0.");
    }

    @Test
    void failToRestoreWithLogPositionInCommittedFile() {
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.logService.restore(new LogPosition(this.metadataProvider.getCurrentLogVersion() - 1L, 100L))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Log position requested to be used for restore belongs to the log file that was already appended by transaction and cannot be restored.").hasMessageContaining("requested restore: LogPosition{logVersion=-1, byteOffset=100}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void restoreOnCurrentLogVersion() throws IOException {
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        long logVersionBefore = this.metadataProvider.getCurrentLogVersion();
        int appendIterations = 100;
        LogPosition previousPosition = null;
        ByteBuffer appendData = TransactionLogServiceIT.createBuffer().put(RandomStringUtils.randomAscii((int)((int)(THRESHOLD + 1L))).getBytes(StandardCharsets.UTF_8));
        try {
            for (int i = 0; i < appendIterations; ++i) {
                LogPosition position = this.logService.append(appendData, OptionalLong.empty());
                if (previousPosition != null) {
                    org.junit.jupiter.api.Assertions.assertEquals(previousPosition, (Object)position);
                }
                this.logService.restore(position);
                previousPosition = position;
                appendData.rewind();
            }
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)appendData, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)logVersionBefore, (long)this.logFiles.getLogFile().getHighestLogVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void restoreInitialLogVersionAndAppend() throws IOException {
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        long logVersionBefore = this.metadataProvider.getCurrentLogVersion();
        ByteBuffer appendData = TransactionLogServiceIT.createBuffer().put(RandomStringUtils.randomAscii((int)((int)(THRESHOLD + 1L))).getBytes(StandardCharsets.UTF_8));
        try {
            int appendIterations = 100;
            LogPosition firstPosition = null;
            for (int i = 0; i < appendIterations; ++i) {
                LogPosition position = this.logService.append(appendData, OptionalLong.of(i + 5));
                if (firstPosition == null) {
                    firstPosition = position;
                }
                appendData.rewind();
            }
            Assertions.assertThat((long)this.logFiles.getLogFile().getHighestLogVersion()).isGreaterThanOrEqualTo(firstPosition.getLogVersion());
            this.logService.restore(firstPosition);
            org.junit.jupiter.api.Assertions.assertEquals((Object)firstPosition, (Object)this.logService.append(appendData, OptionalLong.of(5L)));
            org.junit.jupiter.api.Assertions.assertEquals((long)logVersionBefore, (long)this.logFiles.getLogFile().getHighestLogVersion());
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)appendData, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
    }

    private ByteBuffer readTransactionIntoBuffer(GraphDatabaseAPI db, LogPosition positionBeforeTransaction, LogPosition positionAfterTransaction) throws IOException {
        int length = (int)(positionAfterTransaction.getByteOffset() - positionBeforeTransaction.getByteOffset());
        byte[] data = new byte[length];
        LogFiles systemLogFiles = (LogFiles)db.getDependencyResolver().resolveDependency(LogFiles.class);
        try (ReadableLogChannel reader = systemLogFiles.getLogFile().getReader(positionBeforeTransaction);){
            reader.get(data, length);
        }
        return TransactionLogServiceIT.createBuffer(length).put(data);
    }

    private long getTxOffset(int txId) throws IOException {
        return this.transactionStore.getTransactions((long)txId).position().getByteOffset();
    }

    private void verifyReportedPositions(int txId, long expectedOffset) throws IOException {
        try (TransactionLogChannels logReaders = this.logService.logFilesChannels((long)txId);){
            List logFileChannels = logReaders.getChannels();
            Assertions.assertThat((List)logFileChannels).hasSize(1);
            org.junit.jupiter.api.Assertions.assertEquals((long)expectedOffset, (long)((LogChannel)logFileChannels.get(0)).channel().position());
        }
    }

    private void createNodeInIsolatedTransaction(String propertyValue) {
        try (Transaction tx = this.databaseAPI.beginTx();){
            Node node = tx.createNode();
            node.setProperty("a", (Object)propertyValue);
            tx.commit();
        }
    }

    private static ByteBuffer createBuffer(int length) {
        return ByteBuffers.allocateDirect((int)length, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    private static ByteBuffer createBuffer() {
        return ByteBuffers.allocateDirect((int)((int)(THRESHOLD << 1)), (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    private static class BulkAppendLogRotationMonitor
    extends LogRotationMonitorAdapter {
        private final List<Long> versions = new CopyOnWriteArrayList<Long>();

        private BulkAppendLogRotationMonitor() {
        }

        public void finishLogRotation(Path logFile, long logVersion, long lastTransactionId, long rotationMillis, long millisSinceLastRotation) {
            this.versions.add(logVersion);
        }

        public List<Long> getObservedVersions() {
            return this.versions;
        }
    }
}

