/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.helpers.Strings;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Values;

public abstract class IndexProviderApprovalTest {
    private static Map<TestValue, Set<Object>> noIndexRun;
    private static Map<TestValue, Set<Object>> indexRun;
    public static final String LABEL = "Person";
    private static final String PROPERTY_KEY = "name";
    private static final Function<Node, Object> PROPERTY_EXTRACTOR;

    public static void setupBeforeAllTests(DatabaseManagementService managementService, IndexType indexType) {
        GraphDatabaseService db = managementService.database("neo4j");
        for (TestValue value : TestValue.values()) {
            IndexProviderApprovalTest.createNode(db, PROPERTY_KEY, value.value);
        }
        noIndexRun = IndexProviderApprovalTest.runFindByLabelAndProperty(db);
        IndexProviderApprovalTest.createIndex(db, indexType, Label.label((String)LABEL), PROPERTY_KEY);
        indexRun = IndexProviderApprovalTest.runFindByLabelAndProperty(db);
        managementService.shutdown();
    }

    @ParameterizedTest
    @EnumSource(value=TestValue.class)
    public void test(TestValue currentValue) {
        Set noIndexResult = Iterables.asSet((Iterable)noIndexRun.get((Object)currentValue));
        Set indexResult = Iterables.asSet((Iterable)indexRun.get((Object)currentValue));
        String errorMessage = currentValue.toString();
        if (!noIndexResult.equals(indexResult)) {
            System.out.println("");
        }
        Assertions.assertEquals((Object)noIndexResult, (Object)indexResult, (String)errorMessage);
    }

    private static Map<TestValue, Set<Object>> runFindByLabelAndProperty(GraphDatabaseService db) {
        HashMap<TestValue, Set<Object>> results = new HashMap<TestValue, Set<Object>>();
        try (Transaction tx = db.beginTx();){
            for (TestValue value : TestValue.values()) {
                IndexProviderApprovalTest.addToResults(tx, results, value);
            }
            tx.commit();
        }
        return results;
    }

    private static void createNode(GraphDatabaseService db, String propertyKey, Object value) {
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)LABEL)});
            node.setProperty(propertyKey, value);
            tx.commit();
        }
    }

    private static void addToResults(Transaction tx, Map<TestValue, Set<Object>> results, TestValue value) {
        try (ResourceIterator foundNodes = tx.findNodes(Label.label((String)LABEL), PROPERTY_KEY, value.value);){
            results.put(value, Iterators.asSet((Iterator)Iterators.map(PROPERTY_EXTRACTOR, (Iterator)foundNodes)));
        }
    }

    private static void createIndex(GraphDatabaseService db, IndexType indexType, Label label, String ... properties) {
        IndexDefinition indexDef;
        try (Transaction tx = db.beginTx();){
            IndexCreator indexCreator = tx.schema().indexFor(label).withIndexType(indexType);
            for (String property : properties) {
                indexCreator = indexCreator.on(property);
            }
            indexDef = indexCreator.create();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexOnline(indexDef, 1L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    static {
        PROPERTY_EXTRACTOR = node -> {
            Object value = node.getProperty(PROPERTY_KEY);
            if (value.getClass().isArray()) {
                return new ArrayEqualityObject(value);
            }
            return value;
        };
    }

    public static enum TestValue {
        BOOLEAN_TRUE(true),
        BOOLEAN_FALSE(false),
        STRING_TRUE("true"),
        STRING_FALSE("false"),
        STRING_UPPER_A("A"),
        STRING_LOWER_A("a"),
        CHAR_UPPER_A(Character.valueOf('A')),
        CHAR_LOWER_A(Character.valueOf('a')),
        INT_42(42),
        LONG_42(42L),
        LARGE_LONG_1(0x4000000000000001L),
        LARGE_LONG_2(0x4000000000000003L),
        BYTE_42((byte)42),
        DOUBLE_42(42.0),
        DOUBLE_42andAHalf(42.5),
        SHORT_42((short)42),
        FLOAT_42(Float.valueOf(42.0f)),
        FLOAT_42andAHalf(Float.valueOf(42.5f)),
        POINT_123456_GPS(Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84, (double[])new double[]{12.3, 45.6})),
        POINT_123456_CAR(Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{123.0, 456.0})),
        POINT_123456_GPS_3D(Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84_3D, (double[])new double[]{12.3, 45.6, 78.9})),
        POINT_123456_CAR_3D(Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN_3D, (double[])new double[]{123.0, 456.0, 789.0})),
        ARRAY_OF_INTS(new int[]{1, 2, 3}),
        ARRAY_OF_LONGS(new long[]{1L, 2L, 3L}),
        ARRAY_OF_LARGE_LONGS_1(new long[]{0x4000000000000001L}),
        ARRAY_OF_LARGE_LONGS_2(new long[]{0x4000000000000002L}),
        ARRAY_OF_LARGE_LONGS_3(new Long[]{4611686018425387907L}),
        ARRAY_OF_LARGE_LONGS_4(new Long[]{4611686018425387908L}),
        ARRAY_OF_BOOL_LIKE_STRING(new String[]{"true", "false", "true"}),
        ARRAY_OF_BOOLS(new boolean[]{true, false, true}),
        ARRAY_OF_DOUBLES(new double[]{1.0, 2.0, 3.0}),
        ARRAY_OF_STRING(new String[]{"1", "2", "3"}),
        EMPTY_ARRAY_OF_INTS(new int[0]),
        EMPTY_ARRAY_OF_LONGS(new long[0]),
        EMPTY_ARRAY_OF_BOOLS(new boolean[0]),
        EMPTY_ARRAY_OF_DOUBLES(new double[0]),
        EMPTY_ARRAY_OF_STRING(new String[0]),
        ONE(new String[]{"", "||"}),
        OTHER(new String[]{"||", ""}),
        ANOTHER_ARRAY_OF_STRING(new String[]{"1|2|3"}),
        ARRAY_OF_CHAR(new char[]{'1', '2', '3'}),
        ARRAY_OF_POINTS_GPS(new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84, (double[])new double[]{12.3, 45.6})}),
        ARRAY_OF_POINTS_CAR(new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{123.0, 456.0})}),
        ARRAY_OF_POINTS_GPS_3D(new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84_3D, (double[])new double[]{12.3, 45.6, 78.9})}),
        ARRAY_OF_POINTS_CAR_3D(new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN_3D, (double[])new double[]{123.0, 456.0, 789.0})});

        private final Object value;

        private TestValue(Object value) {
            this.value = value;
        }
    }

    private static class ArrayEqualityObject {
        private final Object array;

        ArrayEqualityObject(Object array) {
            this.array = array;
        }

        public int hashCode() {
            return ArrayUtils.hashCode((Object)this.array);
        }

        public boolean equals(Object obj) {
            return obj instanceof ArrayEqualityObject && Objects.deepEquals(this.array, ((ArrayEqualityObject)obj).array);
        }

        public String toString() {
            return Strings.prettyPrint((Object)this.array);
        }
    }
}

