/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.RawIterator;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

class SchemaProcedureIT
extends KernelIntegrationTest {
    SchemaProcedureIT() {
    }

    @Test
    void testEmptyGraph() throws Throwable {
        Procedures procs = this.procs();
        RawIterator stream = procs.procedureCallRead(procs.procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "schema", "visualization"})).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
        Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).containsExactly((Object[])new AnyValue[][]{{VirtualValues.EMPTY_LIST, VirtualValues.EMPTY_LIST}});
    }

    @Test
    void testLabelIndex() throws Throwable {
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long nbrIndexesOnStartup = Iterators.count((Iterator)transaction.schemaRead().indexesGetAll());
        long nodeId = transaction.dataWrite().nodeCreate();
        int labelId = transaction.tokenWrite().labelGetOrCreateForName("Person");
        transaction.dataWrite().nodeAddLabel(nodeId, labelId);
        int propertyIdName = transaction.tokenWrite().propertyKeyGetOrCreateForName("name");
        int propertyIdAge = transaction.tokenWrite().propertyKeyGetOrCreateForName("age");
        transaction.dataWrite().nodeSetProperty(nodeId, propertyIdName, Values.of((Object)"Emil"));
        this.commit();
        SchemaWrite schemaOps = this.schemaWriteInNewTransaction();
        schemaOps.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propertyIdName})).withName("my index"));
        String constraintName = "constraint name";
        schemaOps.uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propertyIdAge})).withName(constraintName));
        this.commit();
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "schema", "visualization"})).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
        while (stream.hasNext()) {
            AnyValue[] next = (AnyValue[])stream.next();
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)next.length);
            ListValue nodes = (ListValue)next[0];
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)nodes.size());
            NodeValue node = (NodeValue)nodes.value(0);
            Assertions.assertThat((Iterable)node.labels()).isEqualTo((Object)Values.stringArray((String[])new String[]{"Person"}));
            org.junit.jupiter.api.Assertions.assertEquals((Object)Values.stringValue((String)"Person"), (Object)node.properties().get("name"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)VirtualValues.list((AnyValue[])new AnyValue[]{Values.stringValue((String)"name")}), (Object)node.properties().get("indexes"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)VirtualValues.list((AnyValue[])new AnyValue[]{Values.stringValue((String)("Constraint( id=" + this.constraintId(constraintName) + ", name='constraint name', type='UNIQUENESS', schema=(:Person {age}), ownedIndex=" + this.indexId(constraintName) + " )"))}), (Object)node.properties().get("constraints"));
        }
    }

    @Test
    void testRelationship() throws Throwable {
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long nodeIdPerson = transaction.dataWrite().nodeCreate();
        int labelIdPerson = transaction.tokenWrite().labelGetOrCreateForName("Person");
        transaction.dataWrite().nodeAddLabel(nodeIdPerson, labelIdPerson);
        long nodeIdLocation = transaction.dataWrite().nodeCreate();
        int labelIdLocation = transaction.tokenWrite().labelGetOrCreateForName("Location");
        transaction.dataWrite().nodeAddLabel(nodeIdLocation, labelIdLocation);
        int relationshipTypeId = transaction.tokenWrite().relationshipTypeGetOrCreateForName("LIVES_IN");
        transaction.dataWrite().relationshipCreate(nodeIdPerson, relationshipTypeId, nodeIdLocation);
        this.commit();
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "schema", "visualization"})).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
        while (stream.hasNext()) {
            AnyValue[] next = (AnyValue[])stream.next();
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)next.length);
            ListValue relationships = (ListValue)next[1];
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)relationships.size());
            RelationshipValue relationship = (RelationshipValue)relationships.value(0);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"LIVES_IN", (Object)relationship.type().stringValue());
            NodeValue start = (NodeValue)relationship.startNode();
            NodeValue end = (NodeValue)relationship.endNode();
            Assertions.assertThat((Iterable)start.labels()).isEqualTo((Object)Values.stringArray((String[])new String[]{"Person"}));
            Assertions.assertThat((Iterable)end.labels()).isEqualTo((Object)Values.stringArray((String[])new String[]{"Location"}));
        }
    }

    private long constraintId(String name) throws TransactionFailureException {
        try (KernelTransaction tx = this.newTransaction();){
            long l = tx.schemaRead().constraintGetForName(name).getId();
            return l;
        }
    }

    private long indexId(String name) throws TransactionFailureException {
        try (KernelTransaction tx = this.newTransaction();){
            long l = tx.schemaRead().indexGetForName(name).getId();
            return l;
        }
    }
}

