/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.KernelTransactionImplementationHandle;
import org.neo4j.kernel.impl.api.transaction.trace.TransactionInitializationTrace;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.builtin.TransactionId;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.time.Clocks;

@DbmsExtension
public class TransactionStatusIT {
    @Inject
    private GraphDatabaseAPI database;

    @Test
    void emptyInitializationTraceOfClosedTransaction() {
        InternalTransaction transaction = this.database.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
        KernelTransaction kernelTransaction = transaction.kernelTransaction();
        transaction.close();
        KernelTransactionImplementationHandle handle = new KernelTransactionImplementationHandle((KernelTransactionImplementation)kernelTransaction, Clocks.nanoClock());
        Assertions.assertSame((Object)TransactionInitializationTrace.NONE, (Object)handle.transactionInitialisationTrace());
    }

    @Test
    void closedTransactionEmptyConnectionsDetails() {
        InternalTransaction transaction = this.database.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
        KernelTransaction kernelTransaction = transaction.kernelTransaction();
        transaction.close();
        KernelTransactionImplementationHandle handle = new KernelTransactionImplementationHandle((KernelTransactionImplementation)kernelTransaction, Clocks.nanoClock());
        Assertions.assertFalse((boolean)handle.clientInfo().isPresent());
    }

    @Test
    void closedTransactionEmptyQueryDetails() {
        InternalTransaction transaction = this.database.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
        KernelTransaction kernelTransaction = transaction.kernelTransaction();
        transaction.close();
        KernelTransactionImplementationHandle handle = new KernelTransactionImplementationHandle((KernelTransactionImplementation)kernelTransaction, Clocks.nanoClock());
        Assertions.assertDoesNotThrow(() -> new TransactionId("test", handle.getTransactionSequenceNumber()));
    }
}

