/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.checkpoint;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.v50.LogEntryDetachedCheckpointV5_0;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointInfoFactory;
import org.neo4j.kernel.recovery.LogTailExtractor;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;

@PageCacheExtension
@Neo4jLayoutExtension
class CheckpointInfoFactoryTest {
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private PageCache pageCache;
    @Inject
    private DatabaseLayout databaseLayout;

    CheckpointInfoFactoryTest() {
    }

    @Test
    void checkpointInfoOfDetachedCheckpoint42Entry() throws IOException, URISyntaxException {
        LogPosition logPosition = new LogPosition(0L, 48820L);
        StoreId storeId = new StoreId(1645458406002L, 3689108786886031620L, "legacy", "legacy", 1, 1);
        LogPosition position = new LogPosition(0L, 448L);
        LogPosition positionAfterCheckpoint = new LogPosition(0L, 640L);
        LogPosition postReaderPosition = new LogPosition(0L, 640L);
        TransactionId transactionId = new TransactionId(73L, 614900954, 1645458411645L);
        this.prepareTestResources();
        LogTailMetadata tailMetadata = new LogTailExtractor(this.fs, this.pageCache, Config.defaults(), StorageEngineFactory.defaultStorageEngine(), DatabaseTracers.EMPTY).getTailMetadata(this.databaseLayout, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        CheckpointInfo checkpointInfo = (CheckpointInfo)tailMetadata.getLastCheckPoint().get();
        Assertions.assertEquals((Object)logPosition, (Object)checkpointInfo.transactionLogPosition());
        Assertions.assertEquals((Object)storeId, (Object)checkpointInfo.storeId());
        Assertions.assertEquals((Object)position, (Object)checkpointInfo.checkpointEntryPosition());
        Assertions.assertEquals((Object)positionAfterCheckpoint, (Object)checkpointInfo.channelPositionAfterCheckpoint());
        Assertions.assertEquals((Object)postReaderPosition, (Object)checkpointInfo.checkpointFilePostReadPosition());
        Assertions.assertEquals((Object)transactionId, (Object)checkpointInfo.transactionId());
    }

    @Test
    void checkpointInfoOfDetachedCheckpoint50Entry() {
        LogPosition logPosition = new LogPosition(0L, 1L);
        StoreId storeId = new StoreId(4L, 5L, "engine-1", "format-1", 1, 2);
        LogPosition position = new LogPosition(1L, 2L);
        LogPosition positionAfterCheckpoint = new LogPosition(3L, 4L);
        LogPosition postReaderPosition = new LogPosition(5L, 6L);
        TransactionId transactionId = new TransactionId(6L, 7, 8L);
        CheckpointInfo checkpointInfo = CheckpointInfoFactory.ofLogEntry((LogEntry)new LogEntryDetachedCheckpointV5_0(KernelVersion.LATEST, transactionId, logPosition, 2L, storeId, "checkpoint"), (LogPosition)position, (LogPosition)positionAfterCheckpoint, (LogPosition)postReaderPosition, null, null);
        Assertions.assertEquals((Object)logPosition, (Object)checkpointInfo.transactionLogPosition());
        Assertions.assertEquals((Object)storeId, (Object)checkpointInfo.storeId());
        Assertions.assertEquals((Object)position, (Object)checkpointInfo.checkpointEntryPosition());
        Assertions.assertEquals((Object)transactionId, (Object)checkpointInfo.transactionId());
        Assertions.assertEquals((Object)positionAfterCheckpoint, (Object)checkpointInfo.channelPositionAfterCheckpoint());
        Assertions.assertEquals((Object)postReaderPosition, (Object)checkpointInfo.checkpointFilePostReadPosition());
    }

    private void prepareTestResources() throws IOException, URISyntaxException {
        Path logFilesDir = this.databaseLayout.getTransactionLogsDirectory();
        FileUtils.copyFileToDirectory((Path)Path.of(this.getClass().getResource("checkpoint.0").toURI()), (Path)logFilesDir);
        FileUtils.copyFileToDirectory((Path)Path.of(this.getClass().getResource("neostore.transaction.db.0").toURI()), (Path)logFilesDir);
    }
}

