/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.annotations.Public;
import org.neo4j.capabilities.CapabilitiesRegistry;
import org.neo4j.capabilities.CapabilitiesSettings;
import org.neo4j.capabilities.Capability;
import org.neo4j.capabilities.CapabilityDeclaration;
import org.neo4j.capabilities.CapabilityProvider;
import org.neo4j.capabilities.CapabilityProviderContext;
import org.neo4j.capabilities.DBMSCapabilities;
import org.neo4j.capabilities.Name;
import org.neo4j.capabilities.Type;
import org.neo4j.collection.RawIterator;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.kernel.api.CypherScope;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;

class BuiltInDbmsProceduresIT
extends KernelIntegrationTest {
    BuiltInDbmsProceduresIT() {
    }

    @Test
    void listConfig() throws Exception {
        List<AnyValue[]> config = this.callListConfig("");
        List names = config.stream().map(o -> ((TextValue)o[0]).stringValue()).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertTrue((names.size() > 10 ? 1 : 0) != 0);
        Assertions.assertThat(names).contains((Object[])new String[]{GraphDatabaseSettings.db_format.name()});
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)names.stream().filter(n -> n.startsWith("internal")).count());
    }

    @Test
    void listConfigWithASpecificConfigName() throws Exception {
        List<AnyValue[]> config = this.callListConfig(GraphDatabaseSettings.strict_config_validation.name());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)config.size());
        Assertions.assertThat((Object[])config.get(0)).isEqualTo((Object)new AnyValue[]{Values.stringValue((String)"server.config.strict_validation.enabled"), Values.stringValue((String)"A strict configuration validation will prevent the database from starting up if unknown configuration options are specified in the neo4j settings namespace (such as dbms., cypher., etc) or if settings are declared multiple times."), Values.stringValue((String)"true"), Values.FALSE, Values.stringValue((String)"true"), Values.stringValue((String)"true"), Values.FALSE, Values.stringValue((String)"A boolean.")});
    }

    @Test
    void listClientConfig() throws Exception {
        QualifiedName procedureName = new QualifiedName("dbms", "clientConfig");
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            int procedureId = procs.procedureGet(procedureName, CypherScope.CYPHER_5).id();
            RawIterator callResult = procs.procedureCallDbms(procedureId, new AnyValue[0], ProcedureCallContext.EMPTY);
            List config = Iterators.asList((RawIterator)callResult);
            org.junit.jupiter.api.Assertions.assertEquals((int)config.size(), (int)4);
            org.junit.jupiter.api.Assertions.assertEquals((Object)Values.stringValue((String)"browser.post_connect_cmd"), (Object)((AnyValue[])config.get(0))[0]);
            org.junit.jupiter.api.Assertions.assertEquals((Object)Values.stringValue((String)"browser.remote_content_hostname_whitelist"), (Object)((AnyValue[])config.get(1))[0]);
            org.junit.jupiter.api.Assertions.assertEquals((Object)Values.stringValue((String)"client.allow_telemetry"), (Object)((AnyValue[])config.get(2))[0]);
            org.junit.jupiter.api.Assertions.assertEquals((Object)Values.stringValue((String)"dbms.security.auth_enabled"), (Object)((AnyValue[])config.get(3))[0]);
        }
    }

    @Test
    void durationAlwaysListedWithUnit() throws Exception {
        List<AnyValue[]> config = this.callListConfig(GraphDatabaseSettings.transaction_timeout.name());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)config.size());
        Assertions.assertThat((Object[])config.get(0)).isEqualTo((Object)new AnyValue[]{Values.stringValue((String)"db.transaction.timeout"), Values.stringValue((String)"The maximum time interval of a transaction within which it should be completed."), Values.stringValue((String)"0s"), Values.TRUE, Values.stringValue((String)"0s"), Values.stringValue((String)"0s"), Values.FALSE, Values.stringValue((String)"A duration (Valid units are: `ns`, `\u03bcs`, `ms`, `s`, `m`, `h` and `d`; default unit is `s`).")});
    }

    @Test
    void listDynamicSetting() throws KernelException {
        List<AnyValue[]> config = this.callListConfig(GraphDatabaseSettings.check_point_iops_limit.name());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)config.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((BooleanValue)config.get(0)[3]).booleanValue());
    }

    @Test
    void listNotDynamicSetting() throws KernelException {
        List<AnyValue[]> config = this.callListConfig(GraphDatabaseSettings.data_directory.name());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)config.size());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((BooleanValue)config.get(0)[3]).booleanValue());
    }

    @Test
    void listCapabilities() throws KernelException {
        QualifiedName procedureName = new QualifiedName("dbms", "listCapabilities");
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            int procedureId = procs.procedureGet(procedureName, CypherScope.CYPHER_5).id();
            RawIterator callResult = procs.procedureCallDbms(procedureId, new AnyValue[0], ProcedureCallContext.EMPTY);
            List capabilities = Iterators.asList((RawIterator)callResult);
            List capabilityNames = capabilities.stream().map(c -> ((TextValue)c[0]).stringValue()).collect(Collectors.toList());
            Assertions.assertThat(capabilityNames).containsExactlyInAnyOrder((Object[])new String[]{TestCapabilities.my_custom_capability.name().fullName(), TestCapabilities.my_dynamic_capability.name().fullName()});
        }
    }

    @Test
    void listCapabilitiesShouldNotReturnBlocked() throws KernelException {
        Config config = (Config)this.dependencyResolver.resolveDependency(Config.class);
        config.set(CapabilitiesSettings.dbms_capabilities_blocked, List.of("my.**"));
        QualifiedName procedureName = new QualifiedName("dbms", "listCapabilities");
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            int procedureId = procs.procedureGet(procedureName, CypherScope.CYPHER_5).id();
            RawIterator callResult = procs.procedureCallDbms(procedureId, new AnyValue[0], ProcedureCallContext.EMPTY);
            List capabilities = Iterators.asList((RawIterator)callResult);
            List capabilityNames = capabilities.stream().map(c -> ((TextValue)c[0]).stringValue()).collect(Collectors.toList());
            Assertions.assertThat(capabilityNames).doesNotContain((Object[])new String[]{TestCapabilities.my_custom_capability.name().fullName()});
        }
    }

    @Test
    void listCapabilitiesShouldReturnDynamicValues() throws KernelException {
        List capabilities;
        RawIterator callResult;
        QualifiedName procedureName = new QualifiedName("dbms", "listCapabilities");
        Procedures procs = this.procs();
        int procedureId = procs.procedureGet(procedureName, CypherScope.CYPHER_5).id();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            callResult = procs.procedureCallDbms(procedureId, new AnyValue[0], ProcedureCallContext.EMPTY);
            capabilities = Iterators.asList((RawIterator)callResult);
            Assertions.assertThat((List)capabilities).contains((Object[])new AnyValue[][]{{Values.stringValue((String)TestCapabilities.my_dynamic_capability.name().fullName()), Values.stringValue((String)TestCapabilities.my_dynamic_capability.description()), Values.booleanValue((boolean)false)}});
        }
        try (Transaction txc = this.db.beginTx();){
            txc.createNode(new Label[]{Label.label((String)"my_dynamic_capability")});
            txc.commit();
        }
        procs = this.procs();
        statement = this.kernelTransaction.acquireStatement();
        try {
            callResult = this.procs().procedureCallDbms(procedureId, new AnyValue[0], ProcedureCallContext.EMPTY);
            capabilities = Iterators.asList((RawIterator)callResult);
            Assertions.assertThat((List)capabilities).contains((Object[])new AnyValue[][]{{Values.stringValue((String)TestCapabilities.my_dynamic_capability.name().fullName()), Values.stringValue((String)TestCapabilities.my_dynamic_capability.description()), Values.booleanValue((boolean)true)}});
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    @Test
    void listAllCapabilities() throws KernelException {
        QualifiedName procedureName = new QualifiedName("dbms", "listAllCapabilities");
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            int procedureId = procs.procedureGet(procedureName, CypherScope.CYPHER_5).id();
            RawIterator callResult = procs.procedureCallDbms(procedureId, new AnyValue[0], ProcedureCallContext.EMPTY);
            List capabilities = Iterators.asList((RawIterator)callResult);
            List capabilityNames = capabilities.stream().map(c -> ((TextValue)c[0]).stringValue()).collect(Collectors.toList());
            Assertions.assertThat(capabilityNames).containsExactlyInAnyOrder((Object[])new String[]{DBMSCapabilities.dbms_instance_version.name().fullName(), DBMSCapabilities.dbms_instance_kernel_version.name().fullName(), DBMSCapabilities.dbms_instance_edition.name().fullName(), DBMSCapabilities.dbms_instance_operational_mode.name().fullName(), TestCapabilities.my_custom_capability.name().fullName(), TestCapabilities.my_internal_capability.name().fullName(), TestCapabilities.my_dynamic_capability.name().fullName()});
        }
    }

    @Test
    void listAllCapabilitiesShouldNotReturnBlocked() throws KernelException {
        Config config = (Config)this.dependencyResolver.resolveDependency(Config.class);
        config.set(CapabilitiesSettings.dbms_capabilities_blocked, List.of("my.custom.**"));
        QualifiedName procedureName = new QualifiedName("dbms", "listAllCapabilities");
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            int procedureId = procs.procedureGet(procedureName, CypherScope.CYPHER_5).id();
            RawIterator callResult = procs.procedureCallDbms(procedureId, new AnyValue[0], ProcedureCallContext.EMPTY);
            List capabilities = Iterators.asList((RawIterator)callResult);
            List capabilityNames = capabilities.stream().map(c -> ((TextValue)c[0]).stringValue()).collect(Collectors.toList());
            Assertions.assertThat(capabilityNames).containsExactlyInAnyOrder((Object[])new String[]{DBMSCapabilities.dbms_instance_version.name().fullName(), DBMSCapabilities.dbms_instance_kernel_version.name().fullName(), DBMSCapabilities.dbms_instance_edition.name().fullName(), DBMSCapabilities.dbms_instance_operational_mode.name().fullName(), TestCapabilities.my_dynamic_capability.name().fullName(), TestCapabilities.my_internal_capability.name().fullName()});
        }
    }

    private List<AnyValue[]> callListConfig(String searchString) throws KernelException {
        QualifiedName procedureName = new QualifiedName("dbms", "listConfig");
        Procedures procs = this.procs();
        try (Statement statement = this.kernelTransaction.acquireStatement();){
            int procedureId = procs.procedureGet(procedureName, CypherScope.CYPHER_5).id();
            RawIterator callResult = procs.procedureCallDbms(procedureId, (AnyValue[])ArrayUtils.toArray((Object[])new TextValue[]{Values.stringValue((String)searchString)}), ProcedureCallContext.EMPTY);
            List list = Iterators.asList((RawIterator)callResult);
            return list;
        }
    }

    public static class TestCapabilities
    implements CapabilityDeclaration,
    CapabilityProvider {
        @Public
        @Description(value="my custom capability")
        public static final Capability<Integer> my_custom_capability = new Capability(Name.of((String)"my.custom.capability"), Type.INTEGER);
        @Description(value="my internal capability")
        public static final Capability<Double> my_internal_capability = new Capability(Name.of((String)"my.internal.capability"), Type.DOUBLE);
        @Public
        @Description(value="my dynamic capability")
        public static final Capability<Boolean> my_dynamic_capability = new Capability(Name.of((String)"my.dynamic.capability"), Type.BOOLEAN);

        public String namespace() {
            return "my";
        }

        public void register(CapabilityProviderContext ctx, CapabilitiesRegistry registry) {
            registry.set(my_custom_capability, (Object)123);
            registry.supply(my_internal_capability, () -> 7.5);
            registry.supply(my_dynamic_capability, () -> {
                DatabaseManagementService dbms = ctx.dbms();
                GraphDatabaseService db = dbms.database("neo4j");
                try (Transaction txc = db.beginTx();){
                    Boolean bl;
                    block12: {
                        ResourceIterator it = txc.findNodes(Label.label((String)"my_dynamic_capability"));
                        try {
                            bl = it.stream().findAny().isPresent();
                            if (it == null) break block12;
                        }
                        catch (Throwable throwable) {
                            if (it != null) {
                                try {
                                    it.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        it.close();
                    }
                    return bl;
                }
            });
        }
    }
}

