/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.tracer.DefaultTracer;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogSegments;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.event.InternalTransactionEventListener;
import org.neo4j.kernel.recovery.RecoveryHelpers;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.Barrier;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.Race;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.UpgradeTestUtil;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
class TransactionLogsUpgradeIT {
    @Inject
    private DefaultFileSystemAbstraction fileSystem;
    @Inject
    private Neo4jLayout neo4jLayout;
    private DatabaseManagementService managementService;
    private GraphDatabaseAPI testDb;
    private CommandReaderFactory commandReaderFactory;

    TransactionLogsUpgradeIT() {
    }

    @BeforeEach
    void setUp() {
        this.startDbms(builder -> builder.setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)((long)LogSegments.DEFAULT_LOG_SEGMENT_SIZE * 3L)));
        this.commandReaderFactory = ((StorageEngineFactory)((GraphDatabaseAPI)this.managementService.database("neo4j")).getDependencyResolver().resolveDependency(StorageEngineFactory.class)).commandReaderFactory();
    }

    @AfterEach
    void tearDown() {
        this.shutdownDbms();
    }

    private TestDatabaseManagementServiceBuilder configureGloriousFutureAsLatest(TestDatabaseManagementServiceBuilder builder) {
        return builder.setConfig(GraphDatabaseInternalSettings.latest_runtime_version, (Object)DbmsRuntimeVersion.GLORIOUS_FUTURE.getVersion()).setConfig(GraphDatabaseInternalSettings.latest_kernel_version, (Object)KernelVersion.GLORIOUS_FUTURE.version());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldRotateOnKernelVersionChangeAndGetCorrectInfoInLogHeader(boolean useQueueAppender) throws Exception {
        this.shutdownDbms();
        this.startDbms(builder -> this.configureGloriousFutureAsLatest(builder).setConfig(GraphDatabaseInternalSettings.dedicated_transaction_appender, (Object)useQueueAppender));
        UpgradeTestUtil.createWriteTransaction((GraphDatabaseService)this.testDb);
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)this.testDb, (KernelVersion)LatestVersions.LATEST_KERNEL_VERSION);
        UpgradeTestUtil.upgradeDatabase((DatabaseManagementService)this.managementService, (GraphDatabaseAPI)this.testDb, (KernelVersion)LatestVersions.LATEST_KERNEL_VERSION, (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
        long firstNewTransaction = ((TransactionIdStore)this.testDb.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastClosedTransactionId();
        LogFiles logFiles = (LogFiles)this.testDb.getDependencyResolver().resolveDependency(LogFiles.class);
        this.assertLogHeaderExpectedVersion(logFiles, 0L, null, 1L);
        AtomicInteger latestChecksum = new AtomicInteger();
        TransactionLogsUpgradeIT.assertWholeTransactionsIn(logFiles.getLogFile(), 0L, startEntry -> {}, commitEntry -> latestChecksum.set(commitEntry.getChecksum()), this.commandReaderFactory);
        this.assertLogHeaderExpectedVersion(logFiles, logFiles.getLogFile().getHighestLogVersion(), KernelVersion.GLORIOUS_FUTURE, firstNewTransaction - 1L, latestChecksum.get());
        this.assertWholeTransactionsWithCorrectVersionInSpecificLogVersion(logFiles.getLogFile(), 0L, LatestVersions.LATEST_KERNEL_VERSION, (int)(firstNewTransaction - 1L - 1L));
        this.assertWholeTransactionsWithCorrectVersionInSpecificLogVersion(logFiles.getLogFile(), 1L, KernelVersion.GLORIOUS_FUTURE, 1);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void canFindNextLogFileIfHaveFileWithJustHeader(boolean useQueueAppender) throws Throwable {
        DefaultTracer defaultTracer = (DefaultTracer)this.testDb.getDependencyResolver().resolveDependency(DefaultTracer.class);
        while ((double)defaultTracer.appendedBytes() < (double)LogSegments.DEFAULT_LOG_SEGMENT_SIZE * 2.2) {
            UpgradeTestUtil.createWriteTransaction((GraphDatabaseService)this.testDb);
        }
        Assertions.assertThat((long)defaultTracer.numberOfLogRotations()).isEqualTo(0L);
        long nodeCountBeforeTxTriggeringUpgrade = this.getNodeCount(this.testDb);
        long lastClosedTransactionIdBeforeUpgrade = ((TransactionIdStore)this.testDb.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastClosedTransactionId();
        this.shutdownDbms();
        this.startDbms(builder -> this.configureGloriousFutureAsLatest(builder).setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)((long)LogSegments.DEFAULT_LOG_SEGMENT_SIZE * 2L)).setConfig(GraphDatabaseInternalSettings.dedicated_transaction_appender, (Object)useQueueAppender));
        UpgradeTestUtil.upgradeDatabase((DatabaseManagementService)this.managementService, (GraphDatabaseAPI)this.testDb, (KernelVersion)LatestVersions.LATEST_KERNEL_VERSION, (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
        DatabaseLayout dbLayout = this.testDb.databaseLayout();
        DefaultTracer tracer = (DefaultTracer)((GraphDatabaseAPI)this.managementService.database("neo4j")).getDependencyResolver().resolveDependency(DefaultTracer.class);
        Assertions.assertThat((long)tracer.numberOfLogRotations()).isEqualTo(2L);
        this.shutdownDbms();
        Config config = Config.newBuilder().set(GraphDatabaseInternalSettings.latest_kernel_version, (Object)KernelVersion.GLORIOUS_FUTURE.version()).build();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem, (Config)config);
        Assertions.assertThat((Comparable)RecoveryHelpers.getLatestCheckpoint((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem, (Config)config).kernelVersion()).isEqualTo((Object)LatestVersions.LATEST_KERNEL_VERSION);
        this.startDbms(builder -> this.configureGloriousFutureAsLatest(builder).setConfig(GraphDatabaseInternalSettings.dedicated_transaction_appender, (Object)useQueueAppender));
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)this.testDb, (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
        Assertions.assertThat((long)this.getNodeCount(this.testDb)).isEqualTo(nodeCountBeforeTxTriggeringUpgrade + 1L);
        LogFiles logFiles = (LogFiles)this.testDb.getDependencyResolver().resolveDependency(LogFiles.class);
        this.assertLogHeaderExpectedVersion(logFiles, 0L, null, 1L);
        this.assertWholeTransactionsWithCorrectVersionInSpecificLogVersion(logFiles.getLogFile(), 0L, LatestVersions.LATEST_KERNEL_VERSION, (int)(lastClosedTransactionIdBeforeUpgrade + 1L - 1L));
        this.assertLogHeaderExpectedVersion(logFiles, 1L, null, lastClosedTransactionIdBeforeUpgrade + 1L);
        Assertions.assertThat((long)this.fileSystem.getFileSize(logFiles.getLogFile().getLogFileForVersion(1L))).isEqualTo((long)LogFormat.fromKernelVersion((KernelVersion)LatestVersions.LATEST_KERNEL_VERSION).getHeaderSize());
        this.assertWholeTransactionsWithCorrectVersionInSpecificLogVersion(logFiles.getLogFile(), 1L, LatestVersions.LATEST_KERNEL_VERSION, 0);
        this.assertLogHeaderExpectedVersion(logFiles, 2L, KernelVersion.GLORIOUS_FUTURE, lastClosedTransactionIdBeforeUpgrade + 1L);
        this.assertWholeTransactionsWithCorrectVersionInSpecificLogVersion(logFiles.getLogFile(), 2L, KernelVersion.GLORIOUS_FUTURE, 1);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldRotateToNewFileWhenUpgradeTxIsLastOnStartup(boolean useQueueAppender) throws Exception {
        this.shutdownDbms();
        this.startDbms(builder -> this.configureGloriousFutureAsLatest(builder).setConfig(GraphDatabaseInternalSettings.dedicated_transaction_appender, (Object)useQueueAppender));
        TransactionIdStore transactionIdStore = (TransactionIdStore)this.testDb.getDependencyResolver().resolveDependency(TransactionIdStore.class);
        long lastClosedTransactionIdBeforeUpgrade = transactionIdStore.getLastClosedTransactionId();
        long numNodesBefore = this.getNodeCount(this.testDb);
        this.managementService.registerTransactionEventListener("neo4j", (TransactionEventListener)new InternalTransactionEventListener.Adapter<Object>(){

            public Object beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) {
                if (data.metaData().containsKey("triggerTx")) {
                    throw new TransactionFailureException("Failed because you asked for it", (Status)Status.Transaction.TransactionHookFailed);
                }
                return null;
            }
        });
        UpgradeTestUtil.upgradeDbms((DatabaseManagementService)this.managementService);
        GraphDatabaseAPI finalTestDb = this.testDb;
        Assertions.assertThatThrownBy(() -> {
            try (TransactionImpl tx = (TransactionImpl)finalTestDb.beginTx();){
                tx.setMetaData(Map.of("triggerTx", "something"));
                tx.createNode();
                tx.commit();
            }
        }).isInstanceOf(TransactionFailureException.class);
        ((AbstractLongAssert)Assertions.assertThat((long)this.getNodeCount(this.testDb)).as("Triggering transaction succeeded when it should fail", new Object[0])).isEqualTo(numNodesBefore);
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)this.testDb, (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
        LogPosition positionAfterUpgrade = transactionIdStore.getLastClosedTransaction().logPosition();
        this.shutdownDbms();
        this.startDbms(builder -> this.configureGloriousFutureAsLatest(builder).setConfig(GraphDatabaseInternalSettings.dedicated_transaction_appender, (Object)useQueueAppender));
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)this.testDb, (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
        UpgradeTestUtil.createWriteTransaction((GraphDatabaseService)this.testDb);
        LogFiles logFiles = (LogFiles)this.testDb.getDependencyResolver().resolveDependency(LogFiles.class);
        this.assertLogHeaderExpectedVersion(logFiles, 0L, null, 1L);
        AtomicInteger latestChecksum = new AtomicInteger();
        int nbrTxs = TransactionLogsUpgradeIT.assertWholeTransactionsIn(logFiles.getLogFile(), 0L, startEntry -> Assertions.assertThat((Comparable)startEntry.kernelVersion()).isEqualTo((Object)LatestVersions.LATEST_KERNEL_VERSION), commitEntry -> latestChecksum.set(commitEntry.getChecksum()), this.commandReaderFactory);
        Assertions.assertThat((int)nbrTxs).isEqualTo((int)(lastClosedTransactionIdBeforeUpgrade - 1L + 1L));
        Assertions.assertThat((long)this.fileSystem.getFileSize(logFiles.getLogFile().getLogFileForVersion(0L))).isEqualTo(positionAfterUpgrade.getByteOffset());
        this.assertLogHeaderExpectedVersion(logFiles, 1L, KernelVersion.GLORIOUS_FUTURE, lastClosedTransactionIdBeforeUpgrade + 1L, -559063315);
        this.assertWholeTransactionsWithCorrectVersionInSpecificLogVersion(logFiles.getLogFile(), 1L, KernelVersion.GLORIOUS_FUTURE, 1);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void makeCleanRotationOnVersionChange(boolean useQueueAppender) throws Throwable {
        int nbrTxsPerContestant = 10;
        int nbrContestants = 5;
        this.shutdownDbms();
        this.startDbms(builder -> this.configureGloriousFutureAsLatest(builder).setConfig(GraphDatabaseInternalSettings.dedicated_transaction_appender, (Object)useQueueAppender));
        long txsBefore = ((TransactionIdStore)this.testDb.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastCommittedTransactionId() - 1L;
        Barrier.Control atLeastOneTxDoneBeforeAfter = new Barrier.Control();
        Race race = new Race();
        race.addContestant(() -> {
            UpgradeTestUtil.createWriteTransaction((GraphDatabaseService)this.testDb);
            atLeastOneTxDoneBeforeAfter.reached();
            UpgradeTestUtil.createWriteTransaction((GraphDatabaseService)this.testDb);
        }, 1);
        race.addContestants(nbrContestants, () -> {
            for (int i = 0; i < nbrTxsPerContestant; ++i) {
                UpgradeTestUtil.createWriteTransaction((GraphDatabaseService)this.testDb);
            }
        }, 1);
        race.addContestant(Race.throwing(() -> {
            atLeastOneTxDoneBeforeAfter.await();
            UpgradeTestUtil.upgradeDbms((DatabaseManagementService)this.managementService);
            atLeastOneTxDoneBeforeAfter.release();
        }), 1);
        race.go();
        LogFiles logFiles = (LogFiles)this.testDb.getDependencyResolver().resolveDependency(LogFiles.class);
        this.assertLogHeaderExpectedVersion(logFiles, 0L, null, 1L);
        this.assertLogHeaderExpectedVersion(logFiles, logFiles.getLogFile().getHighestLogVersion(), KernelVersion.GLORIOUS_FUTURE);
        int nbrTxsIn0 = this.assertWholeTransactionsWithCorrectVersionInSpecificLogVersion(logFiles.getLogFile(), 0L, LatestVersions.LATEST_KERNEL_VERSION);
        Assertions.assertThat((int)nbrTxsIn0).isGreaterThanOrEqualTo(2);
        int nbrTxsIn1 = this.assertWholeTransactionsWithCorrectVersionInSpecificLogVersion(logFiles.getLogFile(), 1L, KernelVersion.GLORIOUS_FUTURE);
        Assertions.assertThat((int)nbrTxsIn1).isGreaterThanOrEqualTo(1);
        Assertions.assertThat((int)(nbrTxsIn0 + nbrTxsIn1)).isEqualTo((long)(nbrContestants * nbrTxsPerContestant + 2 + 1) + txsBefore);
    }

    private long getNodeCount(GraphDatabaseAPI db) {
        try (Transaction tx = db.beginTx();){
            long l = Iterables.count((Iterable)tx.getAllNodes());
            return l;
        }
    }

    private void startDbms(Configuration configuration) {
        this.managementService = configuration.configure(new TestDatabaseManagementServiceBuilder(this.neo4jLayout).setConfig(GraphDatabaseSettings.keep_logical_logs, (Object)"keep_all").setConfig(GraphDatabaseInternalSettings.automatic_upgrade_enabled, (Object)false)).build();
        this.testDb = (GraphDatabaseAPI)this.managementService.database("neo4j");
    }

    private void shutdownDbms() {
        if (this.managementService != null) {
            this.managementService.shutdown();
            this.managementService = null;
        }
    }

    private LogHeader assertLogHeaderExpectedVersion(LogFiles logFiles, long logVersion, KernelVersion expectedVersion, long lastExpectedTxId) throws IOException {
        LogHeader logHeader = LogHeaderReader.readLogHeader((FileSystemAbstraction)this.fileSystem, (Path)logFiles.getLogFile().getLogFileForVersion(logVersion), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        Assertions.assertThat((long)logHeader.getLastCommittedTxId()).isEqualTo(lastExpectedTxId);
        Assertions.assertThat((Comparable)logHeader.getKernelVersion()).isEqualTo((Object)expectedVersion);
        return logHeader;
    }

    private void assertLogHeaderExpectedVersion(LogFiles logFiles, long logVersion, KernelVersion expectedVersion, long lastExpectedTxId, int checksum) throws IOException {
        LogHeader logHeader = this.assertLogHeaderExpectedVersion(logFiles, logVersion, expectedVersion, lastExpectedTxId);
        Assertions.assertThat((int)logHeader.getPreviousLogFileChecksum()).isEqualTo(checksum);
    }

    private void assertLogHeaderExpectedVersion(LogFiles logFiles, long logVersion, KernelVersion expectedVersion) throws IOException {
        LogHeader logHeader = LogHeaderReader.readLogHeader((FileSystemAbstraction)this.fileSystem, (Path)logFiles.getLogFile().getLogFileForVersion(logVersion), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        Assertions.assertThat((Comparable)logHeader.getKernelVersion()).isEqualTo((Object)expectedVersion);
    }

    private void assertWholeTransactionsWithCorrectVersionInSpecificLogVersion(LogFile logFile, long logVersion, KernelVersion kernelVersion, int expectedNbrTxs) throws IOException {
        Assertions.assertThat((int)this.assertWholeTransactionsWithCorrectVersionInSpecificLogVersion(logFile, logVersion, kernelVersion)).isEqualTo(expectedNbrTxs);
    }

    private int assertWholeTransactionsWithCorrectVersionInSpecificLogVersion(LogFile logFile, long logVersion, KernelVersion kernelVersion) throws IOException {
        return TransactionLogsUpgradeIT.assertWholeTransactionsIn(logFile, logVersion, startEntry -> Assertions.assertThat((Comparable)startEntry.kernelVersion()).isEqualTo((Object)kernelVersion), commitEntry -> {}, this.commandReaderFactory);
    }

    private static int assertWholeTransactionsIn(LogFile logFile, long logVersion, Consumer<LogEntryStart> extraStartCheck, Consumer<LogEntryCommit> extraCommitCheck, CommandReaderFactory commandReaderFactory) throws IOException {
        int transactions = 0;
        try (ReadableLogChannel reader = logFile.getReader(logFile.extractHeader(logVersion).getStartPosition(), LogVersionBridge.NO_MORE_CHANNELS);){
            LogEntry entry;
            VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader(commandReaderFactory, new BinarySupportedKernelVersions(Config.defaults((Setting)GraphDatabaseInternalSettings.latest_kernel_version, (Object)KernelVersion.GLORIOUS_FUTURE.version())));
            boolean inTx = false;
            while ((entry = entryReader.readLogEntry((ReadableLogPositionAwareChannel)reader)) != null) {
                if (!inTx) {
                    org.junit.jupiter.api.Assertions.assertInstanceOf(LogEntryStart.class, (Object)entry);
                    extraStartCheck.accept((LogEntryStart)entry);
                    inTx = true;
                    continue;
                }
                org.junit.jupiter.api.Assertions.assertTrue((entry instanceof LogEntryCommand || entry instanceof LogEntryCommit ? 1 : 0) != 0);
                if (!(entry instanceof LogEntryCommit)) continue;
                LogEntryCommit commit = (LogEntryCommit)entry;
                inTx = false;
                ++transactions;
                extraCommitCheck.accept(commit);
            }
            org.junit.jupiter.api.Assertions.assertFalse((boolean)inTx);
        }
        return transactions;
    }

    @FunctionalInterface
    static interface Configuration {
        public TestDatabaseManagementServiceBuilder configure(TestDatabaseManagementServiceBuilder var1);
    }
}

