/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Iterator;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class NodeTest {
    @Inject
    private GraphDatabaseService db;

    NodeTest() {
    }

    @Test
    void shouldGiveHelpfulExceptionWhenDeletingNodeWithRels() {
        long nodeId;
        try (Transaction transaction = this.db.beginTx();){
            Node node = transaction.createNode();
            Node node2 = transaction.createNode();
            node.createRelationshipTo(node2, RelationshipType.withName((String)"MAYOR_OF"));
            nodeId = node.getId();
            transaction.commit();
        }
        ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> {
            try (Transaction transaction = this.db.beginTx();){
                Node node = transaction.getNodeById(nodeId);
                node.delete();
                transaction.commit();
            }
        });
        Assertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{"Cannot delete node<" + nodeId + ">, because it still has relationships. To delete this node, you must first delete its relationships."});
    }

    @Test
    void testNodeCreateAndDelete() {
        long nodeId;
        try (Transaction transaction = this.db.beginTx();){
            Node node = transaction.createNode();
            nodeId = node.getId();
            transaction.getNodeById(nodeId);
            node.delete();
            transaction.commit();
        }
        org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> {
            try (Transaction transaction = this.db.beginTx();){
                transaction.getNodeById(nodeId);
            }
        });
    }

    @Test
    void testDeletedNode() {
        try (Transaction transaction = this.db.beginTx();){
            Node node = transaction.createNode();
            node.delete();
            org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> node.setProperty("key1", (Object)1));
        }
    }

    @Test
    void testNodeAddPropertyWithNullKey() {
        try (Transaction transaction = this.db.beginTx();){
            Node node1 = transaction.createNode();
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> node1.setProperty(null, (Object)"bar"));
        }
    }

    @Test
    void testNodeAddPropertyWithNullValue() {
        try (Transaction transaction = this.db.beginTx();){
            Node node1 = transaction.createNode();
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> node1.setProperty("foo", null));
        }
    }

    @Test
    void testNodeAddProperty() {
        try (Transaction transaction = this.db.beginTx();){
            Node node1 = transaction.createNode();
            Node node2 = transaction.createNode();
            String key1 = "key1";
            String key2 = "key2";
            String key3 = "key3";
            Integer int1 = 1;
            Integer int2 = 2;
            String string1 = "1";
            String string2 = "2";
            node1.setProperty(key1, (Object)int1);
            node2.setProperty(key1, (Object)string1);
            node1.setProperty(key2, (Object)string2);
            node2.setProperty(key2, (Object)int2);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)node1.hasProperty(key1));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)node2.hasProperty(key1));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)node1.hasProperty(key2));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)node2.hasProperty(key2));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)node1.hasProperty(key3));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)node2.hasProperty(key3));
            org.junit.jupiter.api.Assertions.assertEquals((Object)int1, (Object)node1.getProperty(key1));
            org.junit.jupiter.api.Assertions.assertEquals((Object)string1, (Object)node2.getProperty(key1));
            org.junit.jupiter.api.Assertions.assertEquals((Object)string2, (Object)node1.getProperty(key2));
            org.junit.jupiter.api.Assertions.assertEquals((Object)int2, (Object)node2.getProperty(key2));
        }
    }

    @Test
    void testNodeRemoveProperty() {
        try (Transaction transaction = this.db.beginTx();){
            String key1 = "key1";
            String key2 = "key2";
            Integer int1 = 1;
            Integer int2 = 2;
            String string1 = "1";
            String string2 = "2";
            Node node1 = transaction.createNode();
            Node node2 = transaction.createNode();
            if (node1.removeProperty(key1) != null) {
                org.junit.jupiter.api.Assertions.fail((String)"Remove of non existing property should return null");
            }
            node1.setProperty(key1, (Object)int1);
            node2.setProperty(key1, (Object)string1);
            node1.setProperty(key2, (Object)string2);
            node2.setProperty(key2, (Object)int2);
            org.junit.jupiter.api.Assertions.assertEquals((Object)int1, (Object)node1.removeProperty(key1));
            org.junit.jupiter.api.Assertions.assertEquals((Object)string1, (Object)node2.removeProperty(key1));
            if (node2.removeProperty(key1) != null) {
                org.junit.jupiter.api.Assertions.fail((String)"Remove of non existing property return null.");
            }
        }
    }

    @Test
    void testNodeChangeProperty() {
        try (Transaction transaction = this.db.beginTx();){
            String key1 = "key1";
            String key2 = "key2";
            String key3 = "key3";
            Integer int1 = 1;
            Integer int2 = 2;
            String string1 = "1";
            String string2 = "2";
            Boolean bool1 = Boolean.TRUE;
            Boolean bool2 = Boolean.FALSE;
            Node node1 = transaction.createNode();
            Node node2 = transaction.createNode();
            node1.setProperty(key1, (Object)int1);
            node2.setProperty(key1, (Object)string1);
            node1.setProperty(key2, (Object)string2);
            node2.setProperty(key2, (Object)int2);
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> node1.setProperty(null, null));
            node1.setProperty(key1, (Object)int2);
            node2.setProperty(key1, (Object)string2);
            org.junit.jupiter.api.Assertions.assertEquals((Object)string2, (Object)node2.getProperty(key1));
            node1.setProperty(key3, (Object)bool1);
            node1.setProperty(key3, (Object)bool2);
            org.junit.jupiter.api.Assertions.assertEquals((Object)string2, (Object)node2.getProperty(key1));
            node1.delete();
            node2.delete();
        }
    }

    @Test
    void testNodeChangeProperty2() {
        try (Transaction transaction = this.db.beginTx();){
            String key1 = "key1";
            Integer int1 = 1;
            Integer int2 = 2;
            String string1 = "1";
            String string2 = "2";
            Boolean bool1 = Boolean.TRUE;
            Boolean bool2 = Boolean.FALSE;
            Node node1 = transaction.createNode();
            node1.setProperty(key1, (Object)int1);
            node1.setProperty(key1, (Object)int2);
            org.junit.jupiter.api.Assertions.assertEquals((Object)int2, (Object)node1.getProperty(key1));
            node1.removeProperty(key1);
            node1.setProperty(key1, (Object)string1);
            node1.setProperty(key1, (Object)string2);
            org.junit.jupiter.api.Assertions.assertEquals((Object)string2, (Object)node1.getProperty(key1));
            node1.removeProperty(key1);
            node1.setProperty(key1, (Object)bool1);
            node1.setProperty(key1, (Object)bool2);
            org.junit.jupiter.api.Assertions.assertEquals((Object)bool2, (Object)node1.getProperty(key1));
            node1.removeProperty(key1);
            node1.delete();
        }
    }

    @Test
    void testNodeGetProperties() {
        try (Transaction transaction = this.db.beginTx();){
            String key1 = "key1";
            String key2 = "key2";
            String key3 = "key3";
            Integer int1 = 1;
            Integer int2 = 2;
            String string = "3";
            Node node1 = transaction.createNode();
            org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> node1.getProperty(key1));
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> node1.getProperty(null));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)node1.hasProperty(key1));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)node1.hasProperty(null));
            node1.setProperty(key1, (Object)int1);
            node1.setProperty(key2, (Object)int2);
            node1.setProperty(key3, (Object)string);
            Iterator keys = node1.getPropertyKeys().iterator();
            keys.next();
            keys.next();
            keys.next();
            Map properties = node1.getAllProperties();
            org.junit.jupiter.api.Assertions.assertEquals(properties.get(key1), (Object)int1);
            org.junit.jupiter.api.Assertions.assertEquals(properties.get(key2), (Object)int2);
            org.junit.jupiter.api.Assertions.assertEquals(properties.get(key3), (Object)string);
            properties = node1.getProperties(new String[]{key1, key2});
            org.junit.jupiter.api.Assertions.assertEquals(properties.get(key1), (Object)int1);
            org.junit.jupiter.api.Assertions.assertEquals(properties.get(key2), (Object)int2);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)properties.containsKey(key3));
            properties = node1.getProperties(new String[0]);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)properties.isEmpty());
            org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> {
                String[] names = null;
                node1.getProperties(names);
                org.junit.jupiter.api.Assertions.fail();
            });
            org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> {
                String[] names = new String[]{null};
                node1.getProperties(names);
            });
            node1.removeProperty(key3);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)node1.hasProperty(key3));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)node1.hasProperty(null));
            node1.delete();
        }
    }

    @Test
    void testAddPropertyThenDelete() {
        long nodeId;
        Node node;
        try (Transaction transaction = this.db.beginTx();){
            node = transaction.createNode();
            node.setProperty("test", (Object)"test");
            nodeId = node.getId();
            transaction.commit();
        }
        transaction = this.db.beginTx();
        try {
            node = transaction.getNodeById(nodeId);
            node.setProperty("test2", (Object)"test2");
            node.delete();
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testChangeProperty() {
        long nodeId;
        Node node;
        try (Transaction transaction = this.db.beginTx();){
            node = transaction.createNode();
            node.setProperty("test", (Object)"test1");
            nodeId = node.getId();
            transaction.commit();
        }
        transaction = this.db.beginTx();
        try {
            node = transaction.getNodeById(nodeId);
            node.setProperty("test", (Object)"test2");
            node.removeProperty("test");
            node.setProperty("test", (Object)"test3");
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test3", (Object)node.getProperty("test"));
            node.removeProperty("test");
            node.setProperty("test", (Object)"test4");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.db.beginTx();
        try {
            node = transaction.getNodeById(nodeId);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test4", (Object)node.getProperty("test"));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testChangeProperty2() {
        long nodeId;
        Node node;
        try (Transaction transaction = this.db.beginTx();){
            node = transaction.createNode();
            node.setProperty("test", (Object)"test1");
            nodeId = node.getId();
            transaction.commit();
        }
        transaction = this.db.beginTx();
        try {
            node = transaction.getNodeById(nodeId);
            node.removeProperty("test");
            node.setProperty("test", (Object)"test3");
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test3", (Object)node.getProperty("test"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.db.beginTx();
        try {
            node = transaction.getNodeById(nodeId);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test3", (Object)node.getProperty("test"));
            node.removeProperty("test");
            node.setProperty("test", (Object)"test4");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.db.beginTx();
        try {
            node = transaction.getNodeById(nodeId);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test4", (Object)node.getProperty("test"));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }
}

