/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class ManualAcquireLockTest {
    @Inject
    private GraphDatabaseService db;
    private Worker worker;

    ManualAcquireLockTest() {
    }

    @BeforeEach
    void doBefore() {
        this.worker = new Worker();
    }

    @AfterEach
    void doAfter() {
        this.worker.close();
    }

    @Test
    void releaseReleaseManually() throws Exception {
        String key = "name";
        Node node = this.createNode();
        try (Transaction transaction = this.db.beginTx();){
            Lock nodeLock = transaction.acquireWriteLock((Entity)node);
            this.worker.beginTx();
            try {
                this.worker.setProperty(node, key, "ksjd");
                Assertions.fail((String)"Shouldn't be able to grab it");
            }
            catch (Exception exception) {
                // empty catch block
            }
            nodeLock.release();
            this.worker.setProperty(node, key, "yo");
            try {
                this.worker.finishTx();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }

    @Test
    void canOnlyReleaseOnce() {
        Node node = this.createNode();
        try (Transaction transaction = this.db.beginTx();){
            Lock nodeLock = transaction.acquireWriteLock((Entity)node);
            nodeLock.release();
            try {
                nodeLock.release();
                Assertions.fail((String)"Shouldn't be able to release more than once");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Test
    void makeSureNodeStaysLockedEvenAfterManualRelease() throws Exception {
        String key = "name";
        Node node = this.createNode();
        try (Transaction transaction = this.db.beginTx();){
            Node txNode = transaction.getNodeById(node.getId());
            Lock nodeLock = transaction.acquireWriteLock((Entity)txNode);
            txNode.setProperty(key, (Object)"value");
            nodeLock.release();
            this.worker.beginTx();
            Assertions.assertThrows(Exception.class, () -> this.worker.setProperty(txNode, key, "ksjd"));
            transaction.commit();
        }
        try {
            this.worker.finishTx();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    private Node createNode() {
        try (Transaction transaction = this.db.beginTx();){
            Node node = transaction.createNode();
            transaction.commit();
            Node node2 = node;
            return node2;
        }
    }

    private GraphDatabaseService getGraphDb() {
        return this.db;
    }

    private class Worker
    extends OtherThreadExecutor {
        private final GraphDatabaseService graphDb;
        private Transaction tx;

        Worker() {
            super("other thread");
            this.graphDb = ManualAcquireLockTest.this.getGraphDb();
        }

        void beginTx() throws Exception {
            this.execute(() -> {
                this.tx = this.graphDb.beginTx();
                return null;
            });
        }

        void finishTx() throws Exception {
            this.execute(() -> {
                this.tx.commit();
                return null;
            });
        }

        void setProperty(Node node, String key, Object value) throws Exception {
            this.execute(() -> {
                this.tx.getNodeById(node.getId()).setProperty(key, value);
                return null;
            }, 2L, TimeUnit.SECONDS);
        }
    }
}

