/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.Subject;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.dbms.database.StandaloneDatabaseContext;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.internal.nativeimpl.NativeAccessProvider;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.LogCommandSerialization;
import org.neo4j.internal.recordstorage.RecordStorageCommandReaderFactory;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatch;
import org.neo4j.kernel.impl.transaction.SimpleAppendIndexProvider;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.CompleteTransaction;
import org.neo4j.kernel.impl.transaction.log.FlushableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.InMemoryVersionableReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadAheadUtils;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.DetachedCheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.entry.IncompleteLogHeaderException;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.UnsupportedLogVersionException;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.kernel.recovery.LogTailScannerMonitor;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.AppendIndexProvider;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreIdProvider;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.RandomExtension;

@Neo4jLayoutExtension
@ExtendWith(value={RandomExtension.class})
class RecoveryCorruptedTransactionLogIT {
    private static final int CHECKPOINT_RECORD_SIZE = 232;
    private static final LogCommandSerialization LATEST_LOG_SERIALIZATION = RecordStorageCommandReaderFactory.INSTANCE.get(LatestVersions.LATEST_KERNEL_VERSION);
    @Inject
    private DefaultFileSystemAbstraction fileSystem;
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private RandomSupport random;
    private static final int HEADER_OFFSET = LatestVersions.LATEST_LOG_FORMAT.getHeaderSize();
    private final AssertableLogProvider logProvider = new AssertableLogProvider(true);
    private final RecoveryMonitor recoveryMonitor = new RecoveryMonitor();
    private final CorruptedCheckpointMonitor corruptedFilesMonitor = new CorruptedCheckpointMonitor();
    private final Monitors monitors = new Monitors();
    private LogFiles logFiles;
    private TestDatabaseManagementServiceBuilder databaseFactory;
    private StorageEngineFactory storageEngineFactory;
    private long txOffsetAfterStart;

    RecoveryCorruptedTransactionLogIT() {
    }

    @BeforeEach
    void setUp() {
        this.monitors.addMonitorListener((Object)this.recoveryMonitor, new String[0]);
        this.monitors.addMonitorListener((Object)this.corruptedFilesMonitor, new String[0]);
        this.databaseFactory = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setConfig(GraphDatabaseInternalSettings.checkpoint_logical_log_keep_threshold, (Object)25).setInternalLogProvider((InternalLogProvider)this.logProvider).setMonitors(this.monitors).setFileSystem((FileSystemAbstraction)this.fileSystem);
        this.txOffsetAfterStart = this.startStopDatabaseAndGetTxOffset();
    }

    @Test
    void recoverFromLastCorruptedNotFullyWrittenCheckpointRecord() throws IOException {
        for (int iteration = 0; iteration < 10; ++iteration) {
            int bytesToTrim = this.random.nextInt(1, 232);
            DatabaseManagementService managementService = this.databaseFactory.build();
            GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
            this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
            TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
            LogPosition logOffsetBeforeTestTransactions = transactionIdStore.getLastClosedTransaction().logPosition();
            long lastClosedTransactionBeforeStart = transactionIdStore.getLastClosedTransactionId();
            for (int i = 0; i < 10; ++i) {
                RecoveryCorruptedTransactionLogIT.generateTransaction(database);
            }
            long numberOfClosedTransactions = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database).getLastClosedTransactionId() - lastClosedTransactionBeforeStart;
            DependencyResolver dependencyResolver = database.getDependencyResolver();
            CheckpointFile databaseCheckpointer = ((TransactionLogFiles)dependencyResolver.resolveDependency(TransactionLogFiles.class)).getCheckpointFile();
            databaseCheckpointer.getCheckpointAppender().checkPoint(LogCheckPointEvent.NULL, transactionIdStore.getLastCommittedTransaction(), transactionIdStore.getLastCommittedTransaction().id() + 1L, LatestVersions.LATEST_KERNEL_VERSION, logOffsetBeforeTestTransactions, Instant.now(), "Fallback checkpoint.");
            managementService.shutdown();
            this.truncateBytesFromLastCheckpointLogFile(bytesToTrim);
            this.startStopDbRecoveryOfCorruptedLogs();
            Assertions.assertEquals((long)numberOfClosedTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
            LogAssertions.assertThat((Object[])this.logFiles.getCheckpointFile().getDetachedCheckpointFiles()).hasSize(1);
            Assertions.assertEquals((int)0, (int)this.corruptedFilesMonitor.getNumberOfCorruptedCheckpointFiles());
            this.removeDatabaseDirectories();
        }
    }

    @Test
    void recoverFromLastCorruptedBrokenCheckpointRecord() throws IOException {
        for (int iteration = 0; iteration < 10; ++iteration) {
            int bytesToAdd = this.random.nextInt(3, 233);
            DatabaseManagementService managementService = this.databaseFactory.build();
            GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
            this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
            TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
            LogPosition logOffsetBeforeTestTransactions = transactionIdStore.getLastClosedTransaction().logPosition();
            long lastClosedTransactionBeforeStart = transactionIdStore.getLastClosedTransactionId();
            for (int i = 0; i < 10; ++i) {
                RecoveryCorruptedTransactionLogIT.generateTransaction(database);
            }
            long numberOfClosedTransactions = transactionIdStore.getLastClosedTransactionId() - lastClosedTransactionBeforeStart;
            DependencyResolver dependencyResolver = database.getDependencyResolver();
            CheckpointFile databaseCheckpointer = ((TransactionLogFiles)dependencyResolver.resolveDependency(TransactionLogFiles.class)).getCheckpointFile();
            databaseCheckpointer.getCheckpointAppender().checkPoint(LogCheckPointEvent.NULL, transactionIdStore.getLastCommittedTransaction(), transactionIdStore.getLastCommittedTransaction().id() + 1L, LatestVersions.LATEST_KERNEL_VERSION, logOffsetBeforeTestTransactions, Instant.now(), "Fallback checkpoint.");
            managementService.shutdown();
            this.removeLastCheckpointRecordFromLastLogFile();
            this.appendRandomBytesAfterLastCheckpointRecordFromLastLogFile(bytesToAdd);
            this.startStopDbRecoveryOfCorruptedLogs();
            Assertions.assertEquals((long)numberOfClosedTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
            Assertions.assertEquals((int)(iteration + 1), (int)this.corruptedFilesMonitor.getNumberOfCorruptedCheckpointFiles());
            LogAssertions.assertThat((Object[])this.logFiles.getCheckpointFile().getDetachedCheckpointFiles()).hasSize(1);
            this.removeDatabaseDirectories();
        }
    }

    @Test
    void recoverFromLastCorruptedBrokenCheckpointRecordButNotReachingEndOfFile() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        LogPosition logOffsetBeforeTestTransactions = transactionIdStore.getLastClosedTransaction().logPosition();
        long lastClosedTransactionBeforeStart = transactionIdStore.getLastClosedTransactionId();
        for (int i = 0; i < 10; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        long numberOfClosedTransactions = transactionIdStore.getLastClosedTransactionId() - lastClosedTransactionBeforeStart;
        DependencyResolver dependencyResolver = database.getDependencyResolver();
        CheckpointFile databaseCheckpointer = ((TransactionLogFiles)dependencyResolver.resolveDependency(TransactionLogFiles.class)).getCheckpointFile();
        databaseCheckpointer.getCheckpointAppender().checkPoint(LogCheckPointEvent.NULL, transactionIdStore.getLastCommittedTransaction(), transactionIdStore.getLastCommittedTransaction().id() + 1L, LatestVersions.LATEST_KERNEL_VERSION, logOffsetBeforeTestTransactions, Instant.now(), "Fallback checkpoint.");
        managementService.shutdown();
        this.replacePartOfCheckpointWithZeroes();
        this.startStopDbRecoveryOfCorruptedLogs();
        Assertions.assertEquals((long)numberOfClosedTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        Assertions.assertEquals((int)0, (int)this.corruptedFilesMonitor.getNumberOfCorruptedCheckpointFiles());
        LogAssertions.assertThat((Object[])this.logFiles.getCheckpointFile().getDetachedCheckpointFiles()).hasSize(1);
        this.removeDatabaseDirectories();
    }

    @Test
    void recoverWithNoValidCheckpoints() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        for (int i = 0; i < 10; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        long numberOfClosedTransactions = transactionIdStore.getLastClosedTransactionId() - 1L;
        managementService.shutdown();
        this.replacePartOfFirstCheckpointAndRestOfFileWithZeroes();
        this.startStopDbRecoveryOfCorruptedLogs();
        Assertions.assertEquals((long)numberOfClosedTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        Assertions.assertEquals((int)0, (int)this.corruptedFilesMonitor.getNumberOfCorruptedCheckpointFiles());
        LogAssertions.assertThat((Object[])this.logFiles.getCheckpointFile().getDetachedCheckpointFiles()).hasSize(1);
        LogAssertions.assertThat((List)this.logFiles.getCheckpointFile().getReachableDetachedCheckpoints()).hasSize(2);
        this.removeDatabaseDirectories();
    }

    @Test
    void recoverWithNoCheckpointFile() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        for (int i = 0; i < 10; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        long numberOfClosedTransactions = transactionIdStore.getLastClosedTransactionId() - 1L;
        managementService.shutdown();
        this.fileSystem.deleteFile(this.logFiles.getCheckpointFile().getCurrentFile());
        this.startStopDbRecoveryOfCorruptedLogs();
        Assertions.assertEquals((long)numberOfClosedTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        Assertions.assertEquals((int)0, (int)this.corruptedFilesMonitor.getNumberOfCorruptedCheckpointFiles());
        LogAssertions.assertThat((Object[])this.logFiles.getCheckpointFile().getDetachedCheckpointFiles()).hasSize(1);
        LogAssertions.assertThat((List)this.logFiles.getCheckpointFile().getReachableDetachedCheckpoints()).hasSize(2);
        this.removeDatabaseDirectories();
    }

    @Test
    void recoverWithSingleCheckpointFileWithBrokenHeader() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        for (int i = 0; i < 10; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        long numberOfClosedTransactions = transactionIdStore.getLastClosedTransactionId() - 1L;
        managementService.shutdown();
        Path currentCheckpointFile = this.logFiles.getCheckpointFile().getDetachedCheckpointFileForVersion(0L);
        this.fileSystem.truncate(currentCheckpointFile, 12L);
        this.startStopDbRecoveryOfCorruptedLogs();
        Assertions.assertEquals((long)numberOfClosedTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        Assertions.assertEquals((int)0, (int)this.corruptedFilesMonitor.getNumberOfCorruptedCheckpointFiles());
        LogAssertions.assertThat((Object[])this.logFiles.getCheckpointFile().getDetachedCheckpointFiles()).hasSize(1);
        LogAssertions.assertThat((List)this.logFiles.getCheckpointFile().getReachableDetachedCheckpoints()).hasSize(2);
        this.removeDatabaseDirectories();
    }

    @Test
    void doNotRotateIfRecoveryIsRequiredButThereAreNoUnreadableData() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        LogPosition logOffsetBeforeTestTransactions = transactionIdStore.getLastClosedTransaction().logPosition();
        long lastClosedTransactionBeforeStart = transactionIdStore.getLastClosedTransactionId();
        for (int i = 0; i < 10; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        long numberOfClosedTransactions = transactionIdStore.getLastClosedTransactionId() - lastClosedTransactionBeforeStart;
        DependencyResolver dependencyResolver = database.getDependencyResolver();
        CheckpointFile databaseCheckpointer = ((TransactionLogFiles)dependencyResolver.resolveDependency(TransactionLogFiles.class)).getCheckpointFile();
        databaseCheckpointer.getCheckpointAppender().checkPoint(LogCheckPointEvent.NULL, transactionIdStore.getLastCommittedTransaction(), transactionIdStore.getLastCommittedTransaction().id() + 7L, LatestVersions.LATEST_KERNEL_VERSION, logOffsetBeforeTestTransactions, Instant.now(), "Fallback checkpoint.");
        managementService.shutdown();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.startStopDatabase();
        Assertions.assertEquals((long)numberOfClosedTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        Assertions.assertEquals((int)0, (int)this.corruptedFilesMonitor.getNumberOfCorruptedCheckpointFiles());
        LogAssertions.assertThat((Object[])this.logFiles.getCheckpointFile().getDetachedCheckpointFiles()).hasSize(1);
    }

    @Test
    void evenTruncateNewerTransactionLogFile() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        long lastClosedTransactionBeforeStart = transactionIdStore.getLastClosedTransactionId();
        for (int i = 0; i < 10; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        long numberOfClosedTransactions = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database).getLastClosedTransactionId() - lastClosedTransactionBeforeStart;
        managementService.shutdown();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.addRandomBytesToLastLogFile(this::randomNonZeroByte);
        this.startStopDbRecoveryOfCorruptedLogs();
        Assertions.assertEquals((long)numberOfClosedTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void doNotTruncateNewerTransactionLogFileWhenFailOnError() throws IOException {
        DatabaseManagementService managementService1 = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService1.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        for (int i = 0; i < 10; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        managementService1.shutdown();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.addRandomBytesToLastLogFile(this::randomInvalidVersionsBytes);
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            DatabaseStateService dbStateService = (DatabaseStateService)db.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            Assertions.assertTrue((boolean)dbStateService.causeOfFailure(db.databaseId()).isPresent());
            LogAssertions.assertThat((Throwable)((Throwable)dbStateService.causeOfFailure(db.databaseId()).get())).hasRootCauseInstanceOf(UnsupportedLogVersionException.class);
        }
        finally {
            managementService.shutdown();
        }
    }

    @Test
    void truncateNewerTransactionLogFileWhenForced() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        long numberOfClosedTransactionsAfterStartup = transactionIdStore.getLastClosedTransactionId();
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        long lastTxSize = 0L;
        long totalTxSize = 0L;
        for (int i = 0; i < 10; ++i) {
            long size;
            lastTxSize = size = RecoveryCorruptedTransactionLogIT.generateTransaction(database);
            totalTxSize += size;
        }
        long numberOfTransactionsToRecover = transactionIdStore.getLastClosedTransactionId() - numberOfClosedTransactionsAfterStartup;
        managementService.shutdown();
        this.removeLastCheckpointRecordFromLastLogFile();
        Supplier<Byte> randomBytesSupplier = this::randomInvalidVersionsBytes;
        BytesCaptureSupplier capturingSupplier = new BytesCaptureSupplier(randomBytesSupplier);
        this.addRandomBytesToLastLogFile(capturingSupplier);
        Assertions.assertFalse((boolean)this.recoveryMonitor.wasRecoveryRequired());
        this.startStopDbRecoveryOfCorruptedLogs();
        try {
            Assertions.assertEquals((long)numberOfTransactionsToRecover, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
            Assertions.assertTrue((boolean)this.recoveryMonitor.wasRecoveryRequired());
            LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Fail to read transaction log version 0.", "Fail to read transaction log version 0. Last valid transaction start offset is: " + (totalTxSize - lastTxSize + this.txOffsetAfterStart) + "."});
        }
        catch (Throwable t) {
            throw new RuntimeException("Generated random bytes: " + capturingSupplier.getCapturedBytes(), t);
        }
    }

    @ParameterizedTest(name="[{index}] ({0})")
    @MethodSource(value={"corruptedLogEntryWriters"})
    void recoverFirstCorruptedTransactionSingleFileNoCheckpoint(String testName, LogEntryWriterWrapper logEntryWriterWrapper) throws IOException {
        this.addCorruptedCommandsToLastLogFile(logEntryWriterWrapper);
        this.startStopDbRecoveryOfCorruptedLogs();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Fail to read transaction log version 0.", "Fail to read first transaction of log version 0.", "Recovery required from position LogPosition{logVersion=0, byteOffset=" + this.txOffsetAfterStart + "}", "Fail to recover database. Any transactional logs after position LogPosition{logVersion=0, byteOffset=" + this.txOffsetAfterStart + "} can not be recovered and will be truncated."});
        this.logFiles = this.buildDefaultLogFiles(new StoreId(4L, 5L, "engine-1", "format-1", 1, 2));
        Assertions.assertEquals((long)0L, (long)this.logFiles.getLogFile().getHighestLogVersion());
        if (NativeAccessProvider.getNativeAccess().isAvailable()) {
            Assertions.assertEquals((long)ByteUnit.mebiBytes((long)1L), (long)Files.size(this.logFiles.getCheckpointFile().getCurrentFile()));
        } else {
            Assertions.assertEquals((long)(LatestVersions.LATEST_LOG_FORMAT.getHeaderSize() + 928), (long)Files.size(this.logFiles.getCheckpointFile().getCurrentFile()));
        }
    }

    @Test
    void failToStartWithTransactionLogsWithDataAfterLastEntry() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        long txSize = RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        managementService.shutdown();
        this.writeRandomBytesAfterLastCommandInLastLogFile(() -> ByteBuffer.wrap(new byte[]{1, 2, 3, 4, 5}));
        this.startStopDatabase();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).assertExceptionForLogMessage("Fail to read transaction log version 0.").hasMessageContaining("Failure to read transaction log file number 0. Unreadable bytes are encountered after last readable position.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void startWithTransactionLogsWithDataAfterLastEntryAndCorruptedLogsRecoveryEnabled() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        long txSize = RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        long initialTransactionOffset = this.txOffsetAfterStart + txSize;
        Assertions.assertEquals((long)initialTransactionOffset, (long)RecoveryCorruptedTransactionLogIT.getLastClosedTransactionOffset(database));
        this.logFiles = this.buildDefaultLogFiles(database);
        Path transactionLogFile = this.logFiles.getLogFile().getHighestLogFile();
        LogPosition position = this.getLastReadablePosition(transactionLogFile);
        managementService.shutdown();
        this.writeRandomBytesAfterLastCommandInLastLogFile(transactionLogFile, position, () -> ByteBuffer.wrap(new byte[]{1, 2, 3, 4, 5}));
        managementService = this.databaseFactory.setConfig(GraphDatabaseInternalSettings.fail_on_corrupted_log_files, (Object)false).build();
        try {
            LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Recovery required from position LogPosition{logVersion=0, byteOffset=" + initialTransactionOffset + "}"}).assertExceptionForLogMessage("Fail to read transaction log version 0.").hasMessageContaining("Failure to read transaction log file number 0. Unreadable bytes are encountered after last readable position.");
            GraphDatabaseAPI restartedDb = (GraphDatabaseAPI)managementService.database("neo4j");
            Assertions.assertEquals((long)initialTransactionOffset, (long)RecoveryCorruptedTransactionLogIT.getLastClosedTransactionOffset(restartedDb));
        }
        finally {
            managementService.shutdown();
        }
    }

    @Test
    void failToStartWithNotLastTransactionLogHavingZerosInTheEnd() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        managementService.shutdown();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{this.logFiles});){
            Path originalFile = this.logFiles.getLogFile().getHighestLogFile();
            this.logFiles.getLogFile().rotate();
            try (StoreFileChannel writeChannel = this.fileSystem.write(originalFile);){
                writeChannel.position(writeChannel.size());
                for (int i = 0; i < 10; ++i) {
                    writeChannel.writeAll(ByteBuffer.wrap(new byte[]{0, 0, 0, 0, 0}));
                }
            }
        }
        this.startStopDatabase();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).assertExceptionForLogMessage("Fail to read transaction log version 0.").hasMessageContaining("Transaction log files with version 0 has 50 unreadable bytes");
    }

    @Test
    void startWithNotLastTransactionLogHavingZerosInTheEndAndCorruptedLogRecoveryEnabled() throws IOException {
        long originalLogDataLength;
        Path firstLogFile;
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        long txSize = RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        managementService.shutdown();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{this.logFiles});){
            LogFile logFile = this.logFiles.getLogFile();
            LogPosition readablePosition = this.getLastReadablePosition(logFile);
            firstLogFile = this.logFiles.getLogFile().getHighestLogFile();
            originalLogDataLength = readablePosition.getByteOffset();
            logFile.rotate();
            try (StoreFileChannel writeChannel = this.fileSystem.write(firstLogFile);){
                writeChannel.position(writeChannel.size());
                for (int i = 0; i < 10; ++i) {
                    writeChannel.writeAll(ByteBuffer.wrap(new byte[]{0, 0, 0, 0, 0}));
                }
            }
        }
        this.startStopDbRecoveryOfCorruptedLogs();
        Assertions.assertEquals((long)originalLogDataLength, (long)this.fileSystem.getFileSize(firstLogFile));
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Recovery required from position LogPosition{logVersion=0, byteOffset=" + (txSize + this.txOffsetAfterStart) + "}"}).assertExceptionForLogMessage("Fail to read transaction log version 0.").hasMessage("Transaction log files with version 0 has 50 unreadable bytes. Was able to read upto " + (txSize + this.txOffsetAfterStart) + " but " + (txSize + 50L + this.txOffsetAfterStart) + " is available.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void restoreCheckpointLogVersionFromFileVersion() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        managementService.shutdown();
        int rotations = 10;
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{this.logFiles});){
            CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
            DetachedCheckpointAppender checkpointAppender = (DetachedCheckpointAppender)checkpointFile.getCheckpointAppender();
            for (int i = 0; i < rotations; ++i) {
                checkpointAppender.checkPoint(LogCheckPointEvent.NULL, TransactionIdStore.UNKNOWN_TRANSACTION_ID, TransactionIdStore.UNKNOWN_TRANSACTION_ID.id() + 8L, LatestVersions.LATEST_KERNEL_VERSION, new LogPosition(0L, (long)HEADER_OFFSET), Instant.now(), "test" + i);
                checkpointAppender.rotate();
            }
        }
        for (int i = rotations - 1; i > 0; --i) {
            DatabaseManagementService restartedDbms = this.databaseFactory.build();
            try {
                MetadataProvider metadataProvider = (MetadataProvider)((GraphDatabaseAPI)restartedDbms.database("neo4j")).getDependencyResolver().resolveDependency(MetadataProvider.class);
                Assertions.assertEquals((long)i, (long)metadataProvider.getCheckpointLogVersion());
            }
            finally {
                restartedDbms.shutdown();
            }
            this.removeLastCheckpointRecordFromLastLogFile();
            this.removeLastCheckpointRecordFromLastLogFile();
            this.removeLastCheckpointRecordFromLastLogFile();
        }
    }

    @Test
    void startWithoutProblemsIfRotationForcedBeforeFileEnd() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        managementService.shutdown();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{this.logFiles});){
            Path originalFile = this.logFiles.getLogFile().getHighestLogFile();
            try (StoreFileChannel writeChannel = this.fileSystem.write(originalFile);){
                writeChannel.position(writeChannel.size());
                for (int i = 0; i < 10; ++i) {
                    writeChannel.writeAll(ByteBuffer.wrap(new byte[]{0, 0, 0, 0, 0}));
                }
            }
            this.logFiles.getLogFile().rotate();
        }
        this.startStopDatabase();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).doesNotContainMessage("Fail to read transaction log version 0.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void detectCorruptedCheckpointFileWithDataAfterLastRecord() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        managementService.shutdown();
        this.appendDataAfterLastCheckpointRecordFromLastLogFile();
        DatabaseManagementService dbms = this.databaseFactory.build();
        try {
            StandaloneDatabaseContext context = this.getDefaultDbContext(dbms);
            Assertions.assertFalse((boolean)context.database().isStarted());
            Assertions.assertTrue((boolean)context.isFailed());
            LogAssertions.assertThat((Throwable)context.failureCause()).rootCause().hasMessageContaining("Checkpoint log file with version 0 has some data available after last readable log entry.");
        }
        finally {
            dbms.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void detectAndStartWithCorruptedCheckpointFileWithDataAfterLastRecord() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        managementService.shutdown();
        LogPosition logPosition = this.appendDataAfterLastCheckpointRecordFromLastLogFile();
        DatabaseManagementService dbms = this.databaseFactory.setConfig(GraphDatabaseInternalSettings.fail_on_corrupted_log_files, (Object)false).build();
        try {
            StandaloneDatabaseContext context = this.getDefaultDbContext(dbms);
            Assertions.assertTrue((boolean)context.database().isStarted());
            LogAssertions.assertThat((long)Files.size(this.logFiles.getCheckpointFile().getDetachedCheckpointFileForVersion(logPosition.getLogVersion()))).isEqualTo(logPosition.getByteOffset() + 232L);
        }
        finally {
            dbms.shutdown();
        }
    }

    @Test
    void startWithoutProblemsIfRotationForcedBeforeFileEndAndCorruptedLogFilesRecoveryEnabled() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        managementService.shutdown();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{this.logFiles});){
            Path originalFile = this.logFiles.getLogFile().getHighestLogFile();
            try (StoreFileChannel writeChannel = this.fileSystem.write(originalFile);){
                writeChannel.position(writeChannel.size());
                for (int i = 0; i < 10; ++i) {
                    writeChannel.writeAll(ByteBuffer.wrap(new byte[]{0, 0, 0, 0, 0}));
                }
            }
            this.logFiles.getLogFile().rotate();
        }
        this.startStopDbRecoveryOfCorruptedLogs();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).doesNotContainMessage("Fail to read transaction log version 0.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void failToRecoverFirstCorruptedTransactionSingleFileNoCheckpointIfFailOnCorruption() throws IOException {
        this.addCorruptedCommandsToLastLogFile(CorruptedLogEntryWriter::new);
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            DatabaseStateService dbStateService = (DatabaseStateService)db.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            Assertions.assertTrue((boolean)dbStateService.causeOfFailure(db.databaseId()).isPresent());
            LogAssertions.assertThat((Throwable)((Throwable)dbStateService.causeOfFailure(db.databaseId()).get())).hasRootCauseInstanceOf(NegativeArraySizeException.class);
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void failToRecoverFirstCorruptedTransactionSingleFileNoCheckpointIfFailOnCorruptionVersion() throws IOException {
        this.addCorruptedCommandsToLastLogFile(CorruptedLogEntryVersionWriter::new);
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            DatabaseStateService dbStateService = (DatabaseStateService)db.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            Assertions.assertTrue((boolean)dbStateService.causeOfFailure(db.databaseId()).isPresent());
            LogAssertions.assertThat((Throwable)((Throwable)dbStateService.causeOfFailure(db.databaseId()).get())).hasRootCauseInstanceOf(UnsupportedLogVersionException.class);
        }
        finally {
            managementService.shutdown();
        }
    }

    @ParameterizedTest(name="[{index}] ({0})")
    @MethodSource(value={"corruptedLogEntryWriters"})
    void recoverNotAFirstCorruptedTransactionSingleFileNoCheckpoint(String testName, LogEntryWriterWrapper logEntryWriterWrapper) throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        long lastClosedTransactionBeforeStart = transactionIdStore.getLastClosedTransactionId();
        long txSizes = 0L;
        for (int i = 0; i < 10; ++i) {
            txSizes += RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        long numberOfTransactions = transactionIdStore.getLastClosedTransactionId() - lastClosedTransactionBeforeStart;
        managementService.shutdown();
        Path highestLogFile = this.logFiles.getLogFile().getHighestLogFile();
        long originalFileLength = this.getLastReadablePosition(highestLogFile).getByteOffset();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.addCorruptedCommandsToLastLogFile(logEntryWriterWrapper);
        long modifiedFileLength = this.fileSystem.getFileSize(highestLogFile);
        LogAssertions.assertThat((long)modifiedFileLength).isGreaterThan(originalFileLength);
        this.startStopDbRecoveryOfCorruptedLogs();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Fail to read transaction log version 0.", "Recovery required from position LogPosition{logVersion=0, byteOffset=" + this.txOffsetAfterStart + "}", "Fail to recover database.", "Any transactional logs after position LogPosition{logVersion=0, byteOffset=" + (txSizes + this.txOffsetAfterStart) + "} can not be recovered and will be truncated."});
        Assertions.assertEquals((long)0L, (long)this.logFiles.getLogFile().getHighestLogVersion());
        Assertions.assertEquals((long)numberOfTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        Assertions.assertEquals((long)originalFileLength, (long)this.fileSystem.getFileSize(highestLogFile));
        Assertions.assertEquals((long)(LatestVersions.LATEST_LOG_FORMAT.getHeaderSize() + 928), (long)Files.size(this.logFiles.getCheckpointFile().getCurrentFile()));
    }

    @ParameterizedTest(name="[{index}] ({0})")
    @MethodSource(value={"corruptedLogEntryWriters"})
    void recoverNotAFirstCorruptedTransactionMultipleFilesNoCheckpoints(String testName, LogEntryWriterWrapper logEntryWriterWrapper) throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        long lastClosedTransactionBeforeStart = transactionIdStore.getLastClosedTransactionId();
        long txSize = RecoveryCorruptedTransactionLogIT.generateTransactionsAndRotate(database, 3);
        long additionalTxSizes = 0L;
        for (int i = 0; i < 7; ++i) {
            additionalTxSizes += RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        long numberOfTransactions = transactionIdStore.getLastClosedTransactionId() - lastClosedTransactionBeforeStart;
        managementService.shutdown();
        Path highestLogFile = this.logFiles.getLogFile().getHighestLogFile();
        long originalFileLength = this.getLastReadablePosition(highestLogFile).getByteOffset();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.addCorruptedCommandsToLastLogFile(logEntryWriterWrapper);
        long modifiedFileLength = this.fileSystem.getFileSize(highestLogFile);
        LogAssertions.assertThat((long)modifiedFileLength).isGreaterThan(originalFileLength);
        this.startStopDbRecoveryOfCorruptedLogs();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Fail to read transaction log version 3.", "Recovery required from position LogPosition{logVersion=0, byteOffset=" + this.txOffsetAfterStart + "}", "Fail to recover database.", "Any transactional logs after position LogPosition{logVersion=3, byteOffset=" + (txSize + additionalTxSizes + (long)HEADER_OFFSET) + "} can not be recovered and will be truncated."});
        Assertions.assertEquals((long)3L, (long)this.logFiles.getLogFile().getHighestLogVersion());
        Assertions.assertEquals((long)numberOfTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        Assertions.assertEquals((long)originalFileLength, (long)this.fileSystem.getFileSize(highestLogFile));
        Assertions.assertEquals((long)(LatestVersions.LATEST_LOG_FORMAT.getHeaderSize() + 928), (long)Files.size(this.logFiles.getCheckpointFile().getCurrentFile()));
    }

    @ParameterizedTest(name="[{index}] ({0})")
    @MethodSource(value={"corruptedLogEntryWriters"})
    void recoverNotAFirstCorruptedTransactionMultipleFilesMultipleCheckpoints(String testName, LogEntryWriterWrapper logEntryWriterWrapper) throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        long transactionsToRecover = 7L;
        long txSize = RecoveryCorruptedTransactionLogIT.generateTransactionsAndRotateWithCheckpoint(database, 3);
        long additionalTxSizes = 0L;
        int i = 0;
        while ((long)i < transactionsToRecover) {
            additionalTxSizes += RecoveryCorruptedTransactionLogIT.generateTransaction(database);
            ++i;
        }
        managementService.shutdown();
        Path highestLogFile = this.logFiles.getLogFile().getHighestLogFile();
        long originalFileLength = this.getLastReadablePosition(highestLogFile).getByteOffset();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.addCorruptedCommandsToLastLogFile(logEntryWriterWrapper);
        long modifiedFileLength = this.fileSystem.getFileSize(highestLogFile);
        LogAssertions.assertThat((long)modifiedFileLength).isGreaterThan(originalFileLength);
        this.startStopDbRecoveryOfCorruptedLogs();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Fail to read transaction log version 3.", "Recovery required from position LogPosition{logVersion=3, byteOffset=" + (txSize + (long)HEADER_OFFSET) + "}", "Fail to recover database.", "Any transactional logs after position LogPosition{logVersion=3, byteOffset=" + (txSize + additionalTxSizes + (long)HEADER_OFFSET) + "} can not be recovered and will be truncated."});
        Assertions.assertEquals((long)3L, (long)this.logFiles.getLogFile().getHighestLogVersion());
        Assertions.assertEquals((long)transactionsToRecover, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        Assertions.assertEquals((long)originalFileLength, (long)this.fileSystem.getFileSize(highestLogFile));
        Assertions.assertEquals((long)(LatestVersions.LATEST_LOG_FORMAT.getHeaderSize() + 1624), (long)Files.size(this.logFiles.getCheckpointFile().getCurrentFile()));
    }

    @ParameterizedTest(name="[{index}] ({0})")
    @MethodSource(value={"corruptedLogEntryWriters"})
    void recoverFirstCorruptedTransactionAfterCheckpointInLastLogFile(String testName, LogEntryWriterWrapper logEntryWriterWrapper) throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        long txSize = RecoveryCorruptedTransactionLogIT.generateTransactionsAndRotate(database, 5);
        managementService.shutdown();
        Path highestLogFile = this.logFiles.getLogFile().getHighestLogFile();
        long originalFileLength = this.getLastReadablePosition(highestLogFile).getByteOffset();
        this.addCorruptedCommandsToLastLogFile(logEntryWriterWrapper);
        long modifiedFileLength = this.fileSystem.getFileSize(highestLogFile);
        LogAssertions.assertThat((long)modifiedFileLength).isGreaterThan(originalFileLength);
        this.startStopDbRecoveryOfCorruptedLogs();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Fail to read transaction log version 5.", "Fail to read first transaction of log version 5.", "Recovery required from position LogPosition{logVersion=5, byteOffset=" + (txSize + (long)HEADER_OFFSET) + "}", "Fail to recover database. Any transactional logs after position LogPosition{logVersion=5, byteOffset=" + (txSize + (long)HEADER_OFFSET) + "} can not be recovered and will be truncated."});
        Assertions.assertEquals((long)5L, (long)this.logFiles.getLogFile().getHighestLogVersion());
        Assertions.assertEquals((long)originalFileLength, (long)this.fileSystem.getFileSize(highestLogFile));
        if (NativeAccessProvider.getNativeAccess().isAvailable()) {
            Assertions.assertEquals((long)ByteUnit.mebiBytes((long)1L), (long)Files.size(this.logFiles.getCheckpointFile().getCurrentFile()));
        } else {
            Assertions.assertEquals((long)(LatestVersions.LATEST_LOG_FORMAT.getHeaderSize() + 1160), (long)Files.size(this.logFiles.getCheckpointFile().getCurrentFile()));
        }
    }

    @Test
    void repetitiveRecoveryOfCorruptedLogs() throws IOException {
        DatabaseManagementService service = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)service.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransactionsAndRotate(database, 4, false);
        service.shutdown();
        this.removeLastCheckpointRecordFromLastLogFile();
        for (int expectedRecoveredTransactions = 7; expectedRecoveredTransactions > 0; --expectedRecoveredTransactions) {
            this.truncateBytesFromLastLogFile(1 + this.random.nextInt(10));
            this.startStopDbRecoveryOfCorruptedLogs();
            int numberOfRecoveredTransactions = this.recoveryMonitor.getNumberOfRecoveredTransactions();
            Assertions.assertEquals((int)expectedRecoveredTransactions, (int)numberOfRecoveredTransactions);
            this.removeLastCheckpointRecordFromLastLogFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void dontTruncateOnCorruptedLogsWithoutSettingForZeroByteInWrongPlace() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        for (int i = 0; i < 10; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        LogPosition logOffsetAfterTestTransactions = transactionIdStore.getLastClosedTransaction().logPosition();
        for (int i = 0; i < 2; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        DependencyResolver dependencyResolver = database.getDependencyResolver();
        LogFiles logFiles1 = (LogFiles)dependencyResolver.resolveDependency(LogFiles.class);
        TransactionLogWriter transactionLogWriter = logFiles1.getLogFile().getTransactionLogWriter();
        FlushableLogPositionAwareChannel channel = transactionLogWriter.getChannel();
        LogPositionMarker logPositionMarker = new LogPositionMarker();
        logPositionMarker.mark(logOffsetAfterTestTransactions.getLogVersion(), logOffsetAfterTestTransactions.getByteOffset());
        channel.setLogPosition(logPositionMarker);
        channel.putLong(0L);
        managementService.shutdown();
        this.removeLastCheckpointRecordFromLastLogFile();
        managementService = this.databaseFactory.build();
        try {
            GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
            DatabaseStateService dbStateService = (DatabaseStateService)db.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            Assertions.assertTrue((boolean)dbStateService.causeOfFailure(db.databaseId()).isPresent());
            LogAssertions.assertThat((String)((Throwable)dbStateService.causeOfFailure(db.databaseId()).get()).getCause().getMessage()).contains(new CharSequence[]{"Unreadable bytes are encountered after last readable position."});
        }
        finally {
            managementService.shutdown();
        }
    }

    @Test
    void truncateOnCorruptedLogsWithSettingForZeroByteInWrongPlace() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        LogPosition logOffsetBeforeTestTransactions = transactionIdStore.getLastClosedTransaction().logPosition();
        long lastClosedTransactionBeforeStart = transactionIdStore.getLastClosedTransactionId();
        for (int i = 0; i < 10; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        long numberOfClosedTransactions = transactionIdStore.getLastClosedTransactionId() - lastClosedTransactionBeforeStart;
        LogPosition logOffsetAfterTestTransactions = transactionIdStore.getLastClosedTransaction().logPosition();
        for (int i = 0; i < 2; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        DependencyResolver dependencyResolver = database.getDependencyResolver();
        LogFiles logFiles1 = (LogFiles)dependencyResolver.resolveDependency(LogFiles.class);
        TransactionLogWriter transactionLogWriter = logFiles1.getLogFile().getTransactionLogWriter();
        FlushableLogPositionAwareChannel channel = transactionLogWriter.getChannel();
        LogPositionMarker logPositionMarker = new LogPositionMarker();
        logPositionMarker.mark(logOffsetAfterTestTransactions.getLogVersion(), logOffsetAfterTestTransactions.getByteOffset());
        channel.setLogPosition(logPositionMarker);
        channel.putLong(0L);
        managementService.shutdown();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.startStopDbRecoveryOfCorruptedLogs();
        Assertions.assertEquals((long)numberOfClosedTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Recovery required from position LogPosition{logVersion=0, byteOffset=" + logOffsetBeforeTestTransactions.getByteOffset() + "}", "Fail to recover database.", "Any transactional logs after position LogPosition{logVersion=0, byteOffset=" + logOffsetAfterTestTransactions.getByteOffset() + "} can not be recovered and will be truncated."});
    }

    private static StoreId getStoreId(GraphDatabaseAPI database) {
        return ((StoreIdProvider)database.getDependencyResolver().resolveDependency(StoreIdProvider.class)).getStoreId();
    }

    private static TransactionIdStore getTransactionIdStore(GraphDatabaseAPI database) {
        return (TransactionIdStore)database.getDependencyResolver().resolveDependency(TransactionIdStore.class);
    }

    private void removeLastCheckpointRecordFromLastLogFile() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        Optional checkpoint = checkpointFile.findLatestCheckpoint();
        if (checkpoint.isPresent()) {
            LogPosition logPosition = ((CheckpointInfo)checkpoint.get()).checkpointEntryPosition();
            try (StoreFileChannel storeChannel = this.fileSystem.write(checkpointFile.getDetachedCheckpointFileForVersion(logPosition.getLogVersion()));){
                storeChannel.truncate(logPosition.getByteOffset());
            }
        }
    }

    private void replacePartOfCheckpointWithZeroes() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        Optional checkpoint = checkpointFile.findLatestCheckpoint();
        if (checkpoint.isPresent()) {
            LogPosition logPosition = ((CheckpointInfo)checkpoint.get()).checkpointEntryPosition();
            try (StoreFileChannel storeChannel = this.fileSystem.write(checkpointFile.getDetachedCheckpointFileForVersion(logPosition.getLogVersion()));){
                storeChannel.position(logPosition.getByteOffset() + 15L);
                storeChannel.writeAll(ByteBuffers.allocate((int)232, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE));
            }
        }
    }

    private void replacePartOfFirstCheckpointAndRestOfFileWithZeroes() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        List checkpoints = checkpointFile.getReachableDetachedCheckpoints();
        if (!checkpoints.isEmpty()) {
            LogPosition logPosition = ((CheckpointInfo)checkpoints.get(0)).checkpointEntryPosition();
            try (StoreFileChannel storeChannel = this.fileSystem.write(checkpointFile.getDetachedCheckpointFileForVersion(logPosition.getLogVersion()));){
                long corruptionPoint = logPosition.getByteOffset() + 15L;
                long lastPoint = ((CheckpointInfo)checkpoints.get(checkpoints.size() - 1)).checkpointFilePostReadPosition().getByteOffset();
                storeChannel.position(corruptionPoint);
                storeChannel.writeAll(ByteBuffers.allocate((int)((int)(lastPoint - corruptionPoint)), (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE));
            }
        }
    }

    private LogPosition appendDataAfterLastCheckpointRecordFromLastLogFile() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        Optional checkpoint = checkpointFile.findLatestCheckpoint();
        if (checkpoint.isPresent()) {
            LogPosition logPosition = ((CheckpointInfo)checkpoint.get()).channelPositionAfterCheckpoint();
            try (StoreFileChannel storeChannel = this.fileSystem.write(checkpointFile.getDetachedCheckpointFileForVersion(logPosition.getLogVersion()));){
                storeChannel.position(logPosition.getByteOffset() + 300L);
                storeChannel.writeAll(ByteBuffer.wrap("DeaD BeaF".getBytes()));
            }
            return logPosition;
        }
        return LogPosition.UNSPECIFIED;
    }

    private void appendRandomBytesAfterLastCheckpointRecordFromLastLogFile(int bytesToAdd) throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        Optional checkpoint = checkpointFile.findLatestCheckpoint();
        if (checkpoint.isPresent()) {
            LogPosition logPosition = ((CheckpointInfo)checkpoint.get()).channelPositionAfterCheckpoint();
            try (StoreFileChannel storeChannel = this.fileSystem.write(checkpointFile.getDetachedCheckpointFileForVersion(logPosition.getLogVersion()));){
                storeChannel.position(logPosition.getByteOffset());
                byte[] array = new byte[bytesToAdd];
                do {
                    this.random.nextBytes(array);
                    array[0] = (byte)this.random.nextInt((int)KernelVersion.EARLIEST.version(), LatestVersions.LATEST_KERNEL_VERSION.version() + 1);
                } while (!this.checkpointEntryLooksCorrupted(array));
                storeChannel.writeAll(ByteBuffer.wrap(array));
            }
        }
    }

    private boolean checkpointEntryLooksCorrupted(byte[] array) {
        VersionAwareLogEntryReader testReader = new VersionAwareLogEntryReader(version -> null, LatestVersions.BINARY_VERSIONS);
        InMemoryVersionableReadableClosablePositionAwareChannel ch = new InMemoryVersionableReadableClosablePositionAwareChannel();
        ch.putVersion(array[0]);
        ch.putAll(ByteBuffer.wrap(array).position(1));
        try {
            testReader.readLogEntry((ReadableLogPositionAwareChannel)ch);
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    private void truncateBytesFromLastCheckpointLogFile(long bytesToTrim) throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        Optional checkpoint = checkpointFile.findLatestCheckpoint();
        if (checkpoint.isPresent()) {
            LogPosition logPosition = ((CheckpointInfo)checkpoint.get()).channelPositionAfterCheckpoint();
            try (StoreFileChannel storeChannel = this.fileSystem.write(checkpointFile.getDetachedCheckpointFileForVersion(logPosition.getLogVersion()));){
                storeChannel.truncate(logPosition.getByteOffset() - bytesToTrim);
            }
        }
    }

    private void truncateBytesFromLastLogFile(long bytesToTrim) throws IOException {
        if (this.logFiles.getLogFile().getHighestLogVersion() > 0L) {
            Path highestLogFile = this.logFiles.getLogFile().getHighestLogFile();
            long readableOffset = this.getLastReadablePosition(highestLogFile).getByteOffset();
            if (bytesToTrim > readableOffset) {
                this.fileSystem.deleteFile(highestLogFile);
                if (this.logFiles.logFiles().length > 0) {
                    this.truncateBytesFromLastLogFile(bytesToTrim);
                }
            } else {
                this.fileSystem.truncate(highestLogFile, readableOffset - bytesToTrim);
            }
        }
    }

    private void writeRandomBytesAfterLastCommandInLastLogFile(Supplier<ByteBuffer> source) throws IOException {
        try (Lifespan lifespan = new Lifespan(new Lifecycle[0]);){
            LogFile transactionLogFile = this.logFiles.getLogFile();
            lifespan.add((Lifecycle)this.logFiles);
            LogPosition position = this.getLastReadablePosition(transactionLogFile);
            try (StoreFileChannel writeChannel = this.fileSystem.write(transactionLogFile.getHighestLogFile());){
                writeChannel.position(position.getByteOffset());
                for (int i = 0; i < 10; ++i) {
                    writeChannel.writeAll(source.get());
                }
            }
        }
    }

    private void writeRandomBytesAfterLastCommandInLastLogFile(Path transactionLogFile, LogPosition position, Supplier<ByteBuffer> source) throws IOException {
        int someRandomPaddingAfterEndOfDataInLogFile = this.random.nextInt(1, 10);
        try (StoreFileChannel writeChannel = this.fileSystem.write(transactionLogFile);){
            writeChannel.position(position.getByteOffset() + (long)someRandomPaddingAfterEndOfDataInLogFile);
            for (int i = 0; i < 10; ++i) {
                writeChannel.writeAll(source.get());
            }
        }
    }

    private LogPosition getLastReadablePosition(Path logFile) throws IOException {
        VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader(this.storageEngineFactory.commandReaderFactory(), LatestVersions.BINARY_VERSIONS);
        LogFile txLogFile = this.logFiles.getLogFile();
        long logVersion = txLogFile.getLogVersion(logFile);
        LogPosition startPosition = txLogFile.extractHeader(logVersion).getStartPosition();
        try (ReadableLogChannel reader = this.openTransactionFileChannel(logVersion, startPosition);){
            while (entryReader.readLogEntry((ReadableLogPositionAwareChannel)reader) != null) {
            }
        }
        catch (IncompleteLogHeaderException e) {
            return new LogPosition(logVersion, 0L);
        }
        return entryReader.lastPosition();
    }

    private ReadableLogChannel openTransactionFileChannel(long logVersion, LogPosition startPosition) throws IOException {
        LogFile logFile = this.logFiles.getLogFile();
        ReadableLogChannel channel = ReadAheadUtils.newChannel((LogFile)logFile, (long)logVersion, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        channel.setCurrentPosition(startPosition.getByteOffset());
        return channel;
    }

    private LogPosition getLastReadablePosition(LogFile logFile) throws IOException {
        VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader(this.storageEngineFactory.commandReaderFactory(), LatestVersions.BINARY_VERSIONS);
        LogPosition startPosition = logFile.extractHeader(this.logFiles.getLogFile().getHighestLogVersion()).getStartPosition();
        try (ReadableLogChannel reader = logFile.getReader(startPosition);){
            while (entryReader.readLogEntry((ReadableLogPositionAwareChannel)reader) != null) {
            }
        }
        return entryReader.lastPosition();
    }

    private void addRandomBytesToLastLogFile(Supplier<Byte> byteSource) throws IOException {
        try (Lifespan lifespan = new Lifespan(new Lifecycle[0]);){
            LogFile transactionLogFile = this.logFiles.getLogFile();
            lifespan.add((Lifecycle)this.logFiles);
            FlushableLogPositionAwareChannel channel = transactionLogFile.getTransactionLogWriter().getChannel();
            for (int i = 0; i < 10; ++i) {
                channel.put(byteSource.get().byteValue());
            }
        }
    }

    private byte randomInvalidVersionsBytes() {
        int highestVersionByte = KernelVersion.VERSIONS.stream().filter(version -> version != KernelVersion.GLORIOUS_FUTURE).mapToInt(KernelVersion::version).max().orElseThrow();
        return (byte)this.random.nextInt(highestVersionByte + 1, 127);
    }

    private byte randomNonZeroByte() {
        byte b = (byte)this.random.nextInt(-128, 127);
        if (b != 0) {
            return b;
        }
        return 127;
    }

    private void addCorruptedCommandsToLastLogFile(LogEntryWriterWrapper logEntryWriterWrapper) throws IOException {
        SimpleLogVersionRepository versionRepository = new SimpleLogVersionRepository(RecoveryCorruptedTransactionLogIT.getInitialVersion(this.logFiles), 0L);
        LogFiles internalLogFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem, (KernelVersionProvider)LatestVersions.LATEST_KERNEL_VERSION_PROVIDER).withLogVersionRepository((LogVersionRepository)versionRepository).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).withAppendIndexProvider((AppendIndexProvider)new SimpleAppendIndexProvider()).withStoreId(new StoreId(4L, 5L, "engine-1", "format-1", 1, 2)).withStorageEngineFactory(StorageEngineFactory.selectStorageEngine((Configuration)Config.defaults())).build();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{internalLogFiles});){
            LogFile transactionLogFile = internalLogFiles.getLogFile();
            LogEntryWriter realLogEntryWriter = transactionLogFile.getTransactionLogWriter().getWriter();
            LogEntryWriter wrappedLogEntryWriter = logEntryWriterWrapper.wrap(realLogEntryWriter);
            TransactionLogWriter writer = new TransactionLogWriter((FlushableLogPositionAwareChannel)realLogEntryWriter.getChannel(), wrappedLogEntryWriter, LatestVersions.LATEST_KERNEL_VERSION_PROVIDER, LogRotation.NO_ROTATION);
            ArrayList<Object> commands = new ArrayList<Object>();
            commands.add(new Command.PropertyCommand(LATEST_LOG_SERIALIZATION, new PropertyRecord(1L), new PropertyRecord(2L)));
            commands.add(new Command.NodeCommand(LATEST_LOG_SERIALIZATION, new NodeRecord(2L), new NodeRecord(3L)));
            CompleteTransaction transaction = new CompleteTransaction(commands, -1L, 0L, 0L, 0L, 0, LatestVersions.LATEST_KERNEL_VERSION, Subject.ANONYMOUS);
            writer.append((CommandBatch)transaction, 1000L, 1001L, 0L, -559063315, LogPosition.UNSPECIFIED, LogAppendEvent.NULL);
        }
    }

    private static long getInitialVersion(LogFiles logFiles) {
        return logFiles == null ? 0L : logFiles.getLogFile().getHighestLogVersion();
    }

    private static long getLastClosedTransactionOffset(GraphDatabaseAPI database) {
        return RecoveryCorruptedTransactionLogIT.getLastClosedTransaction(database).getByteOffset();
    }

    private static LogPosition getLastClosedTransaction(GraphDatabaseAPI database) {
        MetadataProvider metaDataStore = (MetadataProvider)database.getDependencyResolver().resolveDependency(MetadataProvider.class);
        return metaDataStore.getLastClosedTransaction().logPosition();
    }

    private LogFiles buildDefaultLogFiles(StoreId storeId) throws IOException {
        return LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem, (KernelVersionProvider)LatestVersions.LATEST_KERNEL_VERSION_PROVIDER).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository()).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).withAppendIndexProvider((AppendIndexProvider)new SimpleAppendIndexProvider()).withStoreId(storeId).withLogProvider((InternalLogProvider)this.logProvider).withStorageEngineFactory(StorageEngineFactory.selectStorageEngine((Configuration)Config.defaults())).build();
    }

    private LogFiles buildDefaultLogFiles(GraphDatabaseAPI database) throws IOException {
        return LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem, (KernelVersionProvider)LatestVersions.LATEST_KERNEL_VERSION_PROVIDER).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository()).withDependencies(database.getDependencyResolver()).withLogProvider((InternalLogProvider)this.logProvider).build();
    }

    private static long generateTransactionsAndRotateWithCheckpoint(GraphDatabaseAPI database, int logFilesToGenerate) throws IOException {
        return RecoveryCorruptedTransactionLogIT.generateTransactionsAndRotate(database, logFilesToGenerate, true);
    }

    private static long generateTransactionsAndRotate(GraphDatabaseAPI database, int logFilesToGenerate) throws IOException {
        return RecoveryCorruptedTransactionLogIT.generateTransactionsAndRotate(database, logFilesToGenerate, false);
    }

    private static long generateTransactionsAndRotate(GraphDatabaseAPI database, int logFilesToGenerate, boolean checkpoint) throws IOException {
        DependencyResolver resolver = database.getDependencyResolver();
        LogFiles logFiles = (LogFiles)resolver.resolveDependency(LogFiles.class);
        CheckPointer checkpointer = (CheckPointer)resolver.resolveDependency(CheckPointer.class);
        long lastTxSize = -1L;
        while (logFiles.getLogFile().getHighestLogVersion() < (long)logFilesToGenerate) {
            logFiles.getLogFile().rotate();
            lastTxSize = RecoveryCorruptedTransactionLogIT.generateTransaction(database);
            if (!checkpoint) continue;
            checkpointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("testForcedCheckpoint"));
        }
        return lastTxSize;
    }

    private static long generateTransaction(GraphDatabaseAPI database) {
        LogPosition lastTx = RecoveryCorruptedTransactionLogIT.getLastClosedTransaction(database);
        LogFiles logFiles = (LogFiles)database.getDependencyResolver().resolveDependency(LogFiles.class);
        long initialOffset = logFiles.getLogFile().getCurrentLogVersion() > lastTx.getLogVersion() ? (long)HEADER_OFFSET : lastTx.getByteOffset();
        try (Transaction transaction = database.beginTx();){
            Node startNode = transaction.createNode(new Label[]{Label.label((String)"startNode")});
            startNode.setProperty("key", (Object)"value");
            Node endNode = transaction.createNode(new Label[]{Label.label((String)"endNode")});
            endNode.setProperty("key", (Object)"value");
            startNode.createRelationshipTo(endNode, RelationshipType.withName((String)"connects"));
            transaction.commit();
        }
        return RecoveryCorruptedTransactionLogIT.getLastClosedTransactionOffset(database) - initialOffset;
    }

    private void startStopDbRecoveryOfCorruptedLogs() {
        DatabaseManagementService managementService = this.databaseFactory.setConfig(GraphDatabaseInternalSettings.fail_on_corrupted_log_files, (Object)false).build();
        managementService.shutdown();
    }

    private void startStopDatabase() {
        DatabaseManagementService managementService = this.databaseFactory.build();
        this.storageEngineFactory = (StorageEngineFactory)((GraphDatabaseAPI)managementService.database("neo4j")).getDependencyResolver().resolveDependency(StorageEngineFactory.class);
        managementService.shutdown();
    }

    private long startStopDatabaseAndGetTxOffset() {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.storageEngineFactory = (StorageEngineFactory)database.getDependencyResolver().resolveDependency(StorageEngineFactory.class);
        long offset = RecoveryCorruptedTransactionLogIT.getLastClosedTransactionOffset(database);
        managementService.shutdown();
        return offset;
    }

    private void removeDatabaseDirectories() throws IOException {
        this.fileSystem.delete(this.databaseLayout.databaseDirectory());
        this.fileSystem.delete(this.databaseLayout.getTransactionLogsDirectory());
    }

    private StandaloneDatabaseContext getDefaultDbContext(DatabaseManagementService dbms) {
        return (StandaloneDatabaseContext)((DatabaseContextProvider)((GraphDatabaseAPI)dbms.database("system")).getDependencyResolver().resolveDependency(DatabaseContextProvider.class)).getDatabaseContext("neo4j").orElseThrow();
    }

    private static Stream<Arguments> corruptedLogEntryWriters() {
        return Stream.of(Arguments.of((Object[])new Object[]{"CorruptedLogEntryWriter", CorruptedLogEntryWriter::new}), Arguments.of((Object[])new Object[]{"CorruptedLogEntryVersionWriter", CorruptedLogEntryVersionWriter::new}));
    }

    private static class RecoveryMonitor
    implements org.neo4j.kernel.recovery.RecoveryMonitor {
        private final List<Long> recoveredBatches = new ArrayList<Long>();
        private int numberOfRecoveredTransactions;
        private final AtomicBoolean recoveryRequired = new AtomicBoolean();

        private RecoveryMonitor() {
        }

        public void recoveryRequired(LogPosition recoveryPosition) {
            this.recoveryRequired.set(true);
            this.numberOfRecoveredTransactions = 0;
        }

        public void batchRecovered(CommittedCommandBatch committedBatch) {
            this.recoveredBatches.add(committedBatch.txId());
            if (committedBatch.commandBatch().isLast()) {
                ++this.numberOfRecoveredTransactions;
            }
        }

        boolean wasRecoveryRequired() {
            return this.recoveryRequired.get();
        }

        int getNumberOfRecoveredTransactions() {
            return this.numberOfRecoveredTransactions;
        }
    }

    private static class CorruptedCheckpointMonitor
    implements LogTailScannerMonitor {
        private final AtomicInteger corruptedFileCounter = new AtomicInteger();

        private CorruptedCheckpointMonitor() {
        }

        public void corruptedLogFile(long version, Throwable t) {
        }

        public void corruptedCheckpointFile(long version, Throwable t) {
            this.corruptedFileCounter.incrementAndGet();
        }

        int getNumberOfCorruptedCheckpointFiles() {
            return this.corruptedFileCounter.get();
        }
    }

    private static class BytesCaptureSupplier
    implements Supplier<Byte> {
        private final Supplier<Byte> generator;
        private final List<Byte> capturedBytes = new ArrayList<Byte>();

        BytesCaptureSupplier(Supplier<Byte> generator) {
            this.generator = generator;
        }

        @Override
        public Byte get() {
            Byte data = this.generator.get();
            this.capturedBytes.add(data);
            return data;
        }

        public List<Byte> getCapturedBytes() {
            return this.capturedBytes;
        }
    }

    @FunctionalInterface
    private static interface LogEntryWriterWrapper {
        default public <T extends WritableChannel> LogEntryWriter<T> wrap(LogEntryWriter<T> logEntryWriter) {
            return this.to(logEntryWriter.getChannel());
        }

        public <T extends WritableChannel> LogEntryWriter<T> to(T var1);
    }

    private static class CorruptedLogEntryVersionWriter<T extends WritableChannel>
    extends LogEntryWriter<T> {
        CorruptedLogEntryVersionWriter(T channel) {
            super(channel, LatestVersions.BINARY_VERSIONS);
        }

        public void writeStartEntry(KernelVersion version, long timeWritten, long latestCommittedTxWhenStarted, long appendIndex, int previousChecksum, byte[] additionalHeaderData) throws IOException {
            byte nonExistingLogEntryVersion = (byte)(LatestVersions.LATEST_KERNEL_VERSION.version() + 10);
            this.channel.putVersion(nonExistingLogEntryVersion).put((byte)1);
            this.channel.putLong(timeWritten).putLong(latestCommittedTxWhenStarted).putInt(previousChecksum).putInt(additionalHeaderData.length).put(additionalHeaderData, additionalHeaderData.length);
        }
    }

    private static class CorruptedLogEntryWriter<T extends WritableChannel>
    extends LogEntryWriter<T> {
        CorruptedLogEntryWriter(T channel) {
            super(channel, LatestVersions.BINARY_VERSIONS);
        }

        public void writeStartEntry(KernelVersion version, long timeWritten, long latestCommittedTxWhenStarted, long appendIndex, int previousChecksum, byte[] additionalHeaderData) throws IOException {
            this.channel.putVersion(version.version()).put((byte)1);
        }
    }
}

