/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tracers;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.Subject;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.RecordStorageCommandReaderFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.FixedVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.api.txid.TransactionIdGenerator;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.transaction.log.CompleteTransaction;
import org.neo4j.kernel.impl.transaction.log.TransactionCommitmentFactory;
import org.neo4j.kernel.impl.transaction.tracing.TransactionWriteEvent;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.CommandBatchToApply;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;

@DbmsExtension(configurationCallback="configure")
public class CommitProcessTracingIT {
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private KernelVersionProvider kernelVersionProvider;
    @Inject
    private TransactionCommitProcess commitProcess;
    @Inject
    private StorageEngine storageEngine;
    @Inject
    private TransactionCommitmentFactory transactionCommitmentFactory;
    @Inject
    private TransactionIdGenerator transactionIdGenerator;

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseInternalSettings.additional_lock_verification, (Object)false);
        builder.setConfig(GraphDatabaseSettings.db_format, (Object)RecordFormatSelector.defaultFormat().name());
    }

    @Test
    void tracePageCacheAccessOnCommandCreation() throws KernelException {
        long sourceId;
        try (Transaction transaction = this.database.beginTx();){
            sourceId = transaction.createNode(new Label[]{Label.label((String)"a")}).getId();
            transaction.commit();
        }
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)pageCacheTracer, FixedVersionContextSupplier.EMPTY_CONTEXT_SUPPLIER);
        try (CursorContext cursorContext = contextFactory.create("tracePageCacheAccessOnCommandCreation");
             StorageReader reader = this.storageEngine.newReader();){
            CommitProcessTracingIT.assertZeroCursor(cursorContext);
            try (CommandCreationContext context = this.storageEngine.newCommandCreationContext(false);
                 StoreCursors storeCursors = this.storageEngine.createStorageCursors(cursorContext);){
                context.initialize(this.kernelVersionProvider, cursorContext, storeCursors, CommandCreationContext.NO_STARTTIME_OF_OLDEST_TRANSACTION, ResourceLocker.IGNORE, () -> LockTracer.NONE);
                TxState txState = new TxState();
                txState.nodeDoAddLabel(1, sourceId);
                this.storageEngine.createCommands((ReadableTransactionState)txState, reader, context, LockTracer.NONE, TxStateVisitor.NO_DECORATION, cursorContext, storeCursors, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            }
            CommitProcessTracingIT.assertCursor(cursorContext, 1);
        }
    }

    @Test
    void tracePageCacheAccessOnTransactionApply() throws TransactionFailureException {
        CompleteTransaction transaction = new CompleteTransaction(List.of(new Command.NodeCountsCommand(RecordStorageCommandReaderFactory.INSTANCE.get(LatestVersions.LATEST_KERNEL_VERSION), 1, 2L)), -1L, 0L, 0L, 0L, 0, LatestVersions.LATEST_KERNEL_VERSION, Subject.ANONYMOUS);
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)pageCacheTracer, FixedVersionContextSupplier.EMPTY_CONTEXT_SUPPLIER);
        try (CursorContext cursorContext = contextFactory.create("tracePageCacheAccessOnTransactionApply");){
            CommitProcessTracingIT.assertZeroCursor(cursorContext);
            this.commitProcess.commit((CommandBatchToApply)new TransactionToApply((CommandBatch)transaction, cursorContext, StoreCursors.NULL, this.transactionCommitmentFactory.newCommitment(), this.transactionIdGenerator), TransactionWriteEvent.NULL, TransactionApplicationMode.EXTERNAL);
            CommitProcessTracingIT.assertCursor(cursorContext, 1);
        }
    }

    private static void assertCursor(CursorContext cursorContext, int expected) {
        PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
        Assertions.assertThat((long)cursorTracer.pins()).isEqualTo((long)expected);
        Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo((long)expected);
        Assertions.assertThat((long)cursorTracer.hits()).isEqualTo((long)expected);
    }

    private static void assertZeroCursor(CursorContext cursorContext) {
        PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
        Assertions.assertThat((long)cursorTracer.pins()).isZero();
        Assertions.assertThat((long)cursorTracer.unpins()).isZero();
        Assertions.assertThat((long)cursorTracer.hits()).isZero();
    }
}

