/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
public class DatabaseAppendIndexIT {
    @Inject
    private MetadataProvider metadataProvider;
    @Inject
    private CheckPointer checkPointer;
    @Inject
    private LogFiles logFiles;
    @Inject
    private GraphDatabaseAPI databaseAPI;

    @Test
    void appendIndexAndTransactionIdsAreMatching() {
        Assertions.assertEquals((long)this.metadataProvider.getLastAppendIndex(), (long)this.metadataProvider.getLastClosedTransactionId());
        try (Transaction transaction = this.databaseAPI.beginTx();){
            transaction.createNode();
            transaction.commit();
        }
        Assertions.assertEquals((long)this.metadataProvider.getLastAppendIndex(), (long)this.metadataProvider.getLastClosedTransactionId());
    }

    @Test
    void appendIndexMatchingTransactionIdWhenInternalTransactionsExecuted() {
        Assertions.assertEquals((long)this.metadataProvider.getLastAppendIndex(), (long)this.metadataProvider.getLastClosedTransactionId());
        try (Transaction transaction = this.databaseAPI.beginTx();){
            Node node = transaction.createNode(new Label[]{Label.label((String)"marker")});
            node.setProperty("foo", (Object)"bar");
            transaction.commit();
        }
        Assertions.assertEquals((long)this.metadataProvider.getLastAppendIndex(), (long)this.metadataProvider.getLastClosedTransactionId());
    }

    @Test
    void checkpointContainsLastAppendedIndex() throws IOException {
        try (Transaction transaction = this.databaseAPI.beginTx();){
            Node node = transaction.createNode(new Label[]{Label.label((String)"marker")});
            node.setProperty("foo", (Object)"bar");
            transaction.commit();
        }
        Assertions.assertEquals((long)this.metadataProvider.getLastAppendIndex(), (long)this.metadataProvider.getLastClosedTransactionId());
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test trigger"));
        CheckpointInfo checkpointInfo = (CheckpointInfo)this.logFiles.getCheckpointFile().findLatestCheckpoint().orElseThrow();
        Assertions.assertEquals((long)this.metadataProvider.getLastAppendIndex(), (long)checkpointInfo.appendIndex());
        Assertions.assertEquals((long)this.metadataProvider.getLastClosedTransactionId(), (long)checkpointInfo.transactionId().id());
    }
}

